/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.retrievers;

import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.utils.IJLogger;
import ij.ImagePlus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import loci.formats.FormatException;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;

public class LocalRetriever
implements Retriever {
    private boolean processAllImages = false;
    private String microscopeFolderPath = "";
    private String resultsFolderPath = "";
    private Map<String, File> filteredFiles;

    public LocalRetriever(String resultsFolderPath) {
        this.resultsFolderPath = resultsFolderPath;
    }

    public static List<String> listMicroscopes(File parentDirectory) {
        if (parentDirectory.exists()) {
            File[] childFiles = parentDirectory.listFiles();
            if (childFiles != null) {
                return Arrays.stream(childFiles).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
            }
            IJLogger.error("The root folder '" + parentDirectory + "' is not a folder. Cannot list microscopes from a file.");
        } else {
            IJLogger.error("The root folder '" + parentDirectory + "' doesn't exist. Cannot list microscopes from there.");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean loadImages(String parentTarget, String microscopeName, boolean processAllImages, String argoSlideName) {
        List microscopeList;
        this.processAllImages = processAllImages;
        File parentFolder = new File(parentTarget);
        if (!parentFolder.exists()) {
            IJLogger.error("Load local images", "The parent folder '" + parentTarget + "' doesn't exists");
            return false;
        }
        File[] files = parentFolder.listFiles();
        if (files != null) {
            microscopeList = Arrays.stream(files).filter(e -> e.isDirectory() && e.getName().toLowerCase().contains(microscopeName)).collect(Collectors.toList());
            if (microscopeList.isEmpty()) {
                IJLogger.error("Load local images", "The folder " + parentFolder.getName() + " does not contain any " + microscopeName + " folder");
                return false;
            }
        } else {
            IJLogger.error("Load local images", "The folder " + parentFolder.getName() + " is empty");
            return false;
        }
        IJLogger.info("Load local images", "Select folder " + ((File)microscopeList.get(0)).getAbsolutePath());
        this.microscopeFolderPath = ((File)microscopeList.get(0)).getAbsolutePath();
        File microscopeFolder = new File(this.microscopeFolderPath);
        File[] rawImgFiles = microscopeFolder.listFiles();
        if (rawImgFiles == null) {
            IJLogger.error("Load local images", "The folder " + this.microscopeFolderPath + " is corrupted ; no images can be listed");
            return false;
        }
        List<String> processedFiles = this.listProcessedFiles(this.resultsFolderPath, microscopeName);
        List<File> filteredImageFileList = this.filterImages(Arrays.stream(rawImgFiles).collect(Collectors.toList()), processAllImages, processedFiles, argoSlideName, microscopeName.replace("_", ""));
        HashMap<String, File> filteredImagesMap = new HashMap<String, File>();
        for (File imageFile : filteredImageFileList) {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            filteredImagesMap.put(uuid, imageFile);
        }
        this.filteredFiles = filteredImagesMap;
        return true;
    }

    private List<String> listProcessedFiles(String resultsFolderPath, String microscopeName) {
        List microscopeList;
        File resultsFolder = new File(resultsFolderPath);
        if (!resultsFolder.exists()) {
            return Collections.emptyList();
        }
        File[] files = resultsFolder.listFiles();
        if (files != null) {
            microscopeList = Arrays.stream(files).filter(e -> e.isDirectory() && e.getName().toLowerCase().contains(microscopeName)).collect(Collectors.toList());
            if (microscopeList.isEmpty()) {
                IJLogger.warn("Load local images", "The folder '" + resultsFolder.getName() + "' does not contain any '" + microscopeName + "' folder");
                IJLogger.warn("Load local images", "Cannot check for already processed images. All images will be processed");
                return Collections.emptyList();
            }
        } else {
            IJLogger.error("Load local images", "The folder " + resultsFolder.getName() + " is empty");
            return Collections.emptyList();
        }
        IJLogger.info("Load local images", "Select folder " + ((File)microscopeList.get(0)).getAbsolutePath());
        File microscopeResultsFolder = new File(((File)microscopeList.get(0)).getAbsolutePath());
        File[] resultsImgList = microscopeResultsFolder.listFiles();
        if (resultsImgList == null) {
            return Collections.emptyList();
        }
        List txtProcessedMicList = Arrays.stream(resultsImgList).filter(e -> e.isFile() && e.getName().toLowerCase().contains(microscopeName.toLowerCase()) && e.getName().endsWith("processed_images.csv")).collect(Collectors.toList());
        if (txtProcessedMicList.isEmpty()) {
            return Collections.emptyList();
        }
        File processedImgFile = (File)txtProcessedMicList.get(0);
        try {
            String line;
            ArrayList<String> processedFiles = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(processedImgFile));
            while ((line = br.readLine()) != null) {
                processedFiles.add(line);
            }
            br.close();
            return processedFiles;
        }
        catch (IOException e2) {
            return Collections.emptyList();
        }
    }

    private List<File> filterImages(List<File> imageFiles, boolean processAllImages, List<String> processedFiles, String argoSlideName, String microscopeName) {
        if (processedFiles == null || processAllImages) {
            processedFiles = new ArrayList<String>();
        }
        ArrayList<File> filteredFiles = new ArrayList<File>();
        for (File rawImgFile : imageFiles) {
            String rawImgName = rawImgFile.getName();
            List dup = processedFiles.stream().filter(e -> e.contains(rawImgName)).collect(Collectors.toList());
            if (!dup.isEmpty() || !rawImgName.toLowerCase().contains(argoSlideName.toLowerCase()) || !rawImgName.toLowerCase().contains(microscopeName.toLowerCase())) continue;
            filteredFiles.add(rawImgFile);
        }
        return filteredFiles;
    }

    @Override
    public List<ImagePlus> getImage(String index) {
        File toProcess = this.filteredFiles.get(index);
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(toProcess.getAbsolutePath());
            options.setOpenAllSeries(true);
            ImagePlus[] images = BF.openImagePlus((ImporterOptions)options);
            return Arrays.asList(images);
        }
        catch (IOException | FormatException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public int getNImages() {
        return this.filteredFiles.size();
    }

    @Override
    public List<String> getIDs() {
        return new ArrayList<String>(this.filteredFiles.keySet());
    }

    @Override
    public String getMicroscopeTarget() {
        return this.microscopeFolderPath;
    }

    @Override
    public boolean isProcessingAllRawImages() {
        return this.processAllImages;
    }
}

