/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.processing;

import ch.epfl.biop.image.ImageChannel;
import ch.epfl.biop.image.ImageFile;
import ch.epfl.biop.processing.ArgoGrid;
import ch.epfl.biop.processing.ArgoSlideOldProcessing;
import ch.epfl.biop.processing.ArgoSlideProcessing;
import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.senders.LocalSender;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.frame.RoiManager;
import ij.process.ImageStatistics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Processing {
    public static void run(Retriever retriever, boolean savingHeatMaps, Sender sender, double userSigma, double userMedianRadius, String userThresholdingMethod, double userParticleThreshold, double userRingRadius, String argoSlide, int argoSpacing, int argoFOV, int argoNPoints) {
        HashMap<String, List<List<Double>>> summaryMap = new HashMap<String, List<List<Double>>>();
        List<String> headers = new ArrayList<String>();
        List<String> IDs = retriever.getIDs();
        for (String Id : IDs) {
            List<ImagePlus> impList = retriever.getImage(Id);
            for (int serie = 0; serie < impList.size(); ++serie) {
                ImagePlus imp = impList.get(serie);
                if (imp == null) continue;
                String imgTitle = imp.getTitle();
                String uniqueID = imgTitle + "%" + Id;
                try {
                    IJLogger.info("Working on image " + imgTitle);
                    ImageFile imageFile = new ImageFile(imp, Id, imgTitle, serie + 1);
                    boolean isOldProtocol = false;
                    if (!imageFile.getArgoSlideName().contains("ArgoSimOld")) {
                        ArgoSlideProcessing.run(imageFile, userSigma, userMedianRadius, userThresholdingMethod, userParticleThreshold, userRingRadius, argoSlide, argoSpacing, argoFOV, argoNPoints);
                    } else {
                        ArgoSlideOldProcessing.run(imageFile);
                        isOldProtocol = true;
                    }
                    IJLogger.info("End of processing");
                    IJLogger.info("Sending results ... ");
                    sender.initialize(imageFile, retriever);
                    sender.sendTags(imageFile.getTags());
                    Processing.sendResults(sender, imageFile, savingHeatMaps, isOldProtocol, argoSpacing);
                    Map<List<String>, List<List<Double>>> allChannelMetrics = imageFile.summaryForParentTable();
                    headers = new ArrayList<List<String>>(allChannelMetrics.keySet()).get(0);
                    if (allChannelMetrics.values().isEmpty()) continue;
                    summaryMap.put(uniqueID, allChannelMetrics.values().iterator().next());
                    continue;
                }
                catch (Exception e) {
                    IJLogger.error("An error occurred during processing ; cannot analyse the image " + imgTitle, e);
                }
            }
        }
        sender.populateParentTable(retriever, summaryMap, headers, !retriever.isProcessingAllRawImages());
    }

    private static void sendResults(Sender sender, ImageFile imageFile, boolean savingHeatMaps, boolean isOldProtocol, int argoSpacing) {
        Map<String, String> keyValues = imageFile.getKeyValues();
        if (imageFile.getNChannels() > 1) {
            sender.sendPCCTable(imageFile.getPCC(), imageFile.getNChannels());
        }
        ArrayList<List<Double>> distortionValues = new ArrayList<List<Double>>();
        ArrayList<List<Double>> uniformityValues = new ArrayList<List<Double>>();
        ArrayList<List<Double>> fwhmValues = new ArrayList<List<Double>>();
        ArrayList<Integer> chIds = new ArrayList<Integer>();
        for (int i = 0; i < imageFile.getNChannels(); ++i) {
            ImageChannel channel = imageFile.getChannel(i);
            keyValues.putAll(channel.getKeyValues());
            sender.sendGridPoints(channel.getGridRings(), channel.getId(), "measuredGrid");
            sender.sendGridPoints(channel.getIdealGridRings(), channel.getId(), "idealGrid");
            distortionValues.add(channel.getFieldDistortion());
            uniformityValues.add(channel.getFieldUniformity());
            fwhmValues.add(channel.getFWHM());
            chIds.add(channel.getId());
            if (!savingHeatMaps) continue;
            if (isOldProtocol || !imageFile.getImagedFoV().equals("partialFoV")) {
                sender.sendHeatMaps(channel.getFieldDistortionHeatMap(imageFile.getImgNameWithoutExtension(), argoSpacing));
            }
            if (isOldProtocol || !imageFile.getImagedFoV().equals("partialFoV")) {
                sender.sendHeatMaps(channel.getFieldUniformityHeatMap(imageFile.getImgNameWithoutExtension(), argoSpacing));
            }
            if (!isOldProtocol && imageFile.getImagedFoV().equals("fullFoV")) continue;
            sender.sendHeatMaps(channel.getFWHMHeatMap(imageFile.getImgNameWithoutExtension(), argoSpacing));
        }
        if (isOldProtocol || !imageFile.getImagedFoV().equals("partialFoV")) {
            sender.sendResultsTable(distortionValues, chIds, false, "Field_distortion");
        }
        if (isOldProtocol || !imageFile.getImagedFoV().equals("partialFoV")) {
            sender.sendResultsTable(uniformityValues, chIds, false, "Field_uniformity");
        }
        if (isOldProtocol || !imageFile.getImagedFoV().equals("fullFoV")) {
            sender.sendResultsTable(fwhmValues, chIds, false, "FWHM");
        }
        if (sender instanceof LocalSender) {
            keyValues.put("Image_ID", imageFile.getId());
            keyValues.put("Image_Title", imageFile.getTitle());
            keyValues.put("Image_Serie", String.valueOf(imageFile.getSerie()));
        }
        sender.sendKeyValues(keyValues);
    }

    protected static Roi getCentralCross(ImagePlus imp, RoiManager rm, double imagePixelSize, String segMethod, int argoFOV) {
        rm.reset();
        IJ.run((ImagePlus)imp, (String)"Select None", (String)"");
        IJ.run((ImagePlus)imp, (String)"Remove Overlay", (String)"");
        ImagePlus mask_imp = imp.duplicate();
        IJ.setAutoThreshold((ImagePlus)mask_imp, (String)(segMethod + " dark"));
        IJ.run((ImagePlus)mask_imp, (String)"Convert to Mask", (String)"");
        IJ.run((ImagePlus)mask_imp, (String)"Analyze Particles...", (String)("size=" + 2.5 / imagePixelSize + "-Infinity add"));
        double gridFactor = (double)argoFOV / (4.0 * imagePixelSize);
        List rois = Arrays.stream(rm.getRoisAsArray()).filter(roi -> roi.getStatistics().xCentroid < (double)imp.getWidth() / 2.0 + gridFactor && roi.getStatistics().xCentroid > (double)imp.getWidth() / 2.0 - gridFactor && roi.getStatistics().yCentroid < (double)imp.getHeight() / 2.0 + gridFactor && roi.getStatistics().yCentroid > (double)imp.getHeight() / 2.0 - gridFactor).collect(Collectors.toList());
        Optional<Roi> crossRoiOpt = rois.stream().max(Comparator.comparing(roi -> roi.getStatistics().roiWidth));
        rm.reset();
        return crossRoiOpt.map(points -> new Roi(points.getBounds())).orElseGet(() -> new Roi(new Rectangle(-1, -1, -1, -1)));
    }

    protected static List<Point2D> getGridPoint(ImagePlus imp, Roi crossRoi, double sigma, double medianRadius, double prtThreshold, String segMethod, int ovalRadius) {
        Roi enlargedRectangle = new Roi(new Rectangle(ovalRadius, ovalRadius, imp.getWidth() - 2 * ovalRadius, imp.getHeight() - 2 * ovalRadius));
        ImagePlus imp2 = imp.duplicate();
        IJ.run((ImagePlus)imp2, (String)"Median...", (String)("radius=" + medianRadius));
        IJ.run((ImagePlus)imp2, (String)"Gaussian Blur...", (String)("sigma=" + sigma));
        IJ.setAutoThreshold((ImagePlus)imp2, (String)(segMethod + " dark"));
        IJ.run((ImagePlus)imp2, (String)"Convert to Mask", (String)"");
        IJ.run((String)"Set Measurements...", (String)"area centroid center display redirect=None decimal=3");
        IJ.run((ImagePlus)imp2, (String)"Analyze Particles...", (String)"pixel display clear overlay add");
        ResultsTable rt_points = ResultsTable.getResultsTable((String)"Results");
        RoiManager rm = RoiManager.getRoiManager();
        rt_points.reset();
        rm.runCommand(imp, "Measure");
        float[] raw_x_array = rt_points.getColumn(rt_points.getColumnIndex("XM"));
        float[] raw_y_array = rt_points.getColumn(rt_points.getColumnIndex("YM"));
        float[] raw_area_array = rt_points.getColumn(rt_points.getColumnIndex("Area"));
        ArrayList<Point2D> gridPoints = new ArrayList<Point2D>();
        for (int i = 0; i < raw_x_array.length; ++i) {
            if (!enlargedRectangle.containsPoint((double)raw_x_array[i], (double)raw_y_array[i]) || crossRoi.containsPoint((double)raw_x_array[i], (double)raw_y_array[i]) || !((double)raw_area_array[i] > prtThreshold)) continue;
            gridPoints.add(new Point2D.Double(raw_x_array[i], raw_y_array[i]));
        }
        IJ.selectWindow((String)"Results");
        IJ.run((String)"Close");
        return gridPoints;
    }

    protected static double getAverageStep(List<Double> values, double pixelSize, int argoSpacing) {
        Optional minOpt = values.stream().min(Comparator.naturalOrder());
        Optional maxOpt = values.stream().max(Comparator.naturalOrder());
        if (!minOpt.isPresent()) {
            return 0.0;
        }
        double min = (Double)minOpt.get();
        double max = (Double)maxOpt.get();
        double step_calc = (max - min) / (double)((int)Math.sqrt(values.size()));
        int tol = (int)(0.6 * (double)argoSpacing / pixelSize);
        ArrayList linesAvgs = new ArrayList();
        IntStream.range(0, (int)Math.sqrt(values.size() + 1)).forEach(line_idx -> {
            List lines = values.stream().filter(e -> e > min + (double)line_idx * step_calc - (double)tol && e < min + (double)line_idx * step_calc + (double)tol).collect(Collectors.toList());
            linesAvgs.add(lines.stream().reduce(0.0, Double::sum) / (double)lines.size());
        });
        ArrayList stepAvgs = new ArrayList();
        IntStream.range(0, linesAvgs.size() - 2).forEach(line_idx -> stepAvgs.add((Double)linesAvgs.get(line_idx + 1) - (Double)linesAvgs.get(line_idx)));
        return stepAvgs.stream().reduce(0.0, Double::sum) / (double)stepAvgs.size();
    }

    protected static ArgoGrid computeRotationAndFinalFoV(List<Point2D> values, double xCross, double yCross, double pixelSize, int argoSpacing, double ovalRadius, ImagePlus imp) {
        ArgoGrid argoGrid = Processing.getCentralLines(values, xCross, yCross, pixelSize, argoSpacing, ovalRadius, imp);
        List<Point2D> leftLine = argoGrid.getLeftPoints();
        List<Point2D> rightLine = argoGrid.getRightPoints();
        List<Point2D> topLine = argoGrid.getTopPoints();
        List<Point2D> bottomLine = argoGrid.getBottomPoints();
        if (!(leftLine.isEmpty() || rightLine.isEmpty() || topLine.isEmpty() || bottomLine.isEmpty())) {
            Collections.reverse(leftLine);
            leftLine.addAll(rightLine);
            Collections.reverse(topLine);
            topLine.addAll(bottomLine);
            double[] xArrayH = leftLine.stream().mapToDouble(Point2D::getX).toArray();
            double[] yArrayH = leftLine.stream().mapToDouble(Point2D::getY).toArray();
            double[] xArrayV = topLine.stream().mapToDouble(Point2D::getX).toArray();
            double[] yArrayV = topLine.stream().mapToDouble(Point2D::getY).toArray();
            CurveFitter fitter = new CurveFitter(xArrayH, yArrayH);
            fitter.doFit(0);
            double hCoefDir = fitter.getParams()[1];
            double angle1 = Math.atan2(hCoefDir, 1.0);
            CurveFitter fitter2 = new CurveFitter(xArrayV, yArrayV);
            fitter2.doFit(0);
            double vCoefDir = fitter2.getParams()[1];
            double angle2 = Math.atan2(vCoefDir, 1.0);
            if (angle2 > 0.0) {
                angle2 -= 1.5707963267948966;
            } else if (angle2 < 0.0) {
                angle2 += 1.5707963267948966;
            }
            argoGrid.setRotationAngle((angle1 + angle2) / 2.0);
            argoGrid.setMaxNbPointsPerLine(Math.min(leftLine.size(), Math.min(rightLine.size(), Math.min(topLine.size(), bottomLine.size()))) * 2 + 1);
        } else {
            argoGrid.setRotationAngle(Double.NaN);
            argoGrid.setMaxNbPointsPerLine(-1);
        }
        return argoGrid;
    }

    private static ArgoGrid getCentralLines(List<Point2D> values, double xCross, double yCross, double pixelSize, int argoSpacing, double ovalRadius, ImagePlus imp) {
        Point2D.Double theoPoint;
        Point2D.Double vectToLeft = new Point2D.Double((double)(-argoSpacing) / pixelSize, 0.0);
        double initX = xCross;
        double initY = yCross;
        ArgoGrid argoGrid = new ArgoGrid();
        ArrayList<Point2D> lineLeft = new ArrayList<Point2D>();
        do {
            if (!((theoPoint = new Point2D.Double(initX + vectToLeft.getX(), initY + vectToLeft.getY())).getX() > ovalRadius)) continue;
            Point2D.Double finalTheoPoint = theoPoint;
            List sortedPoints = values.stream().sorted(Comparator.comparing(e -> e.distance(finalTheoPoint.getX(), finalTheoPoint.getY()))).collect(Collectors.toList());
            Point2D closerRing = (Point2D)sortedPoints.get(0);
            if (!lineLeft.isEmpty()) {
                Point2D lastPoint = (Point2D)lineLeft.get(lineLeft.size() - 1);
                if (closerRing.distance(lastPoint) == 0.0) break;
                lineLeft.add(closerRing);
            } else {
                lineLeft.add(closerRing);
            }
            vectToLeft = new Point2D.Double(closerRing.getX() - initX, closerRing.getY() - initY);
            initX = closerRing.getX();
            initY = closerRing.getY();
        } while (theoPoint.getX() > ovalRadius);
        Point2D.Double vectToRight = new Point2D.Double((double)argoSpacing / pixelSize, 0.0);
        initX = xCross;
        initY = yCross;
        ArrayList<Point2D> lineRight = new ArrayList<Point2D>();
        do {
            if (!((theoPoint = new Point2D.Double(initX + vectToRight.getX(), initY + vectToRight.getY())).getX() < (double)imp.getWidth() - ovalRadius)) continue;
            Point2D.Double finalTheoPoint = theoPoint;
            List sortedPoints = values.stream().sorted(Comparator.comparing(e -> e.distance(finalTheoPoint.getX(), finalTheoPoint.getY()))).collect(Collectors.toList());
            Point2D closerRing = (Point2D)sortedPoints.get(0);
            if (!lineRight.isEmpty()) {
                Point2D lastPoint = (Point2D)lineRight.get(lineRight.size() - 1);
                if (closerRing.distance(lastPoint) == 0.0) break;
                lineRight.add(closerRing);
            } else {
                lineRight.add(closerRing);
            }
            vectToRight = new Point2D.Double(closerRing.getX() - initX, closerRing.getY() - initY);
            initX = closerRing.getX();
            initY = closerRing.getY();
        } while (theoPoint.getX() < (double)imp.getWidth() - ovalRadius);
        Point2D.Double vectToBottom = new Point2D.Double(0.0, (double)argoSpacing / pixelSize);
        initX = xCross;
        initY = yCross;
        ArrayList<Point2D> lineBottom = new ArrayList<Point2D>();
        do {
            if (!((theoPoint = new Point2D.Double(initX + vectToBottom.getX(), initY + vectToBottom.getY())).getY() < (double)imp.getHeight() - ovalRadius)) continue;
            Point2D.Double finalTheoPoint = theoPoint;
            List sortedPoints = values.stream().sorted(Comparator.comparing(e -> e.distance(finalTheoPoint.getX(), finalTheoPoint.getY()))).collect(Collectors.toList());
            Point2D closerRing = (Point2D)sortedPoints.get(0);
            if (!lineBottom.isEmpty()) {
                Point2D lastPoint = (Point2D)lineBottom.get(lineBottom.size() - 1);
                if (closerRing.distance(lastPoint) == 0.0) break;
                lineBottom.add(closerRing);
            } else {
                lineBottom.add(closerRing);
            }
            vectToBottom = new Point2D.Double(closerRing.getX() - initX, closerRing.getY() - initY);
            initX = closerRing.getX();
            initY = closerRing.getY();
        } while (theoPoint.getY() < (double)imp.getHeight() - ovalRadius);
        Point2D.Double vectToTop = new Point2D.Double(0.0, (double)(-argoSpacing) / pixelSize);
        initX = xCross;
        initY = yCross;
        ArrayList<Point2D> lineTop = new ArrayList<Point2D>();
        do {
            if (!((theoPoint = new Point2D.Double(initX + vectToTop.getX(), initY + vectToTop.getY())).getY() > ovalRadius / 2.0)) continue;
            Point2D.Double finalTheoPoint = theoPoint;
            List sortedPoints = values.stream().sorted(Comparator.comparing(e -> e.distance(finalTheoPoint.getX(), finalTheoPoint.getY()))).collect(Collectors.toList());
            Point2D closerRing = (Point2D)sortedPoints.get(0);
            if (!lineTop.isEmpty()) {
                Point2D lastPoint = (Point2D)lineTop.get(lineTop.size() - 1);
                if (closerRing.distance(lastPoint) == 0.0) break;
                lineTop.add(closerRing);
            } else {
                lineTop.add(closerRing);
            }
            vectToTop = new Point2D.Double(closerRing.getX() - initX, closerRing.getY() - initY);
            initX = closerRing.getX();
            initY = closerRing.getY();
        } while (theoPoint.getY() > ovalRadius);
        argoGrid.setBottomPoints(lineBottom);
        argoGrid.setLeftPoints(lineLeft);
        argoGrid.setRightPoints(lineRight);
        argoGrid.setTopPoints(lineTop);
        return argoGrid;
    }

    protected static List<Point2D> getIdealGridPoints(Roi crossRoi, int nPoints, double xStepAvg, double yStepAvg, double theta) {
        double xCross = crossRoi.getStatistics().xCentroid;
        double yCross = crossRoi.getStatistics().yCentroid;
        AffineTransform at = AffineTransform.getRotateInstance(theta, xCross, yCross);
        ArrayList<Point2D> idealPoints = new ArrayList<Point2D>();
        IntStream.range(-(nPoints - 1) / 2, (nPoints - 1) / 2 + 1).forEach(yP -> IntStream.range(-(nPoints - 1) / 2, (nPoints - 1) / 2 + 1).forEach(xP -> {
            if (xP != 0 || yP != 0) {
                double[] pt = new double[]{xCross + (double)xP * xStepAvg, yCross + (double)yP * yStepAvg};
                at.transform(pt, 0, pt, 0, 1);
                idealPoints.add(new Point2D.Double(pt[0], pt[1]));
            }
        }));
        return idealPoints;
    }

    protected static List<Point2D> sortFromReference(List<Roi> listToSort, List<Point2D> reference) {
        ArrayList<Point2D> sorted = new ArrayList<Point2D>();
        reference.forEach(iPt -> {
            for (Roi gPt : listToSort) {
                if (!gPt.contains((int)iPt.getX(), (int)iPt.getY())) continue;
                ImageStatistics stat = gPt.getStatistics();
                sorted.add(new Point2D.Double(stat.xCentroid, stat.yCentroid));
                break;
            }
        });
        return sorted;
    }

    protected static List<Double> computeFieldDistortion(List<Point2D> gridPoints, List<Point2D> idealGridPoints, double pixelSize) {
        ArrayList<Double> distValues = new ArrayList<Double>();
        for (int i = 0; i < gridPoints.size(); ++i) {
            distValues.add(gridPoints.get(i).distance(idealGridPoints.get(i)) * pixelSize);
        }
        return distValues;
    }

    protected static List<Double> computeFieldUniformity(List<Point2D> gridPoints, ImagePlus imp, double ovalRadius) {
        ArrayList<Double> intensityValues = new ArrayList<Double>();
        gridPoints.forEach(pt -> {
            OvalRoi ovalRoi = new OvalRoi(pt.getX() - ovalRadius, pt.getY() - ovalRadius, 2.0 * ovalRadius, 2.0 * ovalRadius);
            imp.setRoi((Roi)ovalRoi);
            intensityValues.add(imp.getStatistics().mean);
        });
        return intensityValues;
    }

    protected static List<Double> computeFWHM(List<Point2D> gridPoints, ImagePlus imp, int lineLength, double pixelSize) {
        ArrayList<Double> fwhmValues = new ArrayList<Double>();
        double[] xData = new double[lineLength];
        for (int i = 0; i < lineLength; ++i) {
            xData[i] = i;
        }
        for (Point2D pt : gridPoints) {
            int nAngles = 30;
            double[] fwhmRingValues = new double[nAngles];
            for (int angle = 0; angle < nAngles; ++angle) {
                double angleRad = (double)angle * Math.PI / (double)nAngles;
                double[] avgProfile = new double[lineLength];
                for (int i = 0; i < lineLength; ++i) {
                    avgProfile[i] = imp.getProcessor().getInterpolatedValue(pt.getX() + (double)i * Math.cos(angleRad), pt.getY() + (double)i * Math.sin(angleRad));
                }
                CurveFitter crvFitr = new CurveFitter(xData, avgProfile);
                crvFitr.doFit(12);
                double[] params = crvFitr.getParams();
                double d = params[3];
                double fwhm_val = 2.0 * Math.sqrt(2.0 * Math.log(2.0)) * d;
                fwhmRingValues[angle] = fwhm_val * pixelSize;
            }
            Arrays.sort(fwhmRingValues);
            int q1Pos = (int)((double)fwhmRingValues.length * 0.25);
            int q3Pos = (int)((double)fwhmRingValues.length * 0.75);
            double avgFWHM = 0.0;
            for (int i = q1Pos; i <= q3Pos; ++i) {
                avgFWHM += fwhmRingValues[i];
            }
            fwhmValues.add(avgFWHM / (double)(q3Pos - q1Pos + 1));
        }
        return fwhmValues;
    }
}

