/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.processing;

import ch.epfl.biop.image.ImageChannel;
import ch.epfl.biop.image.ImageFile;
import ch.epfl.biop.processing.ArgoGrid;
import ch.epfl.biop.processing.Processing;
import ch.epfl.biop.utils.IJLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ArgoSlideProcessing {
    public static void run(ImageFile imageFile, double userSigma, double userMedianRadius, String userThresholdingMethod, double userParticleThreshold, double userRingRadius, String argoSlide, int argoSpacing, int argoFOV, int argoNPoints) {
        int lineLength;
        ImagePlus imp = imageFile.getImage();
        double pixelSizeImage = imp.getCalibration().pixelWidth;
        int ovalRadius = lineLength = (int)(userRingRadius / pixelSizeImage);
        int NChannels = imp.getNChannels();
        double sigma = userSigma / pixelSizeImage;
        double medianRadius = userMedianRadius / pixelSizeImage;
        double particleThreshold = userParticleThreshold / pixelSizeImage;
        imageFile.addTags("raw", "argolight");
        imageFile.addKeyValue("Pixel_size_(um)", String.valueOf(pixelSizeImage));
        imageFile.addKeyValue("Profile_length_for_FWHM_(pix)", String.valueOf(lineLength));
        imageFile.addKeyValue("Oval_radius_(pix)", String.valueOf(ovalRadius));
        imageFile.addKeyValue("Thresholding_method", userThresholdingMethod);
        imageFile.addKeyValue("Sigma_(pix)", String.valueOf(sigma));
        imageFile.addKeyValue("Median_radius_(pix)", String.valueOf(medianRadius));
        imageFile.addKeyValue("Particle_threshold", String.valueOf(particleThreshold));
        imageFile.addKeyValue("ArgoSlide_name", argoSlide);
        imageFile.addKeyValue("ArgoSlide_spacing", String.valueOf(argoSpacing));
        imageFile.addKeyValue("ArgoSlide_FoV", String.valueOf(argoFOV));
        imageFile.addKeyValue("ArgoSlide_n_points", String.valueOf(argoNPoints));
        IJLogger.info("Image", "Pixel size : " + pixelSizeImage + " um");
        IJLogger.info("Detection parameters", "Ring radius : " + ovalRadius + " pix");
        IJLogger.info("Detection parameters", "Sigma : " + sigma + " pix");
        IJLogger.info("Detection parameters", "Median radius : " + medianRadius + " pix");
        IJLogger.info("Detection parameters", "Particle threshold : " + particleThreshold + " pix");
        RoiManager roiManager = RoiManager.getRoiManager();
        for (int c = 0; c < NChannels; ++c) {
            IJ.run((String)"Close All", (String)"");
            roiManager.reset();
            ImageChannel imageChannel = new ImageChannel(c, imp.getWidth(), imp.getHeight(), pixelSizeImage);
            ImagePlus channel = IJ.createHyperStack((String)(imp.getTitle() + "_ch" + c), (int)imp.getWidth(), (int)imp.getHeight(), (int)1, (int)1, (int)1, (int)imp.getBitDepth());
            imp.setPosition(c + 1, 1, 1);
            channel.setProcessor(imp.getProcessor());
            channel.show();
            Roi crossRoi = Processing.getCentralCross(channel, roiManager, pixelSizeImage, userThresholdingMethod, argoFOV);
            if (crossRoi.getStatistics().roiWidth < 0.0) {
                IJLogger.error("Cross detection", "The central cross cannot be detected.Cannot compute metrics");
                throw new RuntimeException();
            }
            imageChannel.setCenterCross(crossRoi);
            IJLogger.info("Channel " + c, "Cross = " + crossRoi);
            roiManager.addRoi(crossRoi);
            channel.setRoi(crossRoi);
            List<Point2D> gridPoints = Processing.getGridPoint(channel, crossRoi, sigma, medianRadius, particleThreshold, userThresholdingMethod, ovalRadius);
            if (gridPoints.isEmpty()) {
                IJLogger.error("Ring detection", "No rings are detected on the channel " + c + " of the current image. Cannot compute metrics");
                throw new RuntimeException();
            }
            roiManager.reset();
            ImageStatistics crossStata = crossRoi.getStatistics();
            double xCross = crossStata.xCentroid;
            double yCross = crossStata.yCentroid;
            List<Point2D> smallerGrid = gridPoints.stream().filter(e -> Math.abs(e.getX() - xCross) < 2.5 * (double)argoSpacing / pixelSizeImage && Math.abs(e.getY() - yCross) < 2.5 * (double)argoSpacing / pixelSizeImage).collect(Collectors.toList());
            if (!imageFile.getImagedFoV().equals("partialFoV")) {
                double xStepAvg = Processing.getAverageStep(smallerGrid.stream().map(Point2D::getX).collect(Collectors.toList()), pixelSizeImage, argoSpacing);
                imageChannel.addKeyValue("ch" + c + "_xStepAvg_(pix)", String.valueOf(xStepAvg));
                IJLogger.info("Channel " + c, "xStepAvg = " + xStepAvg + " pix");
                double yStepAvg = Processing.getAverageStep(smallerGrid.stream().map(Point2D::getY).collect(Collectors.toList()), pixelSizeImage, argoSpacing);
                imageChannel.addKeyValue("ch" + c + "_yStepAvg_(pix)", String.valueOf(yStepAvg));
                IJLogger.info("Channel " + c, "yStepAvg = " + yStepAvg + " pix");
                ArgoGrid argoGrid = Processing.computeRotationAndFinalFoV(gridPoints, xCross, yCross, pixelSizeImage, argoSpacing, ovalRadius, channel);
                double rotationAngle = argoGrid.getRotationAngle();
                if (Double.isNaN(rotationAngle)) {
                    IJLogger.error("Channel " + c, "Cannot compute the rotation angle. Metrics not computed");
                    throw new RuntimeException();
                }
                imageChannel.setRotationAngle(rotationAngle);
                IJLogger.info("Channel " + c, "Rotation angle theta = " + rotationAngle * 180.0 / Math.PI + "\u00b0");
                gridPoints.forEach(pR -> roiManager.addRoi((Roi)new OvalRoi(pR.getX() - (double)(4 * ovalRadius) + 0.5, pR.getY() - (double)(4 * ovalRadius) + 0.5, (double)(8 * ovalRadius), (double)(8 * ovalRadius))));
                List<Point2D> idealGridPoints = Processing.getIdealGridPoints(crossRoi, Math.min((int)Math.sqrt(gridPoints.size() + 1), argoGrid.getMaxNbPointsPerLine()), xStepAvg, yStepAvg, rotationAngle);
                gridPoints = Processing.sortFromReference(Arrays.asList(roiManager.getRoisAsArray()), idealGridPoints);
                roiManager.reset();
                for (Point2D pR2 : gridPoints) {
                    OvalRoi roi = new OvalRoi(pR2.getX() - (double)ovalRadius + 0.5, pR2.getY() - (double)ovalRadius + 0.5, (double)(2 * ovalRadius), (double)(2 * ovalRadius));
                    roi.setStrokeColor(Color.RED);
                    roiManager.addRoi((Roi)roi);
                }
                imageChannel.addGridRings(Arrays.asList(roiManager.getRoisAsArray()));
                ArrayList<Roi> idealGridPointsRoi = new ArrayList<Roi>();
                double idealSize = 0.4 / pixelSizeImage;
                for (Point2D pR3 : idealGridPoints) {
                    OvalRoi roi = new OvalRoi(pR3.getX() - idealSize + 0.5, pR3.getY() - idealSize + 0.5, 2.0 * idealSize, 2.0 * idealSize);
                    roi.setStrokeColor(Color.GREEN);
                    roi.setFillColor(Color.GREEN);
                    idealGridPointsRoi.add((Roi)roi);
                }
                idealGridPointsRoi.forEach(arg_0 -> ((RoiManager)roiManager).addRoi(arg_0));
                imageChannel.addIdealRings(idealGridPointsRoi);
                imageChannel.addFieldDistortion(Processing.computeFieldDistortion(gridPoints, idealGridPoints, pixelSizeImage));
                imageChannel.addFieldUniformity(Processing.computeFieldUniformity(gridPoints, channel, ovalRadius));
                imageFile.addTags("field_distortion", "field_uniformity");
            }
            if (!imageFile.getImagedFoV().equals("fullFoV")) {
                roiManager.reset();
                ArrayList<Roi> fwhmGridPointsRoiList = new ArrayList<Roi>();
                for (Point2D pR4 : smallerGrid) {
                    OvalRoi roi = new OvalRoi(pR4.getX() - (double)ovalRadius + 0.5, pR4.getY() - (double)ovalRadius + 0.5, (double)(2 * ovalRadius), (double)(2 * ovalRadius));
                    roi.setFillColor(new Color(255, 255, 255, 50));
                    roi.setStrokeColor(Color.RED);
                    roiManager.addRoi((Roi)roi);
                    fwhmGridPointsRoiList.add((Roi)roi);
                }
                imageChannel.addGridRings(fwhmGridPointsRoiList);
                smallerGrid.forEach(pR -> roiManager.addRoi((Roi)new PointRoi(pR.getX(), pR.getY())));
                imageChannel.addFWHM(Processing.computeFWHM(smallerGrid, channel, lineLength, pixelSizeImage));
                imageFile.addTags("fwhm");
            }
            roiManager.runCommand(channel, "Show All without labels");
            imageFile.addChannel(imageChannel);
        }
        roiManager.reset();
        roiManager.close();
        IJ.run((String)"Close All", (String)"");
        if (NChannels > 1) {
            imageFile.computePCC();
        }
    }
}

