/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.processing;

import ch.epfl.biop.image.ImageChannel;
import ch.epfl.biop.image.ImageFile;
import ch.epfl.biop.utils.IJLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.RoiEnlarger;
import ij.plugin.frame.RoiManager;
import ij.process.ImageStatistics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ArgoSlideOldProcessing {
    private static final int argoSpacing = 5;
    private static final int argoFOV = 100;
    private static final int argoNPoints = 21;
    private static final String thresholdingMethod = "Huang dark";

    public static void run(ImageFile imageFile) {
        ImagePlus imp = imageFile.getImage();
        double pixelSizeImage = imp.getCalibration().pixelWidth;
        double lineLength = (int)(1.25 / pixelSizeImage);
        double ovalRadius = (int)(1.25 / pixelSizeImage);
        int NChannels = imp.getNChannels();
        imageFile.addTags("raw", "argolight");
        imageFile.addKeyValue("Pixel_size_(um)", "" + pixelSizeImage);
        imageFile.addKeyValue("Profile_length_for_FWHM_(pix)", "" + lineLength);
        imageFile.addKeyValue("Oval_radius_(pix)", "" + ovalRadius);
        imageFile.addKeyValue("thresholding_method", thresholdingMethod);
        RoiManager roiManager = new RoiManager();
        for (int c = 0; c < NChannels; ++c) {
            IJ.run((String)"Close All", (String)"");
            roiManager.reset();
            ImageChannel imageChannel = new ImageChannel(c, imp.getWidth(), imp.getHeight(), pixelSizeImage);
            ImagePlus channel = IJ.createHyperStack((String)(imp.getTitle() + "_ch" + c), (int)imp.getWidth(), (int)imp.getHeight(), (int)1, (int)1, (int)1, (int)imp.getBitDepth());
            imp.setPosition(c + 1, 1, 1);
            channel.setProcessor(imp.getProcessor());
            channel.show();
            Roi crossRoi = ArgoSlideOldProcessing.getCentralCross(channel, roiManager, pixelSizeImage);
            imageChannel.setCenterCross(crossRoi);
            IJLogger.info("Channel " + c, "Cross = " + crossRoi);
            roiManager.addRoi(crossRoi);
            channel.setRoi(crossRoi);
            double sigma = 0.7000000000000001 / (pixelSizeImage * Math.sqrt(2.0));
            List<Point2D> gridPoints = ArgoSlideOldProcessing.getGridPoint2(channel, crossRoi, pixelSizeImage, sigma);
            List smallerGrid = gridPoints.stream().filter(e -> Math.abs(e.getX() - crossRoi.getStatistics().xCentroid) < 12.5 / pixelSizeImage && Math.abs(e.getY() - crossRoi.getStatistics().yCentroid) < 12.5 / pixelSizeImage).collect(Collectors.toList());
            double xStepAvg = ArgoSlideOldProcessing.getAverageStep(smallerGrid.stream().map(Point2D::getX).collect(Collectors.toList()), pixelSizeImage);
            imageChannel.addKeyValue("ch" + c + "_xStepAvg_(pix)", "" + xStepAvg);
            IJLogger.info("Channel " + c, "xStepAvg = " + xStepAvg + " pix");
            double yStepAvg = ArgoSlideOldProcessing.getAverageStep(smallerGrid.stream().map(Point2D::getY).collect(Collectors.toList()), pixelSizeImage);
            imageChannel.addKeyValue("ch" + c + "_yStepAvg_(pix)", "" + yStepAvg);
            IJLogger.info("Channel " + c, "yStepAvg = " + yStepAvg + " pix");
            double rotationAngle = ArgoSlideOldProcessing.getRotationAngle(gridPoints, crossRoi);
            imageChannel.setRotationAngle(rotationAngle * 180.0 / Math.PI);
            IJLogger.info("Channel " + c, "Rotation angle theta = " + rotationAngle * 180.0 / Math.PI + "\u00b0");
            List<Point2D> idealGridPoints = ArgoSlideOldProcessing.getIdealGridPoints(crossRoi, (int)Math.sqrt(gridPoints.size() + 1), xStepAvg, yStepAvg, rotationAngle);
            gridPoints.forEach(pR -> roiManager.addRoi((Roi)new OvalRoi(pR.getX() - 1.2 * ovalRadius, pR.getY() - 1.2 * ovalRadius, 2.4 * ovalRadius, 2.4 * ovalRadius)));
            gridPoints = ArgoSlideOldProcessing.sortFromReference(Arrays.asList(roiManager.getRoisAsArray()), idealGridPoints);
            roiManager.reset();
            gridPoints.forEach(pR -> roiManager.addRoi((Roi)new OvalRoi(pR.getX() - ovalRadius + 0.5, pR.getY() - ovalRadius + 0.5, 2.0 * ovalRadius, 2.0 * ovalRadius)));
            imageChannel.addGridRings(Arrays.asList(roiManager.getRoisAsArray()));
            gridPoints.forEach(pR -> roiManager.addRoi((Roi)new PointRoi(pR.getX(), pR.getY())));
            ArrayList<Roi> idealGridPointsRoi = new ArrayList<Roi>();
            idealGridPoints.forEach(pR -> idealGridPointsRoi.add((Roi)new OvalRoi(pR.getX() - ovalRadius / 2.0 + 0.5, pR.getY() - ovalRadius / 2.0 + 0.5, ovalRadius, ovalRadius)));
            idealGridPointsRoi.forEach(arg_0 -> ((RoiManager)roiManager).addRoi(arg_0));
            imageChannel.addIdealRings(idealGridPointsRoi);
            roiManager.runCommand(channel, "Show All without labels");
            imageChannel.addFieldDistortion(ArgoSlideOldProcessing.computeFieldDistortion(gridPoints, idealGridPoints, pixelSizeImage));
            imageChannel.addFieldUniformity(ArgoSlideOldProcessing.computeFieldUniformity(gridPoints, channel, ovalRadius));
            imageChannel.addFWHM(ArgoSlideOldProcessing.computeFWHM(gridPoints, channel, lineLength, roiManager, pixelSizeImage));
            imageFile.addChannel(imageChannel);
        }
        roiManager.reset();
        roiManager.close();
        IJ.run((String)"Close All", (String)"");
        if (NChannels > 1) {
            imageFile.computePCC();
        }
    }

    private static Roi getCentralCross(ImagePlus imp, RoiManager rm, double imagePixelSize) {
        rm.reset();
        IJ.run((ImagePlus)imp, (String)"Select None", (String)"");
        IJ.run((String)"Remove Overlay", (String)"");
        ImagePlus mask_imp = imp.duplicate();
        IJ.setAutoThreshold((ImagePlus)mask_imp, (String)thresholdingMethod);
        IJ.run((ImagePlus)mask_imp, (String)"Convert to Mask", (String)"");
        IJ.run((ImagePlus)mask_imp, (String)"Analyze Particles...", (String)("size=" + 2.5 / imagePixelSize + "-Infinity add"));
        double gridFactor = 100.0 / (4.0 * imagePixelSize);
        List rois = Arrays.stream(rm.getRoisAsArray()).filter(roi -> roi.getStatistics().xCentroid < (double)imp.getWidth() / 2.0 + gridFactor && roi.getStatistics().xCentroid > (double)imp.getWidth() / 2.0 - gridFactor && roi.getStatistics().yCentroid < (double)imp.getHeight() / 2.0 + gridFactor && roi.getStatistics().yCentroid > (double)imp.getHeight() / 2.0 - gridFactor).collect(Collectors.toList());
        Roi crossRoi = rois.stream().max(Comparator.comparing(roi -> roi.getStatistics().roiWidth)).get();
        rm.reset();
        return new Roi(crossRoi.getBounds());
    }

    private static List<Point2D> getGridPoint(ImagePlus DoGImage, Roi crossRoi, double pixelSizeImage) {
        Roi enlargedRectangle;
        int nPoints;
        if ((double)DoGImage.getWidth() * pixelSizeImage < 104.0 && (double)DoGImage.getHeight() * pixelSizeImage < 104.0) {
            nPoints = (int)Math.min(Math.floor(((double)DoGImage.getWidth() * pixelSizeImage / 2.0 - 2.0) / 5.0), Math.floor(((double)DoGImage.getHeight() * pixelSizeImage / 2.0 - 2.0) / 5.0));
            enlargedRectangle = RoiEnlarger.enlarge((Roi)crossRoi, (double)((int)Math.round(((double)(nPoints * 5) + 2.5) / (crossRoi.getStatistics().roiWidth * pixelSizeImage / 2.0) * crossRoi.getStatistics().roiWidth / 2.0)));
        } else {
            nPoints = 10;
            enlargedRectangle = RoiEnlarger.enlarge((Roi)crossRoi, (double)((int)Math.round(((double)(nPoints * 5) + 1.5) / (crossRoi.getStatistics().roiWidth * pixelSizeImage / 2.0) * crossRoi.getStatistics().roiWidth / 2.0)));
        }
        double large_rect_roi_x = enlargedRectangle.getStatistics().xCentroid;
        double large_rect_roi_y = enlargedRectangle.getStatistics().yCentroid;
        double large_rect_roi_w = enlargedRectangle.getStatistics().roiWidth;
        double large_rect_roi_h = enlargedRectangle.getStatistics().roiHeight;
        IJ.run((ImagePlus)DoGImage, (String)"Find Maxima...", (String)"prominence=1 strict exclude output=[List]");
        ResultsTable rt_points = ResultsTable.getResultsTable((String)"Results");
        if (rt_points == null) {
            return new ArrayList<Point2D>();
        }
        float[] raw_x_array = rt_points.getColumn(0);
        float[] raw_y_array = rt_points.getColumn(1);
        ArrayList<Point2D> gridPoints = new ArrayList<Point2D>();
        for (int i = 0; i < raw_x_array.length; ++i) {
            if (!(Math.abs((double)raw_x_array[i] - large_rect_roi_x) <= large_rect_roi_w / 2.0) || !(Math.abs((double)raw_y_array[i] - large_rect_roi_y) <= large_rect_roi_h / 2.0) || Math.abs((double)raw_x_array[i] - crossRoi.getStatistics().xCentroid) <= crossRoi.getStatistics().roiWidth / 2.0 && Math.abs((double)raw_y_array[i] - crossRoi.getStatistics().yCentroid) <= crossRoi.getStatistics().roiHeight / 2.0) continue;
            gridPoints.add(new Point2D.Double(raw_x_array[i], raw_y_array[i]));
        }
        return gridPoints;
    }

    private static List<Point2D> getGridPoint2(ImagePlus imp, Roi crossRoi, double pixelSizeImage, double sigma) {
        Roi enlargedRectangle;
        int nPoints;
        ImageStatistics crossStatistics = crossRoi.getStatistics();
        if ((double)imp.getWidth() * pixelSizeImage < 104.0 && (double)imp.getHeight() * pixelSizeImage < 104.0) {
            nPoints = (int)Math.min(Math.floor(((double)imp.getWidth() * pixelSizeImage / 2.0 - 2.0) / 5.0), Math.floor(((double)imp.getHeight() * pixelSizeImage / 2.0 - 2.0) / 5.0));
            enlargedRectangle = RoiEnlarger.enlarge((Roi)crossRoi, (double)((int)Math.round(((double)(nPoints * 5) + 2.5) / (crossStatistics.roiWidth * pixelSizeImage / 2.0) * crossStatistics.roiWidth / 2.0)));
        } else {
            nPoints = 10;
            enlargedRectangle = RoiEnlarger.enlarge((Roi)crossRoi, (double)((int)Math.round(((double)(nPoints * 5) + 1.5) / (crossStatistics.roiWidth * pixelSizeImage / 2.0) * crossStatistics.roiWidth / 2.0)));
        }
        ImageStatistics largeCrossStatistics = enlargedRectangle.getStatistics();
        double large_rect_roi_x = largeCrossStatistics.xCentroid;
        double large_rect_roi_y = largeCrossStatistics.yCentroid;
        double large_rect_roi_w = largeCrossStatistics.roiWidth;
        double large_rect_roi_h = largeCrossStatistics.roiHeight;
        ImagePlus imp2 = imp.duplicate();
        IJ.run((ImagePlus)imp2, (String)"Median...", (String)("radius=" + sigma));
        IJ.setAutoThreshold((ImagePlus)imp2, (String)"Li dark");
        IJ.run((ImagePlus)imp2, (String)"Convert to Mask", (String)"");
        IJ.run((String)"Set Measurements...", (String)"area mean min centroid perimeter display redirect=None decimal=3");
        IJ.run((ImagePlus)imp2, (String)"Analyze Particles...", (String)"pixel display clear overlay add");
        ResultsTable rt_points = ResultsTable.getResultsTable((String)"Results");
        if (rt_points == null) {
            return new ArrayList<Point2D>();
        }
        float[] raw_x_array = rt_points.getColumn(rt_points.getColumnIndex("X"));
        float[] raw_y_array = rt_points.getColumn(rt_points.getColumnIndex("Y"));
        ArrayList<Point2D> gridPoints = new ArrayList<Point2D>();
        for (int i = 0; i < raw_x_array.length; ++i) {
            double xInPixel = raw_x_array[i];
            double yInPixel = raw_y_array[i];
            double distance = Math.sqrt(Math.pow(crossStatistics.xCentroid - xInPixel, 2.0) + Math.pow(crossStatistics.yCentroid - yInPixel, 2.0));
            if (!(distance <= 74.235 / pixelSizeImage) || !(Math.abs(xInPixel - large_rect_roi_x) <= large_rect_roi_w / 2.0) || !(Math.abs(yInPixel - large_rect_roi_y) <= large_rect_roi_h / 2.0) || Math.abs(xInPixel - crossStatistics.xCentroid) <= crossStatistics.roiWidth / 2.0 && Math.abs(yInPixel - crossStatistics.yCentroid) <= crossStatistics.roiHeight / 2.0) continue;
            gridPoints.add(new Point2D.Double(xInPixel, yInPixel));
        }
        return gridPoints;
    }

    private static double getAverageStep(List<Double> values, double pixelSize) {
        double min = (Double)values.stream().min(Comparator.naturalOrder()).get();
        double max = (Double)values.stream().max(Comparator.naturalOrder()).get();
        double step_calc = (max - min) / (double)((int)Math.sqrt(values.size()));
        int tol = (int)(3.0 / pixelSize);
        ArrayList linesAvgs = new ArrayList();
        IntStream.range(0, (int)Math.sqrt(values.size() + 1)).forEach(line_idx -> {
            List lines = values.stream().filter(e -> e > min + (double)line_idx * step_calc - (double)tol && e < min + (double)line_idx * step_calc + (double)tol).collect(Collectors.toList());
            linesAvgs.add(lines.stream().reduce(0.0, Double::sum) / (double)lines.size());
        });
        ArrayList stepAvgs = new ArrayList();
        IntStream.range(0, linesAvgs.size() - 2).forEach(line_idx -> stepAvgs.add((Double)linesAvgs.get(line_idx + 1) - (Double)linesAvgs.get(line_idx)));
        return stepAvgs.stream().reduce(0.0, Double::sum) / (double)stepAvgs.size();
    }

    private static double getRotationAngle(List<Point2D> values, Roi crossRoi) {
        double xCross = crossRoi.getStatistics().xCentroid;
        double yCross = crossRoi.getStatistics().yCentroid;
        List sortedPoints = values.stream().sorted(Comparator.comparing(e -> e.distance(xCross, yCross))).collect(Collectors.toList());
        int lastIdx = values.size() - 1;
        List<Point2D> cornerPoints = Arrays.asList((Point2D)sortedPoints.get(lastIdx), (Point2D)sortedPoints.get(lastIdx - 1), (Point2D)sortedPoints.get(lastIdx - 2), (Point2D)sortedPoints.get(lastIdx - 3));
        Point2D topLeftCorner = (Point2D)cornerPoints.stream().filter(e -> e.getX() < xCross && e.getY() < yCross).collect(Collectors.toList()).get(0);
        Point2D topRightCorner = (Point2D)cornerPoints.stream().filter(e -> e.getX() > xCross && e.getY() < yCross).collect(Collectors.toList()).get(0);
        double theta = 0.0;
        if (Math.abs(topRightCorner.getX() - topLeftCorner.getX()) > 0.01) {
            theta = Math.atan2(topRightCorner.getY() - topLeftCorner.getY(), topRightCorner.getX() - topLeftCorner.getX());
        }
        return theta;
    }

    private static List<Point2D> getIdealGridPoints(Roi crossRoi, int nPoints, double xStepAvg, double yStepAvg, double theta) {
        double xCross = crossRoi.getStatistics().xCentroid;
        double yCross = crossRoi.getStatistics().yCentroid;
        AffineTransform at = AffineTransform.getRotateInstance(theta, xCross, yCross);
        ArrayList<Point2D> idealPoints = new ArrayList<Point2D>();
        IntStream.range(-(nPoints - 1) / 2, (nPoints - 1) / 2 + 1).forEach(yP -> IntStream.range(-(nPoints - 1) / 2, (nPoints - 1) / 2 + 1).forEach(xP -> {
            if (xP != 0 || yP != 0) {
                double[] pt = new double[]{xCross + (double)xP * xStepAvg, yCross + (double)yP * yStepAvg};
                at.transform(pt, 0, pt, 0, 1);
                idealPoints.add(new Point2D.Double(pt[0], pt[1]));
            }
        }));
        return idealPoints;
    }

    private static List<Point2D> sortFromReference(List<Roi> listToSort, List<Point2D> reference) {
        ArrayList<Point2D> sorted = new ArrayList<Point2D>();
        reference.forEach(iPt -> {
            for (Roi gPt : listToSort) {
                if (!gPt.contains((int)iPt.getX(), (int)iPt.getY())) continue;
                ImageStatistics stat = gPt.getStatistics();
                sorted.add(new Point2D.Double(stat.xCentroid, stat.yCentroid));
                break;
            }
        });
        return sorted;
    }

    private static List<Double> computeFieldDistortion(List<Point2D> gridPoints, List<Point2D> idealGridPoints, double pixelSize) {
        ArrayList<Double> distValues = new ArrayList<Double>();
        for (int i = 0; i < gridPoints.size(); ++i) {
            distValues.add(gridPoints.get(i).distance(idealGridPoints.get(i)) * pixelSize);
        }
        return distValues;
    }

    private static List<Double> computeFieldUniformity(List<Point2D> gridPoints, ImagePlus imp, double ovalRadius) {
        ArrayList<Double> intensityValues = new ArrayList<Double>();
        gridPoints.forEach(pt -> {
            OvalRoi ovalRoi = new OvalRoi(pt.getX() - ovalRadius, pt.getY() - ovalRadius, 2.0 * ovalRadius, 2.0 * ovalRadius);
            imp.setRoi((Roi)ovalRoi);
            intensityValues.add(imp.getStatistics().mean);
        });
        return intensityValues;
    }

    private static List<Double> computeFWHM(List<Point2D> gridPoints, ImagePlus imp, double lineLength, RoiManager rm, double pixelSize) {
        ArrayList<Double> fwhmValues = new ArrayList<Double>();
        gridPoints.forEach(pt -> {
            Line line_roi = new Line(pt.getX(), pt.getY(), pt.getX(), pt.getY() - lineLength);
            rm.addRoi((Roi)line_roi);
            imp.deleteRoi();
            imp.setRoi((Roi)line_roi);
            ProfilePlot pfpt = new ProfilePlot(imp);
            double[] yData = pfpt.getProfile();
            double[] xData = IntStream.range(0, yData.length).asDoubleStream().toArray();
            CurveFitter crvFitr = new CurveFitter(xData, yData);
            crvFitr.doFit(12);
            double[] params = crvFitr.getParams();
            double d = params[3];
            double fwhm_val = 2.0 * Math.sqrt(2.0 * Math.log(2.0)) * d;
            fwhmValues.add(fwhm_val * pixelSize);
        });
        return fwhmValues;
    }
}

