/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.processing;

import ch.epfl.biop.processing.ArgoGrid;
import ch.epfl.biop.processing.Processing;
import ch.epfl.biop.utils.IJLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ArgoSlideLivePreview {
    private static double xStepAvg = -1.0;
    private static double yStepAvg = -1.0;
    private static double rotationAngle = 10.0;

    public static void run(ImagePlus imp, double pixelSizeImage, double userSigma, double userMedianRadius, String userThresholdingMethod, double userParticleThreshold, double userRingRadius, int argoSpacing, int argoFOV) {
        int lineLength;
        int ovalRadius = lineLength = (int)(userRingRadius / pixelSizeImage);
        double sigma = userSigma / pixelSizeImage;
        double medianRadius = userMedianRadius / pixelSizeImage;
        double particleThreshold = userParticleThreshold / pixelSizeImage;
        IJ.run((ImagePlus)imp, (String)"Remove Overlay", (String)"");
        RoiManager roiManager = RoiManager.getRoiManager();
        roiManager.reset();
        try {
            Roi crossRoi = Processing.getCentralCross(imp, roiManager, pixelSizeImage, userThresholdingMethod, argoFOV);
            if (crossRoi.getStatistics().roiWidth < 0.0) {
                IJLogger.error("Live Preview", "The central cross cannot be detected.Cannot compute metrics");
                return;
            }
            roiManager.reset();
            ImageStatistics crossStata = crossRoi.getStatistics();
            double xCross = crossStata.xCentroid;
            double yCross = crossStata.yCentroid;
            List<Point2D> gridPoints = Processing.getGridPoint(imp, crossRoi, sigma, medianRadius, particleThreshold, userThresholdingMethod, ovalRadius);
            if (gridPoints.isEmpty()) {
                IJLogger.error("Live Preview", "No rings are detected on the current image. Cannot compute metrics");
                rotationAngle = 10.0;
                xStepAvg = -1.0;
                yStepAvg = -1.0;
                imp.setOverlay(null);
                return;
            }
            List smallerGrid = gridPoints.stream().filter(e -> Math.abs(e.getX() - xCross) < 2.5 * (double)argoSpacing / pixelSizeImage && Math.abs(e.getY() - yCross) < 2.5 * (double)argoSpacing / pixelSizeImage).collect(Collectors.toList());
            xStepAvg = Processing.getAverageStep(smallerGrid.stream().map(Point2D::getX).collect(Collectors.toList()), pixelSizeImage, argoSpacing);
            yStepAvg = Processing.getAverageStep(smallerGrid.stream().map(Point2D::getY).collect(Collectors.toList()), pixelSizeImage, argoSpacing);
            ArgoGrid argoGrid = Processing.computeRotationAndFinalFoV(gridPoints, xCross, yCross, pixelSizeImage, argoSpacing, ovalRadius, imp);
            rotationAngle = argoGrid.getRotationAngle();
            if (Double.isNaN(rotationAngle)) {
                IJLogger.error("Live Preview", "Cannot compute the rotation angle. Metrics not computed");
                rotationAngle = 10.0;
                xStepAvg = -1.0;
                yStepAvg = -1.0;
                imp.setOverlay(null);
                return;
            }
            ArrayList<Object> gridPointRois = new ArrayList<Roi>();
            for (Point2D point2D : gridPoints) {
                gridPointRois.add((Roi)new OvalRoi(point2D.getX() - (double)(4 * ovalRadius) + 0.5, point2D.getY() - (double)(4 * ovalRadius) + 0.5, (double)(8 * ovalRadius), (double)(8 * ovalRadius)));
            }
            List<Point2D> idealGridPoints = Processing.getIdealGridPoints(crossRoi, Math.min((int)Math.sqrt(gridPoints.size() + 1), argoGrid.getMaxNbPointsPerLine()), xStepAvg, yStepAvg, rotationAngle);
            gridPoints = Processing.sortFromReference(gridPointRois, idealGridPoints);
            gridPointRois = new ArrayList();
            for (Point2D pR : gridPoints) {
                OvalRoi roi = new OvalRoi(pR.getX() - (double)ovalRadius + 0.5, pR.getY() - (double)ovalRadius + 0.5, (double)(2 * ovalRadius), (double)(2 * ovalRadius));
                roi.setStrokeColor(Color.RED);
                gridPointRois.add(roi);
            }
            ArrayList<OvalRoi> arrayList = new ArrayList<OvalRoi>();
            double idealSize = 0.4 / pixelSizeImage;
            for (Point2D pR : idealGridPoints) {
                OvalRoi roi = new OvalRoi(pR.getX() - idealSize + 0.5, pR.getY() - idealSize + 0.5, 2.0 * idealSize, 2.0 * idealSize);
                roi.setStrokeColor(Color.GREEN);
                roi.setFillColor(Color.GREEN);
                arrayList.add(roi);
            }
            Overlay overlay = new Overlay();
            arrayList.forEach(arg_0 -> ((Overlay)overlay).add(arg_0));
            gridPointRois.forEach(arg_0 -> ((Overlay)overlay).add(arg_0));
            overlay.add(crossRoi);
            imp.setOverlay(overlay);
        }
        catch (Exception e2) {
            IJLogger.error("Live Preview", "An error occurred during processing", e2);
            rotationAngle = 10.0;
            xStepAvg = -1.0;
            yStepAvg = -1.0;
            imp.setOverlay(null);
        }
    }

    public static double getXAvgStep() {
        return xStepAvg;
    }

    public static double getYAvgStep() {
        return yStepAvg;
    }

    public static double getRotationAngle() {
        if (rotationAngle > Math.PI * 2) {
            return Double.NaN;
        }
        return rotationAngle * 180.0 / Math.PI;
    }
}

