/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.image;

import ch.epfl.biop.image.ImageChannel;
import ch.epfl.biop.utils.IJLogger;
import ch.epfl.biop.utils.Tools;
import ij.ImagePlus;
import ij.gui.Roi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageFile {
    private final String imgNameWithoutExtension;
    private final ImagePlus image;
    private final String id;
    private final String title;
    private final int serie;
    private String microscope;
    private String objective;
    private String immersionMedium;
    private String argoSlideName;
    private String acquisitionDate;
    private String imagedFoV;
    private String argoSlidePattern;
    private List<String> tags = new ArrayList<String>();
    private Map<String, String> keyValues = new TreeMap<String, String>();
    private List<List<Double>> pccValues = new ArrayList<List<Double>>();
    public List<ImageChannel> channels = new ArrayList<ImageChannel>();

    public ImageFile(ImagePlus imp, String id, String title, int serie) {
        this.image = imp;
        this.id = id;
        this.title = title;
        this.serie = serie;
        String imgName = imp.getTitle();
        this.imgNameWithoutExtension = ImageFile.getNameWithoutExtension(imgName);
        this.parseImageName(imgName);
    }

    public void addChannel(ImageChannel imageChannel) {
        this.channels.add(imageChannel);
    }

    public void addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
    }

    public void addKeyValue(String key, String value) {
        this.keyValues.put(key, value);
    }

    public int getNChannels() {
        return this.channels.size();
    }

    public String getImgNameWithoutExtension() {
        return this.imgNameWithoutExtension;
    }

    public Map<String, String> getKeyValues() {
        return this.keyValues;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSerie() {
        return this.serie;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public String getImagedFoV() {
        return this.imagedFoV;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void removeAllTags() {
        this.tags = new ArrayList<String>();
    }

    public List<List<Double>> getPCC() {
        return this.pccValues;
    }

    public String getArgoSlideName() {
        return this.argoSlideName;
    }

    public ImageChannel getChannel(int id) {
        if (id >= this.channels.size()) {
            IJLogger.error("Get image channel", "You try to access to channel " + id + " that doesn't exists");
            return null;
        }
        return this.channels.get(id);
    }

    private void parseImageName(String imgName) {
        Optional<FILETYPE> filePattern = Arrays.stream(FILETYPE.values()).filter(ft -> ft.matchesType(imgName)).findFirst();
        if (!filePattern.isPresent()) {
            IJLogger.error("The name " + imgName + "is not correctly formatted.");
            IJLogger.info("Please format it like 'MicroscopeName_ArgoSlideName_pattern_dDate_oObjective_immersion_FoV_serie.extension' for single file");
            IJLogger.info("Please format it like 'MicroscopeName_ArgoSlideName_pattern_dDate_oObjective_immersion.extension [FoV_serie]' for fileset images");
            return;
        }
        Matcher matcher = filePattern.get().pattern.matcher(imgName);
        if (matcher.find()) {
            this.microscope = matcher.group("microscope");
            this.objective = matcher.group("objective");
            this.imagedFoV = matcher.group("fov");
            this.immersionMedium = matcher.group("immersion");
            this.argoSlideName = matcher.group("argoslide");
            this.argoSlidePattern = matcher.group("pattern");
            this.acquisitionDate = matcher.group("date");
            this.addTags(this.imagedFoV, this.objective, this.argoSlideName, this.microscope.toLowerCase(), this.immersionMedium, this.argoSlidePattern);
        } else {
            IJLogger.error("The name " + imgName + "is not correctly formatted.");
            IJLogger.info("Please format it like 'MicroscopeName_ArgoSlideName_pattern_dDate_oObjective_immersion_FoV_serie.extension' for single file");
            IJLogger.info("Please format it like 'MicroscopeName_ArgoSlideName_pattern_dDate_oObjective_immersion.extension [FoV_serie]' for fileset images");
        }
    }

    private static String getNameWithoutExtension(String name) {
        if (name.contains(".lif")) {
            return name.replace(".lif", "");
        }
        if (name.contains(".vsi")) {
            return name.replace(".vsi", "");
        }
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public Map<List<String>, List<List<Double>>> summaryForParentTable() {
        ArrayList<ArrayList<Double>> summaryChannelsList = new ArrayList<ArrayList<Double>>();
        ArrayList<Object> headers = new ArrayList();
        for (ImageChannel channel : this.channels) {
            Map<String, Double> statMap = channel.channelSummary();
            statMap.put("Acquisition_date", this.acquisitionDate == null || this.acquisitionDate.equals("") ? 0.0 : Double.parseDouble(this.acquisitionDate));
            summaryChannelsList.add(new ArrayList<Double>(statMap.values()));
            headers = new ArrayList<String>(statMap.keySet());
        }
        HashMap<List<String>, List<List<Double>>> finalMap = new HashMap<List<String>, List<List<Double>>>();
        finalMap.put(headers, summaryChannelsList);
        return finalMap;
    }

    public void computePCC() {
        if (this.channels.size() > 1) {
            List<Roi> rois = this.channels.get(0).getGridRings();
            for (int i = 0; i < this.channels.size() - 1; ++i) {
                for (int j = i + 1; j < this.channels.size(); ++j) {
                    this.image.setPosition(i + 1, 1, 1);
                    ImagePlus ch1 = new ImagePlus("ch" + i, this.image.getProcessor());
                    this.image.setPosition(j + 1, 1, 1);
                    ImagePlus ch2 = new ImagePlus("ch" + j, this.image.getProcessor());
                    this.pccValues.add(Tools.computePCC(ch1, ch2, rois));
                }
            }
        } else {
            IJLogger.warn("PCC computation", "Only one channel for image " + this.image.getTitle() + ". Cannot compute PCC.");
        }
    }

    public static enum FILETYPE {
        SINGLE("Single file", Pattern.compile("(?<microscope>[^_]*)_(?<argoslide>[^_]*)_(?<pattern>[^_]*)_d(?<date>[\\d]*)_o(?<objective>[a-zA-Z0-9]*?)_(?<immersion>[^_]*?)_(?<fov>[a-zA-Z]*)_(?<serie>.*)\\.(?<extension>.*)"), Pattern.compile(".*[\\.][a-zA-Z0-9]*")),
        MULTIPLE_OMERO("File coming from a fileset", Pattern.compile("(?<microscope>[^_]*)_(?<argoslide>[^_]*)_(?<pattern>[^_]*)_d(?<date>[\\d]*)_o(?<objective>[a-zA-Z0-9]*?)_(?<immersion>[^_]*?)\\.(?<extension>[\\w]*).*\\[(?<fov>[a-zA-Z]*)_(?<serie>.*)\\]"), Pattern.compile(".*[\\.].*\\[.*\\]")),
        MULTIPLE_LOCAL("File coming from a fileset", Pattern.compile("(?<microscope>[^_]*)_(?<argoslide>[^_]*)_(?<pattern>[^_]*)_d(?<date>[\\d]*)_o(?<objective>[a-zA-Z0-9]*?)_(?<immersion>[^_]*?)\\.(?<extension>[\\w]*).*\\- (?<fov>[a-zA-Z]*)_(?<serie>.*)"), Pattern.compile(".*[\\.].*\\-.*")),
        OLDPROTOCOL("Single or multiple files with ArgoSim first protocol naming convention", Pattern.compile("(?<microscope>.*)_o(?<objective>.*)_(?<immersion>.*)_(?<pattern>.*)_d(?<date>[\\d]*)_?(?<series>.*)?\\.(?<extension>.*)"), Pattern.compile(".*"));

        private final String type;
        private final Pattern pattern;
        private final Pattern typeMatching;

        private FILETYPE(String type, Pattern pattern, Pattern comparator) {
            this.type = type;
            this.pattern = pattern;
            this.typeMatching = comparator;
        }

        boolean matchesType(String s) {
            return this.typeMatching.matcher(s).matches();
        }
    }
}

