/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.command;

import ch.epfl.biop.processing.Processing;
import ch.epfl.biop.retrievers.OMERORetriever;
import ch.epfl.biop.senders.LocalSender;
import ch.epfl.biop.senders.OMEROSender;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import fr.igred.omero.Client;
import fr.igred.omero.exception.ServiceException;
import java.io.File;
import org.scijava.plugin.Parameter;

public class ArgoLightOldCommand {
    @Parameter(label="OMERO host")
    String host;
    @Parameter(label="Enter your gaspar username")
    String username;
    @Parameter(label="Enter your gaspar password", style="password", persist=false)
    String password;
    @Parameter(label="Dataset name", choices={"LSM700_INT2", "LSM700_INT1", "LSM700_UP2", "LSM710", "SD_W1", "SP8_FLIM", "STED_3X", "SP8_UP1", "SP8_UP2", "SP8_INT1", "CSU_W1", "LSM980", "CELLXCELLENCE", "AXIOPLAN", "STEREOLOGY", "SIM-STORM", "SLIDESCANNER_1", "SLIDESCANNER_2", "LATTICE_LIGHTSHEET", "LIGHTSHEET_Z1", "PALM_MICROBEAM", "OPERETTA_CLS"})
    String microscope;
    @Parameter(label="Saving options", choices={"No heat maps saving", "Save heat maps locally", "Save heat maps in OMERO"})
    String savingOption;
    @Parameter(label="Save results locally", persist=true)
    boolean saveLocally;
    @Parameter(label="Saving folder", style="directory")
    File folder;
    @Parameter(label="Process all images (old + new ones)", persist=false)
    boolean isProcessingAllRawImages;
    static int port = 4064;
    static long argoLightProjectId = 2004L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Client client = new Client();
        try {
            client.connect(this.host, port, this.username, this.password.toCharArray());
            IJLogger.info("Successful connection to OMERO");
        }
        catch (ServiceException e) {
            IJLogger.error("Cannot connect to OMERO");
            throw new RuntimeException(e);
        }
        try {
            boolean savingHeatMaps;
            OMERORetriever omeroRetriever = new OMERORetriever(client, false);
            omeroRetriever.loadImages("" + argoLightProjectId, this.microscope, this.isProcessingAllRawImages, "ArgoSLG482");
            int nImages = omeroRetriever.getNImages();
            boolean bl = savingHeatMaps = !this.savingOption.equals("No heat maps saving");
            if (this.folder.exists()) {
                Sender sender = this.saveLocally ? new LocalSender(this.folder, this.microscope, false, true) : new OMEROSender(client, omeroRetriever.getMicroscopeTarget(), false);
                if (nImages > 0) {
                    Processing.run(omeroRetriever, savingHeatMaps, sender, 0.2, 0.2, "Li", 5.0, 1.25, "ArgoSLG482", 15, 570, 39);
                } else {
                    IJLogger.error("No images are available for project " + argoLightProjectId + ", dataset " + this.microscope);
                }
            } else {
                IJLogger.error("Directory " + this.folder.getAbsolutePath() + " doesn't exists");
            }
        }
        finally {
            client.disconnect();
            IJLogger.info("Disconnected from OMERO ");
        }
    }
}

