/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.command;

import ch.epfl.biop.processing.Processing;
import ch.epfl.biop.retrievers.OMERORetriever;
import ch.epfl.biop.senders.LocalSender;
import ch.epfl.biop.senders.OMEROSender;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import fr.igred.omero.Client;
import fr.igred.omero.exception.ServiceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;

public class ArgoLightJavaFXGui {
    private static String defaultHost;
    private static String defaultPort;
    private static String defaultProjectID;
    private ObservableList<String> defaultMicroscopes;
    private static String defaultRootFolder;
    private static String defaultSaveFolder;
    private final String hostKey = "OMERO Host";
    private final String portKey = "OMERO Port";
    private final String projectIdKey = "Project ID";
    private final String microscopeKey = "Microscopes";
    private final String saveFolderKey = "Saving folder";
    private final String rootFolderKey = "Root folder";
    private static final String folderName;
    private static final String fileName = "ArgoLight_default_params.csv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runProcessing(boolean isOmeroRetriever, String username, char[] password, String rootFolderPath, String microscope, boolean isOmeroSender, String savingFolderPath, boolean saveHeatMaps, boolean allImages) {
        boolean finalPopupMessage = true;
        if (!isOmeroRetriever && !new File(rootFolderPath).exists()) {
            ArgoLightJavaFXGui.showWarningMessage("Root folder not accessible", "The root folder " + rootFolderPath + " does not exist");
            return;
        }
        if (!isOmeroSender && !new File(savingFolderPath).exists()) {
            ArgoLightJavaFXGui.showWarningMessage("Saving folder not accessible", "The saving folder " + savingFolderPath + " does not exist");
            return;
        }
        Client client = new Client();
        try {
            client.connect(defaultHost, Integer.parseInt(defaultPort), username, password);
            IJLogger.info("Successful connection to OMERO");
        }
        catch (ServiceException e) {
            IJLogger.error("Cannot connect to OMERO");
            ArgoLightJavaFXGui.showErrorMessage("OMERO connections", "OMERO connection fails. Please check host, port and credentials");
            return;
        }
        try {
            Sender sender;
            OMERORetriever omeroRetriever = new OMERORetriever(client, false);
            omeroRetriever.loadImages(defaultProjectID, microscope, allImages, "ArgoSLG482");
            int nImages = omeroRetriever.getNImages();
            if (!isOmeroSender) {
                File savingFolder = new File(savingFolderPath);
                sender = new LocalSender(savingFolder, microscope, false, isOmeroRetriever);
            } else {
                sender = new OMEROSender(client, omeroRetriever.getMicroscopeTarget(), false);
            }
            if (nImages > 0) {
                Processing.run(omeroRetriever, saveHeatMaps, sender, 0.2, 0.2, "Li", 5.0, 1.25, "ArgoSLG482", 15, 570, 39);
            } else {
                IJLogger.error("No images are available for project " + defaultProjectID + ", dataset " + microscope);
            }
        }
        catch (Exception e) {
            finalPopupMessage = false;
        }
        finally {
            client.disconnect();
            IJLogger.info("Disconnected from OMERO ");
        }
        if (finalPopupMessage) {
            ArgoLightJavaFXGui.showInfoMessage("Processing Done", "All images have been analyzed and results saved");
        }
    }

    public void createGui() {
        String title = "Metrology with ArgoLight plugin";
        this.setDefaultParams();
        Label labHost = new Label(defaultHost + ":" + defaultPort);
        Label labUsername = new Label("Username");
        TextField tfUsername = new TextField();
        labUsername.setLabelFor((Node)tfUsername);
        Label labPassword = new Label("Password");
        PasswordField tfPassword = new PasswordField();
        labPassword.setLabelFor((Node)tfPassword);
        Label labProjectID = new Label("Project ID");
        TextField tfProjectID = new TextField(defaultProjectID);
        labProjectID.setLabelFor((Node)tfProjectID);
        Label labRootFolder = new Label("Root Folder");
        TextField tfRootFolder = new TextField(defaultRootFolder);
        labRootFolder.setLabelFor((Node)tfRootFolder);
        labRootFolder.setDisable(true);
        tfRootFolder.setDisable(true);
        Button bRootFolder = new Button("Choose folder");
        bRootFolder.setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Choose the microscopes' root folder");
            File rootFolder = directoryChooser.showDialog(null);
            if (rootFolder != null) {
                tfRootFolder.setText(rootFolder.getAbsolutePath());
            }
        });
        bRootFolder.setDisable(true);
        Label labMicroscope = new Label("Microscope");
        ComboBox cbMicroscope = new ComboBox(this.defaultMicroscopes);
        ToggleGroup senderChoice = new ToggleGroup();
        Label labSavingFolder = new Label("Saving Folder");
        TextField tfSavingFolder = new TextField(defaultSaveFolder);
        labSavingFolder.setLabelFor((Node)tfSavingFolder);
        labSavingFolder.setDisable(true);
        tfSavingFolder.setDisable(true);
        Button bSavingFolder = new Button("Choose folder");
        bSavingFolder.setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Choose the microscopes' root folder");
            File rootFolder = directoryChooser.showDialog(null);
            if (rootFolder != null) {
                tfSavingFolder.setText(rootFolder.getAbsolutePath());
            }
        });
        bSavingFolder.setDisable(true);
        CheckBox chkSaveHeatMap = new CheckBox("Save heat maps");
        chkSaveHeatMap.setMinWidth(Double.NEGATIVE_INFINITY);
        chkSaveHeatMap.setSelected(false);
        CheckBox chkAllImages = new CheckBox("Process again existing images");
        chkAllImages.setMinWidth(Double.NEGATIVE_INFINITY);
        chkAllImages.setSelected(false);
        RadioButton rbLocalSender = new RadioButton("Local");
        rbLocalSender.setToggleGroup(senderChoice);
        rbLocalSender.selectedProperty().addListener((v, o, n) -> {
            tfSavingFolder.setDisable(!rbLocalSender.isSelected());
            labSavingFolder.setDisable(!rbLocalSender.isSelected());
            bSavingFolder.setDisable(!rbLocalSender.isSelected());
        });
        rbLocalSender.setSelected(false);
        RadioButton rbOmeroSender = new RadioButton("OMERO");
        rbOmeroSender.setToggleGroup(senderChoice);
        rbOmeroSender.selectedProperty().addListener((v, o, n) -> {
            tfSavingFolder.setDisable(rbOmeroSender.isSelected());
            labSavingFolder.setDisable(rbOmeroSender.isSelected());
            bSavingFolder.setDisable(rbOmeroSender.isSelected());
        });
        rbOmeroSender.setSelected(true);
        ToggleGroup retrieverChoice = new ToggleGroup();
        RadioButton rbOmeroRetriever = new RadioButton("OMERO");
        rbOmeroRetriever.setToggleGroup(retrieverChoice);
        rbOmeroRetriever.setSelected(true);
        rbOmeroRetriever.selectedProperty().addListener((v, o, n) -> {
            labRootFolder.setDisable(rbOmeroRetriever.isSelected());
            tfRootFolder.setDisable(rbOmeroRetriever.isSelected());
            bRootFolder.setDisable(rbOmeroRetriever.isSelected());
            tfUsername.setDisable(!rbOmeroRetriever.isSelected());
            tfPassword.setDisable(!rbOmeroRetriever.isSelected());
            labHost.setDisable(!rbOmeroRetriever.isSelected());
            labUsername.setDisable(!rbOmeroRetriever.isSelected());
            labPassword.setDisable(!rbOmeroRetriever.isSelected());
            rbOmeroSender.setDisable(!rbOmeroRetriever.isSelected());
            labProjectID.setDisable(!rbOmeroRetriever.isSelected());
            tfProjectID.setDisable(!rbOmeroRetriever.isSelected());
            tfSavingFolder.setDisable(rbOmeroRetriever.isSelected());
            labSavingFolder.setDisable(rbOmeroRetriever.isSelected());
            bSavingFolder.setDisable(rbOmeroRetriever.isSelected());
        });
        RadioButton rbLocalRetriever = new RadioButton("Local");
        rbLocalRetriever.setToggleGroup(retrieverChoice);
        rbLocalRetriever.setSelected(false);
        rbLocalRetriever.selectedProperty().addListener((v, o, n) -> {
            tfUsername.setDisable(rbLocalRetriever.isSelected());
            tfPassword.setDisable(rbLocalRetriever.isSelected());
            labHost.setDisable(rbLocalRetriever.isSelected());
            labUsername.setDisable(rbLocalRetriever.isSelected());
            labPassword.setDisable(rbLocalRetriever.isSelected());
            labProjectID.setDisable(rbLocalRetriever.isSelected());
            tfProjectID.setDisable(rbLocalRetriever.isSelected());
            bRootFolder.setDisable(!rbLocalRetriever.isSelected());
            tfRootFolder.setDisable(!rbLocalRetriever.isSelected());
            labRootFolder.setDisable(!rbLocalRetriever.isSelected());
            rbOmeroSender.setSelected(!rbLocalRetriever.isSelected());
            rbLocalSender.setSelected(rbLocalRetriever.isSelected());
            rbOmeroSender.setDisable(rbLocalRetriever.isSelected());
            tfSavingFolder.setDisable(rbLocalRetriever.isSelected());
            labSavingFolder.setDisable(rbLocalRetriever.isSelected());
            bSavingFolder.setDisable(rbLocalRetriever.isSelected());
        });
        Button bSettings = new Button("Settings");
        bSettings.setOnAction(e -> {
            this.createSettingsPane();
            this.setDefaultParams();
            labHost.setText(defaultHost + ":" + defaultPort);
            cbMicroscope.setItems(this.defaultMicroscopes);
            tfProjectID.setText(defaultProjectID);
            tfRootFolder.setText(defaultRootFolder);
            tfSavingFolder.setText(defaultSaveFolder);
        });
        ColumnConstraints colFourth = new ColumnConstraints();
        colFourth.setPercentWidth(0.0);
        int omeroRow = 0;
        GridPane omeroPane = new GridPane();
        omeroPane.add((Node)rbOmeroRetriever, 0, omeroRow++);
        omeroPane.add((Node)labHost, 0, omeroRow++, 2, 1);
        omeroPane.add((Node)labUsername, 0, omeroRow);
        omeroPane.add((Node)tfUsername, 1, omeroRow++);
        omeroPane.add((Node)labPassword, 0, omeroRow);
        omeroPane.add((Node)tfPassword, 1, omeroRow++);
        omeroPane.add((Node)labProjectID, 0, omeroRow);
        omeroPane.add((Node)tfProjectID, 1, omeroRow);
        omeroPane.setHgap(5.0);
        omeroPane.setVgap(5.0);
        int localRow = 0;
        GridPane localPane = new GridPane();
        localPane.add((Node)rbLocalRetriever, 0, localRow++);
        localPane.add((Node)labRootFolder, 0, localRow);
        localPane.add((Node)tfRootFolder, 1, localRow++);
        localPane.add((Node)bRootFolder, 0, localRow, 2, 1);
        localPane.setHgap(5.0);
        localPane.setVgap(5.0);
        int retrieverRow = 0;
        GridPane retrieverPane = new GridPane();
        retrieverPane.add((Node)omeroPane, 0, retrieverRow);
        retrieverPane.add((Node)localPane, 1, retrieverRow);
        retrieverPane.setHgap(10.0);
        retrieverPane.setVgap(5.0);
        int microscopeRow = 0;
        GridPane microscopePane = new GridPane();
        microscopePane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colFourth, colFourth, colFourth, colFourth});
        microscopePane.add((Node)labMicroscope, 1, microscopeRow);
        microscopePane.add((Node)cbMicroscope, 2, microscopeRow);
        microscopePane.setHgap(5.0);
        microscopePane.setVgap(5.0);
        GridPane savingPane = new GridPane();
        savingPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colFourth, colFourth, colFourth, colFourth});
        savingPane.add((Node)rbOmeroSender, 1, localRow);
        savingPane.add((Node)rbLocalSender, 2, localRow++);
        savingPane.add((Node)chkSaveHeatMap, 0, localRow);
        savingPane.add((Node)labSavingFolder, 2, localRow);
        savingPane.add((Node)tfSavingFolder, 3, localRow++);
        savingPane.add((Node)chkAllImages, 0, localRow, 2, 1);
        savingPane.add((Node)bSavingFolder, 3, localRow);
        savingPane.setHgap(10.0);
        savingPane.setVgap(5.0);
        int generalRow = 0;
        double MAX_FONT_SIZE = 20.0;
        GridPane generalPane = new GridPane();
        Label retrieverHeader = new Label("Get images from");
        retrieverHeader.setFont(new Font(20.0));
        generalPane.add((Node)retrieverHeader, 0, generalRow++, 2, 1);
        generalPane.add((Node)retrieverPane, 0, generalRow++);
        generalPane.add((Node)new Separator(), 0, generalRow++, 2, 1);
        Label microscopeHeader = new Label("Choose your microscope");
        microscopeHeader.setFont(new Font(20.0));
        generalPane.add((Node)microscopeHeader, 0, generalRow++, 2, 1);
        generalPane.add((Node)microscopePane, 0, generalRow++);
        generalPane.add((Node)new Separator(), 0, generalRow++, 4, 1);
        Label savingHeader = new Label("Where to save results");
        savingHeader.setFont(new Font(20.0));
        generalPane.add((Node)savingHeader, 0, generalRow++, 2, 1);
        generalPane.add((Node)savingPane, 0, generalRow++);
        generalPane.add((Node)new Separator(), 0, generalRow++, 4, 1);
        Label settingsHeader = new Label("Setup your project");
        settingsHeader.setFont(new Font(20.0));
        generalPane.add((Node)settingsHeader, 0, generalRow++, 2, 1);
        generalPane.add((Node)bSettings, 0, generalRow);
        generalPane.setHgap(10.0);
        generalPane.setVgap(10.0);
        if (!ArgoLightJavaFXGui.buildDialog(title, (Node)generalPane)) {
            return;
        }
        int passLength = tfPassword.getCharacters().length();
        char[] password = new char[passLength];
        for (int i = 0; i < passLength; ++i) {
            password[i] = tfPassword.getCharacters().charAt(i);
        }
        ArgoLightJavaFXGui.runProcessing(rbOmeroRetriever.isSelected(), tfUsername.getText(), password, tfRootFolder.getText(), (String)cbMicroscope.getSelectionModel().getSelectedItem(), rbOmeroSender.isSelected(), tfSavingFolder.getText(), chkSaveHeatMap.isSelected(), chkAllImages.isSelected());
    }

    private void setDefaultParams() {
        Map<String, List<String>> defaultParams = ArgoLightJavaFXGui.getDefaultParams();
        String string = defaultParams.containsKey("OMERO Host") ? (defaultParams.get("OMERO Host").isEmpty() ? "localhost" : defaultParams.get("OMERO Host").get(0)) : (defaultHost = "localhost");
        defaultPort = defaultParams.containsKey("OMERO Port") ? (defaultParams.get("OMERO Port").isEmpty() ? "4064" : defaultParams.get("OMERO Port").get(0)) : "4064";
        ObservableList observableList = this.defaultMicroscopes = defaultParams.containsKey("Microscopes") ? FXCollections.observableArrayList((Collection)defaultParams.get("Microscopes")) : FXCollections.observableArrayList();
        String string2 = defaultParams.containsKey("Project ID") ? (defaultParams.get("Project ID").isEmpty() ? "-1" : defaultParams.get("Project ID").get(0)) : (defaultProjectID = "-1");
        String string3 = defaultParams.containsKey("Root folder") ? (defaultParams.get("Root folder").isEmpty() ? "" : defaultParams.get("Root folder").get(0)) : (defaultRootFolder = "");
        defaultSaveFolder = defaultParams.containsKey("Saving folder") ? (defaultParams.get("Saving folder").isEmpty() ? "" : defaultParams.get("Saving folder").get(0)) : "";
    }

    private void createSettingsPane() {
        Label labHost = new Label("OMERO host");
        TextField tfHost = new TextField(defaultHost);
        labHost.setLabelFor((Node)tfHost);
        Label labPort = new Label("OMERO port");
        TextField tfPort = new TextField(defaultPort);
        labPort.setLabelFor((Node)tfPort);
        Label labProject = new Label("OMERO Project ID");
        TextField tfProject = new TextField(defaultProjectID);
        labProject.setLabelFor((Node)tfProject);
        Label labMicroscope = new Label("Microscopes");
        TextField tfMicroscope = new TextField(String.join((CharSequence)",", this.defaultMicroscopes));
        labMicroscope.setLabelFor((Node)tfMicroscope);
        Button bChooseMicroscope = new Button("Open file");
        bChooseMicroscope.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Choose the microscopes' csv file");
            File rootFolder = fileChooser.showOpenDialog(null);
            if (rootFolder == null || !rootFolder.exists()) {
                ArgoLightJavaFXGui.showErrorMessage("No files", "The file you selected does not exist. Please check your path / file");
            } else if (!rootFolder.getAbsolutePath().endsWith(".csv")) {
                ArgoLightJavaFXGui.showErrorMessage("Wrong file type", "The file you selected is not a .csv file. Please select a .csv file");
            } else {
                List<String> microscopes = ArgoLightJavaFXGui.parseMicroscopesCSV(rootFolder);
                String microscopesList = String.join((CharSequence)",", microscopes);
                tfMicroscope.setText(microscopesList);
            }
        });
        Label labRootFolder = new Label("Root folder");
        TextField tfRootFolder = new TextField(defaultRootFolder);
        labRootFolder.setLabelFor((Node)tfRootFolder);
        Label labSaveFolder = new Label("Saving folder");
        TextField tfSaveFolder = new TextField(defaultSaveFolder);
        labSaveFolder.setLabelFor((Node)tfSaveFolder);
        Button bChooseRootFolder = new Button("Open folder");
        bChooseRootFolder.setOnAction(e -> {
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle("Choose the root folder where to get local image");
            File rootFolder = dirChooser.showDialog(null);
            if (rootFolder != null) {
                tfRootFolder.setText(rootFolder.getAbsolutePath());
            }
        });
        Button bChooseSaveFolder = new Button("Open folder");
        bChooseSaveFolder.setOnAction(e -> {
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle("Choose the folder where to results");
            File rootFolder = dirChooser.showDialog(null);
            if (rootFolder != null) {
                tfSaveFolder.setText(rootFolder.getAbsolutePath());
            }
        });
        int row = 0;
        GridPane settingsPane = new GridPane();
        settingsPane.add((Node)labHost, 0, row);
        settingsPane.add((Node)tfHost, 1, row++, 2, 1);
        settingsPane.add((Node)labPort, 0, row);
        settingsPane.add((Node)tfPort, 1, row++);
        settingsPane.add((Node)labProject, 0, row);
        settingsPane.add((Node)tfProject, 1, row++);
        settingsPane.add((Node)labMicroscope, 0, row);
        settingsPane.add((Node)tfMicroscope, 1, row);
        settingsPane.add((Node)bChooseMicroscope, 2, row++);
        settingsPane.add((Node)labRootFolder, 0, row);
        settingsPane.add((Node)tfRootFolder, 1, row);
        settingsPane.add((Node)bChooseRootFolder, 2, row++);
        settingsPane.add((Node)labSaveFolder, 0, row);
        settingsPane.add((Node)tfSaveFolder, 1, row);
        settingsPane.add((Node)bChooseSaveFolder, 2, row);
        settingsPane.setHgap(5.0);
        settingsPane.setVgap(5.0);
        if (!ArgoLightJavaFXGui.buildDialog("Setup your default settings", (Node)settingsPane)) {
            return;
        }
        this.buildCSVFile(tfHost.getText(), tfPort.getText(), tfProject.getText(), tfMicroscope.getText(), tfRootFolder.getText(), tfSaveFolder.getText());
    }

    private static boolean buildDialog(String title, Node content) {
        ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
        buttons.add(ButtonType.OK);
        buttons.add(ButtonType.CANCEL);
        Dialog dialog = new Dialog();
        if (title != null) {
            dialog.setTitle(title);
        } else {
            dialog.setTitle("");
        }
        dialog.getDialogPane().setContent(content);
        dialog.getDialogPane().getButtonTypes().setAll(buttons);
        dialog.setResizable(true);
        dialog.initModality(Modality.APPLICATION_MODAL);
        return dialog.showAndWait().orElse(ButtonType.NO) == ButtonType.OK;
    }

    private static Map<String, List<String>> getDefaultParams() {
        File file = new File(folderName + File.separator + fileName);
        HashMap<String, List<String>> default_params = new HashMap<String, List<String>>();
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] items = line.split(",");
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(items).subList(1, items.length));
                default_params.put(items[0], values);
            }
            br.close();
            return default_params;
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    private static void showInfoMessage(String title, String content) {
        ArgoLightJavaFXGui.showMessage(title, content, Alert.AlertType.INFORMATION);
    }

    private static void showErrorMessage(String title, String content) {
        ArgoLightJavaFXGui.showMessage(title, content, Alert.AlertType.ERROR);
    }

    private static void showWarningMessage(String title, String content) {
        ArgoLightJavaFXGui.showMessage(title, content, Alert.AlertType.WARNING);
    }

    private static void showMessage(String title, String content, Alert.AlertType alert) {
        Alert dialog = new Alert(alert);
        if (title != null) {
            dialog.setTitle(title);
        } else {
            dialog.setTitle("");
        }
        dialog.getDialogPane().setContent((Node)new Label(content));
        dialog.setResizable(false);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.show();
    }

    private static List<String> parseMicroscopesCSV(File file) {
        ArrayList<String> items = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                items.add(line.replace("\ufeff", ""));
            }
            br.close();
            return items;
        }
        catch (IOException e) {
            ArgoLightJavaFXGui.showWarningMessage("CSV parsing", "Couldn't parse the csv file. No default microscopes to add");
            return Collections.emptyList();
        }
    }

    private void buildCSVFile(String host, String port, String projectID, String microscopes, String rootFolder, String savingFolder) {
        File directory = new File(folderName);
        if (!directory.exists()) {
            directory.mkdir();
        }
        try {
            File file = new File(directory.getAbsoluteFile() + File.separator + fileName);
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            buffer.write("OMERO Host," + host + "\n");
            buffer.write("OMERO Port," + port + "\n");
            buffer.write("Project ID," + projectID + "\n");
            buffer.write("Microscopes," + microscopes + "\n");
            buffer.write("Root folder," + rootFolder + "\n");
            buffer.write("Saving folder," + savingFolder + "\n");
            buffer.close();
        }
        catch (IOException e) {
            ArgoLightJavaFXGui.showWarningMessage("CSV writing", "Couldn't write the csv for default parameters.");
        }
    }

    static {
        folderName = "." + File.separator + "plugins" + File.separator + "BIOP";
    }
}

