/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.command;

import ch.epfl.biop.processing.ArgoSlideLivePreview;
import ch.epfl.biop.processing.Processing;
import ch.epfl.biop.retrievers.LocalRetriever;
import ch.epfl.biop.retrievers.OMERORetriever;
import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.senders.LocalSender;
import ch.epfl.biop.senders.OMEROSender;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import fr.igred.omero.Client;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ImageWrapper;
import ij.IJ;
import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import loci.formats.FormatException;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import net.imagej.ImageJ;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>ArgoLight analysis tool")
public class ArgoLightCommand
implements Command {
    private String userHost;
    private String userPort;
    private List<String> omeroMicroscopes = Collections.emptyList();
    private List<String> omeroProjects = Collections.emptyList();
    private List<String> omeroDatasets = Collections.emptyList();
    private List<String> localMicroscopes = Collections.emptyList();
    private List<String> userArgoSlides;
    private String defaultArgoSlide;
    private Map<String, List<String>> argoSlidesParameters = Collections.emptyMap();
    private String userRootFolder;
    private String userSaveFolder;
    private double userSigma;
    private double userMedianRadius;
    private String userThresholdMethod;
    private double userParticleThresh;
    private double userRingRadius;
    private boolean isDefaultSigma;
    private boolean isDefaultMedianRadius;
    private boolean isDefaultThresholdMethod;
    private boolean isDefaultParticleThresh;
    private boolean isDefaultRingRadius;
    private boolean startsProcessing = false;
    private JDialog mainDialog;
    private JDialog settingsDialog;
    private JDialog processingDialog;
    private JDialog livePreviewDialog;
    private final String defaultHost = "localhost";
    private final String defaultPort = "4064";
    private final int defaultArgoSpacing = 1;
    private final int defaultArgoFoV = 10;
    private final int defaultArgoNRings = 1;
    private final double defaultSigma = 0.2;
    private final double defaultMedianRadius = 0.2;
    private final String defaultThresholdMethod = "Li";
    private final double defaultParticleThresh = 5.0;
    private final double defaultRingRadius = 1.25;
    private final int sigmaUpperBound = 10;
    private final int particleThresholdUpperBound = 30;
    private final int ringRadiusUpperBound = 5;
    private static final List<String> thresholdingMethods = Arrays.asList("Default", "Huang", "Intermodes", "IsoData", "IJ_IsoData", "Li", "MaxEntropy", "Mean", "MinError(I)", "Minimum", "Moments", "Otsu", "Percentile", "RenyiEntropy", "Shanbhag", "Triangle", "Yen");
    private final String hostKey = "OMERO Host";
    private final String portKey = "OMERO Port";
    private final String argoSlidesKey = "ArgoSlides";
    private final String saveFolderKey = "Saving folder";
    private final String rootFolderKey = "Root folder";
    private final int argoDefaultPos = 0;
    private final int argoSpacingPos = 1;
    private final int argoFoVPos = 2;
    private final int argoNRingsPos = 3;
    private final String sigmaKey = "Sigma";
    private final String medianKey = "Median radius";
    private final String segmentationKey = "Segmentation method";
    private final String threshParticlesKey = "Particle size threshold";
    private final String ringRadiusKey = "Analyzed ring radius";
    private final String folderName = "." + File.separator + "plugins" + File.separator + "BIOP";
    private final String fileName = "ArgoLight_default_params.csv";
    private final String processingFileName = "ArgoLight_default_processing_params.csv";
    private final String argoSlideFileName = "ArgoLight_default_argoslide_params.csv";
    private final Font stdFont = new Font("Calibri", 0, 17);
    private final Font titleFont = new Font("Calibri", 1, 22);
    private final Client client = new Client();
    private CONNECTION_STATE connection_state = CONNECTION_STATE.DISCONNECTED;
    private ImagePlus imageForLivePreview = null;
    private double pixelSizeForLivePreview;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcessing(boolean isOmeroRetriever, String omeroFolderName, boolean isMicOnProject, String rootFolderPath, String microscope, String argoSlide, boolean isOmeroSender, String savingFolderPath, boolean saveHeatMaps, boolean allImages, boolean cleanTargetSelection) {
        boolean finalPopupMessage = true;
        if (!isOmeroRetriever && !new File(rootFolderPath).exists()) {
            this.showWarningMessage("Root folder not accessible", "The root folder " + rootFolderPath + " does not exist");
            IJLogger.info("ArgoLight Analysis Tool exited");
            return;
        }
        if (!isOmeroSender && !new File(savingFolderPath).exists()) {
            this.showWarningMessage("Saving folder not accessible", "The saving folder " + savingFolderPath + " does not exist");
            IJLogger.info("ArgoLight Analysis Tool exited");
            return;
        }
        if (argoSlide == null || argoSlide.isEmpty() || argoSlide.equalsIgnoreCase("null")) {
            this.showWarningMessage("No ArgoSlide selected", "You need to create an ArgoSlide first. Click on 'General Settings' and fill 'ArgoSlides' field");
            IJLogger.info("ArgoLight Analysis Tool exited");
            return;
        }
        if (!this.argoSlidesParameters.containsKey(argoSlide)) {
            this.showWarningMessage("No ArgoSlide settings", "You need to create settings for '" + argoSlide + "' ArgoSlide. Click on 'Settings' under 'Choose your ArgoSlide' and fill the fields");
            IJLogger.info("ArgoLight Analysis Tool exited");
            return;
        }
        try {
            String rawTarget;
            Retriever retriever;
            if (isOmeroRetriever) {
                if (!this.client.isConnected()) {
                    IJLogger.error("Not connected to OMERO");
                    IJLogger.info("ArgoLight Analysis Tool exited");
                    return;
                }
                retriever = new OMERORetriever(this.client, isMicOnProject);
                rawTarget = omeroFolderName;
            } else {
                retriever = new LocalRetriever(savingFolderPath);
                rawTarget = rootFolderPath;
            }
            boolean imageLoaded = retriever.loadImages(rawTarget, microscope, allImages, argoSlide);
            if (imageLoaded) {
                Sender sender;
                boolean cleanTarget;
                int nImages = retriever.getNImages();
                boolean bl = cleanTarget = allImages && cleanTargetSelection;
                if (isOmeroSender) {
                    sender = new OMEROSender(this.client, retriever.getMicroscopeTarget(), cleanTarget);
                } else {
                    File savingFolder = new File(savingFolderPath);
                    sender = new LocalSender(savingFolder, microscope, cleanTarget, isOmeroRetriever);
                }
                List<String> argoParams = this.argoSlidesParameters.get(argoSlide);
                if (nImages > 0) {
                    Processing.run(retriever, saveHeatMaps, sender, this.isDefaultSigma ? 0.2 : this.userSigma, this.isDefaultMedianRadius ? 0.2 : this.userMedianRadius, this.isDefaultThresholdMethod ? "Li" : this.userThresholdMethod, this.isDefaultParticleThresh ? 5.0 : this.userParticleThresh, this.isDefaultRingRadius ? 1.25 : this.userRingRadius, argoSlide, Integer.parseInt(argoParams.get(1)), Integer.parseInt(argoParams.get(2)), Integer.parseInt(argoParams.get(3)));
                } else {
                    IJLogger.warn("Parent container : " + rawTarget + ", microscope " + microscope + " does not contain any images");
                    this.showWarningMessage("No Images", "<html> Parent container : " + rawTarget + ", microscope '" + microscope + "', does not contain any images.<p><ul><li> The selected slide '" + argoSlide + "' may not matched the one used on the images</li><p><li> The name of the images doesn't contain the name of the selected microscope '" + microscope + "'</li><p><li> The images have already been processed</li></ul>");
                    finalPopupMessage = false;
                }
            } else {
                finalPopupMessage = false;
                IJLogger.error("Images cannot be loaded from the parent container : " + rawTarget + ", microscope " + microscope);
            }
        }
        catch (Exception e) {
            finalPopupMessage = false;
            IJLogger.error("Unexpected issue occurred", e);
        }
        finally {
            if (this.client.isConnected()) {
                this.client.disconnect();
                IJLogger.info("Disconnected from OMERO ");
            }
        }
        IJLogger.info("ArgoLight Analysis Tool exited");
        if (finalPopupMessage) {
            this.showInfoMessage("Processing Done", "All images have been analyzed and results saved");
        }
    }

    private boolean connectToOmero(Client client, String username, char[] password) {
        try {
            client.connect(this.userHost, Integer.parseInt(this.userPort), username, password);
            IJLogger.info("Successful connection to OMERO");
            return true;
        }
        catch (ServiceException e) {
            IJLogger.error("Cannot connect to OMERO", (Exception)((Object)e));
            this.showErrorMessage("OMERO connections", "OMERO connection fails. Please check host, port and credentials");
            return false;
        }
    }

    private void createGui() {
        boolean supportsWindowDecorations;
        String title = "Metrology with ArgoLight plugin";
        JDialog generalPane = new JDialog();
        JPanel omeroPane = new JPanel();
        this.setDefaultGeneralParams();
        this.setDefaultArgoParams();
        this.setDefaultProcessingParams();
        JLabel labHost = new JLabel(this.userHost + ":" + this.userPort);
        labHost.setFont(this.stdFont);
        JLabel labUsername = new JLabel("Username");
        labUsername.setFont(this.stdFont);
        JTextField tfUsername = new JTextField();
        tfUsername.setFont(this.stdFont);
        tfUsername.setColumns(15);
        JLabel labPassword = new JLabel("Password");
        labPassword.setFont(this.stdFont);
        JPasswordField tfPassword = new JPasswordField();
        tfPassword.setFont(this.stdFont);
        tfPassword.setColumns(15);
        JLabel labProject = new JLabel("Project");
        labProject.setFont(this.stdFont);
        DefaultComboBoxModel modelCmbProject = new DefaultComboBoxModel();
        JComboBox cbProject = new JComboBox(modelCmbProject);
        cbProject.setFont(this.stdFont);
        this.omeroProjects.forEach(cbProject::addItem);
        cbProject.setEnabled(false);
        JLabel labDataset = new JLabel("Dataset");
        labDataset.setFont(this.stdFont);
        labDataset.setVisible(false);
        DefaultComboBoxModel modelCmbDataset = new DefaultComboBoxModel();
        JComboBox cbDataset = new JComboBox(modelCmbDataset);
        cbDataset.setFont(this.stdFont);
        this.omeroDatasets.forEach(cbDataset::addItem);
        cbDataset.setVisible(false);
        JLabel labMicroscopeFolder = new JLabel("Microscopes folder on");
        labMicroscopeFolder.setFont(this.stdFont);
        this.connection_state = CONNECTION_STATE.DISCONNECTED;
        JButton bConnectToOmero = new JButton(this.connection_state.getName());
        bConnectToOmero.setFont(this.stdFont);
        JButton bLivePreview = new JButton("Live preview");
        bLivePreview.setFont(this.stdFont);
        bLivePreview.setEnabled(false);
        JButton bOk = new JButton("OK");
        bOk.setFont(this.stdFont);
        JLabel labRootFolder = new JLabel("Root Folder");
        labRootFolder.setFont(this.stdFont);
        JTextField tfRootFolder = new JTextField(this.userRootFolder);
        tfRootFolder.setFont(this.stdFont);
        tfRootFolder.setColumns(15);
        labRootFolder.setEnabled(false);
        tfRootFolder.setEnabled(false);
        JLabel labMicroscope = new JLabel("Microscope");
        labMicroscope.setFont(this.stdFont);
        DefaultComboBoxModel modelCmbMicroscope = new DefaultComboBoxModel();
        JComboBox cbMicroscope = new JComboBox(modelCmbMicroscope);
        cbMicroscope.setFont(this.stdFont);
        this.omeroMicroscopes.forEach(cbMicroscope::addItem);
        cbMicroscope.setEnabled(false);
        cbProject.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.omeroMicroscopes = OMERORetriever.listDatasets(this.client, (String)cbProject.getSelectedItem());
                cbMicroscope.removeAllItems();
                this.omeroMicroscopes.forEach(cbMicroscope::addItem);
                cbMicroscope.setSelectedItem(this.omeroProjects);
            }
        });
        JButton bRootFolder = new JButton("Choose folder");
        bRootFolder.setFont(this.stdFont);
        bRootFolder.addActionListener(e -> {
            JFileChooser directoryChooser = new JFileChooser();
            directoryChooser.setFileSelectionMode(1);
            if (new File(this.userRootFolder).exists()) {
                directoryChooser.setCurrentDirectory(new File(this.userRootFolder));
            }
            directoryChooser.setDialogTitle("Choose the microscopes' root folder");
            directoryChooser.showDialog(generalPane, "Select");
            if (directoryChooser.getSelectedFile() != null) {
                File selectedRootFolder = directoryChooser.getSelectedFile();
                tfRootFolder.setText(selectedRootFolder.getAbsolutePath());
                this.userRootFolder = selectedRootFolder.getAbsolutePath();
                this.localMicroscopes = LocalRetriever.listMicroscopes(selectedRootFolder);
                cbMicroscope.removeAllItems();
                this.localMicroscopes.forEach(cbMicroscope::addItem);
                cbMicroscope.setSelectedItem(this.localMicroscopes);
            }
        });
        bRootFolder.setEnabled(false);
        JLabel labArgoSlide = new JLabel("ArgoSlide");
        labArgoSlide.setFont(this.stdFont);
        DefaultComboBoxModel modelCmbArgoSlide = new DefaultComboBoxModel();
        JComboBox cbArgoSlide = new JComboBox(modelCmbArgoSlide);
        cbArgoSlide.setFont(this.stdFont);
        this.userArgoSlides.forEach(cbArgoSlide::addItem);
        if (this.defaultArgoSlide != null && !this.defaultArgoSlide.isEmpty()) {
            cbArgoSlide.setSelectedItem(this.defaultArgoSlide);
        }
        cbArgoSlide.setEnabled(false);
        JLabel labSavingFolder = new JLabel("Saving Folder");
        labSavingFolder.setFont(this.stdFont);
        JTextField tfSavingFolder = new JTextField(this.userSaveFolder);
        tfSavingFolder.setFont(this.stdFont);
        tfSavingFolder.setColumns(15);
        labSavingFolder.setEnabled(false);
        tfSavingFolder.setEnabled(false);
        JButton bSavingFolder = new JButton("Choose folder");
        bSavingFolder.setFont(this.stdFont);
        bSavingFolder.addActionListener(e -> {
            JFileChooser directoryChooser = new JFileChooser();
            directoryChooser.setFileSelectionMode(1);
            directoryChooser.setDialogTitle("Choose the microscopes' saving folder");
            directoryChooser.showDialog(generalPane, "Select");
            if (directoryChooser.getSelectedFile() != null) {
                tfSavingFolder.setText(directoryChooser.getSelectedFile().getAbsolutePath());
            }
        });
        bSavingFolder.setEnabled(false);
        JCheckBox chkSaveHeatMap = new JCheckBox("Save heat maps");
        chkSaveHeatMap.setSelected(false);
        chkSaveHeatMap.setFont(this.stdFont);
        chkSaveHeatMap.setEnabled(false);
        JCheckBox chkRemovePreviousRun = new JCheckBox("Remove previous runs");
        chkRemovePreviousRun.setSelected(false);
        chkRemovePreviousRun.setFont(this.stdFont);
        chkRemovePreviousRun.setEnabled(false);
        JCheckBox chkAllImages = new JCheckBox("Process again existing images");
        chkAllImages.setSelected(false);
        chkAllImages.setFont(this.stdFont);
        chkAllImages.addActionListener(e -> chkRemovePreviousRun.setEnabled(chkAllImages.isSelected()));
        chkAllImages.setEnabled(false);
        ButtonGroup omeroMicroscopeFolderChoice = new ButtonGroup();
        JRadioButton rbOmeroDataset = new JRadioButton("Dataset");
        rbOmeroDataset.setFont(this.stdFont);
        rbOmeroDataset.setSelected(true);
        rbOmeroDataset.setEnabled(false);
        omeroMicroscopeFolderChoice.add(rbOmeroDataset);
        rbOmeroDataset.addActionListener(e -> {
            cbProject.setVisible(rbOmeroDataset.isSelected());
            labProject.setVisible(rbOmeroDataset.isSelected());
            labDataset.setVisible(!rbOmeroDataset.isSelected());
            cbDataset.setVisible(!rbOmeroDataset.isSelected());
            cbProject.setSelectedItem(cbMicroscope.getSelectedItem());
            this.omeroMicroscopes = new ArrayList<String>(this.omeroDatasets);
            cbMicroscope.removeAllItems();
            this.omeroMicroscopes.forEach(cbMicroscope::addItem);
            cbMicroscope.setSelectedItem(this.omeroMicroscopes);
        });
        JRadioButton rbOmeroProject = new JRadioButton("Project");
        rbOmeroProject.setFont(this.stdFont);
        rbOmeroProject.setSelected(false);
        rbOmeroProject.setEnabled(false);
        omeroMicroscopeFolderChoice.add(rbOmeroProject);
        rbOmeroProject.addActionListener(e -> {
            cbProject.setVisible(!rbOmeroProject.isSelected());
            labProject.setVisible(!rbOmeroProject.isSelected());
            labDataset.setVisible(rbOmeroProject.isSelected());
            cbDataset.setVisible(rbOmeroProject.isSelected());
            this.omeroDatasets = new ArrayList<String>(this.omeroMicroscopes);
            this.omeroMicroscopes = new ArrayList<String>(this.omeroProjects);
            cbMicroscope.removeAllItems();
            this.omeroMicroscopes.forEach(cbMicroscope::addItem);
            cbMicroscope.setSelectedItem(cbProject.getSelectedItem());
            cbDataset.removeAllItems();
            this.omeroDatasets.forEach(cbDataset::addItem);
            cbDataset.setSelectedItem(this.omeroDatasets);
        });
        ButtonGroup senderChoice = new ButtonGroup();
        JRadioButton rbLocalSender = new JRadioButton("Local");
        rbLocalSender.setFont(this.stdFont);
        rbLocalSender.setSelected(false);
        rbLocalSender.setEnabled(false);
        senderChoice.add(rbLocalSender);
        rbLocalSender.addActionListener(e -> {
            tfSavingFolder.setEnabled(rbLocalSender.isSelected());
            labSavingFolder.setEnabled(rbLocalSender.isSelected());
            bSavingFolder.setEnabled(rbLocalSender.isSelected());
        });
        JRadioButton rbOmeroSender = new JRadioButton("OMERO");
        rbOmeroSender.setAlignmentX(1.0f);
        rbOmeroSender.setFont(this.stdFont);
        rbOmeroSender.setSelected(true);
        rbOmeroSender.setEnabled(false);
        senderChoice.add(rbOmeroSender);
        rbOmeroSender.addActionListener(e -> {
            tfSavingFolder.setEnabled(!rbOmeroSender.isSelected());
            labSavingFolder.setEnabled(!rbOmeroSender.isSelected());
            bSavingFolder.setEnabled(!rbOmeroSender.isSelected());
        });
        JButton bArgoSlideSettings = new JButton("Settings");
        bArgoSlideSettings.setFont(this.stdFont);
        bArgoSlideSettings.addActionListener(e -> this.createArgoSettingsPane(String.valueOf(cbArgoSlide.getSelectedItem())));
        bArgoSlideSettings.setEnabled(false);
        ButtonGroup retrieverChoice = new ButtonGroup();
        JRadioButton rbOmeroRetriever = new JRadioButton("OMERO");
        rbOmeroRetriever.setFont(this.stdFont);
        retrieverChoice.add(rbOmeroRetriever);
        rbOmeroRetriever.setSelected(true);
        rbOmeroRetriever.addActionListener(e -> {
            labRootFolder.setEnabled(!rbOmeroRetriever.isSelected());
            tfRootFolder.setEnabled(!rbOmeroRetriever.isSelected());
            bRootFolder.setEnabled(!rbOmeroRetriever.isSelected());
            tfUsername.setEnabled(rbOmeroRetriever.isSelected() && !this.client.isConnected());
            tfPassword.setEnabled(rbOmeroRetriever.isSelected() && !this.client.isConnected());
            labHost.setEnabled(rbOmeroRetriever.isSelected());
            labUsername.setEnabled(rbOmeroRetriever.isSelected());
            labPassword.setEnabled(rbOmeroRetriever.isSelected());
            rbOmeroSender.setEnabled(rbOmeroRetriever.isSelected());
            labProject.setEnabled(rbOmeroRetriever.isSelected());
            cbProject.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            tfSavingFolder.setEnabled(!rbOmeroRetriever.isSelected());
            labSavingFolder.setEnabled(!rbOmeroRetriever.isSelected());
            bSavingFolder.setEnabled(!rbOmeroRetriever.isSelected());
            rbOmeroSender.setSelected(rbOmeroRetriever.isSelected());
            rbLocalSender.setSelected(!rbOmeroRetriever.isSelected());
            bConnectToOmero.setEnabled(rbOmeroRetriever.isSelected() && !this.client.isConnected());
            cbMicroscope.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            rbOmeroProject.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            rbOmeroDataset.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            cbArgoSlide.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            bArgoSlideSettings.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            chkSaveHeatMap.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            chkAllImages.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            rbOmeroSender.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            rbLocalSender.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            bLivePreview.setEnabled(!rbOmeroRetriever.isSelected() || this.client.isConnected());
            cbDataset.setVisible(rbOmeroRetriever.isSelected() && rbOmeroProject.isSelected());
            labDataset.setVisible(rbOmeroRetriever.isSelected() && rbOmeroProject.isSelected());
            cbMicroscope.removeAllItems();
            this.omeroMicroscopes.forEach(cbMicroscope::addItem);
            cbMicroscope.setSelectedItem(this.omeroMicroscopes);
            if (rbOmeroRetriever.isSelected() && !this.client.isConnected()) {
                omeroPane.getRootPane().setDefaultButton(bConnectToOmero);
            } else {
                omeroPane.getRootPane().setDefaultButton(bOk);
            }
        });
        JRadioButton rbLocalRetriever = new JRadioButton("Local");
        retrieverChoice.add(rbLocalRetriever);
        rbLocalRetriever.setFont(this.stdFont);
        rbLocalRetriever.setSelected(false);
        rbLocalRetriever.addActionListener(e -> {
            tfUsername.setEnabled(!rbLocalRetriever.isSelected());
            tfPassword.setEnabled(!rbLocalRetriever.isSelected());
            labHost.setEnabled(!rbLocalRetriever.isSelected());
            labUsername.setEnabled(!rbLocalRetriever.isSelected());
            labPassword.setEnabled(!rbLocalRetriever.isSelected());
            rbOmeroDataset.setEnabled(!rbLocalRetriever.isSelected());
            rbOmeroProject.setEnabled(!rbLocalRetriever.isSelected());
            labProject.setEnabled(!rbLocalRetriever.isSelected());
            cbProject.setEnabled(!rbLocalRetriever.isSelected());
            bRootFolder.setEnabled(rbLocalRetriever.isSelected());
            tfRootFolder.setEnabled(rbLocalRetriever.isSelected());
            labRootFolder.setEnabled(rbLocalRetriever.isSelected());
            rbOmeroSender.setSelected(!rbLocalRetriever.isSelected());
            rbOmeroSender.setEnabled(!rbLocalRetriever.isSelected());
            rbLocalSender.setSelected(rbLocalRetriever.isSelected());
            tfSavingFolder.setEnabled(rbLocalRetriever.isSelected());
            labSavingFolder.setEnabled(rbLocalRetriever.isSelected());
            bSavingFolder.setEnabled(rbLocalRetriever.isSelected());
            bConnectToOmero.setEnabled(!rbLocalRetriever.isSelected());
            cbMicroscope.setEnabled(rbLocalRetriever.isSelected());
            cbArgoSlide.setEnabled(rbLocalRetriever.isSelected());
            bArgoSlideSettings.setEnabled(rbLocalRetriever.isSelected());
            chkSaveHeatMap.setEnabled(rbLocalRetriever.isSelected());
            chkAllImages.setEnabled(rbLocalRetriever.isSelected());
            rbLocalSender.setEnabled(rbLocalRetriever.isSelected());
            bLivePreview.setEnabled(rbLocalRetriever.isSelected());
            cbDataset.setVisible(!rbLocalRetriever.isSelected());
            labDataset.setVisible(!rbLocalRetriever.isSelected());
            this.localMicroscopes = LocalRetriever.listMicroscopes(new File(tfRootFolder.getText()));
            cbMicroscope.removeAllItems();
            this.localMicroscopes.forEach(cbMicroscope::addItem);
            cbMicroscope.setSelectedItem(this.localMicroscopes);
            omeroPane.getRootPane().setDefaultButton(bOk);
        });
        cbMicroscope.addItemListener(e -> {
            if (rbOmeroProject.isSelected() && rbOmeroRetriever.isSelected()) {
                this.omeroDatasets = OMERORetriever.listDatasets(this.client, (String)cbMicroscope.getSelectedItem());
                cbDataset.removeAllItems();
                this.omeroDatasets.forEach(cbDataset::addItem);
                cbDataset.setSelectedItem(this.omeroDatasets);
            }
        });
        JButton bGeneralSettings = new JButton("General Settings");
        bGeneralSettings.setFont(this.stdFont);
        bGeneralSettings.addActionListener(e -> {
            this.createSettingsPane();
            this.setDefaultGeneralParams();
            labHost.setText(this.userHost + ":" + this.userPort);
            cbArgoSlide.removeAllItems();
            this.userArgoSlides.forEach(cbArgoSlide::addItem);
            cbArgoSlide.setSelectedItem(this.userArgoSlides);
            tfRootFolder.setText(this.userRootFolder);
            tfSavingFolder.setText(this.userSaveFolder);
        });
        JButton bProcessingSettings = new JButton("Processing Settings");
        bProcessingSettings.setFont(this.stdFont);
        bProcessingSettings.addActionListener(e -> this.createProcessingSettingsPane());
        bLivePreview.addActionListener(e -> {
            boolean isOmeroImage = false;
            if (rbOmeroRetriever.isSelected()) {
                isOmeroImage = true;
                if (!this.client.isConnected() && !this.connectToOmero(this.client, tfUsername.getText(), tfPassword.getPassword())) {
                    return;
                }
            }
            this.createLiveSettingsPane(isOmeroImage, (String)cbArgoSlide.getSelectedItem());
        });
        bConnectToOmero.addActionListener(e -> {
            boolean enableButton = true;
            if (this.connection_state.equals((Object)CONNECTION_STATE.DISCONNECTED)) {
                if (!this.client.isConnected() && this.connectToOmero(this.client, tfUsername.getText(), tfPassword.getPassword())) {
                    tfPassword.setText("");
                    this.omeroMicroscopes = OMERORetriever.listDatasets(this.client, (String)cbProject.getSelectedItem());
                    this.omeroProjects = OMERORetriever.listProjects(this.client);
                    this.connection_state = CONNECTION_STATE.CONNECTED;
                    omeroPane.getRootPane().setDefaultButton(bOk);
                    cbProject.requestFocus();
                }
            } else if (this.client.isConnected()) {
                this.client.disconnect();
                IJLogger.info("Disconnected from OMERO ");
                enableButton = false;
                this.connection_state = CONNECTION_STATE.DISCONNECTED;
                this.omeroMicroscopes = Collections.emptyList();
                this.omeroProjects = Collections.emptyList();
                omeroPane.getRootPane().setDefaultButton(bConnectToOmero);
                bConnectToOmero.requestFocus();
            }
            cbMicroscope.setEnabled(enableButton);
            cbArgoSlide.setEnabled(enableButton);
            bArgoSlideSettings.setEnabled(enableButton);
            bLivePreview.setEnabled(enableButton);
            chkSaveHeatMap.setEnabled(enableButton);
            chkAllImages.setEnabled(enableButton);
            rbOmeroSender.setEnabled(enableButton);
            rbLocalSender.setEnabled(enableButton);
            tfUsername.setEnabled(!enableButton);
            tfPassword.setEnabled(!enableButton);
            cbProject.setEnabled(enableButton);
            rbOmeroDataset.setEnabled(enableButton);
            rbOmeroProject.setEnabled(enableButton);
            bConnectToOmero.setText(this.connection_state.getName());
            cbMicroscope.removeAllItems();
            this.omeroMicroscopes.forEach(cbMicroscope::addItem);
            cbMicroscope.setSelectedItem(this.omeroMicroscopes);
            cbProject.removeAllItems();
            this.omeroProjects.forEach(cbProject::addItem);
            cbProject.setSelectedItem(this.omeroProjects);
        });
        bOk.addActionListener(e -> {
            this.startsProcessing = true;
            this.mainDialog.dispose();
            char[] password = tfPassword.getPassword();
            String folderName = rbOmeroProject.isSelected() && rbOmeroRetriever.isSelected() ? (String)cbDataset.getSelectedItem() : (String)cbProject.getSelectedItem();
            this.runProcessing(rbOmeroRetriever.isSelected(), folderName, rbOmeroProject.isSelected(), tfRootFolder.getText(), (String)cbMicroscope.getSelectedItem(), (String)cbArgoSlide.getSelectedItem(), rbOmeroSender.isSelected(), tfSavingFolder.getText(), chkSaveHeatMap.isSelected(), chkAllImages.isSelected(), chkRemovePreviousRun.isSelected());
        });
        JButton bCancel = new JButton("Cancel");
        bCancel.setFont(this.stdFont);
        bCancel.addActionListener(e -> this.mainDialog.dispose());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        int omeroRetrieverRow = 0;
        omeroPane.setLayout(new GridBagLayout());
        JLabel retrieverTitle = new JLabel("Get images from");
        retrieverTitle.setFont(this.titleFont);
        JPanel omeroFolderPane = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        omeroFolderPane.add(rbOmeroDataset);
        constraints.gridy = 1;
        omeroFolderPane.add(rbOmeroProject);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)retrieverTitle, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)rbOmeroRetriever, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)rbLocalRetriever, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)labHost, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labUsername, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)tfUsername, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labRootFolder, constraints);
        constraints.gridx = 3;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)tfRootFolder, constraints);
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labPassword, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)tfPassword, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bRootFolder, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bConnectToOmero, constraints);
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labMicroscopeFolder, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)omeroFolderPane, constraints);
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labProject, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add(cbProject, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bLivePreview, constraints);
        constraints.gridwidth = 4;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        JLabel microscopyTitle = new JLabel("Choose your microscope");
        microscopyTitle.setFont(this.titleFont);
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)microscopyTitle, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labMicroscope, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add(cbMicroscope, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labDataset, constraints);
        constraints.gridx = 3;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add(cbDataset, constraints);
        constraints.gridwidth = 4;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        JLabel argoslideTitle = new JLabel("Choose your Argoslide");
        argoslideTitle.setFont(this.titleFont);
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)argoslideTitle, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labArgoSlide, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add(cbArgoSlide, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bArgoSlideSettings, constraints);
        constraints.gridwidth = 4;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        JLabel senderTitle = new JLabel("Where to save results");
        senderTitle.setFont(this.titleFont);
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)senderTitle, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)rbOmeroSender, constraints);
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)rbLocalSender, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)chkSaveHeatMap, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)labSavingFolder, constraints);
        constraints.gridx = 3;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)tfSavingFolder, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)chkAllImages, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 2;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bSavingFolder, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)chkRemovePreviousRun, constraints);
        constraints.gridwidth = 1;
        constraints.gridwidth = 4;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        JLabel settingsHeader = new JLabel("Setup your project");
        settingsHeader.setFont(this.titleFont);
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)settingsHeader, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)bGeneralSettings, constraints);
        constraints.gridx = 1;
        constraints.gridy = omeroRetrieverRow++;
        omeroPane.add((Component)bProcessingSettings, constraints);
        JPanel okCancelPane = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        okCancelPane.add(bOk);
        constraints.gridy = 1;
        okCancelPane.add(bCancel);
        constraints.gridx = 3;
        constraints.gridy = omeroRetrieverRow;
        omeroPane.add((Component)okCancelPane, constraints);
        this.mainDialog = new JDialog();
        this.mainDialog.setModal(true);
        this.mainDialog.setTitle(title);
        this.mainDialog.getContentPane().setLayout(new BorderLayout());
        omeroPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.mainDialog.getContentPane().add(omeroPane);
        this.mainDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mainDialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.mainDialog.setUndecorated(true);
            this.mainDialog.getRootPane().setWindowDecorationStyle(2);
        }
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(null);
        tfUsername.requestFocusInWindow();
        omeroPane.getRootPane().setDefaultButton(bConnectToOmero);
        this.mainDialog.setVisible(true);
        this.mainDialog.dispose();
        if (!this.startsProcessing) {
            if (this.client.isConnected()) {
                this.client.disconnect();
                IJLogger.info("Disconnected from OMERO ");
            }
            IJLogger.info("ArgoLight Analysis Tool exited");
        }
    }

    private void createArgoSettingsPane(String argoSlide) {
        if (argoSlide == null || argoSlide.isEmpty() || argoSlide.equals("null")) {
            this.showWarningMessage("No ArgoSlide selected", "You need to create an ArgoSlide first. Click on 'General Settings' and fill 'ArgoSlides' field");
            return;
        }
        List currentArgoslideParameters = this.argoSlidesParameters.getOrDefault(argoSlide, Collections.emptyList());
        if (currentArgoslideParameters.size() < 4) {
            currentArgoslideParameters = new ArrayList(4);
            currentArgoslideParameters.add("false");
            currentArgoslideParameters.add(String.valueOf(1));
            currentArgoslideParameters.add(String.valueOf(10));
            currentArgoslideParameters.add(String.valueOf(1));
        }
        JLabel labArgoSpacing = new JLabel("Distance between two horizontal rings (um)");
        labArgoSpacing.setFont(this.stdFont);
        SpinnerNumberModel spModelArgoSpacing = new SpinnerNumberModel(Integer.parseInt((String)currentArgoslideParameters.get(1)), 1, 1000, 1);
        JSpinner spArgoSpacing = new JSpinner(spModelArgoSpacing);
        spArgoSpacing.setFont(this.stdFont);
        JLabel labArgoFoV = new JLabel("Field of view (um)");
        labArgoFoV.setFont(this.stdFont);
        SpinnerNumberModel spModelArgoFoV = new SpinnerNumberModel(Integer.parseInt((String)currentArgoslideParameters.get(2)), 10, 10000, 1);
        JSpinner spArgoFoV = new JSpinner(spModelArgoFoV);
        spArgoFoV.setFont(this.stdFont);
        JLabel labArgoNRings = new JLabel("Number of rings along one line");
        labArgoNRings.setFont(this.stdFont);
        SpinnerNumberModel spModelArgoNRings = new SpinnerNumberModel(Integer.parseInt((String)currentArgoslideParameters.get(3)), 1, 10000, 1);
        JSpinner spArgoNRings = new JSpinner(spModelArgoNRings);
        spArgoNRings.setFont(this.stdFont);
        JCheckBox chkDefaultArgoSlide = new JCheckBox("Set " + argoSlide + " as your default slide");
        chkDefaultArgoSlide.setSelected(((String)currentArgoslideParameters.get(0)).equalsIgnoreCase("true"));
        chkDefaultArgoSlide.setFont(this.stdFont);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JPanel settingsPane = new JPanel();
        int settingsRow = 0;
        settingsPane.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labArgoSpacing, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spArgoSpacing, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labArgoFoV, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spArgoFoV, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labArgoNRings, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spArgoNRings, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkDefaultArgoSlide, constraints);
        JOptionPane pane = new JOptionPane(settingsPane, -1, 2, null, null, null);
        this.settingsDialog = pane.createDialog(this.mainDialog, "Setup " + argoSlide + " specifications");
        pane.selectInitialValue();
        this.settingsDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.settingsDialog.setVisible(true);
        this.settingsDialog.dispose();
        Object selectedValue = pane.getValue();
        int opt = -1;
        if (selectedValue instanceof Integer) {
            opt = (Integer)selectedValue;
        }
        if (opt == 0) {
            Map<String, List<String>> newMap = this.saveUserDefinedArgoSlideParams(argoSlide, (Integer)spArgoSpacing.getModel().getValue(), (Integer)spArgoFoV.getModel().getValue(), (Integer)spArgoNRings.getModel().getValue(), chkDefaultArgoSlide.getModel().isSelected());
            this.argoSlidesParameters.clear();
            this.argoSlidesParameters = newMap;
        }
    }

    private void createSettingsPane() {
        JDialog generalPane = new JDialog();
        JLabel labHost = new JLabel("OMERO host");
        labHost.setFont(this.stdFont);
        JTextField tfHost = new JTextField(this.userHost);
        tfHost.setFont(this.stdFont);
        tfHost.setColumns(15);
        JLabel labPort = new JLabel("OMERO port");
        labPort.setFont(this.stdFont);
        JTextField tfPort = new JTextField(this.userPort);
        tfPort.setFont(this.stdFont);
        tfPort.setColumns(15);
        JLabel labArgoslide = new JLabel("Argoslides");
        labArgoslide.setFont(this.stdFont);
        JTextField tfArgoslide = new JTextField(String.join((CharSequence)",", this.userArgoSlides));
        tfArgoslide.setFont(this.stdFont);
        tfArgoslide.setColumns(15);
        JButton bChooseArgoslide = new JButton("Open file");
        bChooseArgoslide.setFont(this.stdFont);
        bChooseArgoslide.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogTitle("Choose the argoslides' csv file");
            fileChooser.showDialog(generalPane, "Select");
            if (fileChooser.getSelectedFile() != null) {
                File rootFolder = fileChooser.getSelectedFile();
                if (!rootFolder.exists()) {
                    this.showErrorMessage("No files", "The file you selected does not exist. Please check your path / file");
                } else if (!rootFolder.getAbsolutePath().endsWith(".csv")) {
                    this.showErrorMessage("Wrong file type", "The file you selected is not a .csv file. Please select a .csv file");
                } else {
                    List<String> argoslides = this.parseUserCSV(rootFolder);
                    String argoslidesList = String.join((CharSequence)",", argoslides);
                    tfArgoslide.setText(argoslidesList);
                }
            }
        });
        JLabel labRootFolder = new JLabel("Root folder");
        labRootFolder.setFont(this.stdFont);
        JTextField tfRootFolder = new JTextField(this.userRootFolder);
        tfRootFolder.setFont(this.stdFont);
        tfRootFolder.setColumns(15);
        JLabel labSaveFolder = new JLabel("Saving folder");
        labSaveFolder.setFont(this.stdFont);
        JTextField tfSaveFolder = new JTextField(this.userSaveFolder);
        tfSaveFolder.setFont(this.stdFont);
        tfSaveFolder.setColumns(15);
        JButton bChooseRootFolder = new JButton("Open folder");
        bChooseRootFolder.setFont(this.stdFont);
        bChooseRootFolder.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogTitle("Choose the root folder where to get local image");
            fileChooser.showDialog(generalPane, "Select");
            if (fileChooser.getSelectedFile() != null) {
                tfRootFolder.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        JButton bChooseSaveFolder = new JButton("Open folder");
        bChooseSaveFolder.setFont(this.stdFont);
        bChooseSaveFolder.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogTitle("Choose the folder where to save results");
            fileChooser.showDialog(generalPane, "Select");
            if (fileChooser.getSelectedFile() != null) {
                tfSaveFolder.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JPanel settingsPane = new JPanel();
        int settingsRow = 0;
        settingsPane.setLayout(new GridBagLayout());
        JLabel retrieverTitle = new JLabel("Get images from");
        retrieverTitle.setFont(this.titleFont);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labHost, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)tfHost, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labPort, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)tfPort, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labArgoslide, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)tfArgoslide, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)bChooseArgoslide, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labRootFolder, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)tfRootFolder, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)bChooseRootFolder, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labSaveFolder, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)tfSaveFolder, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)bChooseSaveFolder, constraints);
        JOptionPane pane = new JOptionPane(settingsPane, -1, 2, null, null, null);
        this.settingsDialog = pane.createDialog(this.mainDialog, "Setup your default settings");
        pane.selectInitialValue();
        this.settingsDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.settingsDialog.setVisible(true);
        this.settingsDialog.dispose();
        Object selectedValue = pane.getValue();
        int opt = -1;
        if (selectedValue instanceof Integer) {
            opt = (Integer)selectedValue;
        }
        if (opt == 0) {
            String badEntries = "";
            try {
                Double.parseDouble(tfPort.getText());
                this.userPort = tfPort.getText();
            }
            catch (Exception e2) {
                badEntries = badEntries + " - port";
            }
            this.userHost = tfHost.getText();
            this.userRootFolder = tfRootFolder.getText();
            this.userSaveFolder = tfSaveFolder.getText();
            this.saveUserDefinedGeneralParams(this.userHost, this.userPort, tfArgoslide.getText(), this.userRootFolder, this.userSaveFolder);
            if (!badEntries.isEmpty()) {
                this.showWarningMessage("Bad entries", "The following entries require numeric values : " + badEntries);
            }
        }
    }

    private void createProcessingSettingsPane() {
        JLabel labSigma = new JLabel("Gaussian blur sigma (um)");
        labSigma.setFont(this.stdFont);
        SpinnerNumberModel spModelSigma = new SpinnerNumberModel(this.userSigma, 0.01, 10.0, 0.01);
        JSpinner spSigma = new JSpinner(spModelSigma);
        spSigma.setFont(this.stdFont);
        spSigma.setEnabled(!this.isDefaultSigma);
        JLabel labMedian = new JLabel("Median filter radius (um)");
        labMedian.setFont(this.stdFont);
        SpinnerNumberModel spModelMedian = new SpinnerNumberModel(this.userMedianRadius, 0.01, 10.0, 0.01);
        JSpinner spMedian = new JSpinner(spModelMedian);
        spMedian.setFont(this.stdFont);
        spMedian.setEnabled(!this.isDefaultMedianRadius);
        JLabel labThreshSeg = new JLabel("Thresholding method for segmentation");
        labThreshSeg.setFont(this.stdFont);
        DefaultComboBoxModel modelCmbSegmentation = new DefaultComboBoxModel();
        JComboBox cbSegmentation = new JComboBox(modelCmbSegmentation);
        cbSegmentation.setFont(this.stdFont);
        thresholdingMethods.forEach(cbSegmentation::addItem);
        cbSegmentation.setSelectedItem(this.userThresholdMethod);
        cbSegmentation.setEnabled(!this.isDefaultThresholdMethod);
        JLabel labThreshParticles = new JLabel("Threshold on segmented particles (um^2)");
        labThreshParticles.setFont(this.stdFont);
        SpinnerNumberModel spModelThreshParticles = new SpinnerNumberModel(this.userParticleThresh, 0.001, 20.0, 0.001);
        JSpinner spThreshParticles = new JSpinner(spModelThreshParticles);
        spThreshParticles.setFont(this.stdFont);
        spThreshParticles.setEnabled(!this.isDefaultParticleThresh);
        JLabel labRingRadius = new JLabel("Analyzed ring radius (um)");
        labRingRadius.setFont(this.stdFont);
        SpinnerNumberModel spModelRingRadius = new SpinnerNumberModel(this.userRingRadius, 0.01, 3.0, 0.01);
        JSpinner spRingRadius = new JSpinner(spModelRingRadius);
        spRingRadius.setFont(this.stdFont);
        spRingRadius.setEnabled(!this.isDefaultRingRadius);
        JCheckBox chkSigma = new JCheckBox("default");
        chkSigma.setSelected(this.isDefaultSigma);
        chkSigma.setFont(this.stdFont);
        chkSigma.addActionListener(e -> spSigma.setEnabled(!chkSigma.isSelected()));
        JCheckBox chkMedian = new JCheckBox("default");
        chkMedian.setSelected(this.isDefaultMedianRadius);
        chkMedian.setFont(this.stdFont);
        chkMedian.addActionListener(e -> spMedian.setEnabled(!chkMedian.isSelected()));
        JCheckBox chkThreshSeg = new JCheckBox("default");
        chkThreshSeg.setSelected(this.isDefaultThresholdMethod);
        chkThreshSeg.setFont(this.stdFont);
        chkThreshSeg.addActionListener(e -> cbSegmentation.setEnabled(!chkThreshSeg.isSelected()));
        JCheckBox chkThreshParticles = new JCheckBox("default");
        chkThreshParticles.setSelected(this.isDefaultParticleThresh);
        chkThreshParticles.setFont(this.stdFont);
        chkThreshParticles.addActionListener(e -> spThreshParticles.setEnabled(!chkThreshParticles.isSelected()));
        JCheckBox chkRingRadius = new JCheckBox("default");
        chkRingRadius.setSelected(this.isDefaultRingRadius);
        chkRingRadius.setFont(this.stdFont);
        chkRingRadius.addActionListener(e -> spRingRadius.setEnabled(!chkRingRadius.isSelected()));
        JCheckBox chkUseOnlyOnce = new JCheckBox("Use only once");
        chkUseOnlyOnce.setSelected(false);
        chkUseOnlyOnce.setFont(this.stdFont);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JPanel settingsPane = new JPanel();
        int settingsRow = 0;
        settingsPane.setLayout(new GridBagLayout());
        JLabel retrieverTitle = new JLabel("Get images from");
        retrieverTitle.setFont(this.titleFont);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labSigma, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkSigma, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spSigma, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labMedian, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkMedian, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spMedian, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labThreshSeg, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkThreshSeg, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add(cbSegmentation, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labThreshParticles, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkThreshParticles, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spThreshParticles, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)labRingRadius, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkRingRadius, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        settingsPane.add((Component)spRingRadius, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        settingsPane.add((Component)chkUseOnlyOnce, constraints);
        JOptionPane pane = new JOptionPane(settingsPane, -1, 2, null, null, null);
        this.processingDialog = pane.createDialog(this.mainDialog, "Setup your default settings for processing");
        pane.selectInitialValue();
        this.processingDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.processingDialog.setVisible(true);
        this.processingDialog.dispose();
        Object selectedValue = pane.getValue();
        int opt = -1;
        if (selectedValue instanceof Integer) {
            opt = (Integer)selectedValue;
        }
        if (opt == 0) {
            this.isDefaultSigma = chkSigma.isSelected();
            this.isDefaultMedianRadius = chkMedian.isSelected();
            this.isDefaultThresholdMethod = chkThreshSeg.isSelected();
            this.isDefaultParticleThresh = chkThreshParticles.isSelected();
            this.isDefaultRingRadius = chkRingRadius.isSelected();
            this.userSigma = (Double)spSigma.getValue();
            this.userMedianRadius = (Double)spMedian.getValue();
            this.userThresholdMethod = (String)cbSegmentation.getSelectedItem();
            this.userParticleThresh = (Double)spThreshParticles.getValue();
            this.userRingRadius = (Double)spRingRadius.getValue();
            if (!chkUseOnlyOnce.getModel().isSelected()) {
                this.saveUserDefinedProcessingParams(this.isDefaultSigma, this.isDefaultMedianRadius, this.isDefaultThresholdMethod, this.isDefaultParticleThresh, this.isDefaultRingRadius, this.userSigma, this.userMedianRadius, this.userThresholdMethod, this.userParticleThresh, this.userRingRadius);
            }
        }
    }

    private void createLiveSettingsPane(boolean isOmeroImage, String argoSlide) {
        List currentArgoslideParameters = this.argoSlidesParameters.getOrDefault(argoSlide, Collections.emptyList());
        if (currentArgoslideParameters.isEmpty()) {
            this.showWarningMessage("No ArgoSlide selected", "Please select an ArgoSlide first");
            return;
        }
        int currentArgoSpacing = Integer.parseInt((String)currentArgoslideParameters.get(1));
        int currentArgoFoV = Integer.parseInt((String)currentArgoslideParameters.get(2));
        int currentArgoNRings = Integer.parseInt((String)currentArgoslideParameters.get(3));
        JDialog generalPane = new JDialog();
        JLabel labOmeroImage = new JLabel("Image ID");
        labOmeroImage.setFont(this.stdFont);
        JTextField tfOmeroImage = new JTextField();
        tfOmeroImage.setFont(this.stdFont);
        tfOmeroImage.setColumns(7);
        JLabel labImage = new JLabel("Image path");
        labImage.setFont(this.stdFont);
        JTextField tfImage = new JTextField();
        tfImage.setFont(this.stdFont);
        tfImage.setColumns(7);
        JLabel labSigma = new JLabel("Gaussian blur sigma (um)");
        labSigma.setFont(this.stdFont);
        SpinnerNumberModel spModelSigma = new SpinnerNumberModel(this.userSigma, 0.01, 10.0, 0.01);
        JSpinner spSigma = new JSpinner(spModelSigma);
        spSigma.setFont(this.stdFont);
        spSigma.setEnabled(!this.isDefaultSigma);
        JLabel labMedian = new JLabel("Median filter radius (um)");
        labMedian.setFont(this.stdFont);
        SpinnerNumberModel spModelMedian = new SpinnerNumberModel(this.userMedianRadius, 0.01, 10.0, 0.01);
        JSpinner spMedian = new JSpinner(spModelMedian);
        spMedian.setFont(this.stdFont);
        spMedian.setEnabled(!this.isDefaultMedianRadius);
        JLabel labThreshSeg = new JLabel("Thresholding method for segmentation");
        labThreshSeg.setFont(this.stdFont);
        DefaultComboBoxModel modelCmbSegmentation = new DefaultComboBoxModel();
        JComboBox cbSegmentation = new JComboBox(modelCmbSegmentation);
        cbSegmentation.setFont(this.stdFont);
        thresholdingMethods.forEach(cbSegmentation::addItem);
        cbSegmentation.setSelectedItem(this.userThresholdMethod);
        cbSegmentation.setEnabled(!this.isDefaultThresholdMethod);
        JLabel labThreshParticles = new JLabel("Threshold on segmented particles (um^2)");
        labThreshParticles.setFont(this.stdFont);
        SpinnerNumberModel spModelThreshParticles = new SpinnerNumberModel(this.userParticleThresh, 0.001, 20.0, 0.001);
        JSpinner spThreshParticles = new JSpinner(spModelThreshParticles);
        spThreshParticles.setFont(this.stdFont);
        spThreshParticles.setEnabled(!this.isDefaultParticleThresh);
        JLabel labRingRadius = new JLabel("Analyzed ring radius (um)");
        labRingRadius.setFont(this.stdFont);
        SpinnerNumberModel spModelRingRadius = new SpinnerNumberModel(this.userRingRadius, 0.01, 3.0, 0.01);
        JSpinner spRingRadius = new JSpinner(spModelRingRadius);
        spRingRadius.setFont(this.stdFont);
        spRingRadius.setEnabled(!this.isDefaultRingRadius);
        JLabel labXAverageStepLeg = new JLabel("Average horizontal step (pix)");
        labXAverageStepLeg.setFont(this.stdFont);
        JLabel labXAverageStep = new JLabel("");
        labXAverageStep.setFont(this.stdFont);
        JLabel labYAverageStepLeg = new JLabel("Average vertical step (pix)");
        labYAverageStepLeg.setFont(this.stdFont);
        JLabel labYAverageStep = new JLabel("");
        labYAverageStep.setFont(this.stdFont);
        JLabel labRotationAngleLeg = new JLabel("Rotation angle (\u00b0)");
        labRotationAngleLeg.setFont(this.stdFont);
        JLabel labRotationAngle = new JLabel("");
        labRotationAngle.setFont(this.stdFont);
        JLabel labIdealGrid = new JLabel("Ideal grid");
        labIdealGrid.setFont(this.stdFont);
        labIdealGrid.setForeground(Color.GREEN);
        JLabel labDetectedGrid = new JLabel("Measured grid");
        labDetectedGrid.setFont(this.stdFont);
        labDetectedGrid.setForeground(Color.RED);
        JCheckBox chkSigma = new JCheckBox("default");
        chkSigma.setSelected(this.isDefaultSigma);
        chkSigma.setFont(this.stdFont);
        chkSigma.addActionListener(e -> spSigma.setEnabled(!chkSigma.isSelected()));
        JCheckBox chkMedian = new JCheckBox("default");
        chkMedian.setSelected(this.isDefaultMedianRadius);
        chkMedian.setFont(this.stdFont);
        chkMedian.addActionListener(e -> spMedian.setEnabled(!chkMedian.isSelected()));
        JCheckBox chkThreshSeg = new JCheckBox("default");
        chkThreshSeg.setSelected(this.isDefaultThresholdMethod);
        chkThreshSeg.setFont(this.stdFont);
        chkThreshSeg.addActionListener(e -> cbSegmentation.setEnabled(!chkThreshSeg.isSelected()));
        JCheckBox chkThreshParticles = new JCheckBox("default");
        chkThreshParticles.setSelected(this.isDefaultParticleThresh);
        chkThreshParticles.setFont(this.stdFont);
        chkThreshParticles.addActionListener(e -> spThreshParticles.setEnabled(!chkThreshParticles.isSelected()));
        JCheckBox chkRingRadius = new JCheckBox("default");
        chkRingRadius.setSelected(this.isDefaultRingRadius);
        chkRingRadius.setFont(this.stdFont);
        chkRingRadius.addActionListener(e -> spRingRadius.setEnabled(!chkRingRadius.isSelected()));
        spSigma.addChangeListener(e -> {
            if (this.imageForLivePreview != null) {
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        spMedian.addChangeListener(e -> {
            if (this.imageForLivePreview != null) {
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        spThreshParticles.addChangeListener(e -> {
            if (this.imageForLivePreview != null) {
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        spRingRadius.addChangeListener(e -> {
            if (this.imageForLivePreview != null) {
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        cbSegmentation.addItemListener(e -> {
            if (this.imageForLivePreview != null) {
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        JButton bChooseImageToTest = new JButton("Choose image");
        bChooseImageToTest.setFont(this.stdFont);
        bChooseImageToTest.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogTitle("Choose one image for test");
            fileChooser.showDialog(generalPane, "Select");
            if (fileChooser.getSelectedFile() != null) {
                File imageFile = fileChooser.getSelectedFile();
                tfImage.setText(imageFile.getAbsolutePath());
            }
        });
        JButton bLoadImage = new JButton("Load");
        bLoadImage.setFont(this.stdFont);
        bLoadImage.addActionListener(e -> {
            block12: {
                ImagePlus imp;
                IJ.run((String)"Close All", (String)"");
                this.imageForLivePreview = null;
                if (isOmeroImage) {
                    String idString = tfOmeroImage.getText();
                    try {
                        long imgId = Long.parseLong(idString);
                        ImageWrapper image = this.client.getImage(Long.valueOf(imgId));
                        imp = image.toImagePlus(this.client);
                        ImagePlus channel = IJ.createHyperStack((String)imp.getTitle(), (int)imp.getWidth(), (int)imp.getHeight(), (int)1, (int)1, (int)1, (int)imp.getBitDepth());
                        imp.setPosition(1, 1, 1);
                        channel.setProcessor(imp.getProcessor());
                        this.imageForLivePreview = channel;
                        this.pixelSizeForLivePreview = imp.getCalibration().pixelWidth;
                    }
                    catch (Exception ex) {
                        this.showErrorMessage("OMERO image", "Cannot read image " + idString + " from OMERO");
                    }
                } else {
                    String imgPath = tfImage.getText();
                    File imgFile = new File(imgPath);
                    if (imgFile.exists() && imgFile.isFile()) {
                        try {
                            ImporterOptions options = new ImporterOptions();
                            options.setId(imgFile.getAbsolutePath());
                            options.setOpenAllSeries(true);
                            options.setVirtual(true);
                            ImagePlus[] images = BF.openImagePlus((ImporterOptions)options);
                            if (images == null) {
                                this.showErrorMessage("Local image", "Cannot read image " + imgPath);
                                break block12;
                            }
                            options.setVirtual(false);
                            options.setOpenAllSeries(false);
                            if (images.length > 1) {
                                int serie = this.createSelectSerieGui(images.length);
                                options.setSeriesOn(serie, true);
                            } else {
                                options.setSeriesOn(1, true);
                            }
                            images = BF.openImagePlus((ImporterOptions)options);
                            imp = images[0];
                            ImagePlus channel = IJ.createHyperStack((String)imp.getTitle(), (int)imp.getWidth(), (int)imp.getHeight(), (int)1, (int)1, (int)1, (int)imp.getBitDepth());
                            imp.setPosition(1, 1, 1);
                            channel.setProcessor(imp.getProcessor());
                            this.imageForLivePreview = channel;
                            this.pixelSizeForLivePreview = imp.getCalibration().pixelWidth;
                        }
                        catch (IOException | FormatException ex) {
                            this.showErrorMessage("Local image", "Cannot read image " + imgPath);
                        }
                    } else {
                        this.showErrorMessage("Local image", "Cannot read image " + imgPath);
                    }
                }
            }
            if (this.imageForLivePreview != null) {
                this.imageForLivePreview.show();
                int width = this.imageForLivePreview.getWindow().getWidth();
                Point loc = this.imageForLivePreview.getWindow().getLocationOnScreen();
                this.imageForLivePreview.getWindow().setLocation(IJ.getScreenSize().width - width, loc.y);
                this.imageForLivePreview.getWindow().setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                double sigmaPreview = (Double)spSigma.getValue();
                double medianRadiusPreview = (Double)spMedian.getValue();
                String thresholdMethodPreview = (String)cbSegmentation.getSelectedItem();
                double particleThreshPreview = (Double)spThreshParticles.getValue();
                double ringRadiusPreview = (Double)spRingRadius.getValue();
                ArgoSlideLivePreview.run(this.imageForLivePreview, this.pixelSizeForLivePreview, sigmaPreview, medianRadiusPreview, thresholdMethodPreview, particleThreshPreview, ringRadiusPreview, currentArgoSpacing, currentArgoFoV);
                labXAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getXAvgStep()));
                labYAverageStep.setText(String.valueOf(ArgoSlideLivePreview.getYAvgStep()));
                labRotationAngle.setText(String.valueOf(ArgoSlideLivePreview.getRotationAngle()));
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JPanel livePreviewPane = new JPanel();
        int settingsRow = 0;
        livePreviewPane.setLayout(new GridBagLayout());
        JLabel retrieverTitle = new JLabel("Get images from");
        retrieverTitle.setFont(this.titleFont);
        if (isOmeroImage) {
            constraints.gridx = 0;
            constraints.gridy = settingsRow;
            livePreviewPane.add((Component)labOmeroImage, constraints);
            constraints.gridx = 1;
            constraints.gridy = settingsRow;
            livePreviewPane.add((Component)tfOmeroImage, constraints);
        } else {
            constraints.gridx = 0;
            constraints.gridy = settingsRow;
            livePreviewPane.add((Component)labImage, constraints);
            constraints.gridx = 1;
            constraints.gridy = settingsRow;
            livePreviewPane.add((Component)tfImage, constraints);
            constraints.gridx = 2;
            constraints.gridy = settingsRow;
            livePreviewPane.add((Component)bChooseImageToTest, constraints);
        }
        constraints.gridx = 0;
        int n = ++settingsRow;
        constraints.gridy = n;
        livePreviewPane.add((Component)bLoadImage, constraints);
        constraints.gridx = 0;
        constraints.gridy = ++settingsRow;
        livePreviewPane.add((Component)labSigma, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)chkSigma, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)spSigma, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labMedian, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)chkMedian, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)spMedian, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labThreshSeg, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)chkThreshSeg, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        livePreviewPane.add(cbSegmentation, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labThreshParticles, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)chkThreshParticles, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)spThreshParticles, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labRingRadius, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)chkRingRadius, constraints);
        constraints.gridx = 2;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)spRingRadius, constraints);
        constraints.gridwidth = 4;
        constraints.gridx = 0;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labXAverageStepLeg, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)labXAverageStep, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labYAverageStepLeg, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)labYAverageStep, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labRotationAngleLeg, constraints);
        constraints.gridx = 1;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)labRotationAngle, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow++;
        livePreviewPane.add((Component)labDetectedGrid, constraints);
        constraints.gridx = 0;
        constraints.gridy = settingsRow;
        livePreviewPane.add((Component)labIdealGrid, constraints);
        JOptionPane pane = new JOptionPane(livePreviewPane, -1, 2, null, null, null);
        this.livePreviewDialog = pane.createDialog(this.mainDialog, "Live preview");
        pane.selectInitialValue();
        this.livePreviewDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.livePreviewDialog.setVisible(true);
        this.livePreviewDialog.dispose();
        Object selectedValue = pane.getValue();
        int opt = -1;
        if (selectedValue instanceof Integer) {
            opt = (Integer)selectedValue;
        }
        if (opt == 0 && ((opt = this.showConfirmMessage("Confirm", "<html><h2>Do you want to use these settings as default ones ?</h2><p><ul><li> YES : Previous default settings will be overwritten by live settings.</li><p><li> NO : Live settings are only used in the current simulation but the default settings are kept unmodified.</li><p><li> CANCEL : Live settings are discarded.</li></ul>")) == 0 || opt == 1)) {
            this.isDefaultSigma = chkSigma.isSelected();
            this.isDefaultMedianRadius = chkMedian.isSelected();
            this.isDefaultThresholdMethod = chkThreshSeg.isSelected();
            this.isDefaultParticleThresh = chkThreshParticles.isSelected();
            this.isDefaultRingRadius = chkRingRadius.isSelected();
            this.userSigma = (Double)spSigma.getValue();
            this.userMedianRadius = (Double)spMedian.getValue();
            this.userThresholdMethod = (String)cbSegmentation.getSelectedItem();
            this.userParticleThresh = (Double)spThreshParticles.getValue();
            this.userRingRadius = (Double)spRingRadius.getValue();
            if (opt == 0) {
                this.saveUserDefinedProcessingParams(this.isDefaultSigma, this.isDefaultMedianRadius, this.isDefaultThresholdMethod, this.isDefaultParticleThresh, this.isDefaultRingRadius, this.userSigma, this.userMedianRadius, this.userThresholdMethod, this.userParticleThresh, this.userRingRadius);
            }
        }
        if (this.imageForLivePreview != null) {
            this.imageForLivePreview.close();
            this.imageForLivePreview = null;
        }
    }

    private int createSelectSerieGui(int nSeries) {
        int serie = 1;
        ArrayList<JRadioButton> seriesChoice = new ArrayList<JRadioButton>();
        ButtonGroup rbChoiceGroup = new ButtonGroup();
        for (int i = 0; i < nSeries; ++i) {
            JRadioButton rb = new JRadioButton("Serie " + (i + 1));
            rbChoiceGroup.add(rb);
            rb.setFont(this.stdFont);
            rb.setSelected(false);
            seriesChoice.add(rb);
        }
        ((JRadioButton)seriesChoice.get(0)).setSelected(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JPanel settingsPane = new JPanel();
        int settingsRow = 0;
        settingsPane.setLayout(new GridBagLayout());
        for (JRadioButton selectedSerie : seriesChoice) {
            constraints.gridx = 0;
            constraints.gridy = settingsRow++;
            settingsPane.add((Component)selectedSerie, constraints);
        }
        JOptionPane pane = new JOptionPane(settingsPane, -1, 2, null, null, null);
        this.settingsDialog = pane.createDialog(this.mainDialog, "Select serie to open");
        pane.selectInitialValue();
        this.settingsDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.settingsDialog.setVisible(true);
        this.settingsDialog.dispose();
        Object selectedValue = pane.getValue();
        int opt = -1;
        if (selectedValue instanceof Integer) {
            opt = (Integer)selectedValue;
        }
        if (opt == 0) {
            for (int i = 0; i < nSeries; ++i) {
                if (!((JRadioButton)seriesChoice.get(i)).isSelected()) continue;
                serie = i + 1;
                break;
            }
        }
        return serie;
    }

    private void setDefaultProcessingParams() {
        Map<String, List<String>> defaultParams = this.getUserDefinedParams("ArgoLight_default_processing_params.csv");
        Double val = this.checkAndSetValidityOfReadMetric(defaultParams, "Sigma", 0.2, 10);
        this.isDefaultSigma = val > 0.0;
        this.userSigma = Math.abs(val);
        val = this.checkAndSetValidityOfReadMetric(defaultParams, "Median radius", 0.2, 10);
        this.isDefaultMedianRadius = val > 0.0;
        this.userMedianRadius = Math.abs(val);
        if (defaultParams.containsKey("Segmentation method") && !defaultParams.get("Segmentation method").isEmpty() && defaultParams.get("Segmentation method").size() >= 2) {
            List<String> values = defaultParams.get("Segmentation method");
            this.isDefaultThresholdMethod = Boolean.parseBoolean(values.get(0));
            this.userThresholdMethod = values.get(1);
        } else {
            this.isDefaultThresholdMethod = true;
            this.userThresholdMethod = "Li";
        }
        val = this.checkAndSetValidityOfReadMetric(defaultParams, "Particle size threshold", 5.0, 30);
        this.isDefaultParticleThresh = val > 0.0;
        this.userParticleThresh = Math.abs(val);
        val = this.checkAndSetValidityOfReadMetric(defaultParams, "Analyzed ring radius", 1.25, 5);
        this.isDefaultRingRadius = val > 0.0;
        this.userRingRadius = Math.abs(val);
    }

    private Double checkAndSetValidityOfReadMetric(Map<String, List<String>> metrics, String key, double defaultVal, int upperBound) {
        double userVal;
        boolean isDefault;
        if (metrics.containsKey(key) && !metrics.get(key).isEmpty() && metrics.get(key).size() >= 2) {
            List<String> val = metrics.get(key);
            isDefault = Boolean.parseBoolean(val.get(0));
            try {
                userVal = Double.parseDouble(val.get(1));
                if (userVal < 0.0 || userVal > (double)upperBound) {
                    userVal = defaultVal;
                    IJLogger.warn("Read default processing params", "The value of " + key + " " + val.get(1) + " is not a range ]0;" + upperBound + "]. Default value is used instead.");
                }
            }
            catch (Exception e) {
                userVal = defaultVal;
                IJLogger.warn("Read default processing params", "The value of " + key + " " + val.get(1) + " is not a numeric value. Default value is used instead.");
            }
        } else {
            isDefault = true;
            userVal = defaultVal;
        }
        return isDefault ? userVal : -userVal;
    }

    private void setDefaultGeneralParams() {
        Map<String, List<String>> defaultParams = this.getUserDefinedParams("ArgoLight_default_params.csv");
        String string = defaultParams.containsKey("OMERO Host") ? (defaultParams.get("OMERO Host").isEmpty() ? "localhost" : defaultParams.get("OMERO Host").get(0)) : (this.userHost = "localhost");
        this.userPort = defaultParams.containsKey("OMERO Port") ? (defaultParams.get("OMERO Port").isEmpty() ? "4064" : defaultParams.get("OMERO Port").get(0)) : "4064";
        this.userArgoSlides = defaultParams.getOrDefault("ArgoSlides", Collections.emptyList());
        String string2 = defaultParams.containsKey("Root folder") ? (defaultParams.get("Root folder").isEmpty() ? "" : defaultParams.get("Root folder").get(0)) : (this.userRootFolder = "");
        this.userSaveFolder = defaultParams.containsKey("Saving folder") ? (defaultParams.get("Saving folder").isEmpty() ? "" : defaultParams.get("Saving folder").get(0)) : "";
    }

    private void setDefaultArgoParams() {
        Map<String, List<String>> readArgoSlides = this.getUserDefinedParams("ArgoLight_default_argoslide_params.csv");
        HashMap<String, List<String>> cleanArgoSlides = new HashMap<String, List<String>>();
        for (String argoSlideKey : readArgoSlides.keySet()) {
            List<String> readArgoSlideSpecs = readArgoSlides.get(argoSlideKey);
            ArrayList<String> cleanArgoSlideSpecs = new ArrayList<String>();
            if (readArgoSlideSpecs.isEmpty()) {
                IJLogger.warn("ArgoSlide' " + argoSlideKey + "' parameters have not been read correctly (size 0/4). Default values are used instead");
                this.defaultArgoSlide = "";
                cleanArgoSlideSpecs.add("false");
                cleanArgoSlideSpecs.add(String.valueOf(1));
                cleanArgoSlideSpecs.add(String.valueOf(10));
                cleanArgoSlideSpecs.add(String.valueOf(1));
            } else {
                if (readArgoSlideSpecs.get(0).equalsIgnoreCase("true")) {
                    this.defaultArgoSlide = argoSlideKey;
                }
                if (readArgoSlideSpecs.size() > 3) {
                    cleanArgoSlideSpecs.add(readArgoSlideSpecs.get(0));
                    cleanArgoSlideSpecs.add(this.checkAndSetValidityOfReadArgoMetric(readArgoSlideSpecs, 1, 1, "ring spacing"));
                    cleanArgoSlideSpecs.add(this.checkAndSetValidityOfReadArgoMetric(readArgoSlideSpecs, 2, 10, "pattern FoV"));
                    cleanArgoSlideSpecs.add(this.checkAndSetValidityOfReadArgoMetric(readArgoSlideSpecs, 3, 1, "Number of rings per line"));
                } else {
                    IJLogger.warn("ArgoSlide' " + argoSlideKey + "' parameters have not been read correctly (size " + readArgoSlideSpecs.size() + "/4). Default values are used instead");
                    cleanArgoSlideSpecs.add("false");
                    cleanArgoSlideSpecs.add(String.valueOf(1));
                    cleanArgoSlideSpecs.add(String.valueOf(10));
                    cleanArgoSlideSpecs.add(String.valueOf(1));
                }
            }
            cleanArgoSlides.put(argoSlideKey, cleanArgoSlideSpecs);
        }
        this.argoSlidesParameters.clear();
        this.argoSlidesParameters = cleanArgoSlides;
    }

    private String checkAndSetValidityOfReadArgoMetric(List<String> metrics, int metric, int defaultValue, String metricName) {
        String readArgoSlideSpec = metrics.get(metric);
        if (readArgoSlideSpec == null || readArgoSlideSpec.isEmpty()) {
            IJLogger.warn("Read default ArgoSlide params", "The value of " + metricName + " " + readArgoSlideSpec + " is not a valid. Default value " + defaultValue + "is used instead.");
            readArgoSlideSpec = String.valueOf(defaultValue);
        }
        try {
            Integer.parseInt(readArgoSlideSpec);
        }
        catch (Exception e) {
            IJLogger.warn("Read default ArgoSlide params", "The value of " + metricName + " " + readArgoSlideSpec + " is not a numeric value. Default value " + defaultValue + "is used instead.");
            readArgoSlideSpec = String.valueOf(defaultValue);
        }
        return readArgoSlideSpec;
    }

    private Map<String, List<String>> getUserDefinedParams(String fileName) {
        File file = new File(this.folderName + File.separator + fileName);
        HashMap<String, List<String>> default_params = new HashMap<String, List<String>>();
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] items = line.split(",");
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(items).subList(1, items.length));
                default_params.put(items[0], values);
            }
            br.close();
            return default_params;
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    private void showInfoMessage(String title, String content) {
        this.showMessage(title, content, 1);
    }

    private void showErrorMessage(String title, String content) {
        this.showMessage(title, content, 0);
    }

    private void showWarningMessage(String title, String content) {
        this.showMessage(title, content, 2);
    }

    private int showConfirmMessage(String title, String content) {
        if (title == null) {
            title = "";
        }
        if (content == null) {
            content = "";
        }
        return JOptionPane.showConfirmDialog(new JFrame(), content, title, 1);
    }

    private void showMessage(String title, String content, int type) {
        if (title == null) {
            title = "";
        }
        if (content == null) {
            content = "";
        }
        JOptionPane.showMessageDialog(new JFrame(), content, title, type);
    }

    private List<String> parseUserCSV(File file) {
        ArrayList<String> items = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                items.add(line.replaceAll("\ufeff", "").replaceAll("\u00ef\u00bb\u00bf", ""));
            }
            br.close();
            return items;
        }
        catch (IOException e) {
            this.showWarningMessage("CSV parsing", "Couldn't parse the csv file. No default microscopes to add");
            return Collections.emptyList();
        }
    }

    private void saveUserDefinedGeneralParams(String host, String port, String argoSlides, String rootFolder, String savingFolder) {
        File directory = new File(this.folderName);
        if (!directory.exists()) {
            directory.mkdir();
        }
        try {
            File file = new File(directory.getAbsoluteFile() + File.separator + "ArgoLight_default_params.csv");
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            buffer.write("OMERO Host," + host + "\n");
            buffer.write("OMERO Port," + port + "\n");
            buffer.write("ArgoSlides," + argoSlides + "\n");
            buffer.write("Root folder," + rootFolder + "\n");
            buffer.write("Saving folder," + savingFolder + "\n");
            buffer.close();
        }
        catch (IOException e) {
            this.showWarningMessage("CSV writing", "Couldn't write the csv for default parameters.");
        }
    }

    private void saveUserDefinedProcessingParams(boolean isDefaultSigma, boolean isDefaultMedian, boolean isDefaultSegMed, boolean isDefaultParticleThresh, boolean isDefaultRingRadius, double sigma, double median, String thresholdingMethod, double particleThreshold, double ringRadius) {
        File directory = new File(this.folderName);
        if (!directory.exists()) {
            directory.mkdir();
        }
        try {
            File file = new File(directory.getAbsoluteFile() + File.separator + "ArgoLight_default_processing_params.csv");
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            buffer.write("Sigma," + isDefaultSigma + "," + sigma + "\n");
            buffer.write("Median radius," + isDefaultMedian + "," + median + "\n");
            buffer.write("Segmentation method," + isDefaultSegMed + "," + thresholdingMethod + "\n");
            buffer.write("Particle size threshold," + isDefaultParticleThresh + "," + particleThreshold + "\n");
            buffer.write("Analyzed ring radius," + isDefaultRingRadius + "," + ringRadius + "\n");
            buffer.close();
        }
        catch (IOException e) {
            this.showWarningMessage("CSV writing", "Couldn't write the csv for default parameters.");
        }
    }

    private Map<String, List<String>> saveUserDefinedArgoSlideParams(String argoSlide, int argoSpacing, int argoFov, int argoNRings, boolean isDefault) {
        File directory = new File(this.folderName);
        if (!directory.exists()) {
            directory.mkdir();
        }
        HashMap<String, List<String>> tempMap = new HashMap<String, List<String>>(this.argoSlidesParameters);
        if (isDefault) {
            tempMap.forEach((key, value) -> value.set(0, "false"));
        }
        ArrayList<String> argoslideParamList = new ArrayList<String>();
        argoslideParamList.add(String.valueOf(isDefault));
        argoslideParamList.add(String.valueOf(argoSpacing));
        argoslideParamList.add(String.valueOf(argoFov));
        argoslideParamList.add(String.valueOf(argoNRings));
        tempMap.put(argoSlide, argoslideParamList);
        try {
            File file = new File(directory.getAbsoluteFile() + File.separator + "ArgoLight_default_argoslide_params.csv");
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            for (String argoSlideKey : tempMap.keySet()) {
                String argoSlideParamCSV = String.join((CharSequence)",", (Iterable)tempMap.get(argoSlideKey));
                buffer.write(argoSlideKey + "," + argoSlideParamCSV + "\n");
            }
            buffer.close();
        }
        catch (IOException e) {
            this.showWarningMessage("CSV writing", "Couldn't write the csv for ArgoSlide '" + argoSlide + "' parameters.");
        }
        return tempMap;
    }

    public static void main(String ... args) {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
    }

    public void run() {
        IJLogger.info("ArgoLight Analysis Tool Launched");
        this.createGui();
    }

    private static enum CONNECTION_STATE {
        CONNECTED("Disconnect"),
        DISCONNECTED("Connect");

        private final String name;

        private CONNECTION_STATE(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

