/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.util;

import ij.plugin.filter.GaussianBlur;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.util.Util;

public class Filter {
    public static final void normalize(float[] data) {
        float sum = 0.0f;
        for (float d : data) {
            sum += d;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
    }

    public static final float[] createGaussianKernel(float sigma) {
        float[] kernel;
        if (sigma <= 0.0f) {
            kernel = new float[]{1.0f};
        } else {
            int size = Math.max(3, 2 * (int)(3.0f * sigma + 0.5f) + 1);
            float twoSquareSigma = 2.0f * sigma * sigma;
            kernel = new float[size];
            for (int x = size / 2; x >= 0; --x) {
                float val;
                kernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / twoSquareSigma);
                kernel[size / 2 + x] = val;
            }
        }
        return kernel;
    }

    public static final float[] createNormalizedGaussianKernel(float sigma) {
        float[] kernel = Filter.createGaussianKernel(sigma);
        Filter.normalize(kernel);
        return kernel;
    }

    public static final FloatProcessor createShiftedGaussianKernel(float sigma, float offsetX, float offsetY) {
        FloatProcessor kernel;
        if (sigma <= 0.0f) {
            kernel = new FloatProcessor(1, 1);
            kernel.setf(0, 1.0f);
        } else {
            int size = Math.max(3, 2 * Math.round(3.0f * sigma) + 1);
            float twoSquareSigma = 2.0f * sigma * sigma;
            kernel = new FloatProcessor(size, size);
            for (int x = size - 1; x >= 0; --x) {
                float fx = x - size / 2;
                for (int y = size - 1; y >= 0; --y) {
                    float fy = y - size / 2;
                    float val = (float)Math.exp(-(Math.pow(fx - offsetX, 2.0) + Math.pow(fy - offsetY, 2.0)) / (double)twoSquareSigma);
                    kernel.setf(x, y, val);
                }
            }
        }
        return kernel;
    }

    public static final FloatProcessor createNormalizedShiftedGaussianKernel(float sigma, float offsetX, float offsetY) {
        FloatProcessor kernel = Filter.createShiftedGaussianKernel(sigma, offsetX, offsetY);
        Filter.normalize((float[])kernel.getPixels());
        return kernel;
    }

    public static final FloatProcessor[] createGradients(FloatProcessor array) {
        int width = array.getWidth();
        int height = array.getHeight();
        FloatProcessor[] gradients = new FloatProcessor[]{new FloatProcessor(width, height), new FloatProcessor(width, height)};
        float[] data = (float[])array.getPixels();
        float[] rData = (float[])gradients[0].getPixels();
        float[] phiData = (float[])gradients[1].getPixels();
        for (int y = 0; y < height; ++y) {
            int[] ro = new int[]{width * Math.max(0, y - 1), width * y, width * Math.min(y + 1, height - 1)};
            for (int x = 0; x < width; ++x) {
                float der_x = (data[ro[1] + Math.min(x + 1, width - 1)] - data[ro[1] + Math.max(0, x - 1)]) / 2.0f;
                float der_y = (data[ro[2] + x] - data[ro[0] + x]) / 2.0f;
                rData[ro[1] + x] = (float)Math.sqrt(Math.pow(der_x, 2.0) + Math.pow(der_y, 2.0));
                phiData[ro[1] + x] = (float)Math.atan2(der_y, der_x);
            }
        }
        return gradients;
    }

    public static final FloatProcessor createConvolveSeparable(FloatProcessor input, float[] h, float[] v) {
        FloatProcessor output = (FloatProcessor)input.duplicate();
        Filter.convolveSeparable(output, h, v);
        return output;
    }

    public static final void convolveSeparable(FloatProcessor input, float[] h, float[] v) {
        int width = input.getWidth();
        int height = input.getHeight();
        FloatProcessor temp = new FloatProcessor(width, height);
        float[] inputData = (float[])input.getPixels();
        float[] tempData = (float[])temp.getPixels();
        int hl = h.length / 2;
        int vl = v.length / 2;
        int xl = width - h.length + 1;
        int yl = height - v.length + 1;
        int[] xb = new int[h.length + hl - 1];
        int[] xa = new int[h.length + hl - 1];
        for (int i = 0; i < xb.length; ++i) {
            xb[i] = Util.pingPong(i - hl, width);
            xa[i] = Util.pingPong(i + xl, width);
        }
        int[] yb = new int[v.length + vl - 1];
        int[] ya = new int[v.length + vl - 1];
        for (int i = 0; i < yb.length; ++i) {
            yb[i] = width * Util.pingPong(i - vl, height);
            ya[i] = width * Util.pingPong(i + yl, height);
        }
        xl += hl;
        yl += vl;
        int rl = height * width;
        for (int r = 0; r < rl; r += width) {
            int xk;
            int x;
            for (x = hl; x < xl; ++x) {
                int c = x - hl;
                float val = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    val += h[xk] * inputData[r + c + xk];
                }
                tempData[r + x] = val;
            }
            for (x = 0; x < hl; ++x) {
                float valb = 0.0f;
                float vala = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    valb += h[xk] * inputData[r + xb[x + xk]];
                    vala += h[xk] * inputData[r + xa[x + xk]];
                }
                tempData[r + x] = valb;
                tempData[r + x + xl] = vala;
            }
        }
        int rm = yl * width;
        int vlc = vl * width;
        for (int x = 0; x < width; ++x) {
            int yk;
            for (int r = vlc; r < rm; r += width) {
                float val = 0.0f;
                int c = r - vlc;
                int rk = 0;
                for (yk = 0; yk < v.length; ++yk) {
                    val += v[yk] * tempData[c + rk + x];
                    rk += width;
                }
                inputData[r + x] = val;
            }
            for (int y = 0; y < vl; ++y) {
                int r = y * width;
                float valb = 0.0f;
                float vala = 0.0f;
                for (yk = 0; yk < v.length; ++yk) {
                    valb += h[yk] * tempData[yb[y + yk] + x];
                    vala += h[yk] * tempData[ya[y + yk] + x];
                }
                inputData[r + x] = valb;
                inputData[r + rm + x] = vala;
            }
        }
    }

    public static final void smoothForScale(FloatProcessor source, double scale, float sourceSigma, float targetSigma) {
        assert (scale <= 1.0) : "Downsampling requires a scale factor < 1.0";
        double s = (double)targetSigma / scale;
        double v = s * s - (double)(sourceSigma * sourceSigma);
        if (v <= 0.0) {
            return;
        }
        float sigma = (float)Math.sqrt(v);
        new GaussianBlur().blurFloat(source, (double)sigma, (double)sigma, 0.01);
    }

    public static final FloatProcessor createDownsampled(FloatProcessor source, double scale, float sourceSigma, float targetSigma) {
        int y;
        assert (scale <= 1.0) : "Downsampling requires a scale factor < 1.0";
        int ow = source.getWidth();
        int oh = source.getHeight();
        int w = (int)Math.round((double)ow * scale);
        int h = (int)Math.round((double)oh * scale);
        FloatProcessor temp = (FloatProcessor)source.duplicate();
        temp.setMinAndMax(source.getMin(), source.getMax());
        Filter.smoothForScale(temp, scale, sourceSigma, targetSigma);
        if (scale == 1.0) {
            return temp;
        }
        float[] tempPixels = (float[])temp.getPixels();
        FloatProcessor target = new FloatProcessor(w, h);
        target.setMinAndMax(source.getMin(), source.getMax());
        float[] targetPixels = (float[])target.getPixels();
        int ow1 = ow - 1;
        int oh1 = oh - 1;
        int[] lutx = new int[w];
        for (int x = 0; x < w; ++x) {
            lutx[x] = Math.min(ow1, Math.max(0, (int)Math.round((double)x / scale)));
        }
        int[] luty = new int[h];
        for (y = 0; y < h; ++y) {
            luty[y] = Math.min(oh1, Math.max(0, (int)Math.round((double)y / scale)));
        }
        for (y = 0; y < h; ++y) {
            int p = y * w;
            int q = luty[y] * ow;
            for (int x = 0; x < w; ++x) {
                targetPixels[p + x] = tempPixels[q + lutx[x]];
            }
        }
        return target;
    }

    public static final void smoothForScale(ImageProcessor source, double scale, float sourceSigma, float targetSigma) {
        double s = (double)targetSigma / scale;
        double v = s * s - (double)(sourceSigma * sourceSigma);
        if (v <= 0.0) {
            return;
        }
        double sigma = Math.sqrt(v);
        new GaussianBlur().blurGaussian(source, sigma, sigma, 0.01);
    }

    public static final ImageProcessor createDownsampled(ImageProcessor source, double scale, float sourceSigma, float targetSigma) {
        int ow = source.getWidth();
        int oh = source.getHeight();
        int w = (int)Math.round((double)ow * scale);
        int h = (int)Math.round((double)oh * scale);
        ImageProcessor temp = source.duplicate();
        temp.setMinAndMax(source.getMin(), source.getMax());
        Filter.smoothForScale(temp, scale, sourceSigma, targetSigma);
        if (scale >= 1.0) {
            return temp;
        }
        ImageProcessor target = temp.resize(w, h);
        target.setMinAndMax(source.getMin(), source.getMax());
        return target;
    }

    public static final ImageProcessor scale(ImageProcessor source, float scale) {
        ImageProcessor target;
        if (scale == 1.0f) {
            target = source.duplicate();
        } else if (scale < 1.0f) {
            target = Filter.createDownsampled(source, (double)scale, 0.5f, 0.5f);
        } else {
            source.setInterpolationMethod(1);
            target = source.resize(Math.round(scale * (float)source.getWidth()));
        }
        target.setMinAndMax(source.getMin(), source.getMax());
        return target;
    }
}

