/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.quicknii;

import ch.epfl.biop.atlas.aligner.DeepSliceHelper;
import java.text.DecimalFormat;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;

public class QuickNIISeries {
    public String name;
    public String target;
    public String aligner;
    public List<SliceInfo> slices;

    @Deprecated
    public static AffineTransform3D getTransformInCCFv3(SliceInfo slice, double imgWidth, double imgHeight) {
        return QuickNIISeries.getTransform("Adult Mouse Brain - Allen Brain Atlas V3p1", slice, imgWidth, imgHeight);
    }

    public static AffineTransform3D getTransform(String atlasName, SliceInfo slice, double imgWidth, double imgHeight) {
        AffineTransform3D transform = new AffineTransform3D();
        Anchor anchor = new Anchor(slice.anchoring);
        double[] u = new double[]{anchor.ux / imgWidth, anchor.uy / imgWidth, anchor.uz / imgWidth};
        double[] v = new double[]{anchor.vx / imgHeight, anchor.vy / imgHeight, anchor.vz / imgHeight};
        double[] w = new double[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
        double norm = Math.sqrt(w[0] * w[0] + w[1] * w[1] + w[2] * w[2]);
        w[0] = w[0] * (1.0 / norm);
        w[1] = w[1] * (1.0 / norm);
        w[2] = w[2] * (1.0 / norm);
        transform.set(u[0], v[0], w[0], anchor.ox, u[1], v[1], w[1], anchor.oy, u[2], v[2], w[2], anchor.oz);
        AffineTransform3D toCCF = new AffineTransform3D();
        if (DeepSliceHelper.isDeepSliceMouseCompatible(atlasName)) {
            toCCF.set(0.0, -0.025, 0.0, 13.2, 0.0, 0.0, -0.025, 8.0, 0.025, 0.0, 0.0, 0.0);
            if (!atlasName.startsWith("Adult Mouse Brain - Allen Brain Atlas V3")) {
                AffineTransform3D toBrainGlobe = new AffineTransform3D();
                toBrainGlobe.set(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 11.4);
                toCCF.preConcatenate(toBrainGlobe.inverse());
            }
        } else if (DeepSliceHelper.isDeepSliceRatCompatible(atlasName)) {
            toCCF.set(0.0390625, 0.0, 0.0, -9.53125, 0.0, 0.0390625, 0.0, -24.3359375, 0.0, 0.0, 0.0390625, -9.6875);
            if (!atlasName.startsWith("Rat - Waxholm Sprague Dawley V4")) {
                AffineTransform3D toBrainGlobe = new AffineTransform3D();
                toBrainGlobe.set(-1.0, 0.0, 0.0, 10.45, 0.0, 0.0, -1.0, 10.26, 0.0, -1.0, 0.0, 15.565);
                toCCF.preConcatenate(toBrainGlobe);
            }
        } else {
            System.err.println("Unknown or unsupported atlas named " + atlasName);
        }
        return transform.preConcatenate(toCCF);
    }

    public static class Anchor {
        double ox;
        double oy;
        double oz;
        double ux;
        double uy;
        double uz;
        double vx;
        double vy;
        double vz;
        static DecimalFormat df = new DecimalFormat("###.##");

        public Anchor(double[] values) {
            this.ox = values[0];
            this.oy = values[1];
            this.oz = values[2];
            this.ux = values[3];
            this.uy = values[4];
            this.uz = values[5];
            this.vx = values[6];
            this.vy = values[7];
            this.vz = values[8];
        }

        public String toString() {
            return "o[" + df.format(this.ox) + "," + df.format(this.oy) + "," + df.format(this.oz) + "] u[" + df.format(this.ux) + "," + df.format(this.uy) + "," + df.format(this.uz) + "] v[" + df.format(this.vx) + "," + df.format(this.vy) + "," + df.format(this.vz) + "]";
        }
    }

    public static class SliceInfo {
        public String filename;
        public double[] anchoring;
        public double height;
        public double width;
        public int nr;
    }
}

