/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.quicknii;

import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.SliceToImagePlus;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageConverter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class QuickNIIExporter {
    final List<SliceSources> slices;
    final File datasetFolder;
    final SourcesProcessor processor;
    final double pxSizeMicron;
    final boolean interpolate;
    final boolean convertTo8Bits;
    final boolean convertToJpeg;
    final double[] roi;
    final Consumer<String> logger;
    final String imageName;

    private QuickNIIExporter(List<SliceSources> slices, File datasetFolder, SourcesProcessor processor, double pxSizeMicron, boolean interpolate, boolean convertTo8Bits, boolean convertToJpeg, double[] roi, Consumer<String> logger, String imageName) {
        this.slices = slices;
        this.datasetFolder = datasetFolder;
        this.processor = processor;
        this.pxSizeMicron = pxSizeMicron;
        this.convertTo8Bits = convertTo8Bits;
        this.convertToJpeg = convertToJpeg;
        this.interpolate = interpolate;
        this.roi = roi;
        this.logger = logger;
        this.imageName = imageName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> export() throws Exception {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (!this.datasetFolder.exists() && !this.datasetFolder.mkdir()) {
            throw new IOException("QuickNII dataset export failure, Cannot create folder " + this.datasetFolder.getAbsolutePath());
        }
        if (this.slices.isEmpty()) {
            return filePaths;
        }
        DecimalFormat df = new DecimalFormat("000");
        IntStream.range(0, this.slices.size()).parallel().forEach(i -> {
            SliceSources slice = this.slices.get(i);
            ImagePlus imp = SliceToImagePlus.export(slice, this.processor, this.roi[0], this.roi[1], this.roi[2], this.roi[3], this.pxSizeMicron / 1000.0, 0, this.interpolate);
            imp.setTitle(this.imageName + "_s" + df.format(i));
            if (this.convertTo8Bits) {
                new ImageConverter(imp).convertToGray8();
            }
            if (this.convertToJpeg) {
                String filePath = this.datasetFolder.getAbsolutePath() + File.separator + this.imageName + "_s" + df.format(i) + ".jpg";
                IJ.saveAs((ImagePlus)imp, (String)"jpeg", (String)filePath);
                filePaths.add(filePath);
            } else {
                String filePath = this.datasetFolder.getAbsolutePath() + File.separator + this.imageName + "_s" + df.format(i) + ".tif";
                IJ.save((ImagePlus)imp, (String)filePath);
                filePaths.add(filePath);
            }
            this.logger.accept("Export of slice " + slice + " done (" + (i + 1) + "/" + this.slices.size() + ")");
        });
        this.logger.accept("Export as QuickNii Dataset done - Folder : " + this.datasetFolder.getAbsolutePath());
        return filePaths;
    }

    public static class Builder {
        File datasetFolder;
        SourcesProcessor processor = SourcesProcessorHelper.Identity();
        double pxSizeMicron = 30.0;
        boolean interpolate = true;
        boolean convertTo8Bits = true;
        boolean convertToJpeg = true;
        List<SliceSources> slices = new ArrayList<SliceSources>();
        double[] roi;
        final Consumer<String> logger = System.out::println;
        String imageName = "Section";

        public Builder slices(List<SliceSources> slices) {
            this.slices = slices;
            return this;
        }

        public Builder name(String name) {
            this.imageName = name;
            return this;
        }

        public Builder folder(File datasetFolder) {
            this.datasetFolder = datasetFolder;
            return this;
        }

        public Builder roi(double[] roi) {
            this.roi = roi;
            return this;
        }

        public Builder jpeg(boolean flag) {
            this.convertToJpeg = flag;
            return this;
        }

        public Builder cvt8bits(boolean flag) {
            this.convertTo8Bits = flag;
            return this;
        }

        public Builder pixelSizeMicron(double pxSize) {
            this.pxSizeMicron = pxSize;
            return this;
        }

        public Builder interpolate(boolean flag) {
            this.interpolate = flag;
            return this;
        }

        public Builder setProcessor(SourcesProcessor processor) {
            this.processor = processor;
            return this;
        }

        public QuickNIIExporter create() {
            return new QuickNIIExporter(this.slices, this.datasetFolder, this.processor, this.pxSizeMicron, this.interpolate, this.convertTo8Bits, this.convertToJpeg, this.roi, this.logger, this.imageName);
        }
    }
}

