/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv.card;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.GetUserRectangleCommand;
import net.imglib2.RealPoint;
import org.scijava.Initializable;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.command.InteractiveCommand;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>ABBA - Define Rectangular ROI", description="Defines a rectangular ROI that will be considered for registrations")
public class SliceDefineROICommand
extends InteractiveCommand
implements Initializable {
    protected static final Logger logger = LoggerFactory.getLogger(SliceDefineROICommand.class);
    @Parameter
    MultiSlicePositioner mp;
    @Parameter
    BdvMultislicePositionerView view;
    @Parameter(persist=false)
    Double px;
    @Parameter(persist=false)
    Double py;
    @Parameter(persist=false)
    Double sx;
    @Parameter(persist=false)
    Double sy;
    @Parameter(label="Define Interactively", callback="defineClicked")
    Button defineRegionInteractively;
    @Parameter(label="Full Size", callback="fullSizeClicked")
    Button setRegionFullSize;
    @Parameter
    CommandService cs;
    boolean inProcess = false;

    public SliceDefineROICommand() {
        super(new String[0]);
    }

    public void run() {
        this.mp.setROI(this.px, this.py, this.sx, this.sy);
    }

    public void initialize() {
        double[] roi = this.view.msp.getROI();
        MutableModuleItem px = this.getInfo().getMutableInput("px", Double.class);
        px.setValue((Module)this, (Object)roi[0]);
        MutableModuleItem py = this.getInfo().getMutableInput("py", Double.class);
        py.setValue((Module)this, (Object)roi[1]);
        MutableModuleItem sx = this.getInfo().getMutableInput("sx", Double.class);
        sx.setValue((Module)this, (Object)roi[2]);
        MutableModuleItem sy = this.getInfo().getMutableInput("sy", Double.class);
        sy.setValue((Module)this, (Object)roi[3]);
    }

    public void defineClicked() {
        if (this.inProcess) {
            this.mp.errorMessageForUser.accept("Please confirm the previous rectangle", "ROI already being selected");
        } else {
            Thread t = new Thread(() -> {
                try {
                    this.inProcess = true;
                    CommandModule cm = (CommandModule)this.cs.run(GetUserRectangleCommand.class, true, new Object[]{"bdvh", this.view.getBdvh(), "time_out_in_ms", -1, "message_for_user", "Select the rectangular region of interest."}).get();
                    RealPoint p1 = (RealPoint)cm.getOutput("p1");
                    RealPoint p2 = (RealPoint)cm.getOutput("p2");
                    this.sx = Math.abs(p1.getDoublePosition(0) - p2.getDoublePosition(0));
                    this.sy = Math.abs(p1.getDoublePosition(1) - p2.getDoublePosition(1));
                    double minx = Math.min(p1.getDoublePosition(0), p2.getDoublePosition(0));
                    double miny = Math.min(p1.getDoublePosition(1), p2.getDoublePosition(1));
                    if (this.view.getDisplayMode() == 0) {
                        this.px = Math.IEEEremainder(minx + this.mp.sX * 0.5, this.mp.sX);
                        this.py = miny;
                    }
                    if (this.view.getDisplayMode() == 1) {
                        this.px = minx;
                        this.py = miny;
                    }
                    logger.debug("px = " + this.px);
                    logger.debug("py = " + this.py);
                    logger.debug("sx = " + this.sx);
                    logger.debug("sy = " + this.sy);
                    this.run();
                    this.inProcess = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.fullSizeClicked();
                }
            });
            t.start();
        }
    }

    public void fullSizeClicked() {
        this.px = -this.mp.sX / 2.0;
        this.py = -this.mp.sY / 2.0;
        this.sx = this.mp.sX;
        this.sy = this.mp.sY;
        this.run();
    }
}

