/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv.card;

import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class NavigationPanel {
    final JPanel paneDisplay = new JPanel();
    final JButton singleSliceDisplayMode;
    final JButton allSlicesDisplayMode;
    final JButton reviewMode;
    final JButton positioningMode;
    final JButton gotoNextSlice;
    final JButton centerOnCurrentSlice;
    final JButton gotoPreviousSlice;
    final JButton changeOverlapMode;
    final JSlider overlapFactorSliderX;
    final JSlider overlapFactorSliderY;
    final JButton viewPreviousRegistration;
    final JButton viewNextRegistration;

    public NavigationPanel(BdvMultislicePositionerView view) {
        this.paneDisplay.setLayout(new BoxLayout(this.paneDisplay, 0));
        this.reviewMode = new JButton("Review");
        this.reviewMode.addActionListener(e -> view.setDisplayMode(1));
        this.positioningMode = new JButton("Positioning");
        this.positioningMode.addActionListener(e -> view.setDisplayMode(0));
        this.singleSliceDisplayMode = new JButton("Display One Slice Only (fast)");
        this.singleSliceDisplayMode.addActionListener(e -> view.setSliceDisplayMode(1));
        this.allSlicesDisplayMode = new JButton("Display All Slices");
        this.allSlicesDisplayMode.addActionListener(e -> view.setSliceDisplayMode(0));
        this.changeOverlapMode = new JButton("Change Overlap Mode");
        this.changeOverlapMode.addActionListener(e -> view.toggleOverlap());
        this.gotoPreviousSlice = new JButton("Previous [Left]");
        this.gotoPreviousSlice.addActionListener(e -> view.navigatePreviousSlice());
        this.centerOnCurrentSlice = new JButton("Center Current [C]");
        this.centerOnCurrentSlice.addActionListener(e -> view.navigateCurrentSlice());
        this.gotoNextSlice = new JButton("Next [Right]");
        this.gotoNextSlice.addActionListener(e -> view.navigateNextSlice());
        this.overlapFactorSliderX = new JSlider();
        this.overlapFactorSliderX.addChangeListener(l -> view.setOverlapFactorX(this.overlapFactorSliderX.getValue()));
        this.overlapFactorSliderY = new JSlider();
        this.overlapFactorSliderY.addChangeListener(l -> view.setOverlapFactorY(this.overlapFactorSliderY.getValue()));
        this.viewPreviousRegistration = new JButton("View Previous [P]");
        this.viewPreviousRegistration.addActionListener(e -> view.viewPreviousRegistration());
        this.viewNextRegistration = new JButton("View Next [N]");
        this.viewNextRegistration.addActionListener(e -> view.viewNextRegistration());
        this.paneDisplay.add(NavigationPanel.box(false, new JLabel("Modes"), NavigationPanel.box(true, this.reviewMode, this.positioningMode), new JLabel("Slice Display"), NavigationPanel.box(true, this.singleSliceDisplayMode, this.allSlicesDisplayMode), new JLabel("Overlap (positioning)"), NavigationPanel.box(false, this.changeOverlapMode, NavigationPanel.box(true, new JLabel("Overlap size (X|Y)"), this.overlapFactorSliderX, this.overlapFactorSliderY)), new JLabel("Navigate Slice"), NavigationPanel.box(true, this.gotoPreviousSlice, this.centerOnCurrentSlice, this.gotoNextSlice), new JLabel("Browse Registrations"), NavigationPanel.box(true, this.viewPreviousRegistration, this.viewNextRegistration)));
    }

    public static JPanel box(boolean alongX, JComponent ... components) {
        JPanel box = new JPanel();
        if (alongX) {
            box.setLayout(new GridLayout(1, components.length));
        } else {
            box.setLayout(new GridLayout(components.length, 1));
        }
        for (JComponent component : components) {
            box.add(component);
        }
        return box;
    }

    public JPanel getPanel() {
        return this.paneDisplay;
    }
}

