/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv.card;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.scijava.Context;
import org.scijava.platform.PlatformService;

public class AtlasInfoPanel {
    final JPanel paneDisplay = new JPanel();

    public AtlasInfoPanel(MultiSlicePositioner mp) {
        this.paneDisplay.setLayout(new BoxLayout(this.paneDisplay, 0));
        JLabel atlasName = new JLabel(mp.getAtlas().toString());
        String modalities = "";
        for (String key : mp.getAtlas().getMap().getImagesKeys()) {
            modalities = modalities + "[" + key + "]";
        }
        long[] dimensions = new long[]{0L, 0L, 0L};
        mp.getAtlas().getMap().getLabelImage().getSpimSource().getSource(0, 0).dimensions(dimensions);
        JLabel atlasResolution = new JLabel("[" + dimensions[0] + "," + dimensions[1] + "," + dimensions[2] + "] - Resolution: " + (int)(mp.getAtlas().getMap().getAtlasPrecisionInMillimeter() * 1000.0) + " um");
        JLabel atlasModalities = new JLabel(modalities);
        JTextPane atlasDOI = new JTextPane();
        atlasDOI.setText("doi: " + (String)mp.getAtlas().getDOIs().get(0));
        atlasDOI.setEditable(false);
        atlasDOI.setBackground(null);
        atlasDOI.setBorder(null);
        JButton gotoInfo = new JButton("WebPage");
        Context ctx = mp.getContext();
        gotoInfo.addActionListener(e -> {
            try {
                ((PlatformService)ctx.getService(PlatformService.class)).open(new URL(mp.getAtlas().getURL()));
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        });
        this.paneDisplay.add(this.box(false, atlasName, atlasModalities, atlasResolution, atlasDOI, gotoInfo));
    }

    public JPanel box(boolean alongX, JComponent ... components) {
        JPanel box = new JPanel();
        if (alongX) {
            box.setLayout(new GridLayout(1, components.length));
        } else {
            box.setLayout(new GridLayout(components.length, 1));
        }
        for (JComponent component : components) {
            box.add(component);
        }
        return box;
    }

    public JPanel getPanel() {
        return this.paneDisplay;
    }
}

