/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv.card;

import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import java.util.List;
import org.scijava.Initializable;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

@Plugin(type=Command.class)
public class AtlasAdjustDisplayCommand
extends InteractiveCommand
implements Initializable,
BdvMultislicePositionerView.ModeListener {
    @Parameter
    BdvMultislicePositionerView view;
    boolean listenerRegistered = false;
    @Parameter
    SourceAndConverterService sac_service;

    public AtlasAdjustDisplayCommand() {
        super(new String[0]);
    }

    public void initialize() {
        int idx_Channel = 0;
        for (String key : this.view.msp.getAtlas().getMap().getImagesKeys()) {
            if (!this.view.includedKey(key)) continue;
            this.addInput(key + "_enable", Boolean.class);
            MutableModuleItem modalityEnable = this.getInfo().getMutableInput(key + "_enable", Boolean.class);
            modalityEnable.setLabel(key + " (Ch. " + idx_Channel + ")");
            modalityEnable.setDefaultValue((Object)true);
            this.addInput(key + "_slider", Double.class);
            MutableModuleItem modalitySlider = this.getInfo().getMutableInput(key + "_slider", Double.class);
            modalitySlider.setLabel(" ");
            modalitySlider.setDefaultValue((Object)0.5);
            modalitySlider.setMinimumValue((Object)0.0);
            modalitySlider.setMaximumValue((Object)1.0);
            modalitySlider.setStepSize((Number)0.01);
            modalitySlider.setWidgetStyle("slider,format:#.00");
            ++idx_Channel;
        }
        this.addInput("slicingSteps", Integer.class);
        MutableModuleItem slicingSteps = this.getInfo().getMutableInput("slicingSteps", Integer.class);
        slicingSteps.setWidgetStyle("slider");
        slicingSteps.setMinimumValue((Object)1);
        slicingSteps.setMaximumValue((Object)50);
        slicingSteps.setPersisted(false);
        slicingSteps.setLabel("Displayed slicing [atlas steps]");
        slicingSteps.setValue((Module)this, (Object)((int)this.view.msp.getReslicedAtlas().getStep()));
        this.view.addToCleanUpHook(() -> this.view.removeModeListener(this));
    }

    public void run() {
        if (this.view != null && !this.listenerRegistered) {
            this.view.addModeListener(this);
            this.listenerRegistered = true;
        }
        this.view.msp.getReslicedAtlas().setStep((Integer)this.getInput("slicingSteps"));
        List keys = this.view.msp.getAtlas().getMap().getImagesKeys();
        for (int iChannel = 0; iChannel < keys.size(); ++iChannel) {
            String key = (String)keys.get(iChannel);
            if (!this.view.includedKey(key)) continue;
            this.view.getBdvh().getViewerPanel().state().setSourceActive(this.view.getDisplayedAtlasSources()[iChannel], ((Boolean)this.getInput(key + "_enable")).booleanValue());
            ConverterSetup converterSetup = this.sac_service.getConverterSetup(this.view.getDisplayedAtlasSources()[iChannel]);
            double sliderValue = (Double)this.getInput(key + "_slider");
            converterSetup.setDisplayRange(0.0, this.view.msp.getAtlas().getMap().getImageMax(key) * (1.0 - sliderValue));
        }
    }

    @Override
    public void modeChanged(BdvMultislicePositionerView mp, int oldmode, int newmode) {
        if (newmode == 1) {
            SourceAndConverterHelper.transferColorConverters((SourceAndConverter[])this.view.msp.getReslicedAtlas().extendedSlicedSources, (SourceAndConverter[])this.view.msp.getReslicedAtlas().nonExtendedSlicedSources);
        } else {
            SourceAndConverterHelper.transferColorConverters((SourceAndConverter[])this.view.msp.getReslicedAtlas().nonExtendedSlicedSources, (SourceAndConverter[])this.view.msp.getReslicedAtlas().extendedSlicedSources);
        }
        for (SourceAndConverter sac : this.view.msp.getReslicedAtlas().extendedSlicedSources) {
            this.view.getBdvh().getViewerPanel().state().setSourceActive(sac, false);
        }
        for (SourceAndConverter sac : this.view.msp.getReslicedAtlas().nonExtendedSlicedSources) {
            this.view.getBdvh().getViewerPanel().state().setSourceActive(sac, false);
        }
        List keys = this.view.msp.getAtlas().getMap().getImagesKeys();
        block6: for (int iChannel = 0; iChannel < keys.size(); ++iChannel) {
            String key = (String)keys.get(iChannel);
            if (!this.view.includedKey(key)) continue;
            switch (newmode) {
                case 0: {
                    this.view.getBdvh().getViewerPanel().state().setSourceActive(this.view.msp.getReslicedAtlas().extendedSlicedSources[iChannel], ((Boolean)this.getInput(key + "_enable")).booleanValue());
                    continue block6;
                }
                case 1: {
                    this.view.getBdvh().getViewerPanel().state().setSourceActive(this.view.msp.getReslicedAtlas().nonExtendedSlicedSources[iChannel], ((Boolean)this.getInput(key + "_enable")).booleanValue());
                    continue block6;
                }
            }
        }
    }
}

