/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.command.DisplaySettingsCommand;
import ch.epfl.biop.atlas.aligner.gui.SliceSourcesPopupMenu;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.SliceInformationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.scijava.command.CommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spimdata.util.Displaysettings;

public class TableView
implements MultiSlicePositioner.SliceChangeListener,
ListSelectionListener {
    int maxChannels = 0;
    final JPanel paneDisplay;
    protected static final Logger logger = LoggerFactory.getLogger(TableView.class);
    final JTable table;
    final SliceDisplayTableModel model;
    final BdvMultislicePositionerView view;
    final MultiSlicePositioner mp;
    List<SliceSources> listCopy = new ArrayList<SliceSources>();
    final Object slicesModifyLock = new Object();
    int currentIndex = -1;

    public TableView(final BdvMultislicePositionerView view) {
        this.paneDisplay = new JPanel(new BorderLayout());
        this.view = view;
        this.mp = view.msp;
        this.model = new SliceDisplayTableModel();
        this.table = new JTable(this.model);
        this.table.setShowGrid(false);
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setFillsViewportHeight(false);
        this.table.setDefaultRenderer(Displaysettings.class, new DisplaySettingsRenderer(true));
        this.table.setDefaultRenderer(Boolean.class, new VisibilityRenderer(true));
        this.table.setComponentPopupMenu(SliceSourcesPopupMenu.createFinalPopupMenu(view.msp, view));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new SliceInformationPanel(view).getPanel(), "Center");
        panel.add((Component)new JLabel("Click table header to modify selected slices"), "South");
        this.paneDisplay.add((Component)panel, "North");
        this.paneDisplay.add((Component)new JScrollPane(this.table), "Center");
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = TableView.this.table.columnAtPoint(e.getPoint());
                String name = TableView.this.table.getColumnName(col);
                logger.debug("Column index selected " + col + " " + name);
                if (col == 1) {
                    int[] selectedRows = TableView.this.table.getSelectedRows();
                    int nVisible = 0;
                    int nInvisible = 0;
                    for (int selectedRow : selectedRows) {
                        if (((Boolean)TableView.this.table.getValueAt(selectedRow, col)).booleanValue()) {
                            ++nVisible;
                            continue;
                        }
                        ++nInvisible;
                    }
                    boolean newState = nVisible < nInvisible;
                    for (int selectedRow : selectedRows) {
                        view.guiState.runSlice(TableView.this.getSlices().get(selectedRow), sliceGuiState -> sliceGuiState.setSliceVisibility(newState));
                    }
                }
                if (col > 1 && col % 2 == 0) {
                    int iChannel = (col - 2) / 2;
                    int[] selectedRows = TableView.this.table.getSelectedRows();
                    int nVisible = 0;
                    int nInvisible = 0;
                    for (int row : selectedRows) {
                        if (((Boolean)TableView.this.table.getValueAt(row, col)).booleanValue()) {
                            ++nVisible;
                            continue;
                        }
                        ++nInvisible;
                    }
                    boolean newState = nVisible < nInvisible;
                    for (int selectedRow : selectedRows) {
                        view.guiState.runSlice(TableView.this.getSlices().get(selectedRow), sliceGuiState -> sliceGuiState.setChannelVisibility(iChannel, newState));
                    }
                }
                if (col > 1 && col % 2 == 1) {
                    int iChannel = (col - 3) / 2;
                    int[] selectedRows = TableView.this.table.getSelectedRows();
                    if (selectedRows.length > 0) {
                        int firstSelectedRow = TableView.this.table.getSelectedRows()[0];
                        Displaysettings ds_in = (Displaysettings)TableView.this.table.getValueAt(firstSelectedRow, col);
                        Consumer<Displaysettings> update = displaySettings -> {
                            for (int selectedRow : selectedRows) {
                                view2.guiState.runSlice(TableView.this.getSlices().get(selectedRow), sliceGuiState -> sliceGuiState.setDisplaySettings(iChannel, (Displaysettings)displaySettings));
                            }
                            TableView.this.model.fireTableChanged(new TableModelEvent(TableView.this.model, 0, TableView.this.getSlices().size(), col, 0));
                        };
                        DisplaySettingsCommand.IniValue = ds_in;
                        ((CommandService)TableView.this.mp.getContext().getService(CommandService.class)).run(DisplaySettingsCommand.class, true, new Object[]{"postrun", update});
                    } else {
                        TableView.this.mp.infoMessageForUser.accept("Table issue", "Please select a slice with a valid channel in the tab.");
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                JTable table = (JTable)e.getSource();
                Point point = e.getPoint();
                int row = table.rowAtPoint(point);
                int col = table.columnAtPoint(point);
                if (e.getClickCount() == 2 && col == 0 && row < TableView.this.getSlices().size()) {
                    SliceSources slice = TableView.this.getSlices().get(row);
                    view.navigateSlice(slice);
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            for (SliceSources slice : this.getSlices()) {
                int i = slice.getIndex();
                if (lsm.isSelectedIndex(i)) {
                    if (slice.isSelected()) continue;
                    slice.select();
                    continue;
                }
                if (!slice.isSelected()) continue;
                slice.deSelect();
            }
        }
    }

    public JComponent getPanel() {
        return this.paneDisplay;
    }

    public void cleanup() {
        this.listCopy.clear();
    }

    public void updateTable() {
        this.model.fireTableStructureChanged();
    }

    public void sliceDisplaySettingsChanged(SliceSources slice) {
        int idx = slice.getIndex();
        ((AbstractTableModel)this.table.getModel()).fireTableRowsUpdated(idx, idx);
    }

    synchronized List<SliceSources> getSlices() {
        return this.listCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sliceDeleted(SliceSources slice) {
        Object object = this.slicesModifyLock;
        synchronized (object) {
            int newMaxChannels;
            this.listCopy = this.mp.getSlices();
            int index = slice.getIndex();
            this.model.fireTableRowsDeleted(index, index);
            List<SliceSources> slices = this.getSlices();
            if (slice.nChannels == this.maxChannels && (newMaxChannels = slices.size() == 0 ? 0 : slices.stream().mapToInt(s -> s.nChannels).max().getAsInt()) < this.maxChannels) {
                this.maxChannels = newMaxChannels;
                this.model.fireTableStructureChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sliceCreated(SliceSources slice) {
        Object object = this.slicesModifyLock;
        synchronized (object) {
            this.listCopy = this.mp.getSlices();
            int index = slice.getIndex();
            this.model.fireTableRowsInserted(index, index);
            if (slice.nChannels > this.maxChannels) {
                this.maxChannels = slice.nChannels;
                this.model.fireTableStructureChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sliceZPositionChanged(SliceSources slice) {
        Object object = this.slicesModifyLock;
        synchronized (object) {
            this.listCopy = this.mp.getSlices();
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public void sliceSelected(SliceSources slice) {
        int idx = slice.getIndex();
        if (idx != -1 && !this.table.getSelectionModel().isSelectedIndex(idx)) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
            this.table.repaint();
        }
    }

    @Override
    public void sliceDeselected(SliceSources slice) {
        int idx = slice.getIndex();
        if (idx != -1 && this.table.getSelectionModel().isSelectedIndex(idx)) {
            this.table.getSelectionModel().removeSelectionInterval(idx, idx);
            this.table.repaint();
        }
    }

    @Override
    public void sliceSourcesChanged(SliceSources slice) {
    }

    @Override
    public void slicePretransformChanged(SliceSources slice) {
    }

    @Override
    public void sliceKeyOn(SliceSources slice) {
        int idx = slice.getIndex();
        if (idx != -1) {
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(idx, 0);
        }
    }

    @Override
    public void sliceKeyOff(SliceSources slice) {
        int idx = slice.getIndex();
        if (idx != -1) {
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(idx, 0);
        }
    }

    @Override
    public void roiChanged() {
    }

    @Override
    public void actionEnqueue(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionStarted(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionFinished(SliceSources slice, CancelableAction action, boolean result) {
    }

    @Override
    public void actionCancelEnqueue(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionCancelStarted(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionCancelFinished(SliceSources slice, CancelableAction action, boolean result) {
    }

    @Override
    public void converterChanged(SliceSources slice) {
        int idx = slice.getIndex();
        if (idx != -1) {
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(idx, 0);
        }
    }

    public static class VisibilityRenderer
    extends JLabel
    implements TableCellRenderer {
        static ImageIcon visibleIcon;
        static ImageIcon invisibleIcon;
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered;

        public VisibilityRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object v, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean visible = (Boolean)v;
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (visible.booleanValue()) {
                this.setIcon(visibleIcon);
            } else {
                this.setIcon(invisibleIcon);
            }
            return this;
        }

        static {
            URL iconURL = TableView.class.getResource("/graphics/Visible.png");
            visibleIcon = new ImageIcon(iconURL);
            Image image = visibleIcon.getImage();
            Image newimg = image.getScaledInstance(15, 15, 4);
            visibleIcon = new ImageIcon(newimg);
            iconURL = TableView.class.getResource("/graphics/InvisibleL.png");
            invisibleIcon = new ImageIcon(iconURL);
            image = invisibleIcon.getImage();
            newimg = image.getScaledInstance(15, 15, 4);
            invisibleIcon = new ImageIcon(newimg);
        }
    }

    public static class DisplaySettingsRenderer
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered;
        final JLabel label = new JLabel();

        public DisplaySettingsRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object displaysettings, boolean isSelected, boolean hasFocus, int row, int column) {
            Displaysettings ds = (Displaysettings)displaysettings;
            if (!ds.getName().equals("-")) {
                Color newColor = new Color(ds.color[0], ds.color[1], ds.color[2]);
                this.label.setBackground(newColor);
                this.label.setForeground(new Color((ds.color[0] + 128) % 256, (ds.color[1] + 128) % 256, (ds.color[2] + 128) % 256));
                this.label.setText((int)ds.min + ":" + (int)ds.max);
                if (this.isBordered) {
                    if (isSelected) {
                        if (this.selectedBorder == null) {
                            this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                        }
                        this.label.setBorder(this.selectedBorder);
                    } else {
                        if (this.unselectedBorder == null) {
                            this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                        }
                        this.label.setBorder(this.unselectedBorder);
                    }
                }
                this.label.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
            }
            return this.label;
        }
    }

    class SliceDisplayTableModel
    extends AbstractTableModel {
        SliceDisplayTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "#";
            }
            if (columnIndex == 1) {
                return "Vis.";
            }
            if (columnIndex % 2 == 0) {
                int iChannel = (columnIndex - 2) / 2;
                return "Ch_" + iChannel;
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return TableView.this.getSlices().size();
        }

        @Override
        public int getColumnCount() {
            return TableView.this.maxChannels * 2 + 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex > TableView.this.getSlices().size() - 1) {
                if (columnIndex == 0) {
                    return "null";
                }
                if (columnIndex == 1) {
                    return false;
                }
                if (columnIndex % 2 == 0) {
                    return Boolean.FALSE;
                }
                return new Displaysettings(-1, "-");
            }
            SliceSources slice = TableView.this.getSlices().get(rowIndex);
            if (columnIndex == 0) {
                if (rowIndex == TableView.this.currentIndex) {
                    if (slice.isKeySlice()) {
                        return "[" + rowIndex + "] " + slice.getName() + " (Key)";
                    }
                    return " " + rowIndex + "  " + slice.getName();
                }
                if (slice.isKeySlice()) {
                    return "[" + rowIndex + "] " + slice.getName() + " (Key)";
                }
                return " " + rowIndex + "  " + slice.getName();
            }
            if (columnIndex == 1) {
                return TableView.this.view.getSliceVisibility(slice);
            }
            if (columnIndex % 2 == 0) {
                int iChannel = (columnIndex - 2) / 2;
                return TableView.this.view.getChannelVisibility(slice, iChannel);
            }
            int iChannel = (columnIndex - 3) / 2;
            if (slice.nChannels > iChannel) {
                return TableView.this.view.getDisplaySettings(slice, iChannel);
            }
            return new Displaysettings(-1, "-");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SliceSources slice = TableView.this.getSlices().get(rowIndex);
            if (columnIndex != 0) {
                if (columnIndex == 1) {
                    TableView.this.view.guiState.runSlice(slice, sliceGuiState -> sliceGuiState.setSliceVisibility(!sliceGuiState.getSliceVisibility()));
                } else if (columnIndex % 2 == 0) {
                    int iChannel = (columnIndex - 2) / 2;
                    TableView.this.view.guiState.runSlice(slice, sliceGuiState -> sliceGuiState.setChannelVisibility(iChannel, !sliceGuiState.getChannelVisibility(iChannel)));
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return Boolean.class;
            }
            if (columnIndex % 2 == 0) {
                return Boolean.class;
            }
            return Displaysettings.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }
    }
}

