/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import bdv.util.BdvHandle;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.DefaultMipmapOrdering;
import bdv.viewer.render.MipmapOrdering;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import ch.epfl.biop.atlas.aligner.gui.bdv.SliceDragBehaviour;
import ch.epfl.biop.bdv.gui.graphicalhandle.CircleGraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleToolTip;
import ch.epfl.biop.bdv.gui.graphicalhandle.SquareGraphicalHandle;
import ch.epfl.biop.registration.sourceandconverter.affine.AffineTransformedSourceWrapperRegistration;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.NumericType;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import spimdata.util.Displaysettings;

public class SliceGuiState {
    final SliceSources slice;
    final int nChannels;
    private SourceAndConverter<?>[] sources_displayed;
    private final SourceAndConverter<?>[] ini_sources;
    final AffineTransformedSourceWrapperRegistration slicePositioner;
    final BdvHandle bdvh;
    final BdvMultislicePositionerView view;
    final GraphicalHandleToolTip tt;
    final List<GraphicalHandle> ghs = new ArrayList<GraphicalHandle>();
    final SquareGraphicalHandle keyHandle;
    final boolean[] channelVisible;
    final Displaysettings[] displaysettings;
    boolean sliceVisible = false;
    double yShift = 0.0;
    double xShift = 0.0;
    final List<FilterDisplay> displayFilters = new ArrayList<FilterDisplay>();
    int stepBack = 0;

    public SliceGuiState(BdvMultislicePositionerView view, SliceSources slice, BdvHandle bdvh) {
        this.view = view;
        this.bdvh = bdvh;
        this.slice = slice;
        SourceAndConverter[] iniSources = this.getRegisteredSourcesAtStep(this.stepBack);
        this.nChannels = iniSources.length;
        this.channelVisible = new boolean[this.nChannels];
        this.displaysettings = new Displaysettings[this.nChannels];
        this.ini_sources = iniSources;
        this.addDisplayFilters(iChannel -> this.channelVisible[iChannel]);
        this.addDisplayFilters(iChannel -> this.sliceVisible);
        this.slicePositioner = new AffineTransformedSourceWrapperRegistration();
        this.sources_displayed = this.slicePositioner.getTransformedImageMovingToFixed(iniSources);
        SourceAndConverterHelper.transferColorConverters((SourceAndConverter[])iniSources, this.sources_displayed);
        for (int i = 0; i < this.nChannels; ++i) {
            Displaysettings ds = new Displaysettings(-1);
            Displaysettings.GetDisplaySettingsFromCurrentConverter(this.sources_displayed[i], (Displaysettings)ds);
            this.displaysettings[i] = ds;
        }
        CircleGraphicalHandle gh = new CircleGraphicalHandle((GraphicalHandleListener)view, new Behaviours(new InputTriggerConfig(), new String[0]), view.bdvh.getTriggerbindings(), this + "_gh", this::getSliceHandleCoords, this::getBdvHandleRadius, this::getBdvHandleColor);
        this.tt = new GraphicalHandleToolTip((GraphicalHandle)gh, slice::toString, -20, -10);
        this.ghs.add((GraphicalHandle)gh);
        Behaviours behavioursHandleSlice = new Behaviours(new InputTriggerConfig(), new String[0]);
        behavioursHandleSlice.behaviour(new SliceDragBehaviour(view, slice), "dragSelectedSources" + this, "button1");
        behavioursHandleSlice.behaviour((x, y) -> {
            slice.deSelect();
            view.getBdvh().getViewerPanel().requestRepaint();
        }, "deselectedSources" + this, "button3", "ctrl button1");
        this.keyHandle = new SquareGraphicalHandle((GraphicalHandleListener)view, behavioursHandleSlice, view.getBdvh().getTriggerbindings(), this + "_keyHandle", () -> {
            AffineTransform3D bdvAt3D = new AffineTransform3D();
            view.getBdvh().getViewerPanel().state().getViewerTransform(bdvAt3D);
            RealPoint handlePoint = view.getDisplayedCenter(slice);
            double yShift = this.getBdvHandleRadius().intValue();
            handlePoint.setPosition(view.msp.sY / 2.0, 1);
            bdvAt3D.apply((RealLocalizable)handlePoint, (RealPositionable)handlePoint);
            return new Integer[]{(int)handlePoint.getDoublePosition(0), (int)(handlePoint.getDoublePosition(1) + (slice.isSelected() ? -0.6 : 0.6) * yShift), (int)handlePoint.getDoublePosition(2)};
        }, () -> {
            if (slice.isKeySlice()) {
                return this.getBdvHandleRadius();
            }
            return this.getBdvHandleRadius() / 2;
        }, () -> {
            if (slice.isKeySlice() && slice.isSelected()) {
                return new Integer[]{255, 0, 255, 200};
            }
            return this.getBdvHandleColor();
        });
        this.ghs.add((GraphicalHandle)this.keyHandle);
    }

    public void setSliceVisibility(boolean visible) {
        if (visible != this.sliceVisible) {
            this.sliceVisible = visible;
            this.sliceDisplayChanged();
        }
    }

    public boolean getSliceVisibility() {
        return this.sliceVisible;
    }

    public void setChannelVisibility(int channel, boolean visible) {
        assert (channel >= 0);
        if (channel < this.nChannels && this.channelVisible[channel] != visible) {
            this.channelVisible[channel] = visible;
            this.sliceDisplayChanged();
        }
    }

    public boolean getChannelVisibility(int channel) {
        assert (channel >= 0);
        if (channel < this.nChannels) {
            return this.channelVisible[channel];
        }
        return false;
    }

    public void setDisplaySettings(int channel, Displaysettings ds) {
        if (channel < this.nChannels) {
            this.displaysettings[channel] = ds;
            this.sliceDisplayChanged();
        }
    }

    public Displaysettings getDisplaySettings(int channel) {
        if (channel < this.nChannels) {
            return this.displaysettings[channel];
        }
        return new Displaysettings(-1);
    }

    private boolean currentlyVisible(int idxChannel) {
        for (FilterDisplay fd : this.displayFilters) {
            if (fd.displayChannel(idxChannel)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void show() {
        Class<SliceGuiState> clazz = SliceGuiState.class;
        synchronized (SliceGuiState.class) {
            try {
                EventQueue.invokeLater(() -> {
                    SourceAndConverter[] sources;
                    List<SourceAndConverter> sourcesToDisplay = IntStream.range(0, this.nChannels).filter(this::currentlyVisible).mapToObj(idx -> {
                        Displaysettings.applyDisplaysettings(this.sources_displayed[idx], (Displaysettings)this.displaysettings[idx]);
                        return this.sources_displayed[idx];
                    }).collect(Collectors.toList());
                    for (SourceAndConverter source : sources = sourcesToDisplay.toArray(new SourceAndConverter[sourcesToDisplay.size()])) {
                        SourceAndConverterServices.getSourceAndConverterService().register(source, new String[]{"no tree"});
                    }
                    if (sources.length > 0) {
                        SourceAndConverterServices.getBdvDisplayService().show(this.bdvh, sources);
                    }
                    this.bdvh.getViewerPanel().state().addSources(sourcesToDisplay);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private void hide() {
        this.bdvh.getViewerPanel().state().removeSources(Arrays.asList(this.sources_displayed));
    }

    public void created() {
        this.show();
    }

    public void deleted() {
        this.hide();
        this.ghs.forEach(GraphicalHandle::disable);
    }

    public void setRegistrationStepBack(int stepBack) {
        if (stepBack < 0) {
            stepBack = 0;
        }
        if (this.stepBack != stepBack) {
            this.stepBack = stepBack;
            this.sourcesChanged();
        }
    }

    public int getRegistrationStepBack() {
        return this.stepBack;
    }

    private SourceAndConverter[] getRegisteredSourcesAtStep(int stepBack) {
        return this.slice.getRegisteredSources(stepBack);
    }

    public void sourcesChanged() {
        this.hide();
        this.bdvh.getViewerPanel().repaint();
        SourceAndConverter[] displayedSources = SliceGuiState.alphaCulledSources(this.getRegisteredSourcesAtStep(this.stepBack), this.slice.getAlpha());
        for (int idx = 0; idx < this.nChannels; ++idx) {
            Displaysettings.applyDisplaysettings(this.ini_sources[idx], (Displaysettings)this.displaysettings[idx]);
            Displaysettings.applyDisplaysettings((SourceAndConverter)displayedSources[idx], (Displaysettings)this.displaysettings[idx]);
        }
        this.sources_displayed = this.slicePositioner.getTransformedImageMovingToFixed(displayedSources);
        this.show();
        this.bdvh.getViewerPanel().repaint();
    }

    public void slicePositionChanged() {
        if (this.view.mode == 0) {
            AffineTransform3D slicingModePositionAffineTransform = new AffineTransform3D();
            RealPoint center = this.view.getDisplayedCenter(this.slice);
            slicingModePositionAffineTransform.translate(new double[]{center.getDoublePosition(0), center.getDoublePosition(1), -this.slice.getSlicingAxisPosition()});
            this.slicePositioner.setAffineTransform(slicingModePositionAffineTransform);
        } else {
            assert (this.view.mode == 1);
            this.slicePositioner.setAffineTransform(new AffineTransform3D());
        }
    }

    public void isCurrent() {
        this.sliceDisplayChanged();
    }

    public void isNotCurrent() {
        this.sliceDisplayChanged();
    }

    public Integer[] getSliceHandleCoords() {
        AffineTransform3D bdvAt3D = new AffineTransform3D();
        this.view.bdvh.getViewerPanel().state().getViewerTransform(bdvAt3D);
        if (this.view.mode == 0) {
            RealPoint sliceCenter = this.view.getDisplayedCenter(this.slice);
            bdvAt3D.apply((RealLocalizable)sliceCenter, (RealPositionable)sliceCenter);
            return new Integer[]{(int)sliceCenter.getDoublePosition(0), (int)sliceCenter.getDoublePosition(1), (int)sliceCenter.getDoublePosition(2)};
        }
        if (this.view.mode == 1) {
            RealPoint zero = new RealPoint(3);
            zero.setPosition(0, 0);
            bdvAt3D.apply((RealLocalizable)zero, (RealPositionable)zero);
            return new Integer[]{35 * (this.slice.getIndex() - this.view.getCurrentSliceIndex()) + (int)zero.getDoublePosition(0), 80, 0};
        }
        return new Integer[]{0, 0, 0};
    }

    public Integer[] getBdvHandleColor() {
        if (this.slice.isSelected()) {
            if (this.slice.isKeySlice()) {
                return new Integer[]{0, 255, 0, 255};
            }
            return new Integer[]{0, 255, 0, 180};
        }
        if (this.slice.isKeySlice()) {
            return new Integer[]{255, 255, 0, 128};
        }
        return new Integer[]{255, 255, 0, 64};
    }

    public Integer getBdvHandleRadius() {
        if (this.slice.isKeySlice()) {
            return 16;
        }
        return 12;
    }

    public void drawGraphicalHandles(Graphics2D g) {
        this.ghs.forEach(gh -> gh.draw(g));
        if (this.view.getCurrentSlice().equals(this.slice)) {
            this.tt.draw(g);
        }
    }

    public void setYShift(double yShift) {
        this.yShift = yShift;
        this.slicePositionChanged();
    }

    public double getYShift() {
        return this.yShift;
    }

    public void setXShift(double xShift) {
        this.xShift = xShift;
        this.slicePositionChanged();
    }

    public double getXShift() {
        return this.xShift;
    }

    public void disableGraphicalHandles() {
        this.keyHandle.disable();
    }

    public void enableGraphicalHandles() {
        this.keyHandle.enable();
    }

    public void setDisplayedAxisPosition(double displayedAxisPosition) {
        this.setXShift(displayedAxisPosition - this.slice.getSlicingAxisPosition());
    }

    public void addDisplayFilters(FilterDisplay filterDisplay) {
        this.displayFilters.add(filterDisplay);
    }

    public void sliceDisplayChanged() {
        this.hide();
        for (int idx = 0; idx < this.nChannels; ++idx) {
            Displaysettings.applyDisplaysettings(this.ini_sources[idx], (Displaysettings)this.displaysettings[idx]);
            Displaysettings.applyDisplaysettings((SourceAndConverter)this.getRegisteredSourcesAtStep(this.stepBack)[idx], (Displaysettings)this.displaysettings[idx]);
        }
        this.show();
    }

    public void removeDisplayFilters(FilterDisplay fd) {
        this.displayFilters.remove(fd);
    }

    public void setState(State state) {
        this.hide();
        if (state.channelVisible.length == this.nChannels) {
            for (int i = 0; i < this.nChannels; ++i) {
                this.channelVisible[i] = state.channelVisible[i];
                this.displaysettings[i] = state.displaysettings[i];
            }
            this.sliceVisible = state.sliceVisible;
            this.slice.setDisplaySettings(this.displaysettings);
        }
    }

    public void updateDisplaySettings() {
        for (int i = 0; i < this.nChannels; ++i) {
            Displaysettings ds = new Displaysettings(-1);
            Displaysettings.GetDisplaySettingsFromCurrentConverter(this.slice.getRegisteredSources()[i], (Displaysettings)ds);
            this.displaysettings[i] = ds;
        }
        this.sliceDisplayChanged();
    }

    private static SourceAndConverter[] alphaCulledSources(SourceAndConverter[] sources, IAlphaSource alpha) {
        SourceAndConverter[] alphaCulled = new SourceAndConverter[sources.length];
        for (int i = 0; i < alphaCulled.length; ++i) {
            SourceAndConverter sac;
            SourceAndConverter ori = sources[i];
            alphaCulled[i] = ori.asVolatile() != null ? (sac = new SourceAndConverter(new AlphaCulledSource(ori.getSpimSource(), alpha), ori.getConverter(), new SourceAndConverter(new AlphaCulledSource(ori.asVolatile().getSpimSource(), alpha), ori.asVolatile().getConverter()))) : (sac = new SourceAndConverter(new AlphaCulledSource(ori.getSpimSource(), alpha), ori.getConverter()));
        }
        return alphaCulled;
    }

    public static class AlphaCulledSource<T extends NumericType<T>>
    implements Source<T>,
    MipmapOrdering {
        final Source<T> origin;
        final IAlphaSource alpha;
        private final MipmapOrdering sourceMipmapOrdering;

        public AlphaCulledSource(Source<T> origin, IAlphaSource alpha) {
            this.origin = origin;
            this.alpha = alpha;
            this.sourceMipmapOrdering = MipmapOrdering.class.isInstance(origin) ? (MipmapOrdering)origin : new DefaultMipmapOrdering(origin);
        }

        public boolean isPresent(int t) {
            return this.origin.isPresent(t);
        }

        public RandomAccessibleInterval<T> getSource(int t, int level) {
            return this.alpha.getSource(t, level);
        }

        public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation interpolation) {
            AffineTransform3D tOri = new AffineTransform3D();
            AffineTransform3D tAlpha = new AffineTransform3D();
            this.origin.getSourceTransform(t, level, tOri);
            this.alpha.getSourceTransform(t, level, tAlpha);
            tOri.preConcatenate(tAlpha.inverse());
            return RealViews.affine((RealRandomAccessible)this.origin.getInterpolatedSource(t, level, interpolation), (AffineGet)tOri);
        }

        public void getSourceTransform(int t, int level, AffineTransform3D affineTransform3D) {
            this.alpha.getSourceTransform(t, level, affineTransform3D);
        }

        public T getType() {
            return (T)((NumericType)this.origin.getType());
        }

        public String getName() {
            return this.origin.getName();
        }

        public VoxelDimensions getVoxelDimensions() {
            return this.origin.getVoxelDimensions();
        }

        public int getNumMipmapLevels() {
            return this.origin.getNumMipmapLevels();
        }

        public boolean doBoundingBoxCulling() {
            return true;
        }

        public MipmapOrdering.MipmapHints getMipmapHints(AffineTransform3D screenTransform, int timepoint, int previousTimepoint) {
            return this.sourceMipmapOrdering.getMipmapHints(screenTransform, timepoint, previousTimepoint);
        }
    }

    public static class State {
        final boolean[] channelVisible;
        final Displaysettings[] displaysettings;
        boolean sliceVisible;

        public State(SliceGuiState state) {
            this.channelVisible = state.channelVisible;
            this.sliceVisible = state.sliceVisible;
            this.displaysettings = state.displaysettings;
        }
    }

    public static interface FilterDisplay {
        public boolean displayChannel(int var1);
    }
}

