/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import org.scijava.ui.behaviour.DragBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceDragBehaviour
implements DragBehaviour {
    private static final Logger logger = LoggerFactory.getLogger(SliceDragBehaviour.class);
    List<SliceSources> affectedSlices = new ArrayList<SliceSources>();
    final SliceSources sliceDragged;
    final Map<SliceSources, Double> initialAxisPositions = new HashMap<SliceSources, Double>();
    double rangeBefore;
    double rangeAfter;
    double lastAxisPos;
    RealPoint iniPointBdv = new RealPoint(3);
    double iniSlicePointing;
    double iniSlicingAxisPosition;
    boolean perform;
    final BdvMultislicePositionerView view;
    boolean keyLeft = false;
    boolean keyRight = false;
    SliceSources keySliceRight;
    SliceSources keySliceLeft;
    int indexOfSliceInDraggedOnes = -1;

    public SliceDragBehaviour(BdvMultislicePositionerView view, SliceSources slice) {
        this.view = view;
        this.sliceDragged = slice;
    }

    @Override
    public void init(int x, int y) {
        logger.debug(" DragSlice start (" + x + ":" + y + ")  ? " + this.sliceDragged + " perform = " + this.perform);
        this.perform = this.view.startDragAction();
        if (this.perform && this.view.mode != 0) {
            this.perform = false;
            this.view.stopDragAction();
            logger.debug(" DragSlice start (" + x + ":" + y + ")  Cancelled " + this.sliceDragged + " perform = " + this.perform);
        }
        if (this.perform) {
            logger.debug(" DragSlice start (" + x + ":" + y + ")  ! " + this.sliceDragged + " perform = " + this.perform);
            this.affectedSlices = this.view.msp.getSelectedSlices();
            int indexKeySliceRight = -1;
            int indexKeySliceLeft = -1;
            if (!this.affectedSlices.contains(this.sliceDragged)) {
                logger.warn("This should not happen : slice dragged is not selected!");
                this.perform = false;
                this.view.stopDragAction();
            } else {
                int i;
                this.affectedSlices.forEach(s -> this.initialAxisPositions.put((SliceSources)s, s.getSlicingAxisPosition()));
                int indexCurrentSliceSelected = this.affectedSlices.indexOf(this.sliceDragged);
                ArrayList<SliceSources> slicesSelected = new ArrayList<SliceSources>();
                for (i = indexCurrentSliceSelected - 1; i >= 0; --i) {
                    if (!this.affectedSlices.get(i).isKeySlice() || this.keyLeft) continue;
                    this.keyLeft = true;
                    this.keySliceLeft = this.affectedSlices.get(i);
                    indexKeySliceLeft = i;
                    logger.debug("Key Slice Left found : " + i + " keysliceleft = " + this.keySliceLeft + " at p = " + this.initialAxisPositions.get(this.keySliceLeft));
                }
                for (i = indexCurrentSliceSelected + 1; i < this.affectedSlices.size(); ++i) {
                    if (!this.affectedSlices.get(i).isKeySlice() || this.keyRight) continue;
                    this.keyRight = true;
                    this.keySliceRight = this.affectedSlices.get(i);
                    indexKeySliceRight = i;
                    logger.debug("Key Slice Right found : " + i + " keysliceright = " + this.keySliceRight + " at p = " + this.initialAxisPositions.get(this.keySliceRight));
                }
                for (i = 0; i < this.affectedSlices.size(); ++i) {
                    if (i == indexCurrentSliceSelected) {
                        slicesSelected.add(this.affectedSlices.get(i));
                    }
                    if (this.keyLeft && i < indexKeySliceLeft || this.keyRight && i > indexKeySliceRight) continue;
                    slicesSelected.add(this.affectedSlices.get(i));
                }
                this.affectedSlices = slicesSelected;
                this.indexOfSliceInDraggedOnes = this.affectedSlices.indexOf(this.sliceDragged);
                if (this.indexOfSliceInDraggedOnes == -1) {
                    logger.debug("This should not happen : index of slice in dragged one not present");
                    this.perform = false;
                    this.view.stopDragAction();
                } else {
                    this.rangeBefore = this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes)) - this.initialAxisPositions.get(this.affectedSlices.get(0));
                    this.rangeAfter = this.initialAxisPositions.get(this.affectedSlices.get(this.affectedSlices.size() - 1)) - this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                    this.lastAxisPos = this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                }
            }
        }
        logger.debug(" DragSlice start (" + x + ":" + y + ") " + this.sliceDragged + " Drag perform : (" + this.perform + ")");
    }

    @Override
    public void drag(int x, int y) {
        if (this.perform) {
            double shift;
            double ratio;
            double iniSlicePos;
            SliceSources sliceMoved;
            int i;
            RealPoint currentMousePosition = new RealPoint(3);
            this.view.getBdvh().getViewerPanel().getGlobalMouseCoordinates((RealPositionable)currentMousePosition);
            double currentSlicingAxisPosition = (currentMousePosition.getDoublePosition(0) - 0.5 * this.view.msp.sX) / this.view.msp.sX * this.view.msp.sizePixZ * (double)this.view.msp.getReslicedAtlas().getStep();
            double keyLeftPosition = -1.0;
            if (this.keyLeft) {
                keyLeftPosition = this.initialAxisPositions.get(this.keySliceLeft);
            }
            double keyRightPosition = -1.0;
            if (this.keyRight) {
                keyRightPosition = this.initialAxisPositions.get(this.keySliceRight);
            }
            for (i = 0; i <= this.indexOfSliceInDraggedOnes; ++i) {
                sliceMoved = this.affectedSlices.get(i);
                iniSlicePos = this.initialAxisPositions.get(sliceMoved);
                if (this.keyLeft) {
                    if (this.rangeBefore == 0.0) {
                        assert (i != 0);
                        ratio = 1.0 / (double)i;
                        this.setDisplayAxisPosition(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                        continue;
                    }
                    ratio = (currentSlicingAxisPosition - keyLeftPosition) / this.rangeBefore;
                    this.setDisplayAxisPosition(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                    continue;
                }
                if (this.keyRight) {
                    if (this.rangeAfter == 0.0) {
                        assert (i != this.affectedSlices.size() - 1);
                        ratio = 1.0 / (double)(this.affectedSlices.size() - 1 - i);
                        this.setDisplayAxisPosition(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                        continue;
                    }
                    ratio = (keyRightPosition - currentSlicingAxisPosition) / this.rangeAfter;
                    this.setDisplayAxisPosition(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                    continue;
                }
                shift = currentSlicingAxisPosition - this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                this.setDisplayAxisPosition(sliceMoved, iniSlicePos + shift);
            }
            for (i = this.indexOfSliceInDraggedOnes + 1; i < this.affectedSlices.size(); ++i) {
                sliceMoved = this.affectedSlices.get(i);
                iniSlicePos = this.initialAxisPositions.get(sliceMoved);
                if (this.keyRight) {
                    if (this.rangeAfter == 0.0) {
                        assert (i != this.affectedSlices.size() - 1);
                        ratio = 1.0 / (double)(this.affectedSlices.size() - 1 - i);
                        this.setDisplayAxisPosition(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                        continue;
                    }
                    ratio = (keyRightPosition - currentSlicingAxisPosition) / this.rangeAfter;
                    this.setDisplayAxisPosition(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                    continue;
                }
                if (this.keyLeft) {
                    if (this.rangeBefore == 0.0) {
                        assert (i != 0);
                        ratio = 1.0 / (double)i;
                        this.setDisplayAxisPosition(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                        continue;
                    }
                    ratio = (currentSlicingAxisPosition - keyLeftPosition) / this.rangeBefore;
                    this.setDisplayAxisPosition(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                    continue;
                }
                shift = currentSlicingAxisPosition - this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                this.setDisplayAxisPosition(sliceMoved, iniSlicePos + shift);
            }
            this.view.getBdvh().getViewerPanel().requestRepaint();
        }
    }

    void setDisplayAxisPosition(SliceSources slice, double displayedAxisPosition) {
        this.view.guiState.runSlice(slice, sliceGuiState -> sliceGuiState.setDisplayedAxisPosition(displayedAxisPosition));
    }

    @Override
    public void end(int x, int y) {
        if (this.perform) {
            double shift;
            double ratio;
            double iniSlicePos;
            SliceSources sliceMoved;
            int i;
            logger.debug(" DragSlice end (" + x + ":" + y + ") " + this.sliceDragged);
            for (SliceSources slice : this.affectedSlices) {
                this.setDisplayAxisPosition(slice, this.initialAxisPositions.get(slice));
            }
            if (this.affectedSlices.size() > 1) {
                new MarkActionSequenceBatchAction(this.view.msp).runRequest();
            }
            RealPoint currentMousePosition = new RealPoint(3);
            this.view.getBdvh().getViewerPanel().getGlobalMouseCoordinates((RealPositionable)currentMousePosition);
            double currentSlicingAxisPosition = (currentMousePosition.getDoublePosition(0) - 0.5 * this.view.msp.sX) / this.view.msp.sX * this.view.msp.sizePixZ * (double)this.view.msp.getReslicedAtlas().getStep();
            double keyLeftPosition = -1.0;
            if (this.keyLeft) {
                keyLeftPosition = this.initialAxisPositions.get(this.keySliceLeft);
            }
            double keyRightPosition = -1.0;
            if (this.keyRight) {
                keyRightPosition = this.initialAxisPositions.get(this.keySliceRight);
            }
            for (i = 0; i <= this.indexOfSliceInDraggedOnes; ++i) {
                sliceMoved = this.affectedSlices.get(i);
                iniSlicePos = this.initialAxisPositions.get(sliceMoved);
                if (this.keyLeft) {
                    if (this.rangeBefore == 0.0) {
                        assert (i != 0);
                        ratio = 1.0 / (double)i;
                        this.view.msp.moveSlice(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                        continue;
                    }
                    ratio = (currentSlicingAxisPosition - keyLeftPosition) / this.rangeBefore;
                    this.view.msp.moveSlice(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                    continue;
                }
                if (this.keyRight) {
                    if (this.rangeAfter == 0.0) {
                        assert (i != this.affectedSlices.size() - 1);
                        ratio = 1.0 / (double)(this.affectedSlices.size() - 1 - i);
                        this.view.msp.moveSlice(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                        continue;
                    }
                    ratio = (keyRightPosition - currentSlicingAxisPosition) / this.rangeAfter;
                    this.view.msp.moveSlice(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                    continue;
                }
                shift = currentSlicingAxisPosition - this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                this.view.msp.moveSlice(sliceMoved, iniSlicePos + shift);
            }
            for (i = this.indexOfSliceInDraggedOnes + 1; i < this.affectedSlices.size(); ++i) {
                sliceMoved = this.affectedSlices.get(i);
                iniSlicePos = this.initialAxisPositions.get(sliceMoved);
                if (this.keyRight) {
                    if (this.rangeAfter == 0.0) {
                        assert (i != this.affectedSlices.size() - 1);
                        ratio = 1.0 / (double)(this.affectedSlices.size() - 1 - i);
                        this.view.msp.moveSlice(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                        continue;
                    }
                    ratio = (keyRightPosition - currentSlicingAxisPosition) / this.rangeAfter;
                    this.view.msp.moveSlice(sliceMoved, keyRightPosition + (this.initialAxisPositions.get(sliceMoved) - keyRightPosition) * ratio);
                    continue;
                }
                if (this.keyLeft) {
                    if (this.rangeBefore == 0.0) {
                        assert (i != 0);
                        ratio = 1.0 / (double)i;
                        this.view.msp.moveSlice(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                        continue;
                    }
                    ratio = (currentSlicingAxisPosition - keyLeftPosition) / this.rangeBefore;
                    this.view.msp.moveSlice(sliceMoved, keyLeftPosition + (this.initialAxisPositions.get(sliceMoved) - keyLeftPosition) * ratio);
                    continue;
                }
                shift = currentSlicingAxisPosition - this.initialAxisPositions.get(this.affectedSlices.get(this.indexOfSliceInDraggedOnes));
                this.view.msp.moveSlice(sliceMoved, iniSlicePos + shift);
            }
            if (this.affectedSlices.size() > 1) {
                new MarkActionSequenceBatchAction(this.view.msp).runRequest();
            }
            if (this.view.overlapMode == 2) {
                this.view.updateSliceDisplayedPosition(null);
                this.view.getBdvh().getViewerPanel().requestRepaint();
            }
            this.perform = false;
            this.view.stopDragAction();
        }
        this.affectedSlices.clear();
        this.initialAxisPositions.clear();
        this.rangeBefore = -1.0;
        this.rangeAfter = -1.0;
        this.lastAxisPos = -1.0;
        this.iniPointBdv = new RealPoint(3);
        this.iniSlicePointing = -1.0;
        this.iniSlicingAxisPosition = -1.0;
        this.keyLeft = false;
        this.keyRight = false;
        this.keySliceRight = null;
        this.keySliceLeft = null;
        this.indexOfSliceInDraggedOnes = -1;
    }
}

