/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import bdv.viewer.ViewerPanel;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.util.Behaviours;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionLayer {
    private static final Logger logger = LoggerFactory.getLogger(SelectionLayer.class);
    final BdvMultislicePositionerView view;
    boolean isCurrentlySelecting = false;
    int xCurrentSelectStart;
    int yCurrentSelectStart;
    int xCurrentSelectEnd;
    int yCurrentSelectEnd;
    final ViewerPanel viewer;
    final Stroke normalStroke = new BasicStroke();
    final Color backColor = new Color(16236312);

    public SelectionLayer(BdvMultislicePositionerView mp) {
        this.view = mp;
        this.viewer = mp.bdvh.getViewerPanel();
    }

    protected void addSelectionBehaviours(Behaviours behaviours) {
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("SET"), "select-set-sources", "button1");
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("ADD"), "select-add-sources", "shift button1");
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("REMOVE"), "select-remove-sources", "ctrl button1");
    }

    synchronized void startCurrentSelection(int x, int y) {
        this.xCurrentSelectStart = x;
        this.yCurrentSelectStart = y;
    }

    synchronized void updateCurrentSelection(int xCurrent, int yCurrent) {
        this.xCurrentSelectEnd = xCurrent;
        this.yCurrentSelectEnd = yCurrent;
        this.isCurrentlySelecting = true;
    }

    synchronized void endCurrentSelection(int x, int y, String mode) {
        this.xCurrentSelectEnd = x;
        this.yCurrentSelectEnd = y;
        this.isCurrentlySelecting = false;
        this.processSelectionModificationEvent(this.getLastSelectedSources(), mode);
    }

    public void processSelectionModificationEvent(Set<SliceSources> currentSources, String mode) {
        List<SliceSources> slices = this.view.msp.getSlices();
        switch (mode) {
            case "SET": {
                for (SliceSources slice : slices) {
                    slice.deSelect();
                    if (!currentSources.contains(slice) || slice.isSelected()) continue;
                    slice.select();
                }
                break;
            }
            case "ADD": {
                for (SliceSources slice : slices) {
                    if (!currentSources.contains(slice) || slice.isSelected()) continue;
                    slice.select();
                }
                break;
            }
            case "REMOVE": {
                for (SliceSources slice : slices) {
                    if (!currentSources.contains(slice) || !slice.isSelected()) continue;
                    slice.deSelect();
                }
                break;
            }
            default: {
                System.err.println("Unhandled " + mode + " selected source modification event");
            }
        }
    }

    public void draw(Graphics2D g) {
        if (this.isCurrentlySelecting) {
            g.setStroke(this.normalStroke);
            g.setPaint(this.backColor);
            g.draw(this.getCurrentSelectionRectangle());
        }
    }

    Rectangle getCurrentSelectionRectangle() {
        int h;
        int y0;
        int w;
        int x0;
        if (this.xCurrentSelectStart > this.xCurrentSelectEnd) {
            x0 = this.xCurrentSelectEnd;
            w = this.xCurrentSelectStart - this.xCurrentSelectEnd;
        } else {
            x0 = this.xCurrentSelectStart;
            w = this.xCurrentSelectEnd - this.xCurrentSelectStart;
        }
        if (this.yCurrentSelectStart > this.yCurrentSelectEnd) {
            y0 = this.yCurrentSelectEnd;
            h = this.yCurrentSelectStart - this.yCurrentSelectEnd;
        } else {
            y0 = this.yCurrentSelectStart;
            h = this.yCurrentSelectEnd - this.yCurrentSelectStart;
        }
        if (w == 0) {
            w = 1;
        }
        if (h == 0) {
            h = 1;
        }
        return new Rectangle(x0, y0, w, h);
    }

    Set<SliceSources> getLastSelectedSources() {
        HashSet<SliceSources> lastSelected = new HashSet<SliceSources>();
        Rectangle r = this.getCurrentSelectionRectangle();
        for (SliceSources slice : this.view.msp.getSlices()) {
            Integer[] coords = this.view.getSliceHandleCoords(slice);
            Point p = new Point(coords[0], coords[1]);
            if (!r.contains(p)) continue;
            lastSelected.add(slice);
        }
        return lastSelected;
    }

    class RectangleSelectSourcesBehaviour
    implements DragBehaviour {
        final String mode;
        boolean perform;

        public RectangleSelectSourcesBehaviour(String mode) {
            this.mode = mode;
        }

        @Override
        public void init(int x, int y) {
            logger.debug("Selection drag start ? Perform = " + this.perform);
            this.perform = SelectionLayer.this.view.startDragAction();
            if (this.perform) {
                logger.debug("Selection drag start !");
                SelectionLayer.this.startCurrentSelection(x, y);
                SelectionLayer.this.viewer.setCursor(new Cursor(1));
                switch (this.mode) {
                    case "SET": {
                        SelectionLayer.this.viewer.showMessage("Set Selection");
                        break;
                    }
                    case "ADD": {
                        SelectionLayer.this.viewer.showMessage("Add Selection");
                        break;
                    }
                    case "REMOVE": {
                        SelectionLayer.this.viewer.showMessage("Remove Selection");
                    }
                }
            } else {
                logger.debug("Selection drag failed !");
            }
        }

        @Override
        public void drag(int x, int y) {
            if (this.perform) {
                SelectionLayer.this.updateCurrentSelection(x, y);
                SelectionLayer.this.viewer.getDisplay().repaint();
            }
        }

        @Override
        public void end(int x, int y) {
            if (this.perform) {
                SelectionLayer.this.endCurrentSelection(x, y, this.mode);
                SelectionLayer.this.viewer.setCursor(new Cursor(0));
                SelectionLayer.this.viewer.getDisplay().repaint();
                SelectionLayer.this.view.stopDragAction();
                this.perform = false;
                logger.debug("Selection drag stopped.");
            }
        }
    }
}

