/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvStackSource;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerFrame;
import bdv.viewer.ViewerPanel;
import bdv.viewer.animate.MessageOverlayAnimator;
import bdv.viewer.animate.OverlayAnimator;
import ch.epfl.biop.ResourcesMonitor;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.CreateSliceAction;
import ch.epfl.biop.atlas.aligner.DeepSliceHelper;
import ch.epfl.biop.atlas.aligner.DeleteSliceAction;
import ch.epfl.biop.atlas.aligner.MoveSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.ReslicedAtlas;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.adapter.AlignerState;
import ch.epfl.biop.atlas.aligner.command.ABBACheckForUpdateCommand;
import ch.epfl.biop.atlas.aligner.command.ABBACiteInfoCommand;
import ch.epfl.biop.atlas.aligner.command.ABBADocumentationCommand;
import ch.epfl.biop.atlas.aligner.command.ABBAForumHelpCommand;
import ch.epfl.biop.atlas.aligner.command.ABBAStateLoadCommand;
import ch.epfl.biop.atlas.aligner.command.ABBAStateSaveCommand;
import ch.epfl.biop.atlas.aligner.command.ABBAUserFeedbackCommand;
import ch.epfl.biop.atlas.aligner.command.AtlasSlicingAdjusterCommand;
import ch.epfl.biop.atlas.aligner.command.DeepSliceDocumentationCommand;
import ch.epfl.biop.atlas.aligner.command.ExportAtlasToImageJCommand;
import ch.epfl.biop.atlas.aligner.command.ExportDeformationFieldToImageJCommand;
import ch.epfl.biop.atlas.aligner.command.ExportRegionsToRoiManagerCommand;
import ch.epfl.biop.atlas.aligner.command.ExportRegionsToRoisetFileCommand;
import ch.epfl.biop.atlas.aligner.command.ExportRegistrationToQuPathCommand;
import ch.epfl.biop.atlas.aligner.command.ExportResampledSlicesToBDVSourceCommand;
import ch.epfl.biop.atlas.aligner.command.ExportSlicesOriginalDataToImageJCommand;
import ch.epfl.biop.atlas.aligner.command.ExportSlicesToBDVCommand;
import ch.epfl.biop.atlas.aligner.command.ExportSlicesToBDVJsonDatasetCommand;
import ch.epfl.biop.atlas.aligner.command.ExportSlicesToImageJCommand;
import ch.epfl.biop.atlas.aligner.command.ExportSlicesToQuickNIIDatasetCommand;
import ch.epfl.biop.atlas.aligner.command.ImportSliceFromImagePlusCommand;
import ch.epfl.biop.atlas.aligner.command.ImportSliceFromSourcesCommand;
import ch.epfl.biop.atlas.aligner.command.ImportSlicesFromFilesCommand;
import ch.epfl.biop.atlas.aligner.command.ImportSlicesFromQuPathCommand;
import ch.epfl.biop.atlas.aligner.command.MirrorDoCommand;
import ch.epfl.biop.atlas.aligner.command.MirrorUndoCommand;
import ch.epfl.biop.atlas.aligner.command.RasterSlicesCommand;
import ch.epfl.biop.atlas.aligner.command.RasterSlicesDeformationCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesBigWarpCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesCopyAndApplyCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesDeepSliceLocalCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesDeepSliceWebCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesEditLastCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesElastixAffineCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesElastixSplineCommand;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesRemoveLastCommand;
import ch.epfl.biop.atlas.aligner.command.RotateSlicesCommand;
import ch.epfl.biop.atlas.aligner.command.SetSlicesDeselectedCommand;
import ch.epfl.biop.atlas.aligner.command.SetSlicesDisplayRangeCommand;
import ch.epfl.biop.atlas.aligner.command.SetSlicesSelectedCommand;
import ch.epfl.biop.atlas.aligner.command.SetSlicesThicknessCommand;
import ch.epfl.biop.atlas.aligner.command.SetSlicesThicknessMatchNeighborsCommand;
import ch.epfl.biop.atlas.aligner.command.SliceAffineTransformCommand;
import ch.epfl.biop.atlas.aligner.gui.MultiSliceContextMenuClickBehaviour;
import ch.epfl.biop.atlas.aligner.gui.bdv.SelectionLayer;
import ch.epfl.biop.atlas.aligner.gui.bdv.SliceGuiState;
import ch.epfl.biop.atlas.aligner.gui.bdv.TableView;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.AtlasAdjustDisplayCommand;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.AtlasInfoPanel;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.EditPanel;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.NavigationPanel;
import ch.epfl.biop.atlas.aligner.gui.bdv.card.SliceDefineROICommand;
import ch.epfl.biop.atlas.aligner.plugin.ABBACommand;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandle;
import ch.epfl.biop.bdv.gui.graphicalhandle.GraphicalHandleListener;
import ch.epfl.biop.wrappers.deepslice.ij2commands.DeepSlicePrefsSet;
import ch.epfl.biop.wrappers.ij2command.BiopWrappersSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ij.IJ;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import mpicbg.spim.data.sequence.Tile;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.MenuPath;
import org.scijava.cache.CacheService;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.module.Module;
import org.scijava.object.ObjectService;
import org.scijava.plugin.PluginService;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.swing.widget.SwingInputHarvester;
import org.scijava.ui.swing.widget.SwingInputPanel;
import org.scijava.widget.InputPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.scijava.BdvScijavaHelper;
import sc.fiji.bdvpg.scijava.ScijavaSwingUI;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.BdvTransferHandler;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import spimdata.util.Displaysettings;

public class BdvMultislicePositionerView
implements MultiSlicePositioner.SliceChangeListener,
GraphicalHandleListener,
MouseMotionListener,
MultiSlicePositioner.MultiSlicePositionerListener {
    public static final String NAME_CARD_ATLAS_INFORMATION = "Atlas Information";
    public static final String NAME_CARD_ATLAS_DISPLAY = "Atlas Display";
    public static final String NAME_CARD_DISPLAY_NAVIGATION = "Display & Navigation";
    public static final String NAME_CARD_EDIT_SLICES = "Edit Selected Slices";
    public static final String NAME_CARD_ATLAS_SLICING = "Atlas Slicing";
    public static final String NAME_CARD_DEFINE_ROI = "Define region of interest for registration";
    public static final String NAME_CARD_CURRENT_SLICE_INFO = "Current slice info";
    public static final String NAME_CARD_SLICES_DISPLAY = "Slices Display";
    public MultiSlicePositioner msp;
    final BdvHandle bdvh;
    TableView tableView;
    protected static final Logger logger = LoggerFactory.getLogger(MultiSlicePositioner.class);
    protected int mode;
    public static final int POSITIONING_MODE_INT = 0;
    static final String POSITIONING_MODE = "positioning-mode";
    static final String POSITIONING_BEHAVIOURS_KEY = "positioning-mode-behaviours";
    private Behaviours positioning_behaviours = new Behaviours(new InputTriggerConfig(), "positioning-mode");
    public static final int REVIEW_MODE_INT = 1;
    static final String REVIEW_MODE = "review-mode";
    static final String REVIEW_BEHAVIOURS_KEY = "review-mode-behaviours";
    private Behaviours review_behaviours = new Behaviours(new InputTriggerConfig(), "review-mode");
    static final String COMMON_BEHAVIOURS_KEY = "multipositioner-behaviours";
    private Behaviours common_behaviours = new Behaviours(new InputTriggerConfig(), "multipositioner");
    private SelectionLayer selectionLayer;
    private final Runnable atlasSlicingListener;
    protected final SynchronizedSliceGuiState guiState = new SynchronizedSliceGuiState();
    private MultiSliceContextMenuClickBehaviour mscClick;
    private boolean showSliceInfo;
    private boolean showAtlasPosition = true;
    private final double sX;
    private final double sY;
    private double roiPX;
    private double roiPY;
    private double roiSX;
    private double roiSY;
    private TransferHandler transferHandler;
    private ViewerPanel vp;
    private int previouszStep;
    final List<Runnable> extraCleanUp = new ArrayList<Runnable>();
    private int iCurrentSlice = 0;
    private long lastErrorMessageTimestampMs = -1L;
    private long delayBetweenMessagesMs = 5000L;
    final MessageOverlayAnimator moa;
    final Integer[] rightPosition = new Integer[]{0, 0, 0};
    final Integer[] leftPosition = new Integer[]{0, 0, 0};
    private int sliceDisplayMode = 0;
    public static final int NO_SLICE_DISPLAY_MODE = 2;
    public static final int ALL_SLICES_DISPLAY_MODE = 0;
    public static final int CURRENT_SLICE_DISPLAY_MODE = 1;
    private int iSliceNoStep;
    protected int overlapMode = 1;
    private static final int OVERLAP_ON_ATLAS = 0;
    private static final int OVERLAP_BELOW_ATLAS = 1;
    private static final int OVERLAP_BELOW_ATLAS_STAIRS = 2;
    Set<GraphicalHandle> ghs = new HashSet<GraphicalHandle>();
    final Set<GraphicalHandle> gh_below_mouse = new HashSet<GraphicalHandle>();
    int registrationStepBack = 0;
    private boolean closeAlreadyActivated = false;
    private boolean cleanAllOnExit = false;
    private boolean updateBdv = true;
    Thread modificationMonitorThread;
    boolean stopMonitoring = false;
    ResourcesMonitor rm = null;
    private final BehaviourMap blockMap = new BehaviourMap();
    private static final String[] DRAG_TOGGLE_EDITOR_KEYS = new String[]{"button1"};
    private static final String BLOCKING_MAP = "multipositioner-blocking";
    private final AtomicBoolean dragActionInProgress = new AtomicBoolean(false);
    public static List<String> excludedKeys = new ArrayList<String>();
    double overlapFactorX = 1.0;
    double overlapFactorY = 1.0;
    final List<ModeListener> modeListeners = new ArrayList<ModeListener>();
    final List<CurrentSliceListener> currentSliceListeners = new ArrayList<CurrentSliceListener>();

    private void blockingErrorMessageForUsers(String title, String message) {
        if (System.currentTimeMillis() - this.lastErrorMessageTimestampMs > this.delayBetweenMessagesMs) {
            JOptionPane.showMessageDialog(new JFrame(), message, title, 0);
        } else {
            this.infoMessageForUser(title, message);
        }
        this.lastErrorMessageTimestampMs = System.currentTimeMillis();
    }

    private void warningMessageForUser(String title, String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, title, 2);
    }

    private void infoMessageForUser(String title, String message) {
        message = message.replaceAll("\n", " | ");
        if (title.isEmpty()) {
            this.moa.add(message);
        } else {
            this.moa.add(title + " | " + message);
        }
        this.bdvh.getViewerPanel().getDisplay().repaint();
    }

    private void installCommonBehaviours() {
        this.common_behaviours.behaviour((x, y) -> this.msp.cancelLastAction(), "cancel_last_action", "ctrl Z", "meta Z");
        this.common_behaviours.behaviour((x, y) -> this.msp.redoAction(), "redo_last_action", "ctrl Y", "ctrl shift Z", "meta Y", "ctrl meta Z");
        this.common_behaviours.behaviour((x, y) -> this.navigateNextSlice(), "navigate_next_slice", "RIGHT");
        this.common_behaviours.behaviour((x, y) -> this.navigatePreviousSlice(), "navigate_previous_slice", "LEFT");
        this.common_behaviours.behaviour((x, y) -> this.navigateCurrentSlice(), "navigate_current_slice", "C");
        this.common_behaviours.behaviour((x, y) -> this.nextMode(), "change_mode", "R");
        this.common_behaviours.behaviour((x, y) -> {
            this.msp.getSlices().forEach(SliceSources::select);
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }, "selectAllSlices", "ctrl A", "meta A");
        this.common_behaviours.behaviour((x, y) -> {
            this.msp.getSlices().forEach(SliceSources::deSelect);
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }, "deselectAllSlices", "ctrl shift A", "meta shift A");
        this.common_behaviours.behaviour((x, y) -> this.printBindings(), "print_bindings", "K");
        this.common_behaviours.behaviour((x, y) -> this.viewPreviousRegistration(), "viewPreviousRegistration", "P");
        this.common_behaviours.behaviour((x, y) -> this.viewNextRegistration(), "viewNextRegistration", "N");
        this.bdvh.getTriggerbindings().addBehaviourMap(COMMON_BEHAVIOURS_KEY, this.common_behaviours.getBehaviourMap());
        this.bdvh.getTriggerbindings().addInputTriggerMap(COMMON_BEHAVIOURS_KEY, this.common_behaviours.getInputTriggerMap(), new String[0]);
    }

    public void viewPreviousRegistration() {
        int maxNRegistrations = this.msp.getSlices().stream().mapToInt(SliceSources::getNumberOfRegistrations).max().getAsInt();
        if (this.registrationStepBack < maxNRegistrations) {
            ++this.registrationStepBack;
            this.guiState.forEachSlice(guiState -> guiState.setRegistrationStepBack(this.registrationStepBack));
        }
    }

    public void viewNextRegistration() {
        if (this.registrationStepBack > 0) {
            --this.registrationStepBack;
            this.guiState.forEachSlice(guiState -> guiState.setRegistrationStepBack(this.registrationStepBack));
        }
    }

    private void installPositioningBehaviours() {
        this.positioning_behaviours.behaviour((x, y) -> this.toggleOverlap(), "toggle_superimpose", "O");
        this.positioning_behaviours.behaviour((x, y) -> this.msp.equalSpacingSelectedSlices(), "equalSpacingSelectedSlices", "D");
    }

    private void installReviewBehaviours() {
    }

    private void clearBdvDefaults() {
        BdvHandleHelper.removeCard((BdvHandle)this.bdvh, (Object)"default bdv groups card");
        BdvHandleHelper.removeCard((BdvHandle)this.bdvh, (Object)"default bdv viewer modes card");
        if (SwingUtilities.isEventDispatchThread()) {
            this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", false);
            BdvScijavaHelper.clearBdvHandleMenuBar((BdvHandle)this.bdvh);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.bdvh.getCardPanel().setCardExpanded((Object)"default bdv sources card", false);
                    BdvScijavaHelper.clearBdvHandleMenuBar((BdvHandle)this.bdvh);
                });
            }
            catch (Exception e) {
                this.blockingErrorMessageForUsers("Error when clearing Bdv Defaults", e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void installBdvMenu(int hierarchyLevelsSkipped) {
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"File>Save State (+View)", (int)0, () -> new Thread(this::saveState).start());
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"File>Load State (+View)", (int)0, () -> new Thread(this::loadState).start());
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Undo [Ctrl+Z]", (int)0, this.msp::cancelLastAction);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Redo [Ctrl+Shift+Z]", (int)0, this.msp::redoAction);
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Edit");
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Configuration>Mouse Options>Show Atlas Position", (int)0, this::showAtlasPosition);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Configuration>Mouse Options>Hide Atlas Position", (int)0, this::hideAtlasPosition);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Configuration>Mouse Options>Show Slice Info", (int)0, this::showSliceInfo);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Edit>Configuration>Mouse Options>Hide Slice Info", (int)0, this::hideSliceInfo);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>Configuration>Set Elastix & Transformix path", BiopWrappersSet.class, (Object[])new Object[0]);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Import>Import QuPath Project", ImportSlicesFromQuPathCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Import>Import Current ImageJ Window", ImportSliceFromImagePlusCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Import>Import With Bio-Formats", ImportSlicesFromFilesCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Import>Import Sources", ImportSliceFromSourcesCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Display Mode>Positioning Mode", (int)0, () -> this.setDisplayMode(0));
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Display Mode>Review Mode", (int)0, () -> this.setDisplayMode(1));
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Display Mode>Positioning - Change Overlap Mode [O]", (int)0, this::toggleOverlap);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Cards>Expand Card Panel", (int)0, () -> this.bdvh.getSplitPanel().setCollapsed(false));
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Cards>Collapse Card Panel", (int)0, () -> this.bdvh.getSplitPanel().setCollapsed(true));
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Cards>Add Resources Monitor", (int)0, this::addResourcesMonitor);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Navigate>Next Slice [Right]", (int)0, this::navigateNextSlice);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Navigate>Previous Slice [Left]", (int)0, this::navigatePreviousSlice);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"View>Navigate>Center On Current Slice [C]", (int)0, this::navigateCurrentSlice);
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Slices>Select All Slices [Ctrl+A]", (int)0, () -> this.msp.getSlices().forEach(SliceSources::select));
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Slices>Deselect All Slices [Ctrl+Shift+A]", (int)0, () -> this.msp.getSlices().forEach(SliceSources::deSelect));
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Slices>Select Slices", SetSlicesSelectedCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Slices>Deselect Slices", SetSlicesDeselectedCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Slices");
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Slices>Remove Slices", (int)0, () -> this.msp.getSlices().stream().filter(SliceSources::isSelected).forEach(slice -> new DeleteSliceAction(this.msp, (SliceSources)slice).runRequest()));
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Slices");
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Slices>Set Slices Display Range", SetSlicesDisplayRangeCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Slices");
        BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)"Slices>Distribute Slices [D]", (int)0, () -> {
            if (this.mode == 0) {
                this.msp.equalSpacingSelectedSlices();
            }
        });
        DeepSliceHelper.addMouseCompatibleAtlas("Adult Mouse Brain - Allen Brain Atlas V3");
        DeepSliceHelper.addMouseCompatibleAtlas("Adult Mouse Brain - Allen Brain Atlas V3p1");
        DeepSliceHelper.addMouseCompatibleAtlas("allen_mouse_10um_java");
        DeepSliceHelper.addRatCompatibleAtlas("Rat - Waxholm Sprague Dawley V4");
        DeepSliceHelper.addRatCompatibleAtlas("Rat - Waxholm Sprague Dawley V4p2");
        DeepSliceHelper.addRatCompatibleAtlas("whs_sd_rat_39um_java");
        if (DeepSliceHelper.isDeepSliceMouseCompatible(this.msp.getReslicedAtlas().ba.getName())) {
            logger.debug("Installing DeepSlice Command for Mouse");
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>Configuration>Set DeepSlice Env path", DeepSlicePrefsSet.class, (Object[])new Object[0]);
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>DeepSlice>DeepSlice Registration (Web)", RegisterSlicesDeepSliceWebCommand.class, (Object[])new Object[]{"mp", this.msp, "model", "mouse"});
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>DeepSlice>DeepSlice Registration (Local)", RegisterSlicesDeepSliceLocalCommand.class, (Object[])new Object[]{"mp", this.msp, "model", "mouse"});
        }
        if (DeepSliceHelper.isDeepSliceRatCompatible(this.msp.getReslicedAtlas().ba.getName())) {
            logger.debug("Installing DeepSlice Command for Rat");
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>Configuration>DeepSlice setup...", DeepSlicePrefsSet.class, (Object[])new Object[]{0});
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>DeepSlice>DeepSlice Registration (Web)", RegisterSlicesDeepSliceWebCommand.class, (Object[])new Object[]{"mp", this.msp, "model", "rat"});
            BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>DeepSlice>DeepSlice Registration (Local)", RegisterSlicesDeepSliceLocalCommand.class, (Object[])new Object[]{"mp", this.msp, "model", "rat"});
        }
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Affine>Rotate", RotateSlicesCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Affine>Interactive Transform", SliceAffineTransformCommand.class, (Object[])new Object[]{"mp", this.msp});
        logger.debug("Installing java registration plugins ui");
        this.installRegistrationPluginUI(hierarchyLevelsSkipped);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)>Raster and cache deformation field", RasterSlicesDeformationCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)>Raster slice", RasterSlicesCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)>Copy and Apply Registration", RegisterSlicesCopyAndApplyCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export>Set Slices Thickness", SetSlicesThicknessCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export>Set Slices Thickness (fill gaps)", SetSlicesThicknessMatchNeighborsCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Export");
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Regions To Roi Manager", ExportRegionsToRoiManagerCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Regions To File", ExportRegionsToRoisetFileCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> QuPath > Export Registrations To QuPath Project", ExportRegistrationToQuPathCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)> Export > Bdv > Export Registered Slices to BDV Json Dataset", ExportSlicesToBDVJsonDatasetCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)> Export > Bdv > Export Resampled Slices as BDV Source", ExportResampledSlicesToBDVSourceCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> BigDataViewer > Export Registered Slices to BDV", ExportSlicesToBDVCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Registered Slices to ImageJ", ExportSlicesToImageJCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Original Slices to ImageJ", ExportSlicesOriginalDataToImageJCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Atlas Coordinates of Original Slices to ImageJ", ExportDeformationFieldToImageJCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Export> ImageJ > Export Atlas to ImageJ", ExportAtlasToImageJCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Edit>(Experimental)>Export Registered Slices to Quick NII Dataset", ExportSlicesToQuickNIIDatasetCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Register");
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Edit Last Registration", RegisterSlicesEditLastCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Remove Last Registration", RegisterSlicesRemoveLastCommand.class, (Object[])new Object[]{"mp", this.msp});
        BiConsumer<String, String> guiErrorLogger = this::blockingErrorMessageForUsers;
        this.msp.subscribeToErrorMessages(guiErrorLogger);
        this.addToCleanUpHook(() -> this.msp.unSubscribeFromErrorMessages(guiErrorLogger));
        BiConsumer<String, String> warnLogger = this::warningMessageForUser;
        this.msp.subscribeToWarningMessages(warnLogger);
        this.addToCleanUpHook(() -> this.msp.unSubscribeFromWarningMessages(warnLogger));
        BiConsumer<String, String> infoLogger = this::infoMessageForUser;
        this.msp.subscribeToInfoMessages(infoLogger);
        this.addToCleanUpHook(() -> this.msp.unSubscribeFromInfoMessages(infoLogger));
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>Check for updates", ABBACheckForUpdateCommand.class, (Object[])new Object[0]);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>Ask for help in the forum (web)", ABBAForumHelpCommand.class, (Object[])new Object[0]);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>Go to documentation (web)", ABBADocumentationCommand.class, (Object[])new Object[0]);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>Give your feedback (web)", ABBAUserFeedbackCommand.class, (Object[])new Object[0]);
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>About DeepSlice (web)", DeepSliceDocumentationCommand.class, (Object[])new Object[0]);
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Help");
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Help>How to cite ABBA", ABBACiteInfoCommand.class, (Object[])new Object[0]);
    }

    private void installRegistrationPluginUI(int hierarchyLevelsSkipped) {
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Affine>Elastix Registration (Affine)", RegisterSlicesElastixAffineCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Spline>BigWarp Registration", RegisterSlicesBigWarpCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Register>Spline>Elastix Registration (Spline)", RegisterSlicesElastixSplineCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Slices");
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Slices>Mirror Slices", MirrorDoCommand.class, (Object[])new Object[]{"mp", this.msp});
        BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (String)"Slices>Un-Mirror Slices", MirrorUndoCommand.class, (Object[])new Object[]{"mp", this.msp});
        if (!this.msp.getExternalRegistrationPluginsUI().isEmpty()) {
            BdvScijavaHelper.addSeparator((BdvHandle)this.bdvh, (String)"Register");
        }
        logger.debug("Installing external registration plugins ui");
        this.msp.getExternalRegistrationPluginsUI().keySet().forEach(externalRegistrationType -> this.msp.getExternalRegistrationPluginsUI().get(externalRegistrationType).forEach(ui -> {
            logger.info("External registration plugin " + ui + " added in bdv user interface");
            BdvScijavaHelper.addActionToBdvHandleMenu((BdvHandle)this.bdvh, (String)("Register>" + ui), (int)0, () -> ((CommandService)this.msp.getContext().getService(CommandService.class)).run(ui, true, new Object[]{"mp", this.msp}));
        }));
    }

    private void installBigDataViewerCards() {
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_ATLAS_INFORMATION, (JComponent)new AtlasInfoPanel(this.msp).getPanel(), (boolean)true);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_ATLAS_DISPLAY, (JComponent)ScijavaSwingUI.getPanel((Context)this.msp.getContext(), AtlasAdjustDisplayCommand.class, (Object[])new Object[]{"view", this}), (boolean)true);
        logger.debug("Adding table view");
        this.addTableView();
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_DISPLAY_NAVIGATION, (JComponent)new NavigationPanel(this).getPanel(), (boolean)true);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_EDIT_SLICES, (JComponent)new EditPanel(this.msp).getPanel(), (boolean)true);
        try {
            Module module = ScijavaSwingUI.createModule((Context)this.msp.getContext(), AtlasSlicingAdjusterCommand.class, (Object[])new Object[]{"reslicedAtlas", this.msp.getReslicedAtlas()});
            SwingInputHarvester swingInputHarvester = new SwingInputHarvester();
            this.msp.getContext().inject((Object)swingInputHarvester);
            SwingInputPanel inputPanel = new SwingInputPanel();
            swingInputHarvester.buildPanel((InputPanel)inputPanel, module);
            BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_ATLAS_SLICING, (JComponent)((JComponent)inputPanel.getComponent()), (boolean)true);
            this.msp.getReslicedAtlas().addListener(() -> BdvMultislicePositionerView.lambda$installBigDataViewerCards$33((InputPanel)inputPanel));
        }
        catch (Exception e) {
            this.msp.errorMessageForUser.accept("GUI Initialisation error", e.getMessage());
        }
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_DEFINE_ROI, (JComponent)ScijavaSwingUI.getPanel((Context)this.msp.getContext(), SliceDefineROICommand.class, (Object[])new Object[]{"mp", this.msp, "view", this}), (boolean)false);
        this.addToCleanUpHook(() -> SwingUtilities.invokeLater(() -> {
            if (this.bdvh.getCardPanel() != null) {
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_ATLAS_INFORMATION);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_ATLAS_DISPLAY);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_DISPLAY_NAVIGATION);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_EDIT_SLICES);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_ATLAS_SLICING);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_DEFINE_ROI);
                this.bdvh.getCardPanel().removeCard((Object)NAME_CARD_CURRENT_SLICE_INFO);
            }
        }));
    }

    private void displayAtlas() {
        ArrayList<SourceAndConverter> sacsToAppend = new ArrayList<SourceAndConverter>();
        for (int i = 0; i < this.msp.getAtlas().getMap().getStructuralImages().size(); ++i) {
            sacsToAppend.add(this.msp.getReslicedAtlas().extendedSlicedSources[i]);
            sacsToAppend.add(this.msp.getReslicedAtlas().nonExtendedSlicedSources[i]);
        }
        SourceAndConverterServices.getBdvDisplayService().show(this.bdvh, sacsToAppend.toArray(new SourceAndConverter[0]));
    }

    public void addToCleanUpHook(Runnable runnable) {
        this.extraCleanUp.add(runnable);
    }

    private void addRoiOverlaySource() {
        logger.debug("Adding user ROI source");
        BiConsumer<RealLocalizable, UnsignedShortType> fun = (loc, val) -> {
            double px = loc.getFloatPosition(0);
            double py = loc.getFloatPosition(1);
            if (py < -this.sY / 1.9) {
                val.set(0);
                return;
            }
            if (py > this.sY / 1.9) {
                val.set(0);
                return;
            }
            if (this.mode == 0) {
                double v = Math.IEEEremainder(px + this.sX * 0.5, this.sX);
                if (v < this.roiPX) {
                    val.set(255);
                    return;
                }
                if (v > this.roiPX + this.roiSX) {
                    val.set(255);
                    return;
                }
                if (py < this.roiPY) {
                    val.set(255);
                    return;
                }
                if (py > this.roiPY + this.roiSY) {
                    val.set(255);
                    return;
                }
                val.set(0);
            }
            if (this.mode == 1) {
                if ((double)loc.getFloatPosition(0) < this.roiPX) {
                    val.set(255);
                    return;
                }
                if ((double)loc.getFloatPosition(0) > this.roiPX + this.roiSX) {
                    val.set(255);
                    return;
                }
                if ((double)loc.getFloatPosition(1) < this.roiPY) {
                    val.set(255);
                    return;
                }
                if ((double)loc.getFloatPosition(1) > this.roiPY + this.roiSY) {
                    val.set(255);
                    return;
                }
                val.set(0);
            }
        };
        FunctionRealRandomAccessible roiOverlay = new FunctionRealRandomAccessible(3, fun, UnsignedShortType::new);
        BdvStackSource bss = BdvFunctions.show((RealRandomAccessible)roiOverlay, (Interval)new FinalInterval(new long[]{0L, 0L, 0L}, new long[]{10L, 10L, 10L}), (String)"ROI", (BdvOptions)BdvOptions.options().addTo((Bdv)this.bdvh));
        bss.setDisplayRangeBounds(0.0, 1600.0);
    }

    private void addCleanUpHook() {
        BdvHandleHelper.setBdvHandleCloseOperation((BdvHandle)this.bdvh, (CacheService)((CacheService)this.msp.getContext().getService(CacheService.class)), (SourceAndConverterBdvDisplayService)SourceAndConverterServices.getBdvDisplayService(), (boolean)false, () -> {
            logger.info("Closing multipositioner bdv window, releasing some resources.");
            logger.debug("Removing listeners");
            if (this.guiState != null) {
                this.guiState.clear();
                this.guiState.clear();
            }
            if (this.vp != null) {
                this.vp.setTransferHandler(new javax.swing.TransferHandler("Dummy"));
                this.transferHandler = null;
                this.vp.getDisplay().removeHandler((Object)this);
                this.vp = null;
            }
            if (this.rm != null) {
                this.rm.stop();
                this.rm = null;
            }
            if (this.mscClick != null) {
                this.mscClick.clear();
                this.mscClick = null;
            }
            this.extraCleanUp.forEach(Runnable::run);
            if (this.msp != null) {
                this.common_behaviours = null;
                this.positioning_behaviours = null;
                this.review_behaviours = null;
                this.selectionLayer = null;
                if (this.msp.getReslicedAtlas() != null) {
                    this.msp.getReslicedAtlas().removeListener(this.atlasSlicingListener);
                }
                this.msp.removeSliceListener(this);
                this.msp = null;
            }
        });
    }

    private void addRightClickActions() {
        this.mscClick = new MultiSliceContextMenuClickBehaviour(this.msp, this, this.msp::getSelectedSlices);
        this.common_behaviours.behaviour(this.mscClick, "Slices Context Menu", "button3", "ctrl button1", "meta button1");
    }

    private void addFrameIcon() {
        ViewerFrame frame = ((BdvHandleFrame)this.bdvh).getBigDataViewer().getViewerFrame();
        frame.setExtendedState(6);
        frame.setIconImage(new ImageIcon(MultiSlicePositioner.class.getResource("/graphics/ABBAFrame.jpg")).getImage());
    }

    private void addTableView() {
        this.tableView = new TableView(this);
        this.msp.addSliceListener(this.tableView);
        BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)NAME_CARD_SLICES_DISPLAY, (JComponent)this.tableView.getPanel(), (boolean)true);
        this.addToCleanUpHook(() -> {
            this.tableView.cleanup();
            if (this.msp != null) {
                this.msp.removeSliceListener(this.tableView);
            }
        });
    }

    private void addDnDHandler() {
        this.transferHandler = new TransferHandler();
        this.bdvh.getViewerPanel().setTransferHandler((javax.swing.TransferHandler)((Object)this.transferHandler));
        this.iSliceNoStep = (int)this.msp.getReslicedAtlas().getStep();
    }

    private void addModificationMonitor() {
        BdvHandleHelper.setWindowTitle((BdvHandle)this.bdvh, (String)this.getViewName());
        this.modificationMonitorThread = new Thread(this::modificationMonitor);
        this.modificationMonitorThread.start();
        this.addToCleanUpHook(() -> {
            this.stopMonitoring = true;
        });
    }

    private void addCleanAllHook() {
        this.addToCleanUpHook(() -> {
            if (this.cleanAllOnExit && this.msp != null) {
                Context ctx = this.msp.getContext();
                this.msp.close();
                ((ObjectService)ctx.getService(ObjectService.class)).removeObject((Object)this.msp);
                SourceAndConverterServices.getSourceAndConverterService().remove(SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverters().toArray(new SourceAndConverter[0]));
            }
        });
    }

    private void addConfirmationCloseHook() {
        WindowListener[] listeners;
        final JFrame frame = BdvHandleHelper.getJFrame((BdvHandle)this.bdvh);
        for (WindowListener listener : listeners = frame.getWindowListeners()) {
            frame.removeWindowListener(listener);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!BdvMultislicePositionerView.this.closeAlreadyActivated) {
                    int confirmed;
                    String message = "Are you sure you want to exit ABBA?";
                    if (BdvMultislicePositionerView.this.msp.isModifiedSinceLastSave()) {
                        message = message + " Your last modifications have not been saved.";
                    }
                    if ((confirmed = JOptionPane.showConfirmDialog(frame, message, "Close ABBA", 0)) == 0) {
                        int clearMemory = JOptionPane.showConfirmDialog(frame, "Close session and clear memory ?", "Close ABBA session completely", 0);
                        if (clearMemory == 0) {
                            BdvMultislicePositionerView.this.cleanAllOnExit = true;
                        }
                        BdvMultislicePositionerView.this.closeAlreadyActivated = true;
                        for (WindowListener listener : listeners) {
                            listener.windowClosing(e);
                        }
                    } else {
                        frame.setDefaultCloseOperation(0);
                    }
                }
            }
        });
    }

    private void addExtraABBACommands() {
        ((PluginService)this.msp.getContext().getService(PluginService.class)).getPluginsOfType(ABBACommand.class).forEach(ci -> {
            logger.debug("- ABBA command " + ci.getMenuPath().getLeaf().toString() + " [" + ci.getMenuPath() + "]");
            MenuPath menuPath = ci.getMenuPath();
            try {
                BdvScijavaHelper.addCommandToBdvHandleMenu((BdvHandle)this.bdvh, (Context)this.msp.getContext(), (Class)ci.loadClass(), (int)(menuPath.size() - 2), (Object[])new Object[]{"mp", this.msp});
            }
            catch (Exception e) {
                this.msp.errorMessageForUser.accept("Error while installing " + ci.getMenuPath().getLeaf(), e.getMessage());
            }
        });
    }

    public BdvMultislicePositionerView(MultiSlicePositioner msp, BdvHandle bdvh) {
        this.bdvh = bdvh;
        this.vp = bdvh.getViewerPanel();
        this.msp = msp;
        this.sX = msp.sX;
        this.sY = msp.sY;
        this.roiChanged();
        this.moa = new MessageOverlayAnimator(8000L, 0.0, 0.1);
        SwingUtilities.invokeLater(() -> bdvh.getViewerPanel().addOverlayAnimator((OverlayAnimator)this.moa));
        excludedKeys.add("X");
        excludedKeys.add("Y");
        excludedKeys.add("Z");
        excludedKeys.add("Left Right");
        this.previouszStep = (int)msp.getReslicedAtlas().getStep();
        this.addFrameIcon();
        logger.debug("Installing behaviours : common");
        this.installCommonBehaviours();
        logger.debug("Installing behaviours : positioning");
        this.installPositioningBehaviours();
        logger.debug("Installing behaviours : review");
        this.installReviewBehaviours();
        this.mode = 1;
        this.setDisplayMode(0);
        this.overlapMode = 2;
        this.updateOverlapMode();
        logger.debug("Overriding standard navigation commands");
        this.overrideStandardNavigation();
        logger.debug("Clearing default cards and bdv functionalities of BigDataViewer");
        this.clearBdvDefaults();
        logger.debug("Installing menu");
        int hierarchyLevelsSkipped = 4;
        this.installBdvMenu(hierarchyLevelsSkipped);
        logger.debug("Installing multislice overlay");
        BdvFunctions.showOverlay((BdvOverlay)new InnerOverlay(), (String)"MultiSlice Overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
        logger.debug("Defining atlas slicing listener");
        this.atlasSlicingListener = this::atlasSlicingChanged;
        msp.getReslicedAtlas().addListener(this.atlasSlicingListener);
        logger.debug("Adding bigdataviewer cards");
        this.installBigDataViewerCards();
        logger.debug("Displaying Altas");
        this.displayAtlas();
        logger.debug("Adding ROI Overlay source");
        this.addRoiOverlaySource();
        logger.debug("Add right click actions");
        this.addRightClickActions();
        logger.debug("Adding close window cleaning hook");
        this.addCleanUpHook();
        logger.debug("SplitPanel Expanded");
        bdvh.getSplitPanel().setCollapsed(false);
        logger.debug("Adding Drag and Drop Handler");
        this.addDnDHandler();
        logger.debug("Adding mouse motion listener / handler");
        bdvh.getViewerPanel().getDisplay().addHandler((Object)this);
        logger.debug("Adding modification monitor");
        this.addModificationMonitor();
        logger.debug("Adding confirmation close hook");
        this.addConfirmationCloseHook();
        logger.debug("Add clean all hook");
        this.addCleanAllHook();
        logger.debug("Installing extra ABBA plugin");
        this.addExtraABBACommands();
        logger.debug("Add closing listener");
        msp.addMultiSlicePositionerListener(this);
        msp.addSliceListener(this);
        msp.getSlices().forEach(this::sliceCreated);
        msp.getSlices().forEach(this.tableView::sliceCreated);
        logger.debug("Register bdv view in the object service");
        ((ObjectService)msp.getContext().getService(ObjectService.class)).addObject((Object)this);
        this.addToCleanUpHook(() -> ((ObjectService)msp.getContext().getService(ObjectService.class)).removeObject((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState() {
        try {
            CommandModule cm;
            this.msp.addTask();
            this.bdvh.getViewerPanel().requestRepaint();
            if (this.msp.getSlices() != null && !this.msp.getSlices().isEmpty()) {
                this.msp.errorMessageForUser.accept("Slices are already present!", "You can't open a state file if slices are already present in ABBA.");
                return;
            }
            try {
                this.blockBdvRepaint();
                cm = (CommandModule)((CommandService)this.msp.getContext().getService(CommandService.class)).run(ABBAStateLoadCommand.class, true, new Object[]{"mp", this.msp}).get();
                if (cm == null || cm.getOutput("success") == null) {
                    return;
                }
                boolean success = (Boolean)cm.getOutput("success");
                if (!success) {
                    return;
                }
            }
            finally {
                this.resumeBdvRepaint();
            }
            this.msp.waitForTasks();
            File f = (File)cm.getInput("state_file");
            String fileNoExt = FilenameUtils.removeExtension((String)f.getAbsolutePath());
            File viewFile = new File(fileNoExt + "_bdv_view.json");
            if (viewFile.exists()) {
                FileReader fileReader = new FileReader(viewFile);
                ViewState vs = (ViewState)new Gson().fromJson((Reader)fileReader, ViewState.class);
                fileReader.close();
                this.msp.getReslicedAtlas().setStep(vs.atlasSlicingStep);
                this.mode = -1;
                this.setDisplayMode(vs.bdvViewMode);
                this.sliceDisplayMode = -1;
                this.setSliceDisplayMode(vs.bdvSliceViewMode);
                if (vs.overlapFactorX != 0.0) {
                    this.overlapFactorX = vs.overlapFactorX;
                }
                if (vs.overlapFactorY != 0.0) {
                    this.overlapFactorY = vs.overlapFactorY;
                }
                this.overlapMode = vs.overlapMode;
                this.updateOverlapMode();
                double[] rowPackedCopy = vs.bdvView;
                if (vs.showInfo) {
                    this.showSliceInfo();
                } else {
                    this.hideSliceInfo();
                }
                List<SliceSources> slices = this.msp.getSlices();
                if (vs.slicesStates.size() == this.msp.getSlices().size()) {
                    for (int i = 0; i < vs.slicesStates.size(); ++i) {
                        SliceGuiState.State state = vs.slicesStates.get(i);
                        this.guiState.runSlice(slices.get(i), sliceGuiState -> sliceGuiState.setState(state));
                    }
                    this.tableView.updateTable();
                } else {
                    this.infoMessageForUser("Load state", "Cannot restore display slices!");
                }
                if (vs.iCurrentSlice != null) {
                    this.iCurrentSlice = vs.iCurrentSlice;
                    this.navigateCurrentSlice();
                }
                AffineTransform3D view = new AffineTransform3D();
                view.set(rowPackedCopy);
                this.bdvh.getViewerPanel().state().setViewerTransform(view);
                this.updateSliceDisplayedPosition(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.msp.removeTask();
        }
    }

    private void blockBdvRepaint() {
        this.updateBdv = false;
    }

    private void resumeBdvRepaint() {
        this.updateBdv = true;
        this.bdvh.getViewerPanel().getDisplay().repaint();
        this.bdvh.getViewerPanel().requestRepaint();
    }

    protected boolean bdvRepaintEnabled() {
        return this.updateBdv;
    }

    public void saveState() {
        this.saveState(null);
    }

    public void saveState(File stateFileIn) {
        try {
            boolean success;
            if (stateFileIn == null) {
                CommandModule cm = (CommandModule)((CommandService)this.msp.getContext().getService(CommandService.class)).run(ABBAStateSaveCommand.class, true, new Object[]{"mp", this.msp}).get();
                this.msp.waitForTasks();
                success = (Boolean)cm.getOutput("success");
                if (!success) {
                    this.blockingErrorMessageForUsers("State not saved!", "Something went wrong");
                    return;
                }
                stateFileIn = (File)cm.getInput("state_file");
            } else {
                String extension = FilenameUtils.getExtension((String)stateFileIn.getAbsolutePath());
                if (extension.trim().isEmpty()) {
                    logger.debug("Adding abba extension to state file");
                    stateFileIn = new File(stateFileIn.getAbsolutePath() + ".abba");
                }
                if (stateFileIn.exists()) {
                    this.blockingErrorMessageForUsers("Can't save the state", "Error, the file " + stateFileIn + " already exists.");
                    return;
                }
                success = this.msp.saveState(stateFileIn, true);
                if (!success) {
                    this.blockingErrorMessageForUsers("State not saved!", "Something went wrong");
                    return;
                }
            }
            String fileNoExt = FilenameUtils.removeExtension((String)stateFileIn.getAbsolutePath());
            File viewFile = new File(fileNoExt + "_bdv_view.json");
            ArrayList<SliceGuiState.State> states = new ArrayList<SliceGuiState.State>();
            this.guiState.forEachSlice(sliceState -> states.add(new SliceGuiState.State((SliceGuiState)sliceState)));
            ViewState vs = new ViewState();
            vs.slicesStates = states;
            vs.showInfo = this.showSliceInfo;
            vs.bdvViewMode = this.mode;
            vs.bdvSliceViewMode = this.sliceDisplayMode;
            vs.overlapMode = this.overlapMode;
            vs.bdvView = this.bdvh.getViewerPanel().state().getViewerTransform().getRowPackedCopy();
            vs.atlasSlicingStep = (int)this.msp.getReslicedAtlas().getStep();
            vs.iCurrentSlice = this.iCurrentSlice;
            this.notifyCurrentSliceListeners();
            FileWriter writer = new FileWriter(viewFile.getAbsolutePath());
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)vs, (Appendable)writer);
            writer.flush();
            writer.close();
            if (stateFileIn.exists() && Files.size(Paths.get(stateFileIn.getAbsolutePath(), new String[0])) > 0L) {
                this.infoMessageForUser("State saved", "Path:" + stateFileIn.getAbsolutePath());
            } else {
                this.blockingErrorMessageForUsers("State not saved!", "Something went wrong");
            }
        }
        catch (Exception e) {
            this.blockingErrorMessageForUsers("State not saved!", e.getMessage());
            e.printStackTrace();
        }
    }

    private void modificationMonitor() {
        boolean previousTimeReady;
        boolean previousStateModification = this.msp.isModifiedSinceLastSave();
        boolean bl = previousTimeReady = this.msp.getNumberOfTasks() == 0;
        while (!this.stopMonitoring && this.bdvh != null) {
            MultiSlicePositioner current_msp;
            if (this.bdvRepaintEnabled() && (current_msp = this.msp) != null) {
                if (previousStateModification != current_msp.isModifiedSinceLastSave()) {
                    previousStateModification = current_msp.isModifiedSinceLastSave();
                    BdvHandleHelper.setWindowTitle((BdvHandle)this.bdvh, (String)this.getViewName());
                }
                if (current_msp.getNumberOfTasks() > 0) {
                    if (this.bdvh != null) {
                        this.bdvh.getViewerPanel().getDisplay().repaint();
                        previousTimeReady = false;
                    }
                } else if (!previousTimeReady && this.bdvh != null) {
                    this.bdvh.getViewerPanel().getDisplay().repaint();
                    previousTimeReady = true;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.debug("Bdv view modification monitoring stopped");
    }

    public String getViewName() {
        String name = "Aligning Big Brains and Atlases - " + this.msp.getAtlas().getName();
        if (this.msp.isModifiedSinceLastSave()) {
            return name + "* (modified)";
        }
        return name;
    }

    public void showAtlasPosition() {
        this.showAtlasPosition = true;
    }

    public void hideAtlasPosition() {
        this.showAtlasPosition = false;
    }

    public void showSliceInfo() {
        this.showSliceInfo = true;
    }

    public void hideSliceInfo() {
        this.showSliceInfo = false;
    }

    public void iniSlice(SliceSources slice) {
        logger.debug("Initializing " + slice.getName());
        this.guiState.created(slice);
        if (this.guiState.nSlices() == 1) {
            this.iCurrentSlice = 0;
            this.navigateCurrentSlice();
        }
        this.sliceZPositionChanged(slice);
        this.guiState.runSlice(slice, this::updateSliceDisplayedPosition);
        if (slice.isSelected()) {
            this.sliceSelected(slice);
        } else {
            this.sliceDeselected(slice);
        }
    }

    void atlasSlicingChanged() {
        this.recenterBdvh();
        this.guiState.forEachSlice(this::updateSliceDisplayedPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSliceDisplayedPosition(SliceGuiState sliceGuiState) {
        if (this.overlapMode == 0 && sliceGuiState != null) {
            sliceGuiState.setYShift(0.0);
        } else if (this.overlapMode == 1 && sliceGuiState != null) {
            sliceGuiState.setYShift(1.0);
        } else if (this.overlapMode == 2) {
            double lastPositionAlongX = -1.7976931348623157E308;
            double stairIndex = 0.0;
            List<SliceSources> slices = this.msp.getSlices();
            double globalOffsY = 0.35;
            BdvMultislicePositionerView bdvMultislicePositionerView = this;
            synchronized (bdvMultislicePositionerView) {
                int current = this.iCurrentSlice;
                if (current > 0 && current < slices.size()) {
                    double finalStairIndex;
                    double posX;
                    RealPoint pt;
                    SliceSources slice;
                    int i;
                    for (i = current; i < slices.size(); ++i) {
                        slice = slices.get(i);
                        if (slice == null || (pt = this.getDisplayedCenter(slice)) == null) continue;
                        posX = pt.getDoublePosition(0);
                        if (posX >= lastPositionAlongX + this.msp.sX / this.overlapFactorX) {
                            stairIndex = 0.0;
                            lastPositionAlongX = posX;
                            this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY));
                            continue;
                        }
                        finalStairIndex = stairIndex += this.overlapFactorY;
                        this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY + finalStairIndex));
                    }
                    lastPositionAlongX = Double.MAX_VALUE;
                    stairIndex = 0.0;
                    for (i = current; i >= 0; --i) {
                        slice = slices.get(i);
                        if (slice == null || (pt = this.getDisplayedCenter(slice)) == null) continue;
                        posX = pt.getDoublePosition(0);
                        if (posX <= lastPositionAlongX - this.msp.sX / this.overlapFactorX) {
                            stairIndex = 0.0;
                            lastPositionAlongX = posX;
                            this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY));
                            continue;
                        }
                        finalStairIndex = stairIndex += this.overlapFactorY;
                        this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY + finalStairIndex));
                    }
                } else {
                    for (SliceSources slice : slices) {
                        RealPoint rp;
                        if (slice == null || (rp = this.getDisplayedCenter(slice)) == null) continue;
                        double posX = rp.getDoublePosition(0);
                        if (posX >= lastPositionAlongX + this.msp.sX / this.overlapFactorX) {
                            stairIndex = 0.0;
                            lastPositionAlongX = posX;
                            this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY));
                            continue;
                        }
                        double finalStairIndex = stairIndex += this.overlapFactorY;
                        this.guiState.runSlice(slice, guiState -> guiState.setYShift(globalOffsY + this.overlapFactorY + finalStairIndex));
                    }
                }
            }
        }
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().requestRepaint();
        }
    }

    public void recenterBdvh() {
        double cur_wcx = (double)this.bdvh.getViewerPanel().getWidth() / 2.0;
        double cur_wcy = (double)this.bdvh.getViewerPanel().getHeight() / 2.0;
        RealPoint centerScreenCurrentBdv = new RealPoint(new double[]{cur_wcx, cur_wcy, 0.0});
        RealPoint centerScreenGlobalCoord = new RealPoint(3);
        AffineTransform3D at3D = new AffineTransform3D();
        this.bdvh.getViewerPanel().state().getViewerTransform(at3D);
        at3D.inverse().apply((RealLocalizable)centerScreenCurrentBdv, (RealPositionable)centerScreenGlobalCoord);
        centerScreenGlobalCoord.setPosition((centerScreenGlobalCoord.getDoublePosition(0) - this.msp.sX / 2.0) * (double)this.previouszStep / (double)this.msp.getReslicedAtlas().getStep() + this.msp.sX / 2.0, 0);
        AffineTransform3D nextAffineTransform = new AffineTransform3D();
        nextAffineTransform.set(at3D);
        nextAffineTransform.set(0.0, 0, 3);
        nextAffineTransform.set(0.0, 1, 3);
        nextAffineTransform.set(0.0, 2, 3);
        double next_wcx = (double)this.bdvh.getViewerPanel().getWidth() / 2.0;
        double next_wcy = (double)this.bdvh.getViewerPanel().getHeight() / 2.0;
        RealPoint centerScreenNextBdv = new RealPoint(new double[]{next_wcx, next_wcy, 0.0});
        RealPoint shiftNextBdv = new RealPoint(3);
        nextAffineTransform.inverse().apply((RealLocalizable)centerScreenNextBdv, (RealPositionable)shiftNextBdv);
        double sx = -centerScreenGlobalCoord.getDoublePosition(0) + shiftNextBdv.getDoublePosition(0);
        double sy = -centerScreenGlobalCoord.getDoublePosition(1) + shiftNextBdv.getDoublePosition(1);
        double sz = -centerScreenGlobalCoord.getDoublePosition(2) + shiftNextBdv.getDoublePosition(2);
        RealPoint shiftWindow = new RealPoint(new double[]{sx, sy, sz});
        RealPoint shiftMatrix = new RealPoint(3);
        nextAffineTransform.apply((RealLocalizable)shiftWindow, (RealPositionable)shiftMatrix);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(0), 0, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(1), 1, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(2), 2, 3);
        this.bdvh.getViewerPanel().state().setViewerTransform(nextAffineTransform);
        this.previouszStep = (int)this.msp.getReslicedAtlas().getStep();
        this.bdvh.getViewerPanel().requestRepaint();
    }

    private void overrideStandardNavigation() {
        this.bdvh.getKeybindings().addInputMap("blocking-multipositioner", new InputMap(), "bdv", "navigation");
        InputTriggerMap itm = new InputTriggerMap();
        itm.put(InputTrigger.getFromString("button3"), "drag translate");
        itm.put(InputTrigger.getFromString("UP"), "zoom in");
        itm.put(InputTrigger.getFromString("shift UP"), "zoom in fast");
        itm.put(InputTrigger.getFromString("scroll"), "scroll zoom");
        itm.put(InputTrigger.getFromString("DOWN"), "zoom out");
        itm.put(InputTrigger.getFromString("shift DOWN"), "zoom out fast");
        this.selectionLayer = new SelectionLayer(this);
        this.selectionLayer.addSelectionBehaviours(this.common_behaviours);
        this.refreshBlockMap();
        this.bdvh.getTriggerbindings().addInputTriggerMap("default_navigation", itm, "transform");
    }

    @Override
    public void sliceCreated(SliceSources slice) {
        logger.debug(slice.getName() + " created");
        this.iniSlice(slice);
    }

    @Override
    public void sliceDeleted(SliceSources slice) {
        logger.debug(slice.getName() + " deleted");
        this.guiState.deleted(slice);
    }

    @Override
    public void sliceZPositionChanged(SliceSources slice) {
        logger.debug(slice.getName() + " z position changed");
        this.guiState.runSlice(slice, guiState -> {
            guiState.slicePositionChanged();
            this.updateSliceDisplayedPosition((SliceGuiState)guiState);
        });
    }

    @Override
    public void sliceSelected(SliceSources slice) {
        if (this.bdvRepaintEnabled()) {
            logger.debug(slice.getName() + " selected");
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void sliceDeselected(SliceSources slice) {
        if (this.bdvRepaintEnabled()) {
            logger.debug(slice.getName() + " deselected");
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void sliceSourcesChanged(SliceSources slice) {
        logger.debug(slice.getName() + " slices changed");
        this.guiState.runSlice(slice, SliceGuiState::sourcesChanged);
    }

    @Override
    public void slicePretransformChanged(SliceSources sliceSources) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().requestRepaint();
        }
    }

    @Override
    public void sliceKeyOn(SliceSources slice) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void sliceKeyOff(SliceSources slice) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void roiChanged() {
        double[] currentRoi = this.msp.getROI();
        this.roiPX = currentRoi[0];
        this.roiPY = currentRoi[1];
        this.roiSX = currentRoi[2];
        this.roiSY = currentRoi[3];
        this.bdvh.getViewerPanel().requestRepaint();
    }

    @Override
    public void actionEnqueue(SliceSources slice, CancelableAction action) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void actionStarted(SliceSources slice, CancelableAction action) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void actionFinished(SliceSources slice, CancelableAction action, boolean result) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void actionCancelEnqueue(SliceSources slice, CancelableAction action) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void actionCancelStarted(SliceSources slice, CancelableAction action) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void actionCancelFinished(SliceSources slice, CancelableAction action, boolean result) {
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().getDisplay().repaint();
        }
    }

    @Override
    public void converterChanged(SliceSources slice) {
        this.guiState.forEachSlice(SliceGuiState::updateDisplaySettings);
    }

    public void nextMode() {
        this.setDisplayMode(1 - this.mode);
    }

    public void setDisplayMode(int mode) {
        if (this.mode != mode) {
            int oldMode = mode;
            this.mode = mode;
            this.modeChanged(mode, oldMode);
        }
    }

    private void modeChanged(int mode, int oldMode) {
        this.guiState.forEachSlice(sliceGuiState -> {
            sliceGuiState.sliceDisplayChanged();
            sliceGuiState.slicePositionChanged();
        });
        if (mode == 0) {
            this.guiState.forEachSlice(SliceGuiState::enableGraphicalHandles);
            this.bdvh.getTriggerbindings().removeInputTriggerMap(REVIEW_BEHAVIOURS_KEY);
            this.bdvh.getTriggerbindings().removeBehaviourMap(REVIEW_BEHAVIOURS_KEY);
            this.positioning_behaviours.install(this.bdvh.getTriggerbindings(), POSITIONING_BEHAVIOURS_KEY);
            this.navigateCurrentSlice();
            this.refreshBlockMap();
        }
        if (mode == 1) {
            this.guiState.forEachSlice(SliceGuiState::disableGraphicalHandles);
            this.bdvh.getTriggerbindings().removeInputTriggerMap(POSITIONING_BEHAVIOURS_KEY);
            this.bdvh.getTriggerbindings().removeBehaviourMap(POSITIONING_BEHAVIOURS_KEY);
            this.review_behaviours.install(this.bdvh.getTriggerbindings(), REVIEW_BEHAVIOURS_KEY);
            this.navigateCurrentSlice();
            this.refreshBlockMap();
        }
        this.modeListeners.forEach(modeListener -> modeListener.modeChanged(this, oldMode, mode));
    }

    public void setSliceDisplayMode(int sliceDisplayMode) {
        if (this.sliceDisplayMode != sliceDisplayMode) {
            this.sliceDisplayMode = sliceDisplayMode;
            this.guiState.forEachSlice(SliceGuiState::sliceDisplayChanged);
        }
    }

    public void toggleOverlap() {
        ++this.overlapMode;
        if (this.overlapMode == 3) {
            this.overlapMode = 0;
        }
        this.updateOverlapMode();
    }

    private void updateOverlapMode() {
        if (this.overlapMode == 2) {
            this.updateSliceDisplayedPosition(null);
        } else {
            this.guiState.forEachSlice(this::updateSliceDisplayedPosition);
        }
    }

    public void addResourcesMonitor() {
        if (this.rm == null && this.bdvh != null) {
            try {
                this.rm = new ResourcesMonitor();
                BdvHandleHelper.addCard((BdvHandle)this.bdvh, (String)"Resources Monitor", (JComponent)this.rm, (boolean)false);
            }
            catch (Exception e) {
                this.rm = null;
                logger.debug("Could not start Resources Monitor");
            }
        } else {
            if (this.bdvh == null) {
                this.blockingErrorMessageForUsers("Issue in GUI generation", "No Graphical User Interface.");
            }
            if (this.rm != null) {
                this.warningMessageForUser("Warning", "Resource Monitor is already present");
            }
        }
    }

    public RealPoint getDisplayedCenter(SliceSources slice) {
        if (this.mode == 0) {
            double slicingAxisSnapped = (double)((int)((slice.getSlicingAxisPosition() + this.guiState.getXShift(slice)) / this.msp.sizePixX)) * this.msp.sizePixX;
            double posX = slicingAxisSnapped / this.msp.sizePixX * this.msp.sX / (double)this.msp.getReslicedAtlas().getStep() + 0.5 * this.msp.sX;
            double posY = this.msp.sY * this.guiState.getYShift(slice);
            return new RealPoint(new double[]{posX, posY, 0.0});
        }
        if (this.mode == 1) {
            return new RealPoint(new double[]{0.0, 0.0, slice.getSlicingAxisPosition()});
        }
        return new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
    }

    private void block() {
        this.bdvh.getTriggerbindings().addBehaviourMap(BLOCKING_MAP, this.blockMap);
    }

    private void unblock() {
        this.bdvh.getTriggerbindings().removeBehaviourMap(BLOCKING_MAP);
    }

    private void refreshBlockMap() {
        logger.debug("Refresh Block Map called");
        this.bdvh.getTriggerbindings().removeBehaviourMap(BLOCKING_MAP);
        HashSet<InputTrigger> moveCornerTriggers = new HashSet<InputTrigger>();
        for (String s : DRAG_TOGGLE_EDITOR_KEYS) {
            moveCornerTriggers.add(InputTrigger.getFromString(s));
        }
        Map<InputTrigger, Set<String>> bindings = this.bdvh.getTriggerbindings().getConcatenatedInputTriggerMap().getAllBindings();
        HashSet behavioursToBlock = new HashSet();
        for (InputTrigger t : moveCornerTriggers) {
            behavioursToBlock.addAll(bindings.get(t));
        }
        this.blockMap.clear();
        Behaviour block = new Behaviour(){};
        for (String key : behavioursToBlock) {
            this.blockMap.put(key, block);
        }
    }

    private void printBindings() {
        BdvHandleHelper.printBindings((BdvHandle)this.bdvh, arg_0 -> ((Logger)logger).debug(arg_0));
    }

    public void navigateCurrentSlice() {
        SliceSources slice;
        List<SliceSources> sortedSlices = this.msp.getSlices();
        if (this.iCurrentSlice >= sortedSlices.size()) {
            this.iCurrentSlice = 0;
        }
        if (sortedSlices.size() > 0 && (slice = sortedSlices.get(this.iCurrentSlice)) != null) {
            this.guiState.runSlice(slice, SliceGuiState::isCurrent);
            this.centerBdvViewOn(sortedSlices.get(this.iCurrentSlice));
        }
        this.notifyCurrentSliceListeners();
    }

    public void navigateNextSlice() {
        List<SliceSources> sortedSlices = this.msp.getSlices();
        int previousSliceIndex = this.iCurrentSlice++;
        if (this.iCurrentSlice >= sortedSlices.size()) {
            this.iCurrentSlice = 0;
        }
        if (sortedSlices.size() > 0) {
            SliceSources previousSlice = null;
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                previousSlice = sortedSlices.get(previousSliceIndex);
            }
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                this.guiState.runSlice(sortedSlices.get(previousSliceIndex), SliceGuiState::isNotCurrent);
            }
            this.guiState.runSlice(sortedSlices.get(this.iCurrentSlice), SliceGuiState::isCurrent);
            if (this.overlapMode == 2) {
                this.updateSliceDisplayedPosition(null);
            }
            this.centerBdvViewOn(sortedSlices.get(this.iCurrentSlice), true, previousSlice);
        }
        this.notifyCurrentSliceListeners();
    }

    public void navigatePreviousSlice() {
        int previousSliceIndex = this.iCurrentSlice--;
        List<SliceSources> sortedSlices = this.msp.getSlices();
        if (this.iCurrentSlice < 0) {
            this.iCurrentSlice = sortedSlices.size() - 1;
        }
        if (sortedSlices.size() > 0) {
            SliceSources previousSlice = null;
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                previousSlice = sortedSlices.get(previousSliceIndex);
            }
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                this.guiState.runSlice(sortedSlices.get(previousSliceIndex), SliceGuiState::isNotCurrent);
            }
            this.guiState.runSlice(sortedSlices.get(this.iCurrentSlice), SliceGuiState::isCurrent);
            if (this.overlapMode == 2) {
                this.updateSliceDisplayedPosition(null);
            }
            this.centerBdvViewOn(sortedSlices.get(this.iCurrentSlice), true, previousSlice);
        }
        this.notifyCurrentSliceListeners();
    }

    public void navigateSlice(SliceSources slice) {
        int previousSliceIndex = this.iCurrentSlice;
        List<SliceSources> sortedSlices = this.msp.getSlices();
        this.iCurrentSlice = sortedSlices.indexOf(slice);
        if (this.iCurrentSlice < 0) {
            return;
        }
        if (sortedSlices.size() > 0) {
            SliceSources previousSlice = null;
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                previousSlice = sortedSlices.get(previousSliceIndex);
            }
            if (previousSliceIndex >= 0 && previousSliceIndex < sortedSlices.size()) {
                this.guiState.runSlice(sortedSlices.get(previousSliceIndex), SliceGuiState::isNotCurrent);
            }
            this.guiState.runSlice(sortedSlices.get(this.iCurrentSlice), SliceGuiState::isCurrent);
            if (this.overlapMode == 2) {
                this.updateSliceDisplayedPosition(null);
            }
            this.centerBdvViewOn(sortedSlices.get(this.iCurrentSlice), true, previousSlice);
        }
        this.notifyCurrentSliceListeners();
    }

    public void centerBdvViewOn(SliceSources slice) {
        this.centerBdvViewOn(slice, false, null);
    }

    public void centerBdvViewOn(SliceSources current_slice, boolean maintainoffset, SliceSources previous_slice) {
        RealPoint offset = new RealPoint(3);
        RealPoint centerScreen = this.getCurrentBdvCenter();
        if (maintainoffset && previous_slice != null) {
            RealPoint oldCenter = this.getDisplayedCenter(previous_slice);
            offset.setPosition(-oldCenter.getDoublePosition(0) + centerScreen.getDoublePosition(0), 0);
            offset.setPosition(-oldCenter.getDoublePosition(1) + centerScreen.getDoublePosition(1), 1);
            offset.setPosition(0, 2);
            if (this.mode != 1) {
                offset.setPosition(0, 1);
            }
            if (Math.abs(offset.getDoublePosition(0)) > this.msp.sX * 1.5) {
                maintainoffset = false;
            }
            if (Math.abs(offset.getDoublePosition(1)) > this.msp.sY * 1.5) {
                maintainoffset = false;
            }
        } else {
            maintainoffset = false;
        }
        RealPoint centerSlice = this.getDisplayedCenter(current_slice);
        if (maintainoffset) {
            centerSlice.move((RealLocalizable)offset);
            if (this.mode != 1) {
                centerSlice.setPosition(centerScreen.getDoublePosition(1), 1);
            }
        }
        AffineTransform3D at3d = BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)this.bdvh, (double[])centerSlice.positionAsDoubleArray());
        this.bdvh.getViewerPanel().state().setViewerTransform(at3d);
        if (this.bdvRepaintEnabled()) {
            this.bdvh.getViewerPanel().requestRepaint();
        }
    }

    RealPoint getCurrentBdvCenter() {
        RealPoint centerBdv = new RealPoint(3);
        double px = (double)this.bdvh.getViewerPanel().getWidth() / 2.0;
        double py = (double)this.bdvh.getViewerPanel().getHeight() / 2.0;
        this.bdvh.getViewerPanel().displayToGlobalCoordinates(px, py, (RealPositionable)centerBdv);
        return centerBdv;
    }

    public Integer[] getSliceHandleCoords(SliceSources slice) {
        return this.guiState.getSliceHandleCoords(slice);
    }

    public int getCurrentSliceIndex() {
        return this.iCurrentSlice;
    }

    boolean startDragAction() {
        boolean result = this.dragActionInProgress.compareAndSet(false, true);
        logger.debug("Attempt to do a drag action : successful = " + result);
        return result;
    }

    void stopDragAction() {
        logger.debug("Stopping a drag action");
        this.dragActionInProgress.set(false);
    }

    public void disabled(GraphicalHandle gh) {
    }

    public void enabled(GraphicalHandle gh) {
    }

    public void hover_in(GraphicalHandle gh) {
        this.gh_below_mouse.add(gh);
        if (this.gh_below_mouse.size() == 1) {
            this.block();
        }
    }

    public void hover_out(GraphicalHandle gh) {
        this.gh_below_mouse.remove(gh);
        if (this.gh_below_mouse.size() == 0) {
            this.unblock();
        }
    }

    public void created(GraphicalHandle gh) {
    }

    public void removed(GraphicalHandle gh) {
        if (this.gh_below_mouse.contains(gh)) {
            this.gh_below_mouse.remove(gh);
            if (this.gh_below_mouse.size() == 0) {
                this.unblock();
            }
        }
        this.ghs.remove(gh);
    }

    public Object getCurrentSlice() {
        List<SliceSources> sortedSlices = this.msp.getSlices();
        if (sortedSlices.size() > 0) {
            if (this.iCurrentSlice >= sortedSlices.size()) {
                this.iCurrentSlice = 0;
                this.notifyCurrentSliceListeners();
            }
            return sortedSlices.get(this.iCurrentSlice);
        }
        return new Object();
    }

    public BdvHandle getBdvh() {
        return this.bdvh;
    }

    public SourceAndConverter<?>[] getDisplayedAtlasSources() {
        switch (this.mode) {
            case 0: {
                return this.msp.getReslicedAtlas().extendedSlicedSources;
            }
            case 1: {
                return this.msp.getReslicedAtlas().nonExtendedSlicedSources;
            }
        }
        return null;
    }

    public boolean includedKey(String key) {
        return !excludedKeys.contains(key);
    }

    public int getDisplayMode() {
        return this.mode;
    }

    private void drawSliceInfo(Graphics2D g, List<SliceSources> slicesCopy) {
        RealPoint mouseWindowPosition = new RealPoint(2);
        this.bdvh.getViewerPanel().getMouseCoordinates((Positionable)mouseWindowPosition);
        Optional<SliceSources> optSlice = slicesCopy.stream().filter(slice -> {
            double dy;
            Integer[] coords = this.guiState.getSliceHandleCoords((SliceSources)slice);
            if (coords == null) {
                return false;
            }
            int radius = this.guiState.getBdvHandleRadius((SliceSources)slice);
            double dx = (double)coords[0].intValue() - mouseWindowPosition.getDoublePosition(0);
            double dist = Math.sqrt(dx * dx + (dy = (double)coords[1].intValue() - mouseWindowPosition.getDoublePosition(1)) * dy);
            return dist < (double)radius;
        }).findFirst();
        if (optSlice.isPresent()) {
            SliceSources slice2 = optSlice.get();
            String info = slice2.getInfo();
            g.setFont(new Font("TimesRoman", 1, 16));
            g.setColor(new Color(32, 125, 49, 220));
            Point mouseLocation = this.bdvh.getViewerPanel().getMousePosition();
            if (info != null && mouseLocation != null) {
                this.drawString(g, info, mouseLocation.x, mouseLocation.y + 40);
            }
        }
    }

    private void drawString(Graphics2D g, String info, int x, int y) {
        int lineHeight = g.getFontMetrics().getHeight();
        for (String line : info.split("\n")) {
            g.drawString(line, x, y += lineHeight);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.ghs.forEach(gh -> gh.mouseDragged(e));
        this.guiState.forEachSlice(guiState -> guiState.ghs.forEach(gh -> gh.mouseDragged(e)));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.ghs.forEach(gh -> gh.mouseMoved(e));
        this.guiState.forEachSlice(guiState -> guiState.ghs.forEach(gh -> gh.mouseMoved(e)));
    }

    public Boolean getChannelVisibility(SliceSources slice, int iChannel) {
        if (this.guiState == null) {
            return false;
        }
        if (this.guiState.sliceGuiState == null) {
            return false;
        }
        SliceGuiState guiStateSlice = (SliceGuiState)this.guiState.sliceGuiState.get(slice);
        if (guiStateSlice != null) {
            return guiStateSlice.getChannelVisibility(iChannel);
        }
        return false;
    }

    public Displaysettings getDisplaySettings(SliceSources slice, int iChannel) {
        if (this.guiState == null) {
            return new Displaysettings(-1);
        }
        if (this.guiState.sliceGuiState == null) {
            return new Displaysettings(-1);
        }
        SliceGuiState guiStateSlice = (SliceGuiState)this.guiState.sliceGuiState.get(slice);
        if (guiStateSlice != null) {
            return guiStateSlice.getDisplaySettings(iChannel);
        }
        return new Displaysettings(-1);
    }

    public Boolean getSliceVisibility(SliceSources slice) {
        if (this.guiState == null) {
            return false;
        }
        if (this.guiState.sliceGuiState == null) {
            return false;
        }
        if (this.guiState.sliceGuiState.get(slice) == null) {
            return false;
        }
        SliceGuiState guiStateSlice = (SliceGuiState)this.guiState.sliceGuiState.get(slice);
        if (guiStateSlice != null) {
            return guiStateSlice.getSliceVisibility();
        }
        return false;
    }

    @Override
    public void closing(MultiSlicePositioner msp) {
        if (msp == this.msp && !this.cleanAllOnExit) {
            IJ.error((String)"This ABBA session has been closed outside BigDataViewer, expect errors!");
        }
    }

    public void setSliceDisplayMinMax(SliceSources slice, int iChannel, double display_min, double display_max) {
        this.guiState.runSlice(slice, sliceGuiState -> {
            if (iChannel < sliceGuiState.nChannels) {
                Displaysettings ds = sliceGuiState.getDisplaySettings(iChannel);
                ds.min = display_min;
                ds.max = display_max;
                sliceGuiState.setDisplaySettings(iChannel, ds);
            }
        });
        this.tableView.sliceDisplaySettingsChanged(slice);
    }

    public void setSliceChannelVisibility(SliceSources slice, int iChannel, boolean visible) {
        this.guiState.runSlice(slice, sliceGuiState -> sliceGuiState.setChannelVisibility(iChannel, visible));
        this.tableView.sliceDisplaySettingsChanged(slice);
    }

    public void setSelectedSlicesVisibility(int iChannel, boolean visible) {
        this.guiState.forEachSelectedSlice(sliceGuiState -> sliceGuiState.setChannelVisibility(iChannel, visible));
        this.msp.getSelectedSlices().forEach(slice -> this.tableView.sliceDisplaySettingsChanged((SliceSources)slice));
    }

    public void setSelectedSlicesVisibility(Boolean visible) {
        this.guiState.forEachSelectedSlice(sliceGuiState -> sliceGuiState.setSliceVisibility(visible));
        this.msp.getSelectedSlices().forEach(slice -> this.tableView.sliceDisplaySettingsChanged((SliceSources)slice));
    }

    public void setOverlapFactorX(int value) {
        double newValue = 3.1 - (double)value / 100.0 * 3.0;
        if (newValue != this.overlapFactorX) {
            this.overlapFactorX = newValue;
            if (this.overlapMode == 2) {
                this.updateOverlapMode();
            }
        }
    }

    public void setOverlapFactorY(int value) {
        double newValue = 3.1 - (double)value / 100.0 * 3.0;
        if (newValue != this.overlapFactorY) {
            this.overlapFactorY = newValue;
            if (this.overlapMode == 2) {
                this.updateOverlapMode();
            }
        }
    }

    Object getSourceValueAt(SourceAndConverter<?> sac, RealPoint pt) {
        RealRandomAccessible rra_ible = sac.getSpimSource().getInterpolatedSource(0, 0, Interpolation.NEARESTNEIGHBOR);
        if (rra_ible != null) {
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sac.getSpimSource().getSourceTransform(0, 0, sourceTransform);
            RealRandomAccess rra = rra_ible.realRandomAccess();
            RealPoint iPt = new RealPoint(3);
            sourceTransform.inverse().apply((RealLocalizable)pt, (RealPositionable)iPt);
            rra.setPosition((RealLocalizable)iPt);
            return rra.get();
        }
        return null;
    }

    private void drawAtlasPosition(Graphics2D g) {
        SourceAndConverter zSource;
        SourceAndConverter ySource;
        SourceAndConverter xSource;
        int leftRight;
        SourceAndConverter lrSource;
        int labelValue;
        SourceAndConverter label;
        ReslicedAtlas reslicedAtlas = this.msp.getReslicedAtlas();
        RealPoint globalMouseCoordinates = new RealPoint(3);
        this.bdvh.getViewerPanel().getGlobalMouseCoordinates((RealPositionable)globalMouseCoordinates);
        float[] coords = new float[3];
        if (this.mode == 0) {
            label = reslicedAtlas.extendedSlicedSources[reslicedAtlas.getLabelSourceIndex()];
            labelValue = ((IntegerType)this.getSourceValueAt(label, globalMouseCoordinates)).getInteger();
            lrSource = reslicedAtlas.extendedSlicedSources[reslicedAtlas.getLeftRightSourceIndex()];
            leftRight = ((IntegerType)this.getSourceValueAt(lrSource, globalMouseCoordinates)).getInteger();
            xSource = reslicedAtlas.extendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(0)];
            ySource = reslicedAtlas.extendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(1)];
            zSource = reslicedAtlas.extendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(2)];
            coords[0] = ((FloatType)this.getSourceValueAt(xSource, globalMouseCoordinates)).get();
            coords[1] = ((FloatType)this.getSourceValueAt(ySource, globalMouseCoordinates)).get();
            coords[2] = ((FloatType)this.getSourceValueAt(zSource, globalMouseCoordinates)).get();
        } else {
            assert (this.mode == 1);
            label = reslicedAtlas.nonExtendedSlicedSources[reslicedAtlas.getLabelSourceIndex()];
            labelValue = ((IntegerType)this.getSourceValueAt(label, globalMouseCoordinates)).getInteger();
            lrSource = reslicedAtlas.nonExtendedSlicedSources[reslicedAtlas.getLeftRightSourceIndex()];
            leftRight = ((IntegerType)this.getSourceValueAt(lrSource, globalMouseCoordinates)).getInteger();
            xSource = reslicedAtlas.nonExtendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(0)];
            ySource = reslicedAtlas.nonExtendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(1)];
            zSource = reslicedAtlas.nonExtendedSlicedSources[reslicedAtlas.getCoordinateSourceIndex(2)];
            coords[0] = ((FloatType)this.getSourceValueAt(xSource, globalMouseCoordinates)).get();
            coords[1] = ((FloatType)this.getSourceValueAt(ySource, globalMouseCoordinates)).get();
            coords[2] = ((FloatType)this.getSourceValueAt(zSource, globalMouseCoordinates)).get();
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        String coordinates = "[" + df.format(coords[0]) + ";" + df.format(coords[1]) + ";" + df.format(coords[2]) + "]";
        if (leftRight == this.msp.getAtlas().getMap().labelRight()) {
            coordinates = coordinates + "(R)";
        }
        if (leftRight == this.msp.getAtlas().getMap().labelLeft()) {
            coordinates = coordinates + "(L)";
        }
        StringBuilder ontologyLocation = null;
        AtlasNode node = this.msp.getAtlas().getOntology().getNodeFromId(labelValue);
        if (node != null) {
            ontologyLocation = new StringBuilder(node.toString());
            while (node.parent() != null) {
                if ((node = node.parent()) == null) continue;
                ontologyLocation.append("<").append(node);
            }
        }
        g.setFont(new Font("TimesRoman", 1, 16));
        g.setColor(new Color(255, 255, 100, 250));
        try {
            Point mouseLocation = this.bdvh.getViewerPanel().getMousePosition();
            if (ontologyLocation != null && mouseLocation != null) {
                g.drawString(ontologyLocation.toString(), mouseLocation.x, mouseLocation.y);
            }
            if (mouseLocation != null && !coordinates.startsWith("[0.00;0.00;0.00]")) {
                g.drawString(coordinates, mouseLocation.x, mouseLocation.y - 20);
            }
        }
        catch (NullPointerException npe) {
            System.out.println("NPE CAUGHT!!!!");
        }
    }

    private void drawSetOfSliceControls(Graphics2D g, AffineTransform3D bdvAt3D, List<SliceSources> slicesCopy) {
        if (slicesCopy.stream().anyMatch(SliceSources::isSelected)) {
            List sortedSelected = this.msp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
            RealPoint precedentPoint = null;
            for (int i = 0; i < sortedSelected.size(); ++i) {
                SliceSources slice2 = (SliceSources)sortedSelected.get(i);
                Integer[] coords = this.guiState.getSliceHandleCoords(slice2);
                RealPoint sliceCenter = new RealPoint(new float[]{coords[0].intValue(), coords[1].intValue(), 0.0f});
                if (precedentPoint != null) {
                    g.drawLine((int)precedentPoint.getDoublePosition(0), (int)precedentPoint.getDoublePosition(1), (int)sliceCenter.getDoublePosition(0), (int)sliceCenter.getDoublePosition(1));
                } else {
                    precedentPoint = new RealPoint(2);
                }
                precedentPoint.setPosition(sliceCenter.getDoublePosition(0), 0);
                precedentPoint.setPosition(sliceCenter.getDoublePosition(1), 1);
                bdvAt3D.apply((RealLocalizable)sliceCenter, (RealPositionable)sliceCenter);
                if (i == 0) {
                    RealPoint handleLeftPoint = this.getDisplayedCenter(slice2);
                    handleLeftPoint.setPosition(this.sY / 2.0, 1);
                    bdvAt3D.apply((RealLocalizable)handleLeftPoint, (RealPositionable)handleLeftPoint);
                    this.leftPosition[0] = (int)handleLeftPoint.getDoublePosition(0);
                    this.leftPosition[1] = (int)handleLeftPoint.getDoublePosition(1);
                }
                if (i != sortedSelected.size() - 1) continue;
                RealPoint handleRightPoint = this.getDisplayedCenter(slice2);
                handleRightPoint.setPosition(this.sY / 2.0, 1);
                bdvAt3D.apply((RealLocalizable)handleRightPoint, (RealPositionable)handleRightPoint);
                this.rightPosition[0] = (int)handleRightPoint.getDoublePosition(0);
                this.rightPosition[1] = (int)handleRightPoint.getDoublePosition(1);
            }
            if (sortedSelected.size() > 1) {
                this.ghs.forEach(GraphicalHandle::enable);
                g.setColor(new Color(255, 0, 255, 200));
                g.drawLine(this.leftPosition[0], this.leftPosition[1], this.rightPosition[0], this.rightPosition[1]);
            } else if (sortedSelected.size() == 1) {
                g.setColor(new Color(255, 0, 255, 200));
                g.drawLine(this.leftPosition[0], this.leftPosition[1], this.rightPosition[0], this.rightPosition[1]);
            } else {
                this.ghs.forEach(GraphicalHandle::disable);
            }
            this.ghs.forEach(gh -> gh.draw(g));
        }
        Color colorNotSelected = new Color(255, 255, 0, 64);
        Color colorSelected = new Color(0, 255, 0, 180);
        BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
        g.setStroke(dashed);
        int w = this.bdvh.getViewerPanel().getWidth();
        int h = this.bdvh.getViewerPanel().getHeight();
        slicesCopy.forEach(slice -> {
            Integer[] coordSliceCenter = this.guiState.getSliceHandleCoords((SliceSources)slice);
            RealPoint handlePoint = this.getDisplayedCenter((SliceSources)slice);
            handlePoint.setPosition(this.sY / 2.0, 1);
            bdvAt3D.apply((RealLocalizable)handlePoint, (RealPositionable)handlePoint);
            if (slice.isSelected()) {
                g.setColor(colorSelected);
            } else {
                g.setColor(colorNotSelected);
            }
            if (coordSliceCenter[0] > 0 && coordSliceCenter[0] < w && coordSliceCenter[1] > 0 && (int)handlePoint.getDoublePosition(1) < h) {
                g.drawLine(coordSliceCenter[0], Math.min(h, coordSliceCenter[1]), (int)handlePoint.getDoublePosition(0), Math.max(0, (int)handlePoint.getDoublePosition(1)));
            }
        });
    }

    private void drawCurrentSliceOverlay(Graphics2D g, List<SliceSources> slicesCopy) {
        if (this.iCurrentSlice != -1 && slicesCopy.size() > this.iCurrentSlice) {
            SliceSources slice = this.msp.getSlices().get(this.iCurrentSlice);
            g.setColor(new Color(255, 255, 255, 128));
            g.setStroke(new BasicStroke(5.0f));
            Integer[] coords = this.guiState.getSliceHandleCoords(slice);
            RealPoint sliceCenter = new RealPoint(new float[]{coords[0].intValue(), coords[1].intValue(), 0.0f});
            if (slice.isKeySlice()) {
                g.drawOval((int)sliceCenter.getDoublePosition(0) - 20, (int)sliceCenter.getDoublePosition(1) - 20, 39, 39);
            } else {
                g.drawOval((int)sliceCenter.getDoublePosition(0) - 15, (int)sliceCenter.getDoublePosition(1) - 15, 29, 29);
            }
            Integer[] c = new Integer[]{255, 255, 255, 128};
            g.setColor(new Color(c[0], c[1], c[2], c[3]));
            g.setFont(new Font("TimesRoman", 1, 18));
            g.drawString("\u25c4 \u25ba", (int)(sliceCenter.getDoublePosition(0) - 15.0), (int)(sliceCenter.getDoublePosition(1) - 20.0));
            String name = slice.getName();
            int yOffset = 20;
            if (this.mode == 1) {
                yOffset = 130;
            }
            if (slice.isKeySlice()) {
                name = name + " [Key]";
            }
            DecimalFormat df = new DecimalFormat("00.000");
            DecimalFormat df2 = new DecimalFormat(".0");
            g.drawString("Z: " + df.format(slice.getSlicingAxisPosition() - this.msp.getReslicedAtlas().getZOffset()) + " mm (Thickness: " + df2.format(slice.getThicknessInMm() * 1000.0) + " um)", 15, yOffset + 20);
            g.drawString(name, 15, yOffset);
            List<CancelableAction> actionsArray = this.msp.getActionsFromSlice(slice);
            if (actionsArray != null) {
                List<CancelableAction> actions = new ArrayList<CancelableAction>(actionsArray);
                actions = AlignerState.filterSerializedActions(actions);
                g.setFont(new Font("TimesRoman", 0, 16));
                int index = 0;
                for (CancelableAction action : actions) {
                    if (action instanceof MoveSliceAction || action instanceof CreateSliceAction) continue;
                    g.drawString(action.toString(), 15, yOffset + 5 + (index + 2) * 15);
                    ++index;
                }
            }
        }
    }

    public void addModeListener(ModeListener modeListener) {
        this.modeListeners.add(modeListener);
    }

    public void removeModeListener(ModeListener modeListener) {
        this.modeListeners.remove(modeListener);
    }

    private void drawDragAndDropRectangle(Graphics2D g, AffineTransform3D bdvAt3D) {
        int colorCode = ARGBType.rgba((int)120, (int)250, (int)50, (int)128);
        Color color = new Color(ARGBType.red((int)colorCode), ARGBType.green((int)colorCode), ARGBType.blue((int)colorCode), ARGBType.alpha((int)colorCode));
        g.setColor(color);
        RealPoint[][] ptRectWorld = new RealPoint[2][2];
        Point[][] ptRectScreen = new Point[2][2];
        for (int xp = 0; xp < 2; ++xp) {
            for (int yp = 0; yp < 2; ++yp) {
                ptRectWorld[xp][yp] = new RealPoint(3);
                RealPoint pt = ptRectWorld[xp][yp];
                pt.setPosition(this.sX * (double)(this.iSliceNoStep + xp), 0);
                pt.setPosition(this.sY * (0.5 + (double)yp), 1);
                pt.setPosition(0, 2);
                bdvAt3D.apply((RealLocalizable)pt, (RealPositionable)pt);
                ptRectScreen[xp][yp] = new Point((int)pt.getDoublePosition(0), (int)pt.getDoublePosition(1));
            }
        }
        g.drawLine(ptRectScreen[0][0].x, ptRectScreen[0][0].y, ptRectScreen[1][0].x, ptRectScreen[1][0].y);
        g.drawLine(ptRectScreen[1][0].x, ptRectScreen[1][0].y, ptRectScreen[1][1].x, ptRectScreen[1][1].y);
        g.drawLine(ptRectScreen[1][1].x, ptRectScreen[1][1].y, ptRectScreen[0][1].x, ptRectScreen[0][1].y);
        g.drawLine(ptRectScreen[0][1].x, ptRectScreen[0][1].y, ptRectScreen[0][0].x, ptRectScreen[0][0].y);
        g.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCurrentSliceListeners() {
        List<CurrentSliceListener> list = this.currentSliceListeners;
        synchronized (list) {
            Object currentSlice = this.getCurrentSlice();
            if (currentSlice instanceof SliceSources) {
                SliceSources slice = (SliceSources)currentSlice;
                this.currentSliceListeners.forEach(listener -> listener.currentSliceChanged(slice));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentSliceListener(CurrentSliceListener listener) {
        List<CurrentSliceListener> list = this.currentSliceListeners;
        synchronized (list) {
            this.currentSliceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentSliceListener(CurrentSliceListener listener) {
        List<CurrentSliceListener> list = this.currentSliceListeners;
        synchronized (list) {
            this.currentSliceListeners.remove(listener);
        }
    }

    private static /* synthetic */ void lambda$installBigDataViewerCards$33(InputPanel inputPanel) {
        inputPanel.getWidget("rotateX").refreshWidget();
        inputPanel.getWidget("rotateY").refreshWidget();
    }

    public static interface CurrentSliceListener {
        public void currentSliceChanged(SliceSources var1);
    }

    public static class ViewState {
        List<SliceGuiState.State> slicesStates;
        double[] bdvView;
        int bdvViewMode;
        int bdvSliceViewMode;
        int overlapMode;
        boolean showInfo;
        int atlasSlicingStep;
        Integer iCurrentSlice;
        double overlapFactorX = 1.0;
        double overlapFactorY = 1.0;
    }

    class SynchronizedSliceGuiState {
        private final Map<SliceSources, SliceGuiState> sliceGuiState = new ConcurrentHashMap<SliceSources, SliceGuiState>();

        SynchronizedSliceGuiState() {
        }

        synchronized void created(SliceSources slice) {
            this.sliceGuiState.put(slice, new SliceGuiState(BdvMultislicePositionerView.this, slice, BdvMultislicePositionerView.this.bdvh));
            SliceGuiState.FilterDisplay fd = iChannel -> {
                if (BdvMultislicePositionerView.this.mode == 1) {
                    return slice.equals(BdvMultislicePositionerView.this.getCurrentSlice());
                }
                switch (BdvMultislicePositionerView.this.sliceDisplayMode) {
                    case 2: {
                        return false;
                    }
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return slice.equals(BdvMultislicePositionerView.this.getCurrentSlice());
                    }
                }
                return false;
            };
            this.sliceGuiState.get(slice).addDisplayFilters(fd);
            this.sliceGuiState.get(slice).created();
        }

        synchronized void deleted(SliceSources slice) {
            this.sliceGuiState.get(slice).deleted();
            this.sliceGuiState.remove(slice);
        }

        int nSlices() {
            return this.sliceGuiState.values().size();
        }

        void forEachSlice(Consumer<SliceGuiState> consumer) {
            this.sliceGuiState.values().forEach(consumer);
        }

        void forEachSelectedSlice(Consumer<SliceGuiState> consumer) {
            this.sliceGuiState.values().stream().filter(sliceGuiState -> sliceGuiState.slice.isSelected()).forEach(consumer);
        }

        void runSlice(SliceSources slice, Consumer<SliceGuiState> consumer) {
            SliceGuiState slice_gui = this.sliceGuiState.get(slice);
            if (slice_gui != null) {
                consumer.accept(slice_gui);
            } else {
                logger.debug("Unavailable slice state, cannot perform operation " + consumer + " on slice " + slice);
            }
        }

        double getYShift(SliceSources slice) {
            SliceGuiState slice_gui = this.sliceGuiState.get(slice);
            if (slice_gui != null) {
                return slice_gui.getYShift();
            }
            logger.debug("Unavailable slice state, cannot perform operation getYShift on slice " + slice);
            return 0.0;
        }

        double getXShift(SliceSources slice) {
            SliceGuiState slice_gui = this.sliceGuiState.get(slice);
            if (slice_gui != null) {
                return slice_gui.getXShift();
            }
            logger.debug("Unavailable slice state, cannot perform operation getXShift on slice " + slice);
            return 0.0;
        }

        Integer[] getSliceHandleCoords(SliceSources slice) {
            SliceGuiState slice_gui = this.sliceGuiState.get(slice);
            if (slice_gui != null) {
                return slice_gui.getSliceHandleCoords();
            }
            logger.debug("Unavailable slice state, cannot perform operation getSliceHandleCoords on slice " + slice);
            return new Integer[]{0, 0, 0};
        }

        int getBdvHandleRadius(SliceSources slice) {
            SliceGuiState slice_gui = this.sliceGuiState.get(slice);
            if (slice_gui != null) {
                return slice_gui.getBdvHandleRadius();
            }
            logger.debug("Unavailable slice state, cannot perform operation getBdvHandleRadius on slice " + slice);
            return 10;
        }

        public void clear() {
            this.sliceGuiState.clear();
        }
    }

    class TransferHandler
    extends BdvTransferHandler {
        TransferHandler() {
        }

        public void updateDropLocation(TransferHandler.TransferSupport support, TransferHandler.DropLocation dl) {
            RealPoint pt3d = new RealPoint(3);
            BdvMultislicePositionerView.this.bdvh.getViewerPanel().displayToGlobalCoordinates((double)dl.getDropPoint().x, (double)dl.getDropPoint().y, (RealPositionable)pt3d);
            BdvMultislicePositionerView.this.iSliceNoStep = (int)(pt3d.getDoublePosition(0) / BdvMultislicePositionerView.this.sX);
            if (BdvMultislicePositionerView.this.bdvRepaintEnabled()) {
                BdvMultislicePositionerView.this.bdvh.getViewerPanel().getDisplay().repaint();
            }
        }

        public void importSourcesAndConverters(TransferHandler.TransferSupport support, List<SourceAndConverter<?>> sacs) {
            double slicingAxisPosition = (double)BdvMultislicePositionerView.this.iSliceNoStep * BdvMultislicePositionerView.this.msp.sizePixX * (double)((int)BdvMultislicePositionerView.this.msp.getReslicedAtlas().getStep());
            BdvMultislicePositionerView.this.msp.createSlice(sacs.toArray(new SourceAndConverter[0]), slicingAxisPosition, BdvMultislicePositionerView.this.msp.getAtlas().getMap().getAtlasPrecisionInMillimeter(), Tile.class, new Tile(-1));
        }
    }

    public static interface ModeListener {
        public void modeChanged(BdvMultislicePositionerView var1, int var2, int var3);
    }

    class InnerOverlay
    extends BdvOverlay {
        int drawCounter = 0;
        final Color color = new Color(128, 112, 50, 200);
        final Stroke stroke = new BasicStroke(4.0f);

        InnerOverlay() {
        }

        protected void draw(Graphics2D g) {
            ++this.drawCounter;
            this.drawCounter %= 21;
            List<SliceSources> slicesCopy = BdvMultislicePositionerView.this.msp.getSlices();
            AffineTransform3D bdvAt3D = new AffineTransform3D();
            BdvMultislicePositionerView.this.bdvh.getViewerPanel().state().getViewerTransform(bdvAt3D);
            BdvMultislicePositionerView.this.drawDragAndDropRectangle(g, bdvAt3D);
            BdvMultislicePositionerView.this.guiState.forEachSlice(sliceGuiState -> {
                sliceGuiState.drawGraphicalHandles(g);
                List<CancelableAction> actionsRaw = BdvMultislicePositionerView.this.msp.getActionsFromSlice(sliceGuiState.slice);
                if (actionsRaw == null) {
                    System.err.println("Error : actions null for slice " + sliceGuiState.slice);
                } else {
                    ArrayList<CancelableAction> actions = new ArrayList<CancelableAction>(actionsRaw);
                    Integer[] pos = sliceGuiState.getSliceHandleCoords();
                    if (actions != null) {
                        int iPos = 0;
                        int totalNumberOfRegistration = 0;
                        for (CancelableAction action : actions) {
                            if (action.isHidden() || !(action instanceof RegisterSliceAction) || !action.getSliceSources().getActionState(action).equals("(done)")) continue;
                            ++totalNumberOfRegistration;
                        }
                        int countNumberOfRegistration = 0;
                        for (CancelableAction action : actions) {
                            if (action.isHidden()) continue;
                            ++iPos;
                            if (action instanceof RegisterSliceAction) {
                                if (totalNumberOfRegistration - BdvMultislicePositionerView.this.registrationStepBack < ++countNumberOfRegistration) {
                                    if (action.getSliceSources().getActionState(action).equals("(done)")) {
                                        action.drawAction(g, pos[0].intValue(), pos[1] + iPos * 10, 0.85);
                                        continue;
                                    }
                                    action.drawAction(g, pos[0].intValue(), pos[1] + iPos * 10, 1.2);
                                    continue;
                                }
                                action.drawAction(g, pos[0].intValue(), pos[1] + iPos * 10, 1.2);
                                continue;
                            }
                            action.drawAction(g, pos[0].intValue(), pos[1] + iPos * 10, 1.0);
                        }
                    }
                }
            });
            BdvMultislicePositionerView.this.drawCurrentSliceOverlay(g, slicesCopy);
            if (BdvMultislicePositionerView.this.mode == 0) {
                BdvMultislicePositionerView.this.drawSetOfSliceControls(g, bdvAt3D, slicesCopy);
            }
            if (BdvMultislicePositionerView.this.selectionLayer != null) {
                BdvMultislicePositionerView.this.selectionLayer.draw(g);
            }
            if (BdvMultislicePositionerView.this.showAtlasPosition) {
                BdvMultislicePositionerView.this.drawAtlasPosition(g);
            }
            if (BdvMultislicePositionerView.this.showSliceInfo) {
                BdvMultislicePositionerView.this.drawSliceInfo(g, slicesCopy);
            }
            int w = BdvMultislicePositionerView.this.bdvh.getViewerPanel().getWidth();
            int h = BdvMultislicePositionerView.this.bdvh.getViewerPanel().getHeight();
            g.setColor(this.color);
            g.setStroke(this.stroke);
            if (BdvMultislicePositionerView.this.msp.getNumberOfTasks() > 0) {
                g.drawString("" + BdvMultislicePositionerView.this.msp.getNumberOfTasks(), w - 30 - 4, h - 18 - 4);
                if (this.drawCounter <= 10) {
                    g.drawArc(w - 54, h - 54, 50, 50, 0, this.drawCounter * 36);
                } else {
                    g.drawArc(w - 54, h - 54, 50, 50, (this.drawCounter - 10) * 36, 360 - (this.drawCounter - 10) * 36);
                }
            }
            if (BdvMultislicePositionerView.this.msp.isModifiedSinceLastSave()) {
                g.drawString("Modified since last save!", 5, h - 15);
            } else {
                g.drawString("No modification", 5, h - 15);
            }
        }
    }
}

