/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui.bdv;

import bdv.util.BdvHandle;
import ch.epfl.biop.atlas.aligner.ABBAHelper;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.command.ABBAStartCommand;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import ch.epfl.biop.atlas.struct.Atlas;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.scijava.Initializable;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.supplier.DefaultBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.SerializableBdvOptions;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>ABBA - Align Big Brains and Atlases (BDV)", description="Starts ABBA from an Atlas with a BDV View")
public class ABBABdvStartCommand
implements Command,
Initializable {
    @Parameter
    public Atlas ba;
    @Parameter
    CommandService cs;
    @Parameter(type=ItemIO.OUTPUT)
    BdvMultislicePositionerView view;
    @Parameter
    ObjectService os;

    public void run() {
        try {
            MultiSlicePositioner mp = (MultiSlicePositioner)((CommandModule)this.cs.run(ABBAStartCommand.class, true, new Object[]{"ba", this.ba}).get()).getOutput("mp");
            if (mp == null) {
                System.err.println("Error - could not create multislicepositioner.");
                return;
            }
            BdvHandle bdvh = new DefaultBdvSupplier(new SerializableBdvOptions()).get();
            this.view = new BdvMultislicePositionerView(mp, bdvh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean showWarningMessageWithCheckbox(String title, String message) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(message);
        panel.add(label);
        JCheckBox skipCheckbox = new JCheckBox("Skip this warning");
        panel.add(skipCheckbox);
        int result = JOptionPane.showConfirmDialog(null, panel, title, -1, 2);
        return result == 0 && skipCheckbox.isSelected();
    }

    public void initialize() {
        ABBAHelper.displayABBALogo(1500);
    }
}

