/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.gui;

import ch.epfl.biop.atlas.aligner.DeleteLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.DeleteSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.KeySliceOffAction;
import ch.epfl.biop.atlas.aligner.action.KeySliceOnAction;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesEditLastCommand;
import ch.epfl.biop.atlas.aligner.gui.bdv.BdvMultislicePositionerView;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.scijava.command.CommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceSourcesPopupMenu {
    protected static Logger logger = LoggerFactory.getLogger(SliceSourcesPopupMenu.class);
    private JPopupMenu popup;
    private final Supplier<Collection<SliceSources>> slices;
    final MultiSlicePositioner mp;
    final BdvMultislicePositionerView view;

    public SliceSourcesPopupMenu(MultiSlicePositioner mp, BdvMultislicePositionerView view, Supplier<Collection<SliceSources>> slices) {
        this.slices = slices;
        this.mp = mp;
        this.view = view;
        this.createPopupMenu();
    }

    public static JPopupMenu createFinalPopupMenu(MultiSlicePositioner mp, BdvMultislicePositionerView view) {
        JPopupMenu popup = new JPopupMenu();
        SliceSourcesPopupMenu.addPopupAction(popup, "Set as Key Slice(s)", () -> {
            SliceSources[] slices = mp.getSelectedSlices().toArray(new SliceSources[0]);
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
            for (SliceSources slice : slices) {
                new KeySliceOnAction(mp, slice).runRequest();
            }
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
        });
        SliceSourcesPopupMenu.addPopupAction(popup, "Remove Key Slice(s)", () -> {
            SliceSources[] slices = mp.getSelectedSlices().toArray(new SliceSources[0]);
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
            for (SliceSources slice : slices) {
                new KeySliceOffAction(mp, slice).runRequest();
            }
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
        });
        SliceSourcesPopupMenu.addPopupAction(popup, "Remove Selected Slices ", () -> {
            SliceSources[] slices = mp.getSelectedSlices().toArray(new SliceSources[0]);
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
            for (SliceSources slice : slices) {
                new DeleteSliceAction(mp, slice).runRequest();
            }
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
        });
        popup.addSeparator();
        SliceSourcesPopupMenu.addPopupAction(popup, "Edit Last Registration", () -> ((CommandService)mp.getContext().getService(CommandService.class)).run(RegisterSlicesEditLastCommand.class, true, new Object[]{"mp", mp}));
        SliceSourcesPopupMenu.addPopupAction(popup, "Remove Last Registration", () -> {
            SliceSources[] slices = mp.getSelectedSlices().toArray(new SliceSources[0]);
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
            for (SliceSources slice : slices) {
                new DeleteLastRegistrationAction(mp, slice).runRequest();
            }
            if (slices.length > 1) {
                new MarkActionSequenceBatchAction(mp).runRequest();
            }
        });
        popup.addSeparator();
        SliceSourcesPopupMenu.addPopupAction(popup, "Undo Last Action", mp::cancelLastAction);
        SliceSourcesPopupMenu.addPopupAction(popup, "Redo Last Action", mp::redoAction);
        popup.addSeparator();
        SliceSourcesPopupMenu.addPopupAction(popup, "Positioning mode", () -> view.setDisplayMode(0));
        SliceSourcesPopupMenu.addPopupAction(popup, "Registration mode", () -> view.setDisplayMode(1));
        SliceSourcesPopupMenu.addPopupAction(popup, "Change overlap mode", view::toggleOverlap);
        return popup;
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        if (this.slices.get().size() > 0) {
            this.addPopupAction("Set as Key Slice(s)", slices -> {
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
                for (SliceSources slice : slices) {
                    new KeySliceOnAction(this.mp, slice).runRequest();
                }
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
            });
            this.addPopupAction("Remove Key Slice(s)", slices -> {
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
                for (SliceSources slice : slices) {
                    new KeySliceOffAction(this.mp, slice).runRequest();
                }
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
            });
            this.addPopupAction("Remove Selected Slices (" + this.slices.get().size() + ")", slices -> {
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
                for (SliceSources slice : slices) {
                    new DeleteSliceAction(this.mp, slice).runRequest();
                }
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
            });
            this.addPopupLine();
            this.addPopupAction("Edit Last Registration", slices -> ((CommandService)this.mp.getContext().getService(CommandService.class)).run(RegisterSlicesEditLastCommand.class, true, new Object[]{"mp", this.mp}));
            this.addPopupAction("Remove Last Registration", slices -> {
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
                for (SliceSources slice : slices) {
                    new DeleteLastRegistrationAction(this.mp, slice).runRequest();
                }
                if (((SliceSources[])slices).length > 1) {
                    new MarkActionSequenceBatchAction(this.mp).runRequest();
                }
            });
        }
        this.addPopupLine();
        if (this.mp.userActionsSize() > 0) {
            this.addPopupAction("Undo " + this.mp.getUndoMessage(), slices -> this.mp.cancelLastAction());
        }
        if (this.mp.redoableUserActionsSize() > 0) {
            this.addPopupAction("Redo " + this.mp.getRedoMessage(), slices -> this.mp.redoAction());
        }
        this.addPopupLine();
        if (this.view.getDisplayMode() != 0) {
            this.addPopupAction("Positioning mode", slices -> this.view.setDisplayMode(0));
        }
        if (this.view.getDisplayMode() != 1) {
            this.addPopupAction("Review mode", slices -> this.view.setDisplayMode(1));
        }
        this.addPopupAction("Change overlap mode", slices -> this.view.toggleOverlap());
    }

    public void addPopupLine() {
        this.popup.addSeparator();
    }

    public void addPopupAction(String actionName, Consumer<SliceSources[]> action) {
        if (action == null) {
            System.err.println("No action defined for action named " + actionName);
        }
        JMenuItem menuItem = new JMenuItem(actionName);
        menuItem.addActionListener(e -> action.accept(this.slices.get().toArray(new SliceSources[0])));
        this.popup.add(menuItem);
    }

    public static void addPopupAction(JPopupMenu popup, String actionName, Runnable runnable) {
        JMenuItem menuItem = new JMenuItem(actionName);
        menuItem.addActionListener(e -> runnable.run());
        popup.add(menuItem);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }
}

