/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ij.IJ;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.collections.CollectionUtils;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Edit>ABBA - Interactive Transform", description="To use at the beginning of the registration process only! Rotates, scales, translate the original unregistered selected slices")
public class SliceAffineTransformCommand
extends InteractiveCommand
implements MultiSlicePositioner.MultiSlicePositionerListener {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Rotation axis", choices={"Z", "Y", "X"})
    String axis_string;
    @Parameter(label="Angle (degrees)", style="slider,format:0.00,", min="-180.0", max="180.0", stepSize="0.25", persist=false)
    double angle_degrees = Double.MIN_VALUE;
    @Parameter(label="Scale X", style="slider,format:0.00", min="0.2", max="5.0", stepSize="0.01", persist=false)
    double scale_X = 1.0;
    @Parameter(label="Scale Y", style="slider,format:0.00", min="0.2", max="5.0", stepSize="0.01", persist=false)
    double scale_Y = 1.0;
    @Parameter(label="Translation X (mm)", style="slider,format:0.00", min="-10.0", max="10.0", stepSize="0.025", persist=false)
    double translate_X = Double.MIN_VALUE;
    @Parameter(label="Translation Y (mm)", style="slider,format:0.00", min="-10.0", max="10.0", stepSize="0.025", persist=false)
    double translate_Y = Double.MIN_VALUE;
    @Parameter(label="Restore initial settings", callback="reset")
    Button reset;
    Map<SliceSources, AffineTransform3D> originalTransforms = null;
    Set<SliceSources> selectedSlices = null;
    boolean listenerRegistered = false;
    static int counterWarning = 0;

    public SliceAffineTransformCommand() {
        super(new String[0]);
    }

    public void run() {
        if (this.mp != null) {
            if (!this.listenerRegistered) {
                this.listenerRegistered = true;
                this.mp.addMultiSlicePositionerListener(this);
            }
            if (this.selectedSlices == null) {
                this.selectedSlices = new HashSet<SliceSources>();
                this.selectedSlices.addAll(this.mp.getSelectedSlices());
                this.originalTransforms = new HashMap<SliceSources, AffineTransform3D>();
                boolean oneRegistrationOccured = false;
                for (SliceSources slice : this.selectedSlices) {
                    this.originalTransforms.put(slice, slice.getTransformSourceOrigin());
                    if (slice.getNumberOfRegistrations() == 0) continue;
                    oneRegistrationOccured = true;
                }
                if (oneRegistrationOccured) {
                    if (counterWarning == 0) {
                        this.mp.warningMessageForUser.accept("Warning", "These transformations should be applied before any registration is performed! Undo impossible after the window is closed!");
                    } else {
                        IJ.log((String)"It is advised to apply these interactive transformations before any registration is performed! Undo impossible after the window is closed!");
                    }
                    ++counterWarning;
                }
            }
            if (this.selectedSlices.size() == 0) {
                this.mp.errorMessageForUser.accept("No selected slice", "Please select a slice and rerun the function");
            } else if (!CollectionUtils.isEqualCollection(this.selectedSlices, this.mp.getSelectedSlices())) {
                this.mp.warningMessageForUser.accept("Warning: selected slices have changed!", "Please close and restart this command if you want to transform different slices. Otherwise restore the original selection");
            } else {
                double angle_rad = this.angle_degrees / 180.0 * Math.PI;
                int axis = 0;
                switch (this.axis_string) {
                    case "X": {
                        axis = 0;
                        break;
                    }
                    case "Y": {
                        axis = 1;
                        break;
                    }
                    case "Z": {
                        axis = 2;
                    }
                }
                for (SliceSources slice : this.selectedSlices) {
                    AffineTransform3D at3d = this.originalTransforms.get(slice).copy();
                    at3d.rotate(axis, angle_rad);
                    at3d.scale(this.scale_X, this.scale_Y, 1.0);
                    at3d.translate(new double[]{this.translate_X, this.translate_Y, 0.0});
                    slice.transformSourceOrigin(at3d);
                }
            }
        }
    }

    public void reset() {
        if (this.mp != null && this.selectedSlices != null) {
            this.selectedSlices.forEach(slice -> {
                AffineTransform3D at3d = this.originalTransforms.get(slice);
                slice.transformSourceOrigin(at3d);
            });
        }
        this.angle_degrees = 0.0;
        this.scale_X = 1.0;
        this.scale_Y = 1.0;
        this.translate_X = 0.0;
        this.translate_Y = 0.0;
    }

    @Override
    public void closing(MultiSlicePositioner msp) {
        if (msp == this.mp) {
            this.originalTransforms.clear();
            this.selectedSlices = null;
            this.mp = null;
        }
    }
}

