/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ij.IJ;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Edit>ABBA - Set Slices Thickness (fill gaps)", description="Modifies the selected slices thickness in such a way that no space is left between slices. This is visible only in the reconstructed volume in BigDataViewer")
public class SetSlicesThicknessMatchNeighborsCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;

    public void run() {
        List slices = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slices.size() == 0) {
            this.mp.errorMessageForUser.accept("No slice selected", "You did not select any slice to edit");
        } else {
            List<SliceSources> allSlices = this.mp.getSlices();
            if (allSlices.size() < 2) {
                this.mp.errorMessageForUser.accept("Insufficient number of slices", "You need at least two slices.");
            } else {
                for (int i = 0; i < allSlices.size(); ++i) {
                    SliceSources sliceBefore;
                    double zBegin;
                    double zEnd;
                    SliceSources currentSlice = allSlices.get(i);
                    if (!currentSlice.isSelected()) continue;
                    double currentPosition = currentSlice.getSlicingAxisPosition();
                    if (i == 0) {
                        if (i == allSlices.size() - 1) {
                            this.mp.errorMessageForUser.accept("Insufficient number of slices", "You need at least two slices.");
                            continue;
                        }
                        SliceSources sliceAfter = allSlices.get(i + 1);
                        zEnd = (sliceAfter.getSlicingAxisPosition() + currentSlice.getSlicingAxisPosition()) / 2.0;
                        zBegin = currentPosition - (zEnd - currentPosition);
                        SetSlicesThicknessMatchNeighborsCommand.setSliceThicknessWithValidation(this.mp, currentSlice, zBegin, zEnd);
                        continue;
                    }
                    if (i == allSlices.size() - 1) {
                        if (i == 0) {
                            this.mp.errorMessageForUser.accept("Insufficient number of slices", "You need at least two slices.");
                            continue;
                        }
                        sliceBefore = allSlices.get(i - 1);
                        zBegin = (sliceBefore.getSlicingAxisPosition() + currentSlice.getSlicingAxisPosition()) / 2.0;
                        zEnd = currentPosition + (currentPosition - zBegin);
                        SetSlicesThicknessMatchNeighborsCommand.setSliceThicknessWithValidation(this.mp, currentSlice, zBegin, zEnd);
                        continue;
                    }
                    sliceBefore = allSlices.get(i - 1);
                    SliceSources sliceAfter = allSlices.get(i + 1);
                    zBegin = (sliceBefore.getSlicingAxisPosition() + currentSlice.getSlicingAxisPosition()) / 2.0;
                    zEnd = (sliceAfter.getSlicingAxisPosition() + currentSlice.getSlicingAxisPosition()) / 2.0;
                    SetSlicesThicknessMatchNeighborsCommand.setSliceThicknessWithValidation(this.mp, currentSlice, zBegin, zEnd);
                }
            }
        }
    }

    private static void setSliceThicknessWithValidation(MultiSlicePositioner mp, SliceSources currentSlice, double zBegin, double zEnd) {
        double thickness = zEnd - zBegin;
        double minThickness = mp.getAtlas().getMap().getAtlasPrecisionInMillimeter();
        if (thickness < minThickness) {
            IJ.log((String)("Slice " + currentSlice.getName() + " too thin, thickness set to atlas resolution."));
            double mid = (zEnd + zBegin) / 2.0;
            zBegin = mid - minThickness / 2.0;
            zEnd = mid + minThickness / 2.0;
            currentSlice.setSliceThickness(zBegin, zEnd);
        } else {
            currentSlice.setSliceThickness(zBegin, zEnd);
        }
    }
}

