/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.sourceandconverter.exporter.IntRangeParser;
import java.util.Iterator;
import java.util.List;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Edit>ABBA - Select Slices", description="Set the slices to select.")
public class SetSlicesSelectedCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Slices to select, '*' for all slices, comma separated, 0-based")
    String slices_csv = "*";

    public void run() {
        if (this.slices_csv.trim().equals("*")) {
            this.slices_csv = "0:-1";
        }
        try {
            List indices = new IntRangeParser(this.slices_csv).get(this.mp.getSlices().size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.mp.getSlices().get(index).select();
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("Error during parsing of slice indices", e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

