/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Edit>ABBA - Set Slices Min Max Display Range", description="Change min max displayed value (for each selected slice).")
public class SetSlicesDisplayRangeCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Channels to adjust, '*' for all channels, comma separated, 0-based")
    String channels_csv = "*";
    @Parameter(label="Min displayed valued")
    double display_min;
    @Parameter(label="Max displayed valued")
    double display_max;

    public void run() {
        List slicesToModify = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slicesToModify.isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to adjust");
            return;
        }
        if (!this.channels_csv.trim().equals("*")) {
            List indices = Arrays.stream(this.channels_csv.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            slicesToModify.stream().forEach(slice -> {
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int iChannel = (Integer)iterator.next();
                    slice.setDisplayRange(iChannel, this.display_min, this.display_max);
                }
            });
        } else {
            slicesToModify.stream().forEach(slice -> {
                for (int iChannel = 0; iChannel < slice.nChannels; ++iChannel) {
                    slice.setDisplayRange(iChannel, this.display_min, this.display_max);
                }
            });
        }
    }
}

