/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;

public abstract class RegistrationSingleChannelCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Atlas channels", min="0")
    int channel_atlas;
    @Parameter(label="Slices channels", min="0")
    int channel_slice;
    protected boolean validationError = false;

    public final void run() {
        if (!this.validationError) {
            if (this.channel_atlas >= this.mp.getNumberOfAtlasChannels()) {
                this.mp.errorMessageForUser.accept("The atlas has only " + this.mp.getNumberOfAtlasChannels() + " channels!", "The atlas has only " + this.mp.getNumberOfAtlasChannels() + " channels !\n Maximum index : " + (this.mp.getNumberOfAtlasChannels() - 1));
                return;
            }
            if (this.mp.getSelectedSlices().isEmpty()) {
                this.mp.errorMessageForUser.accept("No slice selected", "Please select the slice(s) you want to register");
                return;
            }
            if (this.channel_slice >= this.mp.getChannelBoundForSelectedSlices()) {
                this.mp.errorMessageForUser.accept("Missing channel in selected slice(s).", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
                return;
            }
            this.runValidated();
        }
    }

    public abstract void runValidated();

    public SourcesProcessor getFixedFilter() {
        return new SourcesChannelsSelect(this.channel_atlas);
    }

    public SourcesProcessor getMovingFilter() {
        return new SourcesChannelsSelect(this.channel_slice);
    }
}

