/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;

public abstract class RegistrationMultiChannelCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Atlas channels (channels comma separated)")
    String channels_atlas_csv;
    @Parameter(label="Slices channels (channels comma separated)")
    String channels_slice_csv;
    protected boolean validationError = false;
    List<Integer> atlas_channels;
    List<Integer> slice_channels;

    public final void run() {
        try {
            this.atlas_channels = Arrays.stream(this.channels_atlas_csv.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            this.slice_channels = Arrays.stream(this.channels_slice_csv.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            this.mp.errorMessageForUser.accept("Error in numeric input", "Number parsing exception " + e.getMessage());
            return;
        }
        if (this.atlas_channels.isEmpty()) {
            this.mp.errorMessageForUser.accept("No Atlas channel", "Error, you did not specify any atlas channel.");
            return;
        }
        if (this.slice_channels.isEmpty()) {
            this.mp.errorMessageForUser.accept("No Slice channel", "Error, you did not specify any slice channel.");
            return;
        }
        int maxIndexAtlas = Collections.max(this.atlas_channels);
        int minIndexAtlas = Collections.min(this.atlas_channels);
        int maxIndexSlices = Collections.max(this.slice_channels);
        int minIndexSlices = Collections.min(this.slice_channels);
        if (minIndexAtlas < 0) {
            this.mp.errorMessageForUser.accept("Negative index!", "The atlas channels index should be positive");
            return;
        }
        if (minIndexSlices < 0) {
            this.mp.errorMessageForUser.accept("Negative index!", "The slices channels index should be positive");
            return;
        }
        if (!this.validationError) {
            if (maxIndexAtlas >= this.mp.getNumberOfAtlasChannels()) {
                this.mp.errorMessageForUser.accept("Issue with channels numbers", "The atlas has only " + this.mp.getNumberOfAtlasChannels() + " channels !\n Maximum index : " + (this.mp.getNumberOfAtlasChannels() - 1));
                return;
            }
            if (this.mp.getSelectedSlices().isEmpty()) {
                this.mp.errorMessageForUser.accept("No selected slice", "Please select the slice(s) you want to register");
                return;
            }
            if (maxIndexSlices >= this.mp.getChannelBoundForSelectedSlices()) {
                this.mp.errorMessageForUser.accept("Issue with channels numbers", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
                return;
            }
            this.runValidated();
        }
    }

    public abstract void runValidated();

    public SourcesProcessor getFixedFilter() {
        return new SourcesChannelsSelect(this.atlas_channels);
    }

    public SourcesProcessor getMovingFilter() {
        return new SourcesChannelsSelect(this.slice_channels);
    }
}

