/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.DeleteLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - Remove Last Registration", description="Remove the last registration of the current selected slices, if possible.")
public class RegisterSlicesRemoveLastCommand
implements Command {
    protected static final Logger logger = LoggerFactory.getLogger(RegisterSlicesRemoveLastCommand.class);
    @Parameter
    MultiSlicePositioner mp;

    public void run() {
        logger.info("Remove last registration command called.");
        if (this.mp.getSelectedSlices().isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to register");
            return;
        }
        new MarkActionSequenceBatchAction(this.mp).runRequest();
        for (SliceSources slice : this.mp.getSelectedSlices()) {
            if (!slice.isSelected()) continue;
            new DeleteLastRegistrationAction(this.mp, slice).runRequest();
        }
        new MarkActionSequenceBatchAction(this.mp).runRequest();
    }
}

