/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.command.RegistrationMultiChannelCommand;
import ch.epfl.biop.registration.sourceandconverter.affine.Elastix2DAffineRegistration;
import ch.epfl.biop.scijava.command.source.register.ElastixHelper;
import java.util.HashMap;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - Elastix Registration (Affine)", description="Uses Elastix for affine in plane registration of selected slices")
public class RegisterSlicesElastixAffineCommand
extends RegistrationMultiChannelCommand {
    @Parameter(label="Registration re-sampling (micrometers)")
    double pixel_size_micrometer = 40.0;
    @Parameter(label="Show registration results as ImagePlus")
    boolean show_imageplus_registration_result;
    @Parameter(label="Background offset value")
    double background_offset_value_moving = 0.0;
    double background_offset_value_fixed = 0.0;

    @Override
    public void runValidated() {
        if (this.atlas_channels.size() != this.slice_channels.size()) {
            this.mp.errorMessageForUser.accept("Number of channels issue", "The number of slice channel(s) should be equal to the number of atlas channel(s).");
            return;
        }
        ElastixHelper.checkOrSetLocal((Context)this.mp.getContext());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("show_image_registration", this.show_imageplus_registration_result);
        parameters.put("background_offset_value_moving", this.background_offset_value_moving);
        parameters.put("background_offset_value_fixed", this.background_offset_value_fixed);
        parameters.put("px_size_in_current_unit", this.pixel_size_micrometer / 1000.0);
        this.mp.registerSelectedSlices(Elastix2DAffineRegistration.class, this.getFixedFilter(), this.getMovingFilter(), parameters);
    }
}

