/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.DeepSliceHelper;
import ch.epfl.biop.atlas.aligner.command.RegisterSlicesDeepSliceAbstractCommand;
import ch.epfl.biop.wrappers.deepslice.DeepSlice;
import ch.epfl.biop.wrappers.deepslice.DeepSliceTaskSettings;
import java.io.File;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - DeepSlice Registration (Local)", description="Uses Deepslice for affine in plane and axial registration of selected slices")
public class RegisterSlicesDeepSliceLocalCommand
extends RegisterSlicesDeepSliceAbstractCommand {
    @Parameter(description="Try with and without ensemble to find the model which best works for you", label="Average of several models (slower)")
    boolean ensemble = false;
    public static final String KEEP_ORDER = "Keep order";
    public static final String KEEP_ORDER_REGULAR_SPACING = "Keep order + ensure regular spacing";
    public static final String KEEP_ORDER_SET_SPACING = "Keep order + set spacing (parameter below)";
    public static final String NO_POST_PROCESSING = "No post-processing";
    @Parameter(description="DeepSlice post-processing", choices={"Keep order", "Keep order + ensure regular spacing", "Keep order + set spacing (parameter below)", "No post-processing"})
    String post_processing;
    @Parameter(style="format:0.0", label="Spacing (micrometer), used only when 'Keep order + set spacing' is selected")
    double slices_spacing_micrometer = -1.0;

    @Override
    boolean setSettings() {
        DeepSliceTaskSettings settings = new DeepSliceTaskSettings();
        settings.model = this.model;
        settings.output_folder = null;
        settings.propagate_angles = true;
        settings.section_numbers = true;
        settings.ensemble = this.ensemble;
        switch (this.post_processing) {
            case "Keep order": {
                this.maintain_rank = true;
                settings.enforce_index_order = true;
                settings.use_enforce_index_spacing = false;
                settings.enforce_index_spacing = "";
                break;
            }
            case "Keep order + ensure regular spacing": {
                this.maintain_rank = true;
                settings.enforce_index_order = true;
                settings.use_enforce_index_spacing = true;
                settings.enforce_index_spacing = "None";
                break;
            }
            case "Keep order + set spacing (parameter below)": {
                this.maintain_rank = true;
                settings.enforce_index_order = true;
                settings.use_enforce_index_spacing = true;
                settings.enforce_index_spacing = Double.toString(this.slices_spacing_micrometer);
                break;
            }
            default: {
                this.maintain_rank = false;
                settings.enforce_index_order = false;
                settings.use_enforce_index_spacing = false;
                settings.enforce_index_spacing = "";
            }
        }
        if (!new File(DeepSlice.envDirPath).exists()) {
            return false;
        }
        this.deepSliceProcessor = input_folder -> {
            settings.input_folder = input_folder.getAbsolutePath();
            return DeepSliceHelper.deepSliceLocalRunner(settings, input_folder);
        };
        return true;
    }
}

