/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.DeepSliceHelper;
import ch.epfl.biop.atlas.aligner.LockAndRunOnceSliceAction;
import ch.epfl.biop.atlas.aligner.MoveSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import ch.epfl.biop.java.utilities.TempDirectory;
import ch.epfl.biop.quicknii.QuickNIIExporter;
import ch.epfl.biop.quicknii.QuickNIISeries;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.plugin.IRegistrationPlugin;
import ch.epfl.biop.registration.sourceandconverter.affine.AffineRegistration;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import com.google.gson.Gson;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ColorProcessor;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;

public abstract class RegisterSlicesDeepSliceAbstractCommand
implements Command {
    @Parameter(visibility=ItemVisibility.MESSAGE)
    public String message = "<html><b>Don't forget to adjust min/max display settings!</b> <br>  Almost 50% of images sent by ABBA users to DeepSlice are over-saturated. <br> (and thus, badly registered) </html>";
    @Parameter
    MultiSlicePositioner mp;
    @Parameter
    PlatformService ps;
    @Parameter
    Context ctx;
    @Parameter
    PluginService pluginService;
    @Parameter(choices={"mouse", "rat"}, label="('mouse', 'rat') Mouse or Rat ?")
    String model;
    @Parameter(label="Slices channels, 0-based, comma separated, '*' for all channels", description="'0,2' for channels 0 and 2")
    String channels = "*";
    @Parameter(label="Allow change of atlas slicing angle")
    boolean allow_slicing_angle_change = true;
    boolean allow_change_slicing_position = true;
    boolean maintain_rank = true;
    boolean affine_transform = true;
    double px_size_micron = Double.NaN;
    boolean convert_to_8_bits = false;
    boolean convert_to_jpg = true;
    boolean interpolate = false;
    String image_name_prefix = "Section";
    File dataset_folder;
    Function<File, File> deepSliceProcessor = null;
    QuickNIISeries series;

    public void run() {
        List indices;
        int maxIndex;
        List iniList = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        ArrayList slicesToRegister = new ArrayList();
        for (int i = iniList.size() - 1; i >= 0; --i) {
            slicesToRegister.add(iniList.get(i));
        }
        if (slicesToRegister.isEmpty()) {
            this.mp.errorMessageForUser.accept("No selected slice", "Please select the slice(s) you want to register");
            return;
        }
        if (!this.channels.trim().equals("*") && (maxIndex = (indices = Arrays.stream(this.channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList())).stream().mapToInt(e -> e).max().getAsInt()) >= this.mp.getChannelBoundForSelectedSlices()) {
            this.mp.errorMessageForUser.accept("Missing channel in selected slice(s).", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
            return;
        }
        this.setPixelSizeFromModel();
        TempDirectory td = new TempDirectory("deepslice");
        this.dataset_folder = td.getPath().toFile();
        td.deleteOnExit();
        if (!this.setSettings()) {
            return;
        }
        HashMap newAxisPosition = new HashMap();
        HashMap newSliceRegistration = new HashMap();
        for (SliceSources slice : slicesToRegister) {
            newAxisPosition.put(slice, new DeepSliceHelper.Holder());
            newSliceRegistration.put(slice, new DeepSliceHelper.Holder());
        }
        Supplier<Boolean> deepSliceRunner = () -> {
            this.exportDownsampledDataset(slicesToRegister);
            File deepSliceResult = this.deepSliceProcessor.apply(this.dataset_folder);
            if (!deepSliceResult.exists()) {
                this.mp.errorMessageForUser.accept("Deep Slice registration aborted", "Could not find DeepSlice result file " + deepSliceResult.getAbsolutePath());
                return false;
            }
            try {
                this.series = (QuickNIISeries)new Gson().fromJson((Reader)new FileReader(deepSliceResult.getAbsolutePath()), QuickNIISeries.class);
            }
            catch (Exception e) {
                this.mp.errorMessageForUser.accept("Deep Slice Command error", "Could not parse json file " + deepSliceResult.getAbsolutePath());
                e.printStackTrace();
                return false;
            }
            if (this.series.slices.size() != slicesToRegister.size()) {
                this.mp.errorMessageForUser.accept("Deep Slice Command error", "Please retry the command, DeepSlice returned less images than present in the input (" + (slicesToRegister.size() - this.series.slices.size()) + " missing) ! ");
                return false;
            }
            double nPixX = 1000.0 * this.mp.getROI()[2] / this.px_size_micron;
            double nPixY = 1000.0 * this.mp.getROI()[3] / this.px_size_micron;
            if (this.allow_slicing_angle_change) {
                this.adjustSlicingAngle(10, slicesToRegister, nPixX, nPixY);
            }
            if (this.allow_change_slicing_position) {
                this.adjustSlicesZPosition(slicesToRegister, nPixX, nPixY, newAxisPosition);
            }
            if (this.affine_transform) {
                try {
                    this.affineTransformInPlane(slicesToRegister, nPixX, nPixY, newSliceRegistration);
                }
                catch (InstantiableException e) {
                    e.printStackTrace();
                }
            }
            return true;
        };
        AtomicInteger counter = new AtomicInteger();
        counter.set(0);
        AtomicBoolean result = new AtomicBoolean();
        new MarkActionSequenceBatchAction(this.mp).runRequest();
        for (SliceSources slice : slicesToRegister) {
            new LockAndRunOnceSliceAction(this.mp, slice, counter, slicesToRegister.size(), deepSliceRunner, result).runRequest(true);
            if (this.allow_change_slicing_position) {
                new MoveSliceAction(this.mp, slice, (Supplier)newAxisPosition.get(slice)).runRequest(true);
            }
            if (!this.affine_transform) continue;
            DeepSliceHelper.Holder regSupplier = (DeepSliceHelper.Holder)newSliceRegistration.get(slice);
            new RegisterSliceAction(this.mp, slice, regSupplier, SourcesProcessorHelper.Identity(), SourcesProcessorHelper.Identity()).runRequest(true);
        }
        new MarkActionSequenceBatchAction(this.mp).runRequest();
    }

    abstract boolean setSettings();

    protected void adjustSlicingAngle(int nIterations, List<SliceSources> slices, double nPixX, double nPixY) {
        double oldX = this.mp.getReslicedAtlas().getRotateX();
        double oldY = this.mp.getReslicedAtlas().getRotateY();
        for (int nAdjust = 0; nAdjust < nIterations; ++nAdjust) {
            AffineTransform3D toABBA = this.mp.getReslicedAtlas().getSlicingTransformToAtlas().inverse();
            double[] rxs = new double[slices.size()];
            double[] rys = new double[slices.size()];
            for (int i = 0; i < slices.size(); ++i) {
                double rx;
                QuickNIISeries.SliceInfo slice = this.series.slices.get(i);
                AffineTransform3D toCCFv3 = QuickNIISeries.getTransform(this.mp.getReslicedAtlas().ba.getName(), slice, nPixX, nPixY);
                AffineTransform3D nonFlat = toCCFv3.preConcatenate(toABBA);
                double zx = nonFlat.get(2, 0);
                double zy = nonFlat.get(2, 1);
                double zz = nonFlat.get(2, 2);
                double zNorm = Math.sqrt(zx * zx + zy * zy + zz * zz);
                zz /= zNorm;
                double ry = Math.asin(zx /= zNorm);
                rxs[i] = rx = Math.asin(zy /= zNorm);
                rys[i] = ry;
            }
            this.mp.getReslicedAtlas().setRotateY(this.mp.getReslicedAtlas().getRotateY() - DeepSliceHelper.getMedian(rys) / 2.0);
            this.mp.getReslicedAtlas().setRotateX(this.mp.getReslicedAtlas().getRotateX() + DeepSliceHelper.getMedian(rxs) / 2.0);
        }
        String angleUpdatedMessage = "";
        DecimalFormat df = new DecimalFormat("#0.000");
        angleUpdatedMessage = angleUpdatedMessage + "Angle X : " + oldX + " has been updated to " + df.format(this.mp.getReslicedAtlas().getRotateX()) + "\n";
        angleUpdatedMessage = angleUpdatedMessage + "Angle Y : " + oldY + " has been updated to " + df.format(this.mp.getReslicedAtlas().getRotateY()) + "\n";
        this.mp.infoMessageForUser.accept("Slicing angle channged", "Slicing angle adjusted to " + angleUpdatedMessage);
    }

    protected void adjustSlicesZPosition(List<SliceSources> slices, double nPixX, double nPixY, Map<SliceSources, DeepSliceHelper.Holder<Double>> newAxisPosition) {
        String regex = "(.*)" + this.image_name_prefix + "_s([0-9]+).*";
        Pattern pattern = Pattern.compile(regex, 8);
        HashMap<SliceSources, Double> slicesNewPosition = new HashMap<SliceSources, Double>();
        AffineTransform3D toABBA = this.mp.getReslicedAtlas().getSlicingTransformToAtlas().inverse();
        for (int i2 = 0; i2 < slices.size(); ++i2) {
            QuickNIISeries.SliceInfo slice = this.series.slices.get(i2);
            Matcher matcher = pattern.matcher(slice.filename);
            matcher.find();
            int iSliceSource = Integer.parseInt(matcher.group(2));
            AffineTransform3D toCCFv3 = QuickNIISeries.getTransform(this.mp.getReslicedAtlas().ba.getName(), slice, nPixX, nPixY);
            AffineTransform3D nonFlat = toCCFv3.preConcatenate(toABBA);
            double zLocation = nonFlat.get(2, 3);
            slicesNewPosition.put(slices.get(iSliceSource), zLocation);
        }
        HashMap<Integer, SliceSources> mapNewRankToSlices = new HashMap<Integer, SliceSources>();
        if (this.maintain_rank) {
            int biggestRankDifference = -1;
            int indexOfSliceWithBiggestRankDifference = -1;
            int targetIndex = -1;
            int direction = 0;
            while (biggestRankDifference != 0) {
                int i3;
                Integer[] indicesNewlyOrdered = new Integer[slices.size()];
                for (i3 = 0; i3 < indicesNewlyOrdered.length; ++i3) {
                    indicesNewlyOrdered[i3] = i3;
                }
                Arrays.sort(indicesNewlyOrdered, Comparator.comparingDouble(i -> -1.0 * (Double)slicesNewPosition.get(slices.get((int)i))));
                for (i3 = 0; i3 < indicesNewlyOrdered.length; ++i3) {
                    mapNewRankToSlices.put(i3, slices.get(indicesNewlyOrdered[i3]));
                }
                biggestRankDifference = 0;
                for (i3 = 0; i3 < indicesNewlyOrdered.length; ++i3) {
                    int abs = Math.abs(i3 - indicesNewlyOrdered[i3]);
                    if (abs <= biggestRankDifference) continue;
                    biggestRankDifference = abs;
                    indexOfSliceWithBiggestRankDifference = indicesNewlyOrdered[i3];
                    targetIndex = indicesNewlyOrdered[i3];
                    direction = i3 - indicesNewlyOrdered[i3];
                }
                if (biggestRankDifference == 0) continue;
                double targetLocation = (Double)slicesNewPosition.get(mapNewRankToSlices.get(targetIndex));
                if (direction < 0) {
                    targetLocation -= this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter() / 10.0;
                }
                if (direction > 0) {
                    targetLocation += this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter() / 10.0;
                }
                slicesNewPosition.put(slices.get(indexOfSliceWithBiggestRankDifference), targetLocation);
            }
        }
        for (SliceSources slice : slices) {
            newAxisPosition.get(slice).accept((Double)slicesNewPosition.get(slice));
        }
    }

    protected void affineTransformInPlane(List<SliceSources> slices, double nPixX, double nPixY, Map<SliceSources, DeepSliceHelper.Holder<Registration<SourceAndConverter<?>[]>>> newSliceTransform) throws InstantiableException {
        AffineTransform3D toABBA = this.mp.getReslicedAtlas().getSlicingTransformToAtlas().inverse();
        String regex = "(.*)" + this.image_name_prefix + "_s([0-9]+).*";
        Pattern pattern = Pattern.compile(regex, 8);
        for (int i = 0; i < slices.size(); ++i) {
            QuickNIISeries.SliceInfo slice = this.series.slices.get(i);
            AffineTransform3D toCCFv3 = QuickNIISeries.getTransform(this.mp.getReslicedAtlas().ba.getName(), slice, nPixX, nPixY);
            AffineTransform3D flat = toCCFv3.preConcatenate(toABBA);
            flat.set(0.0, 2, 0);
            flat.set(0.0, 2, 1);
            flat.set(1.0, 2, 2);
            flat.set(0.0, 2, 3);
            AffineTransform3D preTransform = new AffineTransform3D();
            preTransform.scale(1000.0 / this.px_size_micron);
            preTransform.set(1.0, 2, 2);
            preTransform.set(-1000.0 / this.px_size_micron * this.mp.getROI()[0], 0, 3);
            preTransform.set(-1000.0 / this.px_size_micron * this.mp.getROI()[1], 1, 3);
            Matcher matcher = pattern.matcher(slice.filename);
            matcher.find();
            int iSliceSource = Integer.parseInt(matcher.group(2));
            IRegistrationPlugin registration = (IRegistrationPlugin)this.pluginService.getPlugin(AffineRegistration.class).createInstance();
            registration.setScijavaContext(this.ctx);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            AffineTransform3D inPlaneTransform = new AffineTransform3D();
            inPlaneTransform.set(flat);
            inPlaneTransform.concatenate(preTransform);
            parameters.put("transform", AffineRegistration.affineTransform3DToString((AffineTransform3D)inPlaneTransform));
            parameters.put("pz", 0);
            AffineTransform3D at3d = new AffineTransform3D();
            at3d.translate(new double[]{0.0, 0.0, -slices.get(iSliceSource).getSlicingAxisPosition()});
            registration.setRegistrationParameters(MultiSlicePositioner.convertToString(this.ctx, parameters));
            newSliceTransform.get(slices.get(iSliceSource)).accept((Registration<SourceAndConverter<?>[]>)registration);
        }
    }

    protected void exportDownsampledDataset(List<SliceSources> slices) {
        SourcesProcessor preprocess = SourcesProcessorHelper.Identity();
        if (!this.channels.trim().equals("*")) {
            List indices = Arrays.stream(this.channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            preprocess = new SourcesChannelsSelect(indices);
        }
        try {
            List<String> filePaths = QuickNIIExporter.builder().roi(this.mp.getROI()).cvt8bits(this.convert_to_8_bits).jpeg(this.convert_to_jpg).setProcessor(preprocess).slices(slices).name(this.image_name_prefix).folder(this.dataset_folder).pixelSizeMicron(this.px_size_micron).interpolate(this.interpolate).create().export();
            double ratioSaturatedPixelValueThreshold = 0.02;
            String message = "";
            int iSaturatedCounter = 0;
            for (int i = 0; i < filePaths.size(); ++i) {
                double saturationForImage = RegisterSlicesDeepSliceAbstractCommand.calculateSaturatedPixelRatio(IJ.openImage((String)filePaths.get(i)));
                if (saturationForImage > ratioSaturatedPixelValueThreshold) {
                    message = message + slices.get(i).getName() + " is saturated above " + (int)(ratioSaturatedPixelValueThreshold * 100.0) + " % (" + (int)(saturationForImage * 100.0) + "  %) \n";
                    ++iSaturatedCounter;
                }
                if (iSaturatedCounter <= 20) continue;
                message = message + "...";
                break;
            }
            if (!message.isEmpty()) {
                this.mp.warningMessageForUser.accept("Slices saturated!", "DeepSlice will run but results won't be optimal. Please change display settings to avoid saturation: \n" + message);
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("Export to Quick NII dataset error. ", e.getMessage());
        }
    }

    private void setPixelSizeFromModel() {
        if (this.model.equals("mouse")) {
            this.px_size_micron = 30.0;
        } else if (this.model.equals("rat")) {
            this.px_size_micron = 60.0;
        }
    }

    public static double calculateSaturatedPixelRatio(ImagePlus image) {
        if (!(image.getProcessor() instanceof ColorProcessor)) {
            return 0.0;
        }
        ColorProcessor processor = (ColorProcessor)image.getProcessor();
        int width = processor.getWidth();
        int height = processor.getHeight();
        int saturatedPixelCount = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = processor.getPixel(x, y);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if (red != 255 && green != 255 && blue != 255) continue;
                ++saturatedPixelCount;
            }
        }
        double totalPixels = width * height;
        return (double)saturatedPixelCount / totalPixels;
    }
}

