/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.LockAndRunOnceSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.adapter.AlignerState;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - Copy and Apply Registration", description="Copy the registration sequence of a slice and apply it to selected slices")
public class RegisterSlicesCopyAndApplyCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Index of the slice registrations you'd like to copy")
    int model_slice_index;
    @Parameter(label="Tick if you want to skip the pre-transform (probably not)")
    boolean skip_pre_transform = false;
    Gson serializer;

    public void run() {
        List<SliceSources> selectedSlices = this.mp.getSelectedSlices();
        if (selectedSlices.size() == 0) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to register");
            return;
        }
        if (this.model_slice_index < 0 || this.model_slice_index >= this.mp.getSlices().size()) {
            this.mp.warningMessageForUser.accept("Invalid model slice index", "Please enter a valid slice index.");
            return;
        }
        SliceSources modelSlice = this.mp.getSlices().get(this.model_slice_index);
        if (selectedSlices.contains(modelSlice)) {
            selectedSlices.remove(modelSlice);
            this.mp.warningMessageForUser.accept("Model slice selected!", "The registration sequence will not be applied to the model slice.");
        }
        AtomicInteger counter = new AtomicInteger(0);
        AtomicBoolean result = new AtomicBoolean();
        this.serializer = this.mp.getGsonStateSerializer(new ArrayList<SourceAndConverter>());
        new LockAndRunOnceSliceAction(this.mp, modelSlice, counter, 1, () -> {
            AlignerState.SliceSourcesState slice_state = new AlignerState.SliceSourcesState();
            slice_state.actions.addAll(AlignerState.filterSerializedActions(this.mp.getActionsFromSlice(modelSlice)));
            slice_state.preTransform = modelSlice.getTransformSourceOrigin();
            for (SliceSources slice : selectedSlices) {
                for (CancelableAction action : slice_state.actions) {
                    if (!(action instanceof RegisterSliceAction)) continue;
                    RegisterSliceAction regActionModel = this.copyReg((RegisterSliceAction)action);
                    RegisterSliceAction registerSlice = new RegisterSliceAction(this.mp, slice, regActionModel.getRegistration(), regActionModel.getFixedSourcesProcessor(), regActionModel.getMovingSourcesProcessor());
                    registerSlice.setRegistration(registerSlice.getRegistration());
                    registerSlice.runRequest();
                }
                if (this.skip_pre_transform) continue;
                slice.transformSourceOrigin(modelSlice.getTransformSourceOrigin().copy());
            }
            return true;
        }, result).runRequest();
    }

    private RegisterSliceAction copyReg(RegisterSliceAction action) {
        String regString = this.serializer.toJson((Object)action, RegisterSliceAction.class);
        return (RegisterSliceAction)this.serializer.fromJson(regString, RegisterSliceAction.class);
    }
}

