/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RasterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Edit>ABBA - Raster slice", description="Speed up the display of slices by precomputing and caching their pixel.")
public class RasterSlicesCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Pixel size (micrometer)")
    double pixel_size_micrometer = 10.0;
    @Parameter(label="Interpolate")
    boolean interpolate = false;

    public void run() {
        if (this.pixel_size_micrometer < 0.0) {
            this.mp.errorMessageForUser.accept("Raster deformation error", "Please use a positive value for the pixel size.");
            return;
        }
        List slicesToProcess = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slicesToProcess.isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to operate on");
            return;
        }
        new MarkActionSequenceBatchAction(this.mp).runRequest();
        for (SliceSources slice : slicesToProcess) {
            RasterSliceAction rasterSliceAction = new RasterSliceAction(this.mp, slice, this.pixel_size_micrometer, this.interpolate);
            rasterSliceAction.runRequest();
        }
        new MarkActionSequenceBatchAction(this.mp).runRequest();
    }
}

