/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.UnMirrorSliceAction;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import java.util.List;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - Un-Mirror Slices", description="Remove slice mirroring.")
public class MirrorUndoCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;

    public void run() {
        List<SliceSources> slices = this.mp.getSelectedSlices();
        if (slices.size() == 0) {
            this.mp.errorMessageForUser.accept("No slice selected", "You did not select any slice.");
        } else {
            new MarkActionSequenceBatchAction(this.mp).runRequest();
            for (SliceSources slice : slices) {
                new UnMirrorSliceAction(this.mp, slice).runRequest();
            }
            new MarkActionSequenceBatchAction(this.mp).runRequest();
        }
    }
}

