/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import ch.epfl.biop.registration.sourceandconverter.mirror.MirrorXRegistration;
import ch.epfl.biop.sourceandconverter.processor.SourcesIdentity;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import java.util.HashMap;
import java.util.List;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Align>ABBA - Mirror Slices", description="Mirror a half section to create the other side.")
public class MirrorDoCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(choices={"Left", "Right"})
    String mirror_side;

    public void run() {
        List<SliceSources> slicesToMirror = this.mp.getSelectedSlices();
        if (slicesToMirror.isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to mirror.");
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("mirror_side", this.mirror_side);
        new MarkActionSequenceBatchAction(this.mp).runRequest();
        this.mp.registerSelectedSlices(MirrorXRegistration.class, (SourcesProcessor)new SourcesIdentity(), (SourcesProcessor)new SourcesIdentity(), parameters);
        new MarkActionSequenceBatchAction(this.mp).runRequest();
    }
}

