/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusToSpimData;
import ij.ImagePlus;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Import>ABBA - Import Current ImageJ Window", description="Import the current ImageJ image as a slice into ABBA")
public class ImportSliceFromImagePlusCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Initial axis position (0 = front, mm units)", style="format:0.000", stepSize="0.1")
    double slice_axis_mm;
    @Parameter
    ImagePlus image;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        AbstractSpimData asd = ImagePlusToSpimData.getSpimData((ImagePlus)this.image);
        this.sac_service.register(asd);
        this.sac_service.setSpimDataName(asd, this.image.getTitle());
        SourceAndConverter[] sacs = this.sac_service.getSourceAndConverterFromSpimdata(asd).toArray(new SourceAndConverter[0]);
        this.mp.createSlice(sacs, this.slice_axis_mm);
    }
}

