/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.ExportDeformationFieldToImagePlusAction;
import ij.ImagePlus;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Atlas Channel in Original Slices Coordinates to ImageJ", description="Exports physical coordinates of the atlas in a 3 channel (x,y,z) image that matches pixels of the initial unregistered slice (for each selected slice). Resolution levels can be specified.")
public class ExportTransformedAtlasToImageJCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Channels to export, '*' for all channels")
    String atlas_channels = "*";
    @Parameter(label="Resolution level (0 = max resolution)")
    int resolution_level = 0;
    @Parameter(label="Extra DownSampling")
    int downsampling = 1;
    @Parameter(label="Max iterations in invertible transform computation (default 200)")
    int max_number_of_iterations = 200;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus[] images;

    public void run() {
        List slicesToExport = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        double tolerance = this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter();
        if (slicesToExport.isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to operate on.");
            return;
        }
        this.images = new ImagePlus[slicesToExport.size()];
        HashMap<SliceSources, ExportDeformationFieldToImagePlusAction> tasks = new HashMap<SliceSources, ExportDeformationFieldToImagePlusAction>();
        for (SliceSources slice : slicesToExport) {
            ExportDeformationFieldToImagePlusAction export = new ExportDeformationFieldToImagePlusAction(this.mp, slice, this.resolution_level, this.downsampling, 0, tolerance, this.max_number_of_iterations);
            tasks.put(slice, export);
            export.runRequest();
        }
        ImagePlus[] images = new ImagePlus[slicesToExport.size()];
        IntStream.range(0, slicesToExport.size()).parallel().forEach(i -> {
            SliceSources slice = (SliceSources)slicesToExport.get(i);
            boolean success = slice.waitForEndOfAction((CancelableAction)tasks.get(slice));
            if (success) {
                images[i] = ((ExportDeformationFieldToImagePlusAction)tasks.get(slice)).getImagePlus();
                ((ExportDeformationFieldToImagePlusAction)tasks.get(slice)).clean();
                this.mp.infoMessageForUser.accept("Export deformation field to ImagePlus", "Slice " + slice + " done (" + (i + 1) + "/" + images.length + ")");
                images[i].show();
            } else {
                this.mp.errorMessageForUser.accept("Export to ImageJ Stack error", "Error in export of slice " + slice);
            }
        });
    }
}

