/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.quicknii.QuickNIIExporter;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Registered Slices to Quick NII Dataset")
public class ExportSlicesToQuickNIIDatasetCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Pixel Size in micron")
    double px_size_micron = 40.0;
    @Parameter(label="Slices channels, 0-based, comma separated, '*' for all channels", description="'0,2' for channels 0 and 2")
    String channels = "*";
    @Parameter(label="Section Name Prefix")
    String image_name = "Section";
    @Parameter(label="QuickNII dataset folder", style="directory")
    File dataset_folder;
    @Parameter(label="Convert to 8 bit image")
    boolean convert_to_8_bits = true;
    @Parameter(label="Convert to jpg (single channel recommended)")
    boolean convert_to_jpg = true;
    @Parameter
    boolean interpolate;

    public void run() {
        List<SliceSources> slicesToExport = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        SourcesProcessor preprocess = SourcesProcessorHelper.Identity();
        if (!this.channels.trim().equals("*")) {
            List indices = Arrays.stream(this.channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            int maxIndex = indices.stream().mapToInt(e -> e).max().getAsInt();
            if (maxIndex >= this.mp.getChannelBoundForSelectedSlices()) {
                this.mp.errorMessageForUser.accept("Missing channel in selected slice(s).", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
                return;
            }
            preprocess = new SourcesChannelsSelect(indices);
        }
        try {
            QuickNIIExporter.builder().roi(this.mp.getROI()).cvt8bits(this.convert_to_8_bits).jpeg(this.convert_to_jpg).setProcessor(preprocess).slices(slicesToExport).name(this.image_name).folder(this.dataset_folder).pixelSizeMicron(this.px_size_micron).interpolate(this.interpolate).create().export();
        }
        catch (Exception e2) {
            this.mp.errorMessageForUser.accept("Export to Quick NII dataset error. ", e2.getMessage());
        }
    }
}

