/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.ExportSliceToImagePlusAction;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.java.utilities.roi.types.CompositeFloatPoly;
import ch.epfl.biop.java.utilities.roi.types.IJShapeRoiArray;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.Concatenator;
import ij.plugin.RoiScaler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scijava.Initializable;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Registered Slices to ImageJ", description="Export registered (deformed) slices in the atlas coordinates. A pixel size should be specified to resample the registered images.")
public class ExportSlicesToImageJCommand
extends DynamicCommand
implements Initializable {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Pixel Size in micron")
    double px_size_micron = 20.0;
    @Parameter(label="Slices channels, 0-based, comma separated, '*' for all channels", description="'0,2' for channels 0 and 2")
    String channels = "*";
    @Parameter(label="Atlas Roi Naming")
    String naming_choice;
    @Parameter(label="Exported image name")
    String image_name = "Untitled";
    @Parameter
    boolean interpolate;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus image;

    public void run() {
        List slicesToExport = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slicesToExport.isEmpty()) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to export");
            return;
        }
        SourcesProcessor preprocess = SourcesProcessorHelper.Identity();
        if (!this.channels.trim().equals("*")) {
            List indices = Arrays.stream(this.channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            int maxIndex = indices.stream().mapToInt(e -> e).max().getAsInt();
            if (maxIndex >= this.mp.getChannelBoundForSelectedSlices()) {
                this.mp.errorMessageForUser.accept("Missing channel in selected slice(s).", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
                return;
            }
            preprocess = new SourcesChannelsSelect(indices);
        }
        double[] roi = this.mp.getROI();
        HashMap<SliceSources, ExportSliceToImagePlusAction> tasks = new HashMap<SliceSources, ExportSliceToImagePlusAction>();
        for (SliceSources slice : slicesToExport) {
            ExportSliceToImagePlusAction export = new ExportSliceToImagePlusAction(this.mp, slice, preprocess, roi[0], roi[1], roi[2], roi[3], this.px_size_micron / 1000.0, 0, this.interpolate);
            tasks.put(slice, export);
            export.runRequest();
        }
        ImagePlus[] images = new ImagePlus[slicesToExport.size()];
        IntStream.range(0, slicesToExport.size()).parallel().forEach(i -> {
            SliceSources slice = (SliceSources)slicesToExport.get(i);
            boolean success = slice.waitForEndOfAction((CancelableAction)tasks.get(slice));
            if (success) {
                images[i] = ((ExportSliceToImagePlusAction)tasks.get(slice)).getImagePlus();
                ((ExportSliceToImagePlusAction)tasks.get(slice)).clean();
                this.mp.infoMessageForUser.accept("ImagePlus export", "Slice " + slice + " done (" + (i + 1) + "/" + images.length + ")");
                images[i].setTitle(slice.getName());
                images[i].show();
                this.addRegionsOverlay(images[i], slice);
            } else {
                this.mp.errorMessageForUser.accept("Export to ImageJ Stack error", "Error in export of slice " + slice);
            }
        });
        if (images.length > 1) {
            int iCh;
            int nChannels = images[0].getNChannels();
            Overlay concatOverlay = new Overlay();
            if (images[0].getOverlay() != null) {
                for (int i2 = 0; i2 < images.length; ++i2) {
                    Roi[] rois;
                    for (Roi aRoi : rois = images[i2].getOverlay().toArray()) {
                        aRoi.setPosition(0, i2 + 1, 1);
                        concatOverlay.add(aRoi);
                    }
                }
            }
            double[] min = new double[nChannels];
            double[] max = new double[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                images[0].setC(iCh + 1);
                min[iCh] = images[0].getProcessor().getMin();
                max[iCh] = images[0].getProcessor().getMax();
            }
            this.image = Concatenator.run((ImagePlus[])images);
            for (iCh = 0; iCh < nChannels; ++iCh) {
                this.image.setC(iCh + 1);
                this.image.setDisplayRange(min[iCh], max[iCh]);
            }
            this.image.setOverlay(concatOverlay);
            this.image.setDimensions(this.image.getNChannels(), this.image.getNFrames(), this.image.getNSlices());
            String[] labels = this.image.getStack().getSliceLabels();
            for (int iZ = 0; iZ < this.image.getNSlices(); ++iZ) {
                for (int iCh2 = 0; iCh2 < nChannels; ++iCh2) {
                    labels[iZ * this.image.getNChannels() + iCh2] = images[iZ].getTitle();
                }
            }
            this.image.draw();
        } else {
            this.image = images[0];
            this.image.draw();
        }
        this.image.setTitle(this.image_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegionsOverlay(ImagePlus image, SliceSources slice) {
        if (!this.naming_choice.equals("Do not add regions")) {
            try {
                this.mp.addTask();
                double atlas_px_in_microns = 1000.0 * this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter();
                double scale = atlas_px_in_microns / this.px_size_micron;
                image.setOverlay(new Overlay());
                IJShapeRoiArray ijRois = slice.getOriginalAtlasRegions(this.naming_choice);
                for (CompositeFloatPoly aRoi : ijRois.rois) {
                    int atlasId = Integer.parseInt(aRoi.name);
                    AtlasNode node = this.mp.getAtlas().getOntology().getNodeFromId(atlasId);
                    Roi atlas_roi = aRoi.getRoi();
                    atlas_roi.setName((String)node.data().get(this.naming_choice));
                    int[] color = node.getColor();
                    atlas_roi.setStrokeColor(new Color(color[0], color[1], color[2], color[3]));
                    double dxInUm = -(-this.mp.sX / 2.0 - this.mp.getROI()[0]) * 1000.0;
                    double dyInUm = -(-this.mp.sY / 2.0 - this.mp.getROI()[1]) * 1000.0;
                    atlas_roi.setLocation(atlas_roi.getXBase() - dxInUm / atlas_px_in_microns, atlas_roi.getYBase() - dyInUm / atlas_px_in_microns);
                    atlas_roi = RoiScaler.scale((Roi)atlas_roi, (double)scale, (double)scale, (boolean)false);
                    if (atlas_roi != null) {
                        image.getOverlay().add(atlas_roi);
                        continue;
                    }
                    this.mp.errorMessageForUser.accept("Error in ROI export", "Region " + aRoi.name + " is null!");
                }
            }
            finally {
                this.mp.removeTask();
            }
        }
    }

    public void initialize() {
        MutableModuleItem naming_choice = this.getInfo().getMutableInput("naming_choice", String.class);
        ArrayList names = new ArrayList(this.mp.getAtlas().getOntology().getRoot().data().keySet());
        names.add(0, "Do not add regions");
        naming_choice.setChoices(names);
    }
}

