/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.util.BdvHandle;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.gui.bdv.SliceGuiState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Registered Slices to BDV", description="Export registered slices to a BigDataViewer window.")
public class ExportSlicesToBDVCommand
implements Command {
    @Parameter(label="Enter a tag to identify the registered sources (metadata key = \"ABBA\")")
    String tag;
    @Parameter
    MultiSlicePositioner mp;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        this.mp.infoMessageForUser.accept("", "Waiting for the end of all current tasks...");
        this.mp.waitForTasks();
        this.mp.infoMessageForUser.accept("", "All tasks ended");
        List<SliceSources> slices = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slices.size() == 0) {
            this.mp.errorMessageForUser.accept("No slice selected", "You did not select any slice to export");
        } else {
            ArrayList sacsToAppend = new ArrayList();
            AffineTransform3D at3D = this.mp.getAffineTransformFromAlignerToAtlas();
            SourceAffineTransformer sat = new SourceAffineTransformer(null, at3D);
            slices.forEach(slice -> {
                for (SourceAndConverter<?> sac : slice.getRegisteredSources()) {
                    SourceAndConverter source = sat.apply(ExportSlicesToBDVCommand.alphaCulledSources(new SourceAndConverter[]{sac}, slice.getAlpha())[0]);
                    this.sac_service.register(source);
                    this.sac_service.setMetadata(source, "ABBA", (Object)this.tag);
                    sacsToAppend.add(source);
                }
            });
            BdvHandle bdvh = SourceAndConverterServices.getBdvDisplayService().getNewBdv();
            SourceAndConverterServices.getBdvDisplayService().show(bdvh, sacsToAppend.toArray(new SourceAndConverter[0]));
        }
    }

    private static SourceAndConverter[] alphaCulledSources(SourceAndConverter[] sources, IAlphaSource alpha) {
        SourceAndConverter[] alphaCulled = new SourceAndConverter[sources.length];
        for (int i = 0; i < alphaCulled.length; ++i) {
            SourceAndConverter sac;
            SourceAndConverter ori = sources[i];
            alphaCulled[i] = ori.asVolatile() != null ? (sac = new SourceAndConverter(new SliceGuiState.AlphaCulledSource(ori.getSpimSource(), alpha), ori.getConverter(), new SourceAndConverter(new SliceGuiState.AlphaCulledSource(ori.asVolatile().getSpimSource(), alpha), ori.asVolatile().getConverter()))) : (sac = new SourceAndConverter(new SliceGuiState.AlphaCulledSource(ori.getSpimSource(), alpha), ori.getConverter()));
        }
        return alphaCulled;
    }
}

