/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusGetter;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import ij.ImagePlus;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Original Slices to ImageJ", description="Export to ImageJ the original unregistered slice data (for each selected slice).If the image has more than 2GPixels, this will fail. Resolution levels can be specified.")
public class ExportSlicesOriginalDataToImageJCommand<T extends NativeType<T> & NumericType<T>>
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Slices channels, 0-based, comma separated, '*' for all channels", description="'0,2' for channels 0 and 2")
    String channels = "*";
    @Parameter(label="Resolution level (0 = max resolution)")
    int resolution_level = 0;
    @Parameter(label="verbose")
    boolean verbose = false;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus[] images;

    public void run() {
        List slicesToExport = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (slicesToExport.size() == 0) {
            this.mp.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to export");
            return;
        }
        SourcesProcessor preprocess = SourcesProcessorHelper.Identity();
        if (!this.channels.trim().equals("*")) {
            List indices = Arrays.stream(this.channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            int maxIndex = indices.stream().mapToInt(e -> e).max().getAsInt();
            if (maxIndex >= this.mp.getChannelBoundForSelectedSlices()) {
                this.mp.errorMessageForUser.accept("Missing channel in selected slice(s).", "Missing channel in selected slice(s)\n One selected slice only has " + this.mp.getChannelBoundForSelectedSlices() + " channel(s).\n Maximum index : " + (this.mp.getChannelBoundForSelectedSlices() - 1));
                return;
            }
            preprocess = new SourcesChannelsSelect(indices);
        }
        this.images = new ImagePlus[slicesToExport.size()];
        try {
            int index = 0;
            for (SliceSources slice : slicesToExport) {
                List<Object> sliceSources = Arrays.asList((Object[])preprocess.apply(slice.getOriginalSources()));
                CZTRange range = ImagePlusGetter.fromSources(sliceSources, (int)0, (int)this.resolution_level);
                List castSources = sliceSources.stream().map(source -> source).collect(Collectors.toList());
                this.images[index] = ImagePlusGetter.getImagePlus((String)((SourceAndConverter)sliceSources.get(0)).getSpimSource().getName(), castSources, (int)this.resolution_level, (CZTRange)range, (boolean)this.verbose, (boolean)false, (boolean)false, null);
                this.images[index].show();
                ++index;
            }
        }
        catch (Exception e2) {
            this.mp.errorMessageForUser.accept("Error in slices export", "Reason:" + e2.getMessage() + " \n Please also check the stack trace.");
            e2.printStackTrace();
        }
    }
}

