/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.ExportSliceRegionsToFileAction;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.scijava.Initializable;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Regions To File", description="Export the transformed atlas regions of currently selected slices as ImageJ roi zip files.")
public class ExportRegionsToRoisetFileCommand
extends DynamicCommand
implements Initializable {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Roi Naming")
    String naming_choice;
    @Parameter(label="Directory for ROI Saving", style="directory")
    File dir_output;
    @Parameter(label="Erase Previous ROIs")
    boolean erase_previous_file;

    public void run() {
        List<SliceSources> slices = this.mp.getSelectedSlices();
        if (slices.size() == 0) {
            this.mp.errorMessageForUser.accept("No slice selected", "You did not select any slice.");
        } else {
            new MarkActionSequenceBatchAction(this.mp).runRequest();
            for (SliceSources slice : slices) {
                new ExportSliceRegionsToFileAction(this.mp, slice, this.naming_choice, this.dir_output, this.erase_previous_file).runRequest();
            }
            new MarkActionSequenceBatchAction(this.mp).runRequest();
        }
    }

    public void initialize() {
        MutableModuleItem naming_choice = this.getInfo().getMutableInput("naming_choice", String.class);
        ArrayList names = new ArrayList(this.mp.getAtlas().getOntology().getRoot().data().keySet());
        naming_choice.setChoices(names);
    }
}

