/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.ExportSliceRegionsToRoiManagerAction;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import java.util.ArrayList;
import java.util.List;
import org.scijava.Initializable;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Regions To Roi Manager", description="Export atlas regions to ROI Manager (for each selected slice).")
public class ExportRegionsToRoiManagerCommand
extends DynamicCommand
implements Initializable {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Roi Naming")
    String naming_choice;

    public void run() {
        List<SliceSources> slices = this.mp.getSelectedSlices();
        if (slices.size() == 0) {
            this.mp.errorMessageForUser.accept("No slice selected", "You did not select any slice.");
        } else {
            new MarkActionSequenceBatchAction(this.mp).runRequest();
            for (SliceSources slice : slices) {
                new ExportSliceRegionsToRoiManagerAction(this.mp, slice, this.naming_choice).runRequest();
            }
            new MarkActionSequenceBatchAction(this.mp).runRequest();
        }
    }

    public void initialize() {
        MutableModuleItem naming_choice = this.getInfo().getMutableInput("naming_choice", String.class);
        ArrayList names = new ArrayList(this.mp.getAtlas().getOntology().getRoot().data().keySet());
        naming_choice.setChoices(names);
    }
}

