/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.action.ExportAtlasSliceToImagePlusAction;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import ij.ImagePlus;
import ij.plugin.Concatenator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Export>ABBA - Export Atlas to ImageJ", description="Export atlas properties as an ImageJ stack (for each selected slice).")
public class ExportAtlasToImageJCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(label="Pixel Size in micron")
    double px_size_micron = 20.0;
    @Parameter(label="Channels to export, '*' for all channels")
    String atlas_channels = "*";
    @Parameter(label="Exported image name")
    String image_name = "Atlas";
    @Parameter
    boolean interpolate;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus image;

    public void run() {
        List slicesToExport = this.mp.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        SourcesProcessor preprocess = SourcesProcessorHelper.Identity();
        if (!this.atlas_channels.trim().equals("*")) {
            int maxChannelInAtlas;
            List indices = Arrays.stream(this.atlas_channels.trim().split(",")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            int maxIndex = indices.stream().mapToInt(e -> e).max().getAsInt();
            if (maxIndex >= (maxChannelInAtlas = this.mp.getReslicedAtlas().nonExtendedSlicedSources.length)) {
                this.mp.errorMessageForUser.accept("Wrong atlas channel index", "The atlas only has " + maxChannelInAtlas + " channel(s).\n Maximum index : " + (maxChannelInAtlas - 1));
                return;
            }
            preprocess = new SourcesChannelsSelect(indices);
        }
        double[] roi = this.mp.getROI();
        HashMap<SliceSources, ExportAtlasSliceToImagePlusAction> tasks = new HashMap<SliceSources, ExportAtlasSliceToImagePlusAction>();
        for (SliceSources slice : slicesToExport) {
            ExportAtlasSliceToImagePlusAction export = new ExportAtlasSliceToImagePlusAction(this.mp, slice, preprocess, roi[0], roi[1], roi[2], roi[3], this.px_size_micron / 1000.0, 0, this.interpolate);
            tasks.put(slice, export);
            export.runRequest();
        }
        ImagePlus[] images = new ImagePlus[slicesToExport.size()];
        IntStream.range(0, slicesToExport.size()).parallel().forEach(i -> {
            SliceSources slice = (SliceSources)slicesToExport.get(i);
            boolean success = slice.waitForEndOfAction((CancelableAction)tasks.get(slice));
            if (success) {
                images[i] = ((ExportAtlasSliceToImagePlusAction)tasks.get(slice)).getImagePlus();
                ((ExportAtlasSliceToImagePlusAction)tasks.get(slice)).clean();
                this.mp.infoMessageForUser.accept("", "Atlas export to ImagePlus of slice " + slice + " done (" + (i + 1) + "/" + images.length + ")");
                images[i].setTitle("Slice_" + i + "_" + slice);
                images[i].show();
            } else {
                this.mp.errorMessageForUser.accept("Export to ImageJ Stack error", "Error in export of slice " + slice);
            }
        });
        if (images.length > 1) {
            int iCh;
            int nChannels = images[0].getNChannels();
            double[] min = new double[nChannels];
            double[] max = new double[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                images[0].setC(iCh + 1);
                min[iCh] = images[0].getProcessor().getMin();
                max[iCh] = images[0].getProcessor().getMax();
            }
            this.image = Concatenator.run((ImagePlus[])images);
            for (iCh = 0; iCh < nChannels; ++iCh) {
                this.image.setC(iCh + 1);
                this.image.setDisplayRange(min[iCh], max[iCh]);
            }
        } else {
            this.image = images[0];
        }
        if (this.image != null) {
            this.image.show();
            this.image.setTitle(this.image_name);
        }
    }
}

