/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.ReslicedAtlas;
import org.scijava.Initializable;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=InteractiveCommand.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>ABBA - Adjust Slicing")
public class AtlasSlicingAdjusterCommand
extends InteractiveCommand
implements Initializable {
    @Parameter(label="Lock rotations")
    Boolean lockAngles = Boolean.FALSE;
    @Parameter(min="-45", max="+45", stepSize="0.5", style="slider,format:0.0", label="X Rotation [deg]", callback="changeRotate", persist=false)
    double rotateX = 0.0;
    double oldRotateX = 0.0;
    @Parameter(min="-45", max="+45", stepSize="0.5", style="slider,format:0.0", label="Y Rotation [deg]", callback="changeRotate", persist=false)
    double rotateY = 0.0;
    double oldRotateY = 0.0;
    @Parameter
    ReslicedAtlas reslicedAtlas;

    public AtlasSlicingAdjusterCommand() {
        super(new String[0]);
    }

    public void initialize() {
        this.oldRotateX = this.rotateX = this.reslicedAtlas.getRotateX() * 180.0 / Math.PI;
        this.oldRotateY = this.rotateY = this.reslicedAtlas.getRotateY() * 180.0 / Math.PI;
        this.reslicedAtlas.addListener(() -> {
            if (this.reslicedAtlas.getRotateX() != this.rotateX / 180.0 * Math.PI || this.reslicedAtlas.getRotateY() != this.rotateY / 180.0 * Math.PI) {
                this.setInput("rotateX", this.reslicedAtlas.getRotateX() * 180.0 / Math.PI);
                this.setInput("oldRotateX", this.reslicedAtlas.getRotateX() * 180.0 / Math.PI);
                this.setInput("rotateY", this.reslicedAtlas.getRotateY() * 180.0 / Math.PI);
                this.setInput("oldRotateY", this.reslicedAtlas.getRotateY() * 180.0 / Math.PI);
            }
        });
    }

    public void run() {
        if (!this.lockAngles.booleanValue()) {
            this.reslicedAtlas.setRotateX(this.rotateX / 180.0 * Math.PI);
            this.reslicedAtlas.setRotateY(this.rotateY / 180.0 * Math.PI);
            this.oldRotateX = this.rotateX;
            this.oldRotateY = this.rotateY;
        } else {
            this.rotateX = this.oldRotateX;
            this.rotateY = this.oldRotateY;
        }
    }

    public void changeRotate() {
        if (this.lockAngles.booleanValue()) {
            this.rotateX = this.oldRotateX;
            this.rotateY = this.oldRotateY;
        }
    }
}

