/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>File>ABBA - Save State", description="Saves the current registration state")
public class ABBAStateSaveCommand
implements Command {
    @Parameter
    MultiSlicePositioner mp;
    @Parameter(style="save", persist=false)
    File state_file;
    @Parameter(type=ItemIO.OUTPUT)
    Boolean success = false;

    public void run() {
        String extension = FilenameUtils.getExtension((String)this.state_file.getAbsolutePath());
        if (extension == null || extension.trim().equals("")) {
            this.mp.infoMessageForUser.accept("", "Adding abba extension to state file");
            this.state_file = new File(this.state_file.getAbsolutePath() + ".abba");
        }
        if (this.state_file.exists()) {
            this.mp.errorMessageForUser.accept("This file already exists!", "Please choose a different name or location.");
        } else {
            this.success = this.mp.saveState(this.state_file, true);
        }
    }
}

