/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import bdv.BigDataViewer;
import bdv.util.BdvHandle;
import bigwarp.BigWarp;
import ch.epfl.biop.atlas.aligner.ABBAHelper;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.sourceandconverter.register.Elastix2DSplineRegister;
import ch.epfl.biop.wrappers.deepslice.DeepSlice;
import ch.epfl.biop.wrappers.elastix.Elastix;
import ch.epfl.biop.wrappers.elastix.ElastixTask;
import ch.epfl.biop.wrappers.transformix.Transformix;
import ij.IJ;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.imagej.ImageJ;
import net.imagej.updater.UpdateService;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.AvailableSites;
import org.scijava.command.Command;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.VersionUtils;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Help>ABBA - Ask for help in the forum", description="Open a new post in the image.sc forum with current install information")
public class ABBAForumHelpCommand
implements Command {
    @Parameter
    PlatformService ps;
    @Parameter
    UpdateService us;
    public static String pythonInformation = "";

    public void run() {
        try {
            StringBuilder sites_string = new StringBuilder();
            if (pythonInformation.isEmpty()) {
                Map sites = AvailableSites.getAvailableSites();
                try {
                    for (UpdateSite site : sites.values()) {
                        if (!this.us.getUpdateSite(site.getName()).isActive()) continue;
                        sites_string.append(site.getName()).append("+");
                    }
                }
                catch (Exception e) {
                    sites_string.append("Could not get installed update sites.");
                }
            } else {
                sites_string.append("Can't collect update sites with ABBA run from Python");
            }
            String nl = "\n";
            String imageScForumUrl = "https://forum.image.sc/";
            String title = "Help for ABBA in Fiji: [your question here]";
            String body = "[Detail your issue here]" + nl;
            body = body + nl;
            body = body + "---" + nl;
            body = body + nl;
            body = body + "OS and Dependencies Info" + nl;
            body = body + "```" + nl;
            body = body + "OS " + System.getProperty("os.name") + nl;
            body = !pythonInformation.isEmpty() ? body + pythonInformation + nl : body + "Not run from PyImageJ" + nl;
            body = body + "ImageJ " + VersionUtils.getVersion(ImageJ.class) + nl;
            body = body + "IJ " + VersionUtils.getVersion(IJ.class) + nl;
            body = body + "ABBA " + VersionUtils.getVersion(ABBAHelper.class) + nl;
            body = body + "BigWarp " + VersionUtils.getVersion(BigWarp.class) + nl;
            body = body + "Bdv " + VersionUtils.getVersion(BigDataViewer.class) + nl;
            body = body + "Bdv Vistools " + VersionUtils.getVersion(BdvHandle.class) + nl;
            body = body + "Bdv Biop Tools " + VersionUtils.getVersion(Elastix2DSplineRegister.class) + nl;
            body = body + "Bdv Playground " + VersionUtils.getVersion(SourceAndConverterServices.class) + nl;
            body = body + "Biop Image Loader " + VersionUtils.getVersion(BioFormatsHelper.class) + nl;
            body = body + "Biop Wrappers " + VersionUtils.getVersion(ElastixTask.class) + nl;
            body = Elastix.exePath != null ? body + "Elastix Path: " + Elastix.exePath + " exists ?" + new File(Elastix.exePath).exists() + nl : body + "Elastix path not set" + nl;
            body = Transformix.exePath != null ? body + "Transformix Path: " + Transformix.exePath + " exists ?" + new File(Transformix.exePath).exists() + nl : body + "Transformix path not set" + nl;
            body = DeepSlice.envDirPath != null ? body + "Deepslice env dir: " + DeepSlice.envDirPath + " exists ?" + new File(DeepSlice.envDirPath).exists() + nl : body + "Deepslice env dir not set" + nl;
            body = body + "Updates sites: " + sites_string + nl;
            body = body + "```";
            String fullUrl = imageScForumUrl + "new-topic?title=" + title + "&body=" + ABBAForumHelpCommand.formatStringForUrl(body) + "&category=usage-issues&tags=fiji,abba";
            IJ.log((String)fullUrl);
            this.ps.open(new URL(fullUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String formatStringForUrl(String input) {
        try {
            return URLEncoder.encode(input, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

