/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import java.awt.Color;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Help>ABBA - How to cite", description="How to cite ABBA")
public class ABBACiteInfoCommand
implements Command {
    public void run() {
        JFrame frame = new JFrame("How to cite");
        frame.setSize(450, 350);
        frame.setLocationRelativeTo(null);
        frame.setIconImage(new ImageIcon(MultiSlicePositioner.class.getResource("/graphics/ABBAFrame.jpg")).getImage());
        JPanel panel = new JPanel();
        panel.setBackground(new Color(245, 245, 245));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(15, 15, 15, 15));
        String htmlContent = "<html><body>No network connection, the citation information is not available. Please connect to the internet and retry.</body></html>";
        try {
            String inputLine;
            URL url = new URL("https://go.epfl.ch/abba-cite");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            htmlContent = "";
            while ((inputLine = in.readLine()) != null) {
                System.out.println(inputLine);
                if (inputLine.startsWith("#")) continue;
                htmlContent = htmlContent + inputLine + "\n";
            }
            in.close();
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
        }
        JEditorPane editorPane = new JEditorPane("text/html", htmlContent);
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(new URI(e.getURL().toString()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setHorizontalScrollBarPolicy(31);
        panel.add(scrollPane);
        frame.add(panel);
        frame.setVisible(true);
    }
}

